# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RocketMQInstanceArgs', 'RocketMQInstance']

@pulumi.input_type
class RocketMQInstanceArgs:
    def __init__(__self__, *,
                 network_info: pulumi.Input['RocketMQInstanceNetworkInfoArgs'],
                 payment_type: pulumi.Input[str],
                 series_code: pulumi.Input[str],
                 service_code: pulumi.Input[str],
                 sub_series_code: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 product_info: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 software: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a RocketMQInstance resource.
        :param pulumi.Input['RocketMQInstanceNetworkInfoArgs'] network_info: Instance network configuration information. See `network_info` below.
        :param pulumi.Input[str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition.
        :param pulumi.Input[str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        :param pulumi.Input[str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] instance_name: The name of instance.
        :param pulumi.Input[int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3.
        :param pulumi.Input[str] period_unit: The minimum periodic unit for the duration of purchase. The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis.
        :param pulumi.Input['RocketMQInstanceProductInfoArgs'] product_info: product info. See `product_info` below.
        :param pulumi.Input[str] remark: Custom description.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input['RocketMQInstanceSoftwareArgs'] software: Instance software information. See `software` below.
        :param pulumi.Input[Mapping[str, Any]] tags: The resource label.
        """
        pulumi.set(__self__, "network_info", network_info)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "series_code", series_code)
        pulumi.set(__self__, "service_code", service_code)
        pulumi.set(__self__, "sub_series_code", sub_series_code)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_renew_period_unit is not None:
            pulumi.set(__self__, "auto_renew_period_unit", auto_renew_period_unit)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_info is not None:
            pulumi.set(__self__, "product_info", product_info)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if software is not None:
            pulumi.set(__self__, "software", software)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> pulumi.Input['RocketMQInstanceNetworkInfoArgs']:
        """
        Instance network configuration information. See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @network_info.setter
    def network_info(self, value: pulumi.Input['RocketMQInstanceNetworkInfoArgs']):
        pulumi.set(self, "network_info", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.
        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> pulumi.Input[str]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition.
        """
        return pulumi.get(self, "series_code")

    @series_code.setter
    def series_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "series_code", value)

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Input[str]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_code", value)

    @property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> pulumi.Input[str]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @sub_series_code.setter
    def sub_series_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "sub_series_code", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @auto_renew_period_unit.setter
    def auto_renew_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew_period_unit", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum periodic unit for the duration of purchase. The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]:
        """
        product info. See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @product_info.setter
    def product_info(self, value: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]):
        pulumi.set(self, "product_info", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Custom description.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def software(self) -> Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @software.setter
    def software(self, value: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]):
        pulumi.set(self, "software", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RocketMQInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 network_info: Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 product_info: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series_code: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 software: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sub_series_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Input properties used for looking up and filtering RocketMQInstance resources.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        :param pulumi.Input[str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] instance_name: The name of instance.
        :param pulumi.Input['RocketMQInstanceNetworkInfoArgs'] network_info: Instance network configuration information. See `network_info` below.
        :param pulumi.Input[str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3.
        :param pulumi.Input[str] period_unit: The minimum periodic unit for the duration of purchase. The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis.
        :param pulumi.Input['RocketMQInstanceProductInfoArgs'] product_info: product info. See `product_info` below.
        :param pulumi.Input[str] remark: Custom description.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition.
        :param pulumi.Input[str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input['RocketMQInstanceSoftwareArgs'] software: Instance software information. See `software` below.
        :param pulumi.Input[str] status: The status of the instance.
        :param pulumi.Input[str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, Any]] tags: The resource label.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if auto_renew_period_unit is not None:
            pulumi.set(__self__, "auto_renew_period_unit", auto_renew_period_unit)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if network_info is not None:
            pulumi.set(__self__, "network_info", network_info)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_info is not None:
            pulumi.set(__self__, "product_info", product_info)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if series_code is not None:
            pulumi.set(__self__, "series_code", series_code)
        if service_code is not None:
            pulumi.set(__self__, "service_code", service_code)
        if software is not None:
            pulumi.set(__self__, "software", software)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_series_code is not None:
            pulumi.set(__self__, "sub_series_code", sub_series_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @auto_renew_period_unit.setter
    def auto_renew_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew_period_unit", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']]:
        """
        Instance network configuration information. See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @network_info.setter
    def network_info(self, value: Optional[pulumi.Input['RocketMQInstanceNetworkInfoArgs']]):
        pulumi.set(self, "network_info", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.
        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum periodic unit for the duration of purchase. The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]:
        """
        product info. See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @product_info.setter
    def product_info(self, value: Optional[pulumi.Input['RocketMQInstanceProductInfoArgs']]):
        pulumi.set(self, "product_info", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Custom description.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> Optional[pulumi.Input[str]]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition.
        """
        return pulumi.get(self, "series_code")

    @series_code.setter
    def series_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "series_code", value)

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> Optional[pulumi.Input[str]]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @service_code.setter
    def service_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_code", value)

    @property
    @pulumi.getter
    def software(self) -> Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @software.setter
    def software(self, value: Optional[pulumi.Input['RocketMQInstanceSoftwareArgs']]):
        pulumi.set(self, "software", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> Optional[pulumi.Input[str]]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @sub_series_code.setter
    def sub_series_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_series_code", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


class RocketMQInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 network_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceNetworkInfoArgs']]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 product_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceProductInfoArgs']]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series_code: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 software: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceSoftwareArgs']]] = None,
                 sub_series_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        ## Import

        RocketMQ Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        :param pulumi.Input[str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] instance_name: The name of instance.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceNetworkInfoArgs']] network_info: Instance network configuration information. See `network_info` below.
        :param pulumi.Input[str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3.
        :param pulumi.Input[str] period_unit: The minimum periodic unit for the duration of purchase. The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceProductInfoArgs']] product_info: product info. See `product_info` below.
        :param pulumi.Input[str] remark: Custom description.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition.
        :param pulumi.Input[str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceSoftwareArgs']] software: Instance software information. See `software` below.
        :param pulumi.Input[str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, Any]] tags: The resource label.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RocketMQInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        RocketMQ Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:rocketmq/rocketMQInstance:RocketMQInstance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param RocketMQInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RocketMQInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 auto_renew_period_unit: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 network_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceNetworkInfoArgs']]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 product_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceProductInfoArgs']]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 series_code: Optional[pulumi.Input[str]] = None,
                 service_code: Optional[pulumi.Input[str]] = None,
                 software: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceSoftwareArgs']]] = None,
                 sub_series_code: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RocketMQInstanceArgs.__new__(RocketMQInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["auto_renew_period_unit"] = auto_renew_period_unit
            __props__.__dict__["instance_name"] = instance_name
            if network_info is None and not opts.urn:
                raise TypeError("Missing required property 'network_info'")
            __props__.__dict__["network_info"] = network_info
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["product_info"] = product_info
            __props__.__dict__["remark"] = remark
            __props__.__dict__["resource_group_id"] = resource_group_id
            if series_code is None and not opts.urn:
                raise TypeError("Missing required property 'series_code'")
            __props__.__dict__["series_code"] = series_code
            if service_code is None and not opts.urn:
                raise TypeError("Missing required property 'service_code'")
            __props__.__dict__["service_code"] = service_code
            __props__.__dict__["software"] = software
            if sub_series_code is None and not opts.urn:
                raise TypeError("Missing required property 'sub_series_code'")
            __props__.__dict__["sub_series_code"] = sub_series_code
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(RocketMQInstance, __self__).__init__(
            'alicloud:rocketmq/rocketMQInstance:RocketMQInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            auto_renew_period_unit: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            network_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceNetworkInfoArgs']]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            product_info: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceProductInfoArgs']]] = None,
            remark: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            series_code: Optional[pulumi.Input[str]] = None,
            service_code: Optional[pulumi.Input[str]] = None,
            software: Optional[pulumi.Input[pulumi.InputType['RocketMQInstanceSoftwareArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sub_series_code: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'RocketMQInstance':
        """
        Get an existing RocketMQInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
               - true: Enable auto-renewal
               - false: Disable auto-renewal.
        :param pulumi.Input[int] auto_renew_period: Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        :param pulumi.Input[str] auto_renew_period_unit: The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] instance_name: The name of instance.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceNetworkInfoArgs']] network_info: Instance network configuration information. See `network_info` below.
        :param pulumi.Input[str] payment_type: The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
               - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
               - Subscription: Subscription-based, a pre-payment model where you pay before usage.
               For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        :param pulumi.Input[int] period: Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
               - Monthly purchase: 1, 2, 3, 4, 5, 6
               - Annual purchase: 1, 2, 3.
        :param pulumi.Input[str] period_unit: The minimum periodic unit for the duration of purchase. The parameter values are as follows:
               - Month: Purchase on a monthly basis
               - Year: Purchase on an annual basis.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceProductInfoArgs']] product_info: product info. See `product_info` below.
        :param pulumi.Input[str] remark: Custom description.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] series_code: The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - standard: Standard Edition
               - ultimate: Platinum Edition
               - professional: Professional Edition.
        :param pulumi.Input[str] service_code: The code of the service code instance. The code of the RocketMQ is rmq.
        :param pulumi.Input[pulumi.InputType['RocketMQInstanceSoftwareArgs']] software: Instance software information. See `software` below.
        :param pulumi.Input[str] status: The status of the instance.
        :param pulumi.Input[str] sub_series_code: The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
               - cluster_ha: Cluster High Availability Edition
               - single_node: Single Node Testing Edition
               When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        :param pulumi.Input[Mapping[str, Any]] tags: The resource label.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RocketMQInstanceState.__new__(_RocketMQInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["auto_renew_period_unit"] = auto_renew_period_unit
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["network_info"] = network_info
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["product_info"] = product_info
        __props__.__dict__["remark"] = remark
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["series_code"] = series_code
        __props__.__dict__["service_code"] = service_code
        __props__.__dict__["software"] = software
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_series_code"] = sub_series_code
        __props__.__dict__["tags"] = tags
        return RocketMQInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable auto-renewal. This parameter is only applicable when the payment type for the instance is Subscription (prepaid).
        - true: Enable auto-renewal
        - false: Disable auto-renewal.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        Auto-renewal period. This parameter is only valid when auto-renewal is enabled. The values can be as follows: 1, 2, 3, 6, 12.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="autoRenewPeriodUnit")
    def auto_renew_period_unit(self) -> pulumi.Output[str]:
        """
        The minimum periodic unit for the duration of auto-renewal. This parameter is only valid when auto-renewal is enabled. Valid values: `Month`, `Year`.
        """
        return pulumi.get(self, "auto_renew_period_unit")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="networkInfo")
    def network_info(self) -> pulumi.Output['outputs.RocketMQInstanceNetworkInfo']:
        """
        Instance network configuration information. See `network_info` below.
        """
        return pulumi.get(self, "network_info")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type for the instance. Alibaba Cloud Message Queue RocketMQ version supports two types of payment. The parameter values are as follows:
        - PayAsYouGo: Pay-as-you-go, a post-payment model where you pay after usage.
        - Subscription: Subscription-based, a pre-payment model where you pay before usage.
        For more information, please refer to [Billing Methods](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/overview-2).
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Duration of purchase. This parameter is only valid when the payment type for the instance is Subscription (prepaid). The values can be as follows:
        - Monthly purchase: 1, 2, 3, 4, 5, 6
        - Annual purchase: 1, 2, 3.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[str]:
        """
        The minimum periodic unit for the duration of purchase. The parameter values are as follows:
        - Month: Purchase on a monthly basis
        - Year: Purchase on an annual basis.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="productInfo")
    def product_info(self) -> pulumi.Output[Optional['outputs.RocketMQInstanceProductInfo']]:
        """
        product info. See `product_info` below.
        """
        return pulumi.get(self, "product_info")

    @property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[str]]:
        """
        Custom description.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="seriesCode")
    def series_code(self) -> pulumi.Output[str]:
        """
        The primary series encoding for the instance. For specific differences between the primary series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - standard: Standard Edition
        - ultimate: Platinum Edition
        - professional: Professional Edition.
        """
        return pulumi.get(self, "series_code")

    @property
    @pulumi.getter(name="serviceCode")
    def service_code(self) -> pulumi.Output[str]:
        """
        The code of the service code instance. The code of the RocketMQ is rmq.
        """
        return pulumi.get(self, "service_code")

    @property
    @pulumi.getter
    def software(self) -> pulumi.Output['outputs.RocketMQInstanceSoftware']:
        """
        Instance software information. See `software` below.
        """
        return pulumi.get(self, "software")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subSeriesCode")
    def sub_series_code(self) -> pulumi.Output[str]:
        """
        The sub-series encoding for the instance. For specific differences between the sub-series, please refer to [Product Selection](https://help.aliyun.com/zh/apsaramq-for-rocketmq/cloud-message-queue-rocketmq-5-x-series/product-overview/instance-selection). The parameter values are as follows:
        - cluster_ha: Cluster High Availability Edition
        - single_node: Single Node Testing Edition
        When selecting the primary series as ultimate (Platinum Edition), the sub-series can only be chosen as cluster_ha (Cluster High Availability Edition).
        """
        return pulumi.get(self, "sub_series_code")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The resource label.
        """
        return pulumi.get(self, "tags")

