# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TemplateScratchArgs', 'TemplateScratch']

@pulumi.input_type
class TemplateScratchArgs:
    def __init__(__self__, *,
                 template_scratch_type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 execution_mode: Optional[pulumi.Input[str]] = None,
                 logical_id_strategy: Optional[pulumi.Input[str]] = None,
                 preference_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]] = None,
                 source_resource_group: Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']] = None,
                 source_resources: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]] = None,
                 source_tag: Optional[pulumi.Input['TemplateScratchSourceTagArgs']] = None):
        """
        The set of arguments for constructing a TemplateScratch resource.
        :param pulumi.Input[str] template_scratch_type: The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        :param pulumi.Input[str] description: The Description of the Template Scratch.
        :param pulumi.Input[str] execution_mode: The execution mode. Valid Values: `Async` or `Sync`.
        :param pulumi.Input[str] logical_id_strategy: Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]] preference_parameters: Priority parameter. See the following `Block preference_parameters`.
        :param pulumi.Input['TemplateScratchSourceResourceGroupArgs'] source_resource_group: Source resource grouping. See the following `Block source_resource_group`.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]] source_resources: Source resource. See the following `Block source_resources`.
        :param pulumi.Input['TemplateScratchSourceTagArgs'] source_tag: Source tag. See the following `Block source_tag`.
        """
        pulumi.set(__self__, "template_scratch_type", template_scratch_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_mode is not None:
            pulumi.set(__self__, "execution_mode", execution_mode)
        if logical_id_strategy is not None:
            pulumi.set(__self__, "logical_id_strategy", logical_id_strategy)
        if preference_parameters is not None:
            pulumi.set(__self__, "preference_parameters", preference_parameters)
        if source_resource_group is not None:
            pulumi.set(__self__, "source_resource_group", source_resource_group)
        if source_resources is not None:
            pulumi.set(__self__, "source_resources", source_resources)
        if source_tag is not None:
            pulumi.set(__self__, "source_tag", source_tag)

    @property
    @pulumi.getter(name="templateScratchType")
    def template_scratch_type(self) -> pulumi.Input[str]:
        """
        The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        return pulumi.get(self, "template_scratch_type")

    @template_scratch_type.setter
    def template_scratch_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_scratch_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Description of the Template Scratch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The execution mode. Valid Values: `Async` or `Sync`.
        """
        return pulumi.get(self, "execution_mode")

    @execution_mode.setter
    def execution_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_mode", value)

    @property
    @pulumi.getter(name="logicalIdStrategy")
    def logical_id_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        """
        return pulumi.get(self, "logical_id_strategy")

    @logical_id_strategy.setter
    def logical_id_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_id_strategy", value)

    @property
    @pulumi.getter(name="preferenceParameters")
    def preference_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]]:
        """
        Priority parameter. See the following `Block preference_parameters`.
        """
        return pulumi.get(self, "preference_parameters")

    @preference_parameters.setter
    def preference_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]]):
        pulumi.set(self, "preference_parameters", value)

    @property
    @pulumi.getter(name="sourceResourceGroup")
    def source_resource_group(self) -> Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']]:
        """
        Source resource grouping. See the following `Block source_resource_group`.
        """
        return pulumi.get(self, "source_resource_group")

    @source_resource_group.setter
    def source_resource_group(self, value: Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']]):
        pulumi.set(self, "source_resource_group", value)

    @property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]]:
        """
        Source resource. See the following `Block source_resources`.
        """
        return pulumi.get(self, "source_resources")

    @source_resources.setter
    def source_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]]):
        pulumi.set(self, "source_resources", value)

    @property
    @pulumi.getter(name="sourceTag")
    def source_tag(self) -> Optional[pulumi.Input['TemplateScratchSourceTagArgs']]:
        """
        Source tag. See the following `Block source_tag`.
        """
        return pulumi.get(self, "source_tag")

    @source_tag.setter
    def source_tag(self, value: Optional[pulumi.Input['TemplateScratchSourceTagArgs']]):
        pulumi.set(self, "source_tag", value)


@pulumi.input_type
class _TemplateScratchState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_mode: Optional[pulumi.Input[str]] = None,
                 logical_id_strategy: Optional[pulumi.Input[str]] = None,
                 preference_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]] = None,
                 source_resource_group: Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']] = None,
                 source_resources: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]] = None,
                 source_tag: Optional[pulumi.Input['TemplateScratchSourceTagArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 template_scratch_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TemplateScratch resources.
        :param pulumi.Input[str] description: The Description of the Template Scratch.
        :param pulumi.Input[str] execution_mode: The execution mode. Valid Values: `Async` or `Sync`.
        :param pulumi.Input[str] logical_id_strategy: Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]] preference_parameters: Priority parameter. See the following `Block preference_parameters`.
        :param pulumi.Input['TemplateScratchSourceResourceGroupArgs'] source_resource_group: Source resource grouping. See the following `Block source_resource_group`.
        :param pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]] source_resources: Source resource. See the following `Block source_resources`.
        :param pulumi.Input['TemplateScratchSourceTagArgs'] source_tag: Source tag. See the following `Block source_tag`.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] template_scratch_type: The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_mode is not None:
            pulumi.set(__self__, "execution_mode", execution_mode)
        if logical_id_strategy is not None:
            pulumi.set(__self__, "logical_id_strategy", logical_id_strategy)
        if preference_parameters is not None:
            pulumi.set(__self__, "preference_parameters", preference_parameters)
        if source_resource_group is not None:
            pulumi.set(__self__, "source_resource_group", source_resource_group)
        if source_resources is not None:
            pulumi.set(__self__, "source_resources", source_resources)
        if source_tag is not None:
            pulumi.set(__self__, "source_tag", source_tag)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_scratch_type is not None:
            pulumi.set(__self__, "template_scratch_type", template_scratch_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Description of the Template Scratch.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The execution mode. Valid Values: `Async` or `Sync`.
        """
        return pulumi.get(self, "execution_mode")

    @execution_mode.setter
    def execution_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_mode", value)

    @property
    @pulumi.getter(name="logicalIdStrategy")
    def logical_id_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        """
        return pulumi.get(self, "logical_id_strategy")

    @logical_id_strategy.setter
    def logical_id_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_id_strategy", value)

    @property
    @pulumi.getter(name="preferenceParameters")
    def preference_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]]:
        """
        Priority parameter. See the following `Block preference_parameters`.
        """
        return pulumi.get(self, "preference_parameters")

    @preference_parameters.setter
    def preference_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchPreferenceParameterArgs']]]]):
        pulumi.set(self, "preference_parameters", value)

    @property
    @pulumi.getter(name="sourceResourceGroup")
    def source_resource_group(self) -> Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']]:
        """
        Source resource grouping. See the following `Block source_resource_group`.
        """
        return pulumi.get(self, "source_resource_group")

    @source_resource_group.setter
    def source_resource_group(self, value: Optional[pulumi.Input['TemplateScratchSourceResourceGroupArgs']]):
        pulumi.set(self, "source_resource_group", value)

    @property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]]:
        """
        Source resource. See the following `Block source_resources`.
        """
        return pulumi.get(self, "source_resources")

    @source_resources.setter
    def source_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TemplateScratchSourceResourceArgs']]]]):
        pulumi.set(self, "source_resources", value)

    @property
    @pulumi.getter(name="sourceTag")
    def source_tag(self) -> Optional[pulumi.Input['TemplateScratchSourceTagArgs']]:
        """
        Source tag. See the following `Block source_tag`.
        """
        return pulumi.get(self, "source_tag")

    @source_tag.setter
    def source_tag(self, value: Optional[pulumi.Input['TemplateScratchSourceTagArgs']]):
        pulumi.set(self, "source_tag", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="templateScratchType")
    def template_scratch_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        return pulumi.get(self, "template_scratch_type")

    @template_scratch_type.setter
    def template_scratch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_scratch_type", value)


class TemplateScratch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_mode: Optional[pulumi.Input[str]] = None,
                 logical_id_strategy: Optional[pulumi.Input[str]] = None,
                 preference_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchPreferenceParameterArgs']]]]] = None,
                 source_resource_group: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceGroupArgs']]] = None,
                 source_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceArgs']]]]] = None,
                 source_tag: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceTagArgs']]] = None,
                 template_scratch_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ROS Template Scratch resource.

        For information about ROS Template Scratch and how to use it, see [What is Template Scratch](https://www.alibabacloud.com/help/zh/doc-detail/352074.html).

        > **NOTE:** Available in v1.151.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups()
        example = alicloud.ros.TemplateScratch("example",
            description="tf_testacc",
            template_scratch_type="ResourceImport",
            preference_parameters=[alicloud.ros.TemplateScratchPreferenceParameterArgs(
                parameter_key="DeletionPolicy",
                parameter_value="Retain",
            )],
            source_resource_group=alicloud.ros.TemplateScratchSourceResourceGroupArgs(
                resource_group_id=default.ids[0],
                resource_type_filters=["ALIYUN::ECS::VPC"],
            ))
        ```

        ## Import

        ROS Template Scratch can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ros/templateScratch:TemplateScratch example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The Description of the Template Scratch.
        :param pulumi.Input[str] execution_mode: The execution mode. Valid Values: `Async` or `Sync`.
        :param pulumi.Input[str] logical_id_strategy: Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchPreferenceParameterArgs']]]] preference_parameters: Priority parameter. See the following `Block preference_parameters`.
        :param pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceGroupArgs']] source_resource_group: Source resource grouping. See the following `Block source_resource_group`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceArgs']]]] source_resources: Source resource. See the following `Block source_resources`.
        :param pulumi.Input[pulumi.InputType['TemplateScratchSourceTagArgs']] source_tag: Source tag. See the following `Block source_tag`.
        :param pulumi.Input[str] template_scratch_type: The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TemplateScratchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ROS Template Scratch resource.

        For information about ROS Template Scratch and how to use it, see [What is Template Scratch](https://www.alibabacloud.com/help/zh/doc-detail/352074.html).

        > **NOTE:** Available in v1.151.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default = alicloud.resourcemanager.get_resource_groups()
        example = alicloud.ros.TemplateScratch("example",
            description="tf_testacc",
            template_scratch_type="ResourceImport",
            preference_parameters=[alicloud.ros.TemplateScratchPreferenceParameterArgs(
                parameter_key="DeletionPolicy",
                parameter_value="Retain",
            )],
            source_resource_group=alicloud.ros.TemplateScratchSourceResourceGroupArgs(
                resource_group_id=default.ids[0],
                resource_type_filters=["ALIYUN::ECS::VPC"],
            ))
        ```

        ## Import

        ROS Template Scratch can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ros/templateScratch:TemplateScratch example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TemplateScratchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TemplateScratchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_mode: Optional[pulumi.Input[str]] = None,
                 logical_id_strategy: Optional[pulumi.Input[str]] = None,
                 preference_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchPreferenceParameterArgs']]]]] = None,
                 source_resource_group: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceGroupArgs']]] = None,
                 source_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceArgs']]]]] = None,
                 source_tag: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceTagArgs']]] = None,
                 template_scratch_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TemplateScratchArgs.__new__(TemplateScratchArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["execution_mode"] = execution_mode
            __props__.__dict__["logical_id_strategy"] = logical_id_strategy
            __props__.__dict__["preference_parameters"] = preference_parameters
            __props__.__dict__["source_resource_group"] = source_resource_group
            __props__.__dict__["source_resources"] = source_resources
            __props__.__dict__["source_tag"] = source_tag
            if template_scratch_type is None and not opts.urn:
                raise TypeError("Missing required property 'template_scratch_type'")
            __props__.__dict__["template_scratch_type"] = template_scratch_type
            __props__.__dict__["status"] = None
        super(TemplateScratch, __self__).__init__(
            'alicloud:ros/templateScratch:TemplateScratch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            execution_mode: Optional[pulumi.Input[str]] = None,
            logical_id_strategy: Optional[pulumi.Input[str]] = None,
            preference_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchPreferenceParameterArgs']]]]] = None,
            source_resource_group: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceGroupArgs']]] = None,
            source_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceArgs']]]]] = None,
            source_tag: Optional[pulumi.Input[pulumi.InputType['TemplateScratchSourceTagArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            template_scratch_type: Optional[pulumi.Input[str]] = None) -> 'TemplateScratch':
        """
        Get an existing TemplateScratch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The Description of the Template Scratch.
        :param pulumi.Input[str] execution_mode: The execution mode. Valid Values: `Async` or `Sync`.
        :param pulumi.Input[str] logical_id_strategy: Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchPreferenceParameterArgs']]]] preference_parameters: Priority parameter. See the following `Block preference_parameters`.
        :param pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceGroupArgs']] source_resource_group: Source resource grouping. See the following `Block source_resource_group`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TemplateScratchSourceResourceArgs']]]] source_resources: Source resource. See the following `Block source_resources`.
        :param pulumi.Input[pulumi.InputType['TemplateScratchSourceTagArgs']] source_tag: Source tag. See the following `Block source_tag`.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] template_scratch_type: The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TemplateScratchState.__new__(_TemplateScratchState)

        __props__.__dict__["description"] = description
        __props__.__dict__["execution_mode"] = execution_mode
        __props__.__dict__["logical_id_strategy"] = logical_id_strategy
        __props__.__dict__["preference_parameters"] = preference_parameters
        __props__.__dict__["source_resource_group"] = source_resource_group
        __props__.__dict__["source_resources"] = source_resources
        __props__.__dict__["source_tag"] = source_tag
        __props__.__dict__["status"] = status
        __props__.__dict__["template_scratch_type"] = template_scratch_type
        return TemplateScratch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The Description of the Template Scratch.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionMode")
    def execution_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The execution mode. Valid Values: `Async` or `Sync`.
        """
        return pulumi.get(self, "execution_mode")

    @property
    @pulumi.getter(name="logicalIdStrategy")
    def logical_id_strategy(self) -> pulumi.Output[str]:
        """
        Logical ID generation strategy. Valid Values: `LongTypePrefixAndIndexSuffix`, `LongTypePrefixAndHashSuffix` and `ShortTypePrefixAndHashSuffix`.
        """
        return pulumi.get(self, "logical_id_strategy")

    @property
    @pulumi.getter(name="preferenceParameters")
    def preference_parameters(self) -> pulumi.Output[Sequence['outputs.TemplateScratchPreferenceParameter']]:
        """
        Priority parameter. See the following `Block preference_parameters`.
        """
        return pulumi.get(self, "preference_parameters")

    @property
    @pulumi.getter(name="sourceResourceGroup")
    def source_resource_group(self) -> pulumi.Output[Optional['outputs.TemplateScratchSourceResourceGroup']]:
        """
        Source resource grouping. See the following `Block source_resource_group`.
        """
        return pulumi.get(self, "source_resource_group")

    @property
    @pulumi.getter(name="sourceResources")
    def source_resources(self) -> pulumi.Output[Optional[Sequence['outputs.TemplateScratchSourceResource']]]:
        """
        Source resource. See the following `Block source_resources`.
        """
        return pulumi.get(self, "source_resources")

    @property
    @pulumi.getter(name="sourceTag")
    def source_tag(self) -> pulumi.Output[Optional['outputs.TemplateScratchSourceTag']]:
        """
        Source tag. See the following `Block source_tag`.
        """
        return pulumi.get(self, "source_tag")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="templateScratchType")
    def template_scratch_type(self) -> pulumi.Output[str]:
        """
        The type of the Template scan. Valid Values: `ResourceImport` or `ArchitectureReplication`.
        """
        return pulumi.get(self, "template_scratch_type")

