# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IngressArgs', 'Ingress']

@pulumi.input_type
class IngressArgs:
    def __init__(__self__, *,
                 listener_port: pulumi.Input[int],
                 namespace_id: pulumi.Input[str],
                 rules: pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]],
                 slb_id: pulumi.Input[str],
                 cert_id: Optional[pulumi.Input[str]] = None,
                 cert_ids: Optional[pulumi.Input[str]] = None,
                 default_rule: Optional[pulumi.Input['IngressDefaultRuleArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balance_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Ingress resource.
        :param pulumi.Input[int] listener_port: SLB listening port.
        :param pulumi.Input[str] namespace_id: The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        :param pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]] rules: Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        :param pulumi.Input[str] slb_id: SLB ID.
        :param pulumi.Input[str] cert_id: The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        :param pulumi.Input[str] cert_ids: The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        :param pulumi.Input['IngressDefaultRuleArgs'] default_rule: Default Rule. See `default_rule` below.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[str] listener_protocol: The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        :param pulumi.Input[str] load_balance_type: The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "namespace_id", namespace_id)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "slb_id", slb_id)
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_ids is not None:
            pulumi.set(__self__, "cert_ids", cert_ids)
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balance_type is not None:
            pulumi.set(__self__, "load_balance_type", load_balance_type)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[int]:
        """
        SLB listening port.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Input[str]:
        """
        The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]:
        """
        Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> pulumi.Input[str]:
        """
        SLB ID.
        """
        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "slb_id", value)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_id", value)

    @property
    @pulumi.getter(name="certIds")
    def cert_ids(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        """
        return pulumi.get(self, "cert_ids")

    @cert_ids.setter
    def cert_ids(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_ids", value)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input['IngressDefaultRuleArgs']]:
        """
        Default Rule. See `default_rule` below.
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input['IngressDefaultRuleArgs']]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalanceType")
    def load_balance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        """
        return pulumi.get(self, "load_balance_type")

    @load_balance_type.setter
    def load_balance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balance_type", value)


@pulumi.input_type
class _IngressState:
    def __init__(__self__, *,
                 cert_id: Optional[pulumi.Input[str]] = None,
                 cert_ids: Optional[pulumi.Input[str]] = None,
                 default_rule: Optional[pulumi.Input['IngressDefaultRuleArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balance_type: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]] = None,
                 slb_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Ingress resources.
        :param pulumi.Input[str] cert_id: The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        :param pulumi.Input[str] cert_ids: The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        :param pulumi.Input['IngressDefaultRuleArgs'] default_rule: Default Rule. See `default_rule` below.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[int] listener_port: SLB listening port.
        :param pulumi.Input[str] listener_protocol: The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        :param pulumi.Input[str] load_balance_type: The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        :param pulumi.Input[str] namespace_id: The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        :param pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]] rules: Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        :param pulumi.Input[str] slb_id: SLB ID.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cert_ids is not None:
            pulumi.set(__self__, "cert_ids", cert_ids)
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_protocol is not None:
            pulumi.set(__self__, "listener_protocol", listener_protocol)
        if load_balance_type is not None:
            pulumi.set(__self__, "load_balance_type", load_balance_type)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if slb_id is not None:
            pulumi.set(__self__, "slb_id", slb_id)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        """
        return pulumi.get(self, "cert_id")

    @cert_id.setter
    def cert_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_id", value)

    @property
    @pulumi.getter(name="certIds")
    def cert_ids(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        """
        return pulumi.get(self, "cert_ids")

    @cert_ids.setter
    def cert_ids(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_ids", value)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input['IngressDefaultRuleArgs']]:
        """
        Default Rule. See `default_rule` below.
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input['IngressDefaultRuleArgs']]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        SLB listening port.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "listener_protocol")

    @listener_protocol.setter
    def listener_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_protocol", value)

    @property
    @pulumi.getter(name="loadBalanceType")
    def load_balance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        """
        return pulumi.get(self, "load_balance_type")

    @load_balance_type.setter
    def load_balance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balance_type", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]]:
        """
        Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IngressRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        SLB ID.
        """
        return pulumi.get(self, "slb_id")

    @slb_id.setter
    def slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slb_id", value)


class Ingress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_id: Optional[pulumi.Input[str]] = None,
                 cert_ids: Optional[pulumi.Input[str]] = None,
                 default_rule: Optional[pulumi.Input[pulumi.InputType['IngressDefaultRuleArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balance_type: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressRuleArgs']]]]] = None,
                 slb_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Serverless App Engine (SAE) Ingress resource.

        For information about Serverless App Engine (SAE) Ingress and how to use it, see [What is Ingress](https://www.alibabacloud.com/help/en/sae/latest/createingress).

        > **NOTE:** Available since v1.137.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("defaultNamespace",
            namespace_id=default_random_integer.result.apply(lambda result: f"{default_regions.regions[0].id}:example{result}"),
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("defaultApplication",
            app_description=name,
            app_name=name,
            namespace_id=default_namespace.id,
            image_url=f"registry-vpc.{default_regions.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
            package_type="Image",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        default_ingress = alicloud.sae.Ingress("defaultIngress",
            slb_id=default_application_load_balancer.id,
            namespace_id=default_namespace.id,
            listener_port=80,
            rules=[alicloud.sae.IngressRuleArgs(
                app_id=default_application.id,
                container_port=443,
                domain="www.alicloud.com",
                app_name=default_application.app_name,
                path="/",
            )],
            default_rule=alicloud.sae.IngressDefaultRuleArgs(
                app_id=default_application.id,
                container_port=443,
            ))
        ```

        ## Import

        Serverless App Engine (SAE) Ingress can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sae/ingress:Ingress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cert_id: The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        :param pulumi.Input[str] cert_ids: The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        :param pulumi.Input[pulumi.InputType['IngressDefaultRuleArgs']] default_rule: Default Rule. See `default_rule` below.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[int] listener_port: SLB listening port.
        :param pulumi.Input[str] listener_protocol: The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        :param pulumi.Input[str] load_balance_type: The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        :param pulumi.Input[str] namespace_id: The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressRuleArgs']]]] rules: Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        :param pulumi.Input[str] slb_id: SLB ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IngressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Serverless App Engine (SAE) Ingress resource.

        For information about Serverless App Engine (SAE) Ingress and how to use it, see [What is Ingress](https://www.alibabacloud.com/help/en/sae/latest/createingress).

        > **NOTE:** Available since v1.137.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("defaultNamespace",
            namespace_id=default_random_integer.result.apply(lambda result: f"{default_regions.regions[0].id}:example{result}"),
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("defaultApplication",
            app_description=name,
            app_name=name,
            namespace_id=default_namespace.id,
            image_url=f"registry-vpc.{default_regions.regions[0].id}.aliyuncs.com/sae-demo-image/consumer:1.0",
            package_type="Image",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        default_ingress = alicloud.sae.Ingress("defaultIngress",
            slb_id=default_application_load_balancer.id,
            namespace_id=default_namespace.id,
            listener_port=80,
            rules=[alicloud.sae.IngressRuleArgs(
                app_id=default_application.id,
                container_port=443,
                domain="www.alicloud.com",
                app_name=default_application.app_name,
                path="/",
            )],
            default_rule=alicloud.sae.IngressDefaultRuleArgs(
                app_id=default_application.id,
                container_port=443,
            ))
        ```

        ## Import

        Serverless App Engine (SAE) Ingress can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sae/ingress:Ingress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param IngressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IngressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cert_id: Optional[pulumi.Input[str]] = None,
                 cert_ids: Optional[pulumi.Input[str]] = None,
                 default_rule: Optional[pulumi.Input[pulumi.InputType['IngressDefaultRuleArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 listener_protocol: Optional[pulumi.Input[str]] = None,
                 load_balance_type: Optional[pulumi.Input[str]] = None,
                 namespace_id: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressRuleArgs']]]]] = None,
                 slb_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IngressArgs.__new__(IngressArgs)

            __props__.__dict__["cert_id"] = cert_id
            __props__.__dict__["cert_ids"] = cert_ids
            __props__.__dict__["default_rule"] = default_rule
            __props__.__dict__["description"] = description
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            __props__.__dict__["listener_protocol"] = listener_protocol
            __props__.__dict__["load_balance_type"] = load_balance_type
            if namespace_id is None and not opts.urn:
                raise TypeError("Missing required property 'namespace_id'")
            __props__.__dict__["namespace_id"] = namespace_id
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if slb_id is None and not opts.urn:
                raise TypeError("Missing required property 'slb_id'")
            __props__.__dict__["slb_id"] = slb_id
        super(Ingress, __self__).__init__(
            'alicloud:sae/ingress:Ingress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cert_id: Optional[pulumi.Input[str]] = None,
            cert_ids: Optional[pulumi.Input[str]] = None,
            default_rule: Optional[pulumi.Input[pulumi.InputType['IngressDefaultRuleArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[int]] = None,
            listener_protocol: Optional[pulumi.Input[str]] = None,
            load_balance_type: Optional[pulumi.Input[str]] = None,
            namespace_id: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressRuleArgs']]]]] = None,
            slb_id: Optional[pulumi.Input[str]] = None) -> 'Ingress':
        """
        Get an existing Ingress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cert_id: The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        :param pulumi.Input[str] cert_ids: The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        :param pulumi.Input[pulumi.InputType['IngressDefaultRuleArgs']] default_rule: Default Rule. See `default_rule` below.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[int] listener_port: SLB listening port.
        :param pulumi.Input[str] listener_protocol: The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        :param pulumi.Input[str] load_balance_type: The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        :param pulumi.Input[str] namespace_id: The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IngressRuleArgs']]]] rules: Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        :param pulumi.Input[str] slb_id: SLB ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IngressState.__new__(_IngressState)

        __props__.__dict__["cert_id"] = cert_id
        __props__.__dict__["cert_ids"] = cert_ids
        __props__.__dict__["default_rule"] = default_rule
        __props__.__dict__["description"] = description
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_protocol"] = listener_protocol
        __props__.__dict__["load_balance_type"] = load_balance_type
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["rules"] = rules
        __props__.__dict__["slb_id"] = slb_id
        return Ingress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate ID of the HTTPS listener. The `cert_id` takes effect only when `load_balance_type` is set to `clb`.
        """
        return pulumi.get(self, "cert_id")

    @property
    @pulumi.getter(name="certIds")
    def cert_ids(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate IDs of the HTTPS listener, and multiple certificate IDs are separated by commas. The `cert_ids` takes effect only when `load_balance_type` is set to `alb`.
        """
        return pulumi.get(self, "cert_ids")

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> pulumi.Output[Optional['outputs.IngressDefaultRule']]:
        """
        Default Rule. See `default_rule` below.
        """
        return pulumi.get(self, "default_rule")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[int]:
        """
        SLB listening port.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> pulumi.Output[str]:
        """
        The protocol that is used to forward requests. Default value: `HTTP`. Valid values: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "listener_protocol")

    @property
    @pulumi.getter(name="loadBalanceType")
    def load_balance_type(self) -> pulumi.Output[str]:
        """
        The type of the SLB instance. Default value: `clb`. Valid values: `clb`, `alb`.
        """
        return pulumi.get(self, "load_balance_type")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[str]:
        """
        The ID of Namespace. It can contain 2 to 32 lowercase characters.The value is in format `{RegionId}:{namespace}`.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.IngressRule']]:
        """
        Forwarding rules. Forward traffic to the specified application according to the domain name and path. See `rules` below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="slbId")
    def slb_id(self) -> pulumi.Output[str]:
        """
        SLB ID.
        """
        return pulumi.get(self, "slb_id")

