# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerIntranetArgs', 'LoadBalancerIntranet']

@pulumi.input_type
class LoadBalancerIntranetArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[str],
                 intranets: pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]],
                 intranet_slb_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LoadBalancerIntranet resource.
        :param pulumi.Input[str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]] intranets: The bound private network SLB. See `intranet` below.
        :param pulumi.Input[str] intranet_slb_id: The intranet SLB ID.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "intranets", intranets)
        if intranet_slb_id is not None:
            pulumi.set(__self__, "intranet_slb_id", intranet_slb_id)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[str]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter
    def intranets(self) -> pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]]:
        """
        The bound private network SLB. See `intranet` below.
        """
        return pulumi.get(self, "intranets")

    @intranets.setter
    def intranets(self, value: pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]]):
        pulumi.set(self, "intranets", value)

    @property
    @pulumi.getter(name="intranetSlbId")
    def intranet_slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        The intranet SLB ID.
        """
        return pulumi.get(self, "intranet_slb_id")

    @intranet_slb_id.setter
    def intranet_slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intranet_slb_id", value)


@pulumi.input_type
class _LoadBalancerIntranetState:
    def __init__(__self__, *,
                 app_id: Optional[pulumi.Input[str]] = None,
                 intranet_ip: Optional[pulumi.Input[str]] = None,
                 intranet_slb_id: Optional[pulumi.Input[str]] = None,
                 intranets: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]]] = None):
        """
        Input properties used for looking up and filtering LoadBalancerIntranet resources.
        :param pulumi.Input[str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[str] intranet_ip: Use designated private network SLBs that have been purchased to support non-shared instances.
        :param pulumi.Input[str] intranet_slb_id: The intranet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]] intranets: The bound private network SLB. See `intranet` below.
        """
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if intranet_ip is not None:
            pulumi.set(__self__, "intranet_ip", intranet_ip)
        if intranet_slb_id is not None:
            pulumi.set(__self__, "intranet_slb_id", intranet_slb_id)
        if intranets is not None:
            pulumi.set(__self__, "intranets", intranets)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Use designated private network SLBs that have been purchased to support non-shared instances.
        """
        return pulumi.get(self, "intranet_ip")

    @intranet_ip.setter
    def intranet_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intranet_ip", value)

    @property
    @pulumi.getter(name="intranetSlbId")
    def intranet_slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        The intranet SLB ID.
        """
        return pulumi.get(self, "intranet_slb_id")

    @intranet_slb_id.setter
    def intranet_slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intranet_slb_id", value)

    @property
    @pulumi.getter
    def intranets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]]]:
        """
        The bound private network SLB. See `intranet` below.
        """
        return pulumi.get(self, "intranets")

    @intranets.setter
    def intranets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIntranetIntranetArgs']]]]):
        pulumi.set(self, "intranets", value)


class LoadBalancerIntranet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 intranet_slb_id: Optional[pulumi.Input[str]] = None,
                 intranets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerIntranetIntranetArgs']]]]] = None,
                 __props__=None):
        """
        Provides an Alicloud Serverless App Engine (SAE) Application Load Balancer Attachment resource.

        For information about Serverless App Engine (SAE) Load Balancer Intranet Attachment and how to use it, see [sae.LoadBalancerIntranet](https://www.alibabacloud.com/help/en/sae/latest/bindslb).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("defaultNamespace",
            namespace_id=default_random_integer.result.apply(lambda result: f"{default_regions.regions[0].id}:example{result}"),
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("defaultApplication",
            app_description=name,
            app_name=name,
            namespace_id=default_namespace.id,
            image_url="registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
            package_type="Image",
            jdk="Open JDK 8",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        default_load_balancer_intranet = alicloud.sae.LoadBalancerIntranet("defaultLoadBalancerIntranet",
            app_id=default_application.id,
            intranet_slb_id=default_application_load_balancer.id,
            intranets=[alicloud.sae.LoadBalancerIntranetIntranetArgs(
                protocol="TCP",
                port=80,
                target_port=8080,
            )])
        ```

        ## Import

        The resource can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sae/loadBalancerIntranet:LoadBalancerIntranet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[str] intranet_slb_id: The intranet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerIntranetIntranetArgs']]]] intranets: The bound private network SLB. See `intranet` below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerIntranetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Alicloud Serverless App Engine (SAE) Application Load Balancer Attachment resource.

        For information about Serverless App Engine (SAE) Load Balancer Intranet Attachment and how to use it, see [sae.LoadBalancerIntranet](https://www.alibabacloud.com/help/en/sae/latest/bindslb).

        > **NOTE:** Available since v1.165.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_namespace = alicloud.sae.Namespace("defaultNamespace",
            namespace_id=default_random_integer.result.apply(lambda result: f"{default_regions.regions[0].id}:example{result}"),
            namespace_name=name,
            namespace_description=name,
            enable_micro_registration=False)
        default_application = alicloud.sae.Application("defaultApplication",
            app_description=name,
            app_name=name,
            namespace_id=default_namespace.id,
            image_url="registry-vpc.cn-hangzhou.aliyuncs.com/lxepoo/apache-php5",
            package_type="Image",
            jdk="Open JDK 8",
            security_group_id=default_security_group.id,
            vpc_id=default_network.id,
            vswitch_id=default_switch.id,
            timezone="Asia/Beijing",
            replicas=5,
            cpu=500,
            memory=2048)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            load_balancer_name=name,
            vswitch_id=default_switch.id,
            load_balancer_spec="slb.s2.small",
            address_type="intranet")
        default_load_balancer_intranet = alicloud.sae.LoadBalancerIntranet("defaultLoadBalancerIntranet",
            app_id=default_application.id,
            intranet_slb_id=default_application_load_balancer.id,
            intranets=[alicloud.sae.LoadBalancerIntranetIntranetArgs(
                protocol="TCP",
                port=80,
                target_port=8080,
            )])
        ```

        ## Import

        The resource can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sae/loadBalancerIntranet:LoadBalancerIntranet example <id>
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerIntranetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerIntranetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 intranet_slb_id: Optional[pulumi.Input[str]] = None,
                 intranets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerIntranetIntranetArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerIntranetArgs.__new__(LoadBalancerIntranetArgs)

            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            __props__.__dict__["intranet_slb_id"] = intranet_slb_id
            if intranets is None and not opts.urn:
                raise TypeError("Missing required property 'intranets'")
            __props__.__dict__["intranets"] = intranets
            __props__.__dict__["intranet_ip"] = None
        super(LoadBalancerIntranet, __self__).__init__(
            'alicloud:sae/loadBalancerIntranet:LoadBalancerIntranet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            intranet_ip: Optional[pulumi.Input[str]] = None,
            intranet_slb_id: Optional[pulumi.Input[str]] = None,
            intranets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerIntranetIntranetArgs']]]]] = None) -> 'LoadBalancerIntranet':
        """
        Get an existing LoadBalancerIntranet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_id: The target application ID that needs to be bound to the SLB.
        :param pulumi.Input[str] intranet_ip: Use designated private network SLBs that have been purchased to support non-shared instances.
        :param pulumi.Input[str] intranet_slb_id: The intranet SLB ID.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LoadBalancerIntranetIntranetArgs']]]] intranets: The bound private network SLB. See `intranet` below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerIntranetState.__new__(_LoadBalancerIntranetState)

        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["intranet_ip"] = intranet_ip
        __props__.__dict__["intranet_slb_id"] = intranet_slb_id
        __props__.__dict__["intranets"] = intranets
        return LoadBalancerIntranet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The target application ID that needs to be bound to the SLB.
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="intranetIp")
    def intranet_ip(self) -> pulumi.Output[str]:
        """
        Use designated private network SLBs that have been purchased to support non-shared instances.
        """
        return pulumi.get(self, "intranet_ip")

    @property
    @pulumi.getter(name="intranetSlbId")
    def intranet_slb_id(self) -> pulumi.Output[Optional[str]]:
        """
        The intranet SLB ID.
        """
        return pulumi.get(self, "intranet_slb_id")

    @property
    @pulumi.getter
    def intranets(self) -> pulumi.Output[Sequence['outputs.LoadBalancerIntranetIntranet']]:
        """
        The bound private network SLB. See `intranet` below.
        """
        return pulumi.get(self, "intranets")

