# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SmartagFlowLogArgs', 'SmartagFlowLog']

@pulumi.input_type
class SmartagFlowLogArgs:
    def __init__(__self__, *,
                 output_type: pulumi.Input[str],
                 active_aging: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_log_name: Optional[pulumi.Input[str]] = None,
                 inactive_aging: Optional[pulumi.Input[int]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 netflow_server_ip: Optional[pulumi.Input[str]] = None,
                 netflow_server_port: Optional[pulumi.Input[int]] = None,
                 netflow_version: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SmartagFlowLog resource.
        :param pulumi.Input[str] output_type: The location where the flow log is stored. Valid values:
        :param pulumi.Input[int] active_aging: The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        :param pulumi.Input[str] description: The description of the flow log.
        :param pulumi.Input[str] flow_log_name: The name of the flow log.
        :param pulumi.Input[int] inactive_aging: The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        :param pulumi.Input[str] logstore_name: The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_server_ip: The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[int] netflow_server_port: The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_version: The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] project_name: The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] sls_region_id: The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] status: The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        pulumi.set(__self__, "output_type", output_type)
        if active_aging is not None:
            pulumi.set(__self__, "active_aging", active_aging)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_log_name is not None:
            pulumi.set(__self__, "flow_log_name", flow_log_name)
        if inactive_aging is not None:
            pulumi.set(__self__, "inactive_aging", inactive_aging)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if netflow_server_ip is not None:
            pulumi.set(__self__, "netflow_server_ip", netflow_server_ip)
        if netflow_server_port is not None:
            pulumi.set(__self__, "netflow_server_port", netflow_server_port)
        if netflow_version is not None:
            pulumi.set(__self__, "netflow_version", netflow_version)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if sls_region_id is not None:
            pulumi.set(__self__, "sls_region_id", sls_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Input[str]:
        """
        The location where the flow log is stored. Valid values:
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter(name="activeAging")
    def active_aging(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        """
        return pulumi.get(self, "active_aging")

    @active_aging.setter
    def active_aging(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "active_aging", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the flow log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flow log.
        """
        return pulumi.get(self, "flow_log_name")

    @flow_log_name.setter
    def flow_log_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flow_log_name", value)

    @property
    @pulumi.getter(name="inactiveAging")
    def inactive_aging(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        """
        return pulumi.get(self, "inactive_aging")

    @inactive_aging.setter
    def inactive_aging(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "inactive_aging", value)

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logstore_name", value)

    @property
    @pulumi.getter(name="netflowServerIp")
    def netflow_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_ip")

    @netflow_server_ip.setter
    def netflow_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netflow_server_ip", value)

    @property
    @pulumi.getter(name="netflowServerPort")
    def netflow_server_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_port")

    @netflow_server_port.setter
    def netflow_server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "netflow_server_port", value)

    @property
    @pulumi.getter(name="netflowVersion")
    def netflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_version")

    @netflow_version.setter
    def netflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netflow_version", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "sls_region_id")

    @sls_region_id.setter
    def sls_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sls_region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _SmartagFlowLogState:
    def __init__(__self__, *,
                 active_aging: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_log_name: Optional[pulumi.Input[str]] = None,
                 inactive_aging: Optional[pulumi.Input[int]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 netflow_server_ip: Optional[pulumi.Input[str]] = None,
                 netflow_server_port: Optional[pulumi.Input[int]] = None,
                 netflow_version: Optional[pulumi.Input[str]] = None,
                 output_type: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SmartagFlowLog resources.
        :param pulumi.Input[int] active_aging: The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        :param pulumi.Input[str] description: The description of the flow log.
        :param pulumi.Input[str] flow_log_name: The name of the flow log.
        :param pulumi.Input[int] inactive_aging: The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        :param pulumi.Input[str] logstore_name: The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_server_ip: The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[int] netflow_server_port: The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_version: The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] output_type: The location where the flow log is stored. Valid values:
        :param pulumi.Input[str] project_name: The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] sls_region_id: The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] status: The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        if active_aging is not None:
            pulumi.set(__self__, "active_aging", active_aging)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_log_name is not None:
            pulumi.set(__self__, "flow_log_name", flow_log_name)
        if inactive_aging is not None:
            pulumi.set(__self__, "inactive_aging", inactive_aging)
        if logstore_name is not None:
            pulumi.set(__self__, "logstore_name", logstore_name)
        if netflow_server_ip is not None:
            pulumi.set(__self__, "netflow_server_ip", netflow_server_ip)
        if netflow_server_port is not None:
            pulumi.set(__self__, "netflow_server_port", netflow_server_port)
        if netflow_version is not None:
            pulumi.set(__self__, "netflow_version", netflow_version)
        if output_type is not None:
            pulumi.set(__self__, "output_type", output_type)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if sls_region_id is not None:
            pulumi.set(__self__, "sls_region_id", sls_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="activeAging")
    def active_aging(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        """
        return pulumi.get(self, "active_aging")

    @active_aging.setter
    def active_aging(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "active_aging", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the flow log.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flow log.
        """
        return pulumi.get(self, "flow_log_name")

    @flow_log_name.setter
    def flow_log_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flow_log_name", value)

    @property
    @pulumi.getter(name="inactiveAging")
    def inactive_aging(self) -> Optional[pulumi.Input[int]]:
        """
        The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        """
        return pulumi.get(self, "inactive_aging")

    @inactive_aging.setter
    def inactive_aging(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "inactive_aging", value)

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "logstore_name")

    @logstore_name.setter
    def logstore_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logstore_name", value)

    @property
    @pulumi.getter(name="netflowServerIp")
    def netflow_server_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_ip")

    @netflow_server_ip.setter
    def netflow_server_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netflow_server_ip", value)

    @property
    @pulumi.getter(name="netflowServerPort")
    def netflow_server_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_port")

    @netflow_server_port.setter
    def netflow_server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "netflow_server_port", value)

    @property
    @pulumi.getter(name="netflowVersion")
    def netflow_version(self) -> Optional[pulumi.Input[str]]:
        """
        The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_version")

    @netflow_version.setter
    def netflow_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netflow_version", value)

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> Optional[pulumi.Input[str]]:
        """
        The location where the flow log is stored. Valid values:
        """
        return pulumi.get(self, "output_type")

    @output_type.setter
    def output_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_type", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "sls_region_id")

    @sls_region_id.setter
    def sls_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sls_region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class SmartagFlowLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_aging: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_log_name: Optional[pulumi.Input[str]] = None,
                 inactive_aging: Optional[pulumi.Input[int]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 netflow_server_ip: Optional[pulumi.Input[str]] = None,
                 netflow_server_port: Optional[pulumi.Input[int]] = None,
                 netflow_version: Optional[pulumi.Input[str]] = None,
                 output_type: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Smartag Flow Log resource.

        For information about Smartag Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createflowlog).

        > **NOTE:** Available since v1.168.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.sag.SmartagFlowLog("example",
            netflow_server_ip="192.168.0.2",
            netflow_server_port=9995,
            netflow_version="V9",
            output_type="netflow")
        ```

        ## Import

        Smartag Flow Log can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sag/smartagFlowLog:SmartagFlowLog example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] active_aging: The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        :param pulumi.Input[str] description: The description of the flow log.
        :param pulumi.Input[str] flow_log_name: The name of the flow log.
        :param pulumi.Input[int] inactive_aging: The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        :param pulumi.Input[str] logstore_name: The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_server_ip: The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[int] netflow_server_port: The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_version: The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] output_type: The location where the flow log is stored. Valid values:
        :param pulumi.Input[str] project_name: The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] sls_region_id: The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] status: The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SmartagFlowLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Smartag Flow Log resource.

        For information about Smartag Flow Log and how to use it, see [What is Flow Log](https://www.alibabacloud.com/help/en/smart-access-gateway/latest/createflowlog).

        > **NOTE:** Available since v1.168.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.sag.SmartagFlowLog("example",
            netflow_server_ip="192.168.0.2",
            netflow_server_port=9995,
            netflow_version="V9",
            output_type="netflow")
        ```

        ## Import

        Smartag Flow Log can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:sag/smartagFlowLog:SmartagFlowLog example <id>
        ```

        :param str resource_name: The name of the resource.
        :param SmartagFlowLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmartagFlowLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_aging: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_log_name: Optional[pulumi.Input[str]] = None,
                 inactive_aging: Optional[pulumi.Input[int]] = None,
                 logstore_name: Optional[pulumi.Input[str]] = None,
                 netflow_server_ip: Optional[pulumi.Input[str]] = None,
                 netflow_server_port: Optional[pulumi.Input[int]] = None,
                 netflow_version: Optional[pulumi.Input[str]] = None,
                 output_type: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmartagFlowLogArgs.__new__(SmartagFlowLogArgs)

            __props__.__dict__["active_aging"] = active_aging
            __props__.__dict__["description"] = description
            __props__.__dict__["flow_log_name"] = flow_log_name
            __props__.__dict__["inactive_aging"] = inactive_aging
            __props__.__dict__["logstore_name"] = logstore_name
            __props__.__dict__["netflow_server_ip"] = netflow_server_ip
            __props__.__dict__["netflow_server_port"] = netflow_server_port
            __props__.__dict__["netflow_version"] = netflow_version
            if output_type is None and not opts.urn:
                raise TypeError("Missing required property 'output_type'")
            __props__.__dict__["output_type"] = output_type
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["sls_region_id"] = sls_region_id
            __props__.__dict__["status"] = status
        super(SmartagFlowLog, __self__).__init__(
            'alicloud:sag/smartagFlowLog:SmartagFlowLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_aging: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            flow_log_name: Optional[pulumi.Input[str]] = None,
            inactive_aging: Optional[pulumi.Input[int]] = None,
            logstore_name: Optional[pulumi.Input[str]] = None,
            netflow_server_ip: Optional[pulumi.Input[str]] = None,
            netflow_server_port: Optional[pulumi.Input[int]] = None,
            netflow_version: Optional[pulumi.Input[str]] = None,
            output_type: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            sls_region_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'SmartagFlowLog':
        """
        Get an existing SmartagFlowLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] active_aging: The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        :param pulumi.Input[str] description: The description of the flow log.
        :param pulumi.Input[str] flow_log_name: The name of the flow log.
        :param pulumi.Input[int] inactive_aging: The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        :param pulumi.Input[str] logstore_name: The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_server_ip: The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[int] netflow_server_port: The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] netflow_version: The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        :param pulumi.Input[str] output_type: The location where the flow log is stored. Valid values:
        :param pulumi.Input[str] project_name: The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] sls_region_id: The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        :param pulumi.Input[str] status: The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmartagFlowLogState.__new__(_SmartagFlowLogState)

        __props__.__dict__["active_aging"] = active_aging
        __props__.__dict__["description"] = description
        __props__.__dict__["flow_log_name"] = flow_log_name
        __props__.__dict__["inactive_aging"] = inactive_aging
        __props__.__dict__["logstore_name"] = logstore_name
        __props__.__dict__["netflow_server_ip"] = netflow_server_ip
        __props__.__dict__["netflow_server_port"] = netflow_server_port
        __props__.__dict__["netflow_version"] = netflow_version
        __props__.__dict__["output_type"] = output_type
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["sls_region_id"] = sls_region_id
        __props__.__dict__["status"] = status
        return SmartagFlowLog(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeAging")
    def active_aging(self) -> pulumi.Output[int]:
        """
        The time interval at which log data of active connections is collected. Valid values: `60` to `6000`. Default value: `300`. Unit: second.
        """
        return pulumi.get(self, "active_aging")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the flow log.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the flow log.
        """
        return pulumi.get(self, "flow_log_name")

    @property
    @pulumi.getter(name="inactiveAging")
    def inactive_aging(self) -> pulumi.Output[int]:
        """
        The time interval at which log data of inactive connections is connected. Valid values: `10` to `600`. Default value: `15`. Unit: second.
        """
        return pulumi.get(self, "inactive_aging")

    @property
    @pulumi.getter(name="logstoreName")
    def logstore_name(self) -> pulumi.Output[Optional[str]]:
        """
        The Logstore in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "logstore_name")

    @property
    @pulumi.getter(name="netflowServerIp")
    def netflow_server_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address of the NetFlow collector where the flow log is stored. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_ip")

    @property
    @pulumi.getter(name="netflowServerPort")
    def netflow_server_port(self) -> pulumi.Output[int]:
        """
        The port of the NetFlow collector. Default value: `9995`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_server_port")

    @property
    @pulumi.getter(name="netflowVersion")
    def netflow_version(self) -> pulumi.Output[str]:
        """
        The NetFlow version. Default value: `V9`. Valid values: `V10`, `V5`, `V9`. If `output_type` is set to `netflow` or `all`, this parameter is required.
        """
        return pulumi.get(self, "netflow_version")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> pulumi.Output[str]:
        """
        The location where the flow log is stored. Valid values:
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[Optional[str]]:
        """
        The project in Log Service. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the region where Log Service is deployed. If `output_type` is set to `sls` or `all`, this parameter is required.
        """
        return pulumi.get(self, "sls_region_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the flow log. Valid values:  `Active`: The flow log is enabled. `Inactive`: The flow log is disabled.
        """
        return pulumi.get(self, "status")

