# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ServiceMeshExtraConfigurationArgs',
    'ServiceMeshLoadBalancerArgs',
    'ServiceMeshMeshConfigArgs',
    'ServiceMeshMeshConfigAccessLogArgs',
    'ServiceMeshMeshConfigAuditArgs',
    'ServiceMeshMeshConfigControlPlaneLogArgs',
    'ServiceMeshMeshConfigKialiArgs',
    'ServiceMeshMeshConfigOpaArgs',
    'ServiceMeshMeshConfigPilotArgs',
    'ServiceMeshMeshConfigPrometheusArgs',
    'ServiceMeshMeshConfigProxyArgs',
    'ServiceMeshMeshConfigSidecarInjectorArgs',
    'ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs',
    'ServiceMeshNetworkArgs',
    'UserPermissionPermissionArgs',
]

@pulumi.input_type
class ServiceMeshExtraConfigurationArgs:
    def __init__(__self__, *,
                 cr_aggregation_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] cr_aggregation_enabled: Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
        """
        if cr_aggregation_enabled is not None:
            pulumi.set(__self__, "cr_aggregation_enabled", cr_aggregation_enabled)

    @property
    @pulumi.getter(name="crAggregationEnabled")
    def cr_aggregation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
        """
        return pulumi.get(self, "cr_aggregation_enabled")

    @cr_aggregation_enabled.setter
    def cr_aggregation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cr_aggregation_enabled", value)


@pulumi.input_type
class ServiceMeshLoadBalancerArgs:
    def __init__(__self__, *,
                 api_server_loadbalancer_id: Optional[pulumi.Input[str]] = None,
                 api_server_public_eip: Optional[pulumi.Input[bool]] = None,
                 pilot_public_eip: Optional[pulumi.Input[bool]] = None,
                 pilot_public_loadbalancer_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] api_server_loadbalancer_id: The IP address of a public network exposed API Server corresponding to the load balancing ID.
        :param pulumi.Input[bool] api_server_public_eip: Indicates whether to use the IP address of a public network exposed API Server.
        :param pulumi.Input[bool] pilot_public_eip: Indicates whether to use the IP address of a public network exposure Istio Pilot.
        :param pulumi.Input[str] pilot_public_loadbalancer_id: The IP address of a public network exposure Istio Pilot corresponds to the load balancing ID.
        """
        if api_server_loadbalancer_id is not None:
            pulumi.set(__self__, "api_server_loadbalancer_id", api_server_loadbalancer_id)
        if api_server_public_eip is not None:
            pulumi.set(__self__, "api_server_public_eip", api_server_public_eip)
        if pilot_public_eip is not None:
            pulumi.set(__self__, "pilot_public_eip", pilot_public_eip)
        if pilot_public_loadbalancer_id is not None:
            pulumi.set(__self__, "pilot_public_loadbalancer_id", pilot_public_loadbalancer_id)

    @property
    @pulumi.getter(name="apiServerLoadbalancerId")
    def api_server_loadbalancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of a public network exposed API Server corresponding to the load balancing ID.
        """
        return pulumi.get(self, "api_server_loadbalancer_id")

    @api_server_loadbalancer_id.setter
    def api_server_loadbalancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_server_loadbalancer_id", value)

    @property
    @pulumi.getter(name="apiServerPublicEip")
    def api_server_public_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use the IP address of a public network exposed API Server.
        """
        return pulumi.get(self, "api_server_public_eip")

    @api_server_public_eip.setter
    def api_server_public_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "api_server_public_eip", value)

    @property
    @pulumi.getter(name="pilotPublicEip")
    def pilot_public_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to use the IP address of a public network exposure Istio Pilot.
        """
        return pulumi.get(self, "pilot_public_eip")

    @pilot_public_eip.setter
    def pilot_public_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pilot_public_eip", value)

    @property
    @pulumi.getter(name="pilotPublicLoadbalancerId")
    def pilot_public_loadbalancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of a public network exposure Istio Pilot corresponds to the load balancing ID.
        """
        return pulumi.get(self, "pilot_public_loadbalancer_id")

    @pilot_public_loadbalancer_id.setter
    def pilot_public_loadbalancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pilot_public_loadbalancer_id", value)


@pulumi.input_type
class ServiceMeshMeshConfigArgs:
    def __init__(__self__, *,
                 access_log: Optional[pulumi.Input['ServiceMeshMeshConfigAccessLogArgs']] = None,
                 audit: Optional[pulumi.Input['ServiceMeshMeshConfigAuditArgs']] = None,
                 control_plane_log: Optional[pulumi.Input['ServiceMeshMeshConfigControlPlaneLogArgs']] = None,
                 customized_zipkin: Optional[pulumi.Input[bool]] = None,
                 enable_locality_lb: Optional[pulumi.Input[bool]] = None,
                 include_ip_ranges: Optional[pulumi.Input[str]] = None,
                 kiali: Optional[pulumi.Input['ServiceMeshMeshConfigKialiArgs']] = None,
                 opa: Optional[pulumi.Input['ServiceMeshMeshConfigOpaArgs']] = None,
                 outbound_traffic_policy: Optional[pulumi.Input[str]] = None,
                 pilot: Optional[pulumi.Input['ServiceMeshMeshConfigPilotArgs']] = None,
                 prometheus: Optional[pulumi.Input['ServiceMeshMeshConfigPrometheusArgs']] = None,
                 proxy: Optional[pulumi.Input['ServiceMeshMeshConfigProxyArgs']] = None,
                 sidecar_injector: Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorArgs']] = None,
                 telemetry: Optional[pulumi.Input[bool]] = None,
                 tracing: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['ServiceMeshMeshConfigAccessLogArgs'] access_log: The access logging configuration. See `access_log` below.
        :param pulumi.Input['ServiceMeshMeshConfigAuditArgs'] audit: Audit information. See `audit` below.
        :param pulumi.Input['ServiceMeshMeshConfigControlPlaneLogArgs'] control_plane_log: Control plane log collection configuration. See `control_plane_log` below.
        :param pulumi.Input[bool] customized_zipkin: Whether or not to enable the use of a custom zipkin.
        :param pulumi.Input[bool] enable_locality_lb: Whether to enable service can access the service through the nearest node access.
        :param pulumi.Input[str] include_ip_ranges: The IP ADDRESS range.
        :param pulumi.Input['ServiceMeshMeshConfigKialiArgs'] kiali: Kiali configuration. See `kiali` below.
        :param pulumi.Input['ServiceMeshMeshConfigOpaArgs'] opa: The open-door policy of agent (OPA) plug-in information. See `opa` below.
        :param pulumi.Input[str] outbound_traffic_policy: Out to the traffic policy.
        :param pulumi.Input['ServiceMeshMeshConfigPilotArgs'] pilot: Link trace sampling information. See `pilot` below.
        :param pulumi.Input['ServiceMeshMeshConfigPrometheusArgs'] prometheus: Prometheus configuration.
        :param pulumi.Input['ServiceMeshMeshConfigProxyArgs'] proxy: Proxy configuration. See `proxy` below.
        :param pulumi.Input['ServiceMeshMeshConfigSidecarInjectorArgs'] sidecar_injector: Sidecar injector configuration. See `sidecar_injector` below.
        :param pulumi.Input[bool] telemetry: Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
        :param pulumi.Input[bool] tracing: Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
        """
        if access_log is not None:
            pulumi.set(__self__, "access_log", access_log)
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if control_plane_log is not None:
            pulumi.set(__self__, "control_plane_log", control_plane_log)
        if customized_zipkin is not None:
            pulumi.set(__self__, "customized_zipkin", customized_zipkin)
        if enable_locality_lb is not None:
            pulumi.set(__self__, "enable_locality_lb", enable_locality_lb)
        if include_ip_ranges is not None:
            pulumi.set(__self__, "include_ip_ranges", include_ip_ranges)
        if kiali is not None:
            pulumi.set(__self__, "kiali", kiali)
        if opa is not None:
            pulumi.set(__self__, "opa", opa)
        if outbound_traffic_policy is not None:
            pulumi.set(__self__, "outbound_traffic_policy", outbound_traffic_policy)
        if pilot is not None:
            pulumi.set(__self__, "pilot", pilot)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if sidecar_injector is not None:
            pulumi.set(__self__, "sidecar_injector", sidecar_injector)
        if telemetry is not None:
            pulumi.set(__self__, "telemetry", telemetry)
        if tracing is not None:
            pulumi.set(__self__, "tracing", tracing)

    @property
    @pulumi.getter(name="accessLog")
    def access_log(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigAccessLogArgs']]:
        """
        The access logging configuration. See `access_log` below.
        """
        return pulumi.get(self, "access_log")

    @access_log.setter
    def access_log(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigAccessLogArgs']]):
        pulumi.set(self, "access_log", value)

    @property
    @pulumi.getter
    def audit(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigAuditArgs']]:
        """
        Audit information. See `audit` below.
        """
        return pulumi.get(self, "audit")

    @audit.setter
    def audit(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigAuditArgs']]):
        pulumi.set(self, "audit", value)

    @property
    @pulumi.getter(name="controlPlaneLog")
    def control_plane_log(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigControlPlaneLogArgs']]:
        """
        Control plane log collection configuration. See `control_plane_log` below.
        """
        return pulumi.get(self, "control_plane_log")

    @control_plane_log.setter
    def control_plane_log(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigControlPlaneLogArgs']]):
        pulumi.set(self, "control_plane_log", value)

    @property
    @pulumi.getter(name="customizedZipkin")
    def customized_zipkin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the use of a custom zipkin.
        """
        return pulumi.get(self, "customized_zipkin")

    @customized_zipkin.setter
    def customized_zipkin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "customized_zipkin", value)

    @property
    @pulumi.getter(name="enableLocalityLb")
    def enable_locality_lb(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable service can access the service through the nearest node access.
        """
        return pulumi.get(self, "enable_locality_lb")

    @enable_locality_lb.setter
    def enable_locality_lb(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_locality_lb", value)

    @property
    @pulumi.getter(name="includeIpRanges")
    def include_ip_ranges(self) -> Optional[pulumi.Input[str]]:
        """
        The IP ADDRESS range.
        """
        return pulumi.get(self, "include_ip_ranges")

    @include_ip_ranges.setter
    def include_ip_ranges(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "include_ip_ranges", value)

    @property
    @pulumi.getter
    def kiali(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigKialiArgs']]:
        """
        Kiali configuration. See `kiali` below.
        """
        return pulumi.get(self, "kiali")

    @kiali.setter
    def kiali(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigKialiArgs']]):
        pulumi.set(self, "kiali", value)

    @property
    @pulumi.getter
    def opa(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigOpaArgs']]:
        """
        The open-door policy of agent (OPA) plug-in information. See `opa` below.
        """
        return pulumi.get(self, "opa")

    @opa.setter
    def opa(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigOpaArgs']]):
        pulumi.set(self, "opa", value)

    @property
    @pulumi.getter(name="outboundTrafficPolicy")
    def outbound_traffic_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Out to the traffic policy.
        """
        return pulumi.get(self, "outbound_traffic_policy")

    @outbound_traffic_policy.setter
    def outbound_traffic_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outbound_traffic_policy", value)

    @property
    @pulumi.getter
    def pilot(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigPilotArgs']]:
        """
        Link trace sampling information. See `pilot` below.
        """
        return pulumi.get(self, "pilot")

    @pilot.setter
    def pilot(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigPilotArgs']]):
        pulumi.set(self, "pilot", value)

    @property
    @pulumi.getter
    def prometheus(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigPrometheusArgs']]:
        """
        Prometheus configuration.
        """
        return pulumi.get(self, "prometheus")

    @prometheus.setter
    def prometheus(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigPrometheusArgs']]):
        pulumi.set(self, "prometheus", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigProxyArgs']]:
        """
        Proxy configuration. See `proxy` below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="sidecarInjector")
    def sidecar_injector(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorArgs']]:
        """
        Sidecar injector configuration. See `sidecar_injector` below.
        """
        return pulumi.get(self, "sidecar_injector")

    @sidecar_injector.setter
    def sidecar_injector(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorArgs']]):
        pulumi.set(self, "sidecar_injector", value)

    @property
    @pulumi.getter
    def telemetry(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
        """
        return pulumi.get(self, "telemetry")

    @telemetry.setter
    def telemetry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "telemetry", value)

    @property
    @pulumi.getter
    def tracing(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
        """
        return pulumi.get(self, "tracing")

    @tracing.setter
    def tracing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tracing", value)


@pulumi.input_type
class ServiceMeshMeshConfigAccessLogArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class ServiceMeshMeshConfigAuditArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class ServiceMeshMeshConfigControlPlaneLogArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class ServiceMeshMeshConfigKialiArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] url: Grid topology service address.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Grid topology service address.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class ServiceMeshMeshConfigOpaArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 limit_cpu: Optional[pulumi.Input[str]] = None,
                 limit_memory: Optional[pulumi.Input[str]] = None,
                 log_level: Optional[pulumi.Input[str]] = None,
                 request_cpu: Optional[pulumi.Input[str]] = None,
                 request_memory: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] limit_cpu: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] limit_memory: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] log_level: OPA proxy container log level.
        :param pulumi.Input[str] request_cpu: Sidecar injector Pods on the requested resource.
        :param pulumi.Input[str] request_memory: Sidecar injector Pods on the requested resource.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @limit_cpu.setter
    def limit_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_cpu", value)

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @limit_memory.setter
    def limit_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_memory", value)

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[str]]:
        """
        OPA proxy container log level.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_level", value)

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @request_cpu.setter
    def request_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_cpu", value)

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")

    @request_memory.setter
    def request_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_memory", value)


@pulumi.input_type
class ServiceMeshMeshConfigPilotArgs:
    def __init__(__self__, *,
                 http10_enabled: Optional[pulumi.Input[bool]] = None,
                 trace_sampling: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[bool] http10_enabled: Whether to support the HTTP1.0.
        :param pulumi.Input[float] trace_sampling: Link trace sampling percentage.
        """
        if http10_enabled is not None:
            pulumi.set(__self__, "http10_enabled", http10_enabled)
        if trace_sampling is not None:
            pulumi.set(__self__, "trace_sampling", trace_sampling)

    @property
    @pulumi.getter(name="http10Enabled")
    def http10_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to support the HTTP1.0.
        """
        return pulumi.get(self, "http10_enabled")

    @http10_enabled.setter
    def http10_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http10_enabled", value)

    @property
    @pulumi.getter(name="traceSampling")
    def trace_sampling(self) -> Optional[pulumi.Input[float]]:
        """
        Link trace sampling percentage.
        """
        return pulumi.get(self, "trace_sampling")

    @trace_sampling.setter
    def trace_sampling(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "trace_sampling", value)


@pulumi.input_type
class ServiceMeshMeshConfigPrometheusArgs:
    def __init__(__self__, *,
                 external_url: Optional[pulumi.Input[str]] = None,
                 use_external: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] external_url: Prometheus service addresses (enabled external Prometheus when the system automatically populates).
        :param pulumi.Input[bool] use_external: Whether to enable external Prometheus.
        """
        if external_url is not None:
            pulumi.set(__self__, "external_url", external_url)
        if use_external is not None:
            pulumi.set(__self__, "use_external", use_external)

    @property
    @pulumi.getter(name="externalUrl")
    def external_url(self) -> Optional[pulumi.Input[str]]:
        """
        Prometheus service addresses (enabled external Prometheus when the system automatically populates).
        """
        return pulumi.get(self, "external_url")

    @external_url.setter
    def external_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_url", value)

    @property
    @pulumi.getter(name="useExternal")
    def use_external(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable external Prometheus.
        """
        return pulumi.get(self, "use_external")

    @use_external.setter
    def use_external(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_external", value)


@pulumi.input_type
class ServiceMeshMeshConfigProxyArgs:
    def __init__(__self__, *,
                 cluster_domain: Optional[pulumi.Input[str]] = None,
                 limit_cpu: Optional[pulumi.Input[str]] = None,
                 limit_memory: Optional[pulumi.Input[str]] = None,
                 request_cpu: Optional[pulumi.Input[str]] = None,
                 request_memory: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cluster_domain: Trust cluster domain.
        :param pulumi.Input[str] limit_cpu: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] limit_memory: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] request_cpu: Sidecar injector Pods on the requested resource.
        :param pulumi.Input[str] request_memory: Sidecar injector Pods on the requested resource.
        """
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Trust cluster domain.
        """
        return pulumi.get(self, "cluster_domain")

    @cluster_domain.setter
    def cluster_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_domain", value)

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @limit_cpu.setter
    def limit_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_cpu", value)

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @limit_memory.setter
    def limit_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_memory", value)

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @request_cpu.setter
    def request_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_cpu", value)

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")

    @request_memory.setter
    def request_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_memory", value)


@pulumi.input_type
class ServiceMeshMeshConfigSidecarInjectorArgs:
    def __init__(__self__, *,
                 auto_injection_policy_enabled: Optional[pulumi.Input[bool]] = None,
                 enable_namespaces_by_default: Optional[pulumi.Input[bool]] = None,
                 init_cni_configuration: Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs']] = None,
                 limit_cpu: Optional[pulumi.Input[str]] = None,
                 limit_memory: Optional[pulumi.Input[str]] = None,
                 request_cpu: Optional[pulumi.Input[str]] = None,
                 request_memory: Optional[pulumi.Input[str]] = None,
                 sidecar_injector_webhook_as_yaml: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] auto_injection_policy_enabled: Whether to enable by Pod Annotations automatic injection Sidecar.
        :param pulumi.Input[bool] enable_namespaces_by_default: Whether it is the all namespaces you turn on the auto injection capabilities.
        :param pulumi.Input['ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs'] init_cni_configuration: CNI configuration. See `init_cni_configuration` below.
        :param pulumi.Input[str] limit_cpu: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] limit_memory: Sidecar injector Pods on the throttle.
        :param pulumi.Input[str] request_cpu: Sidecar injector Pods on the requested resource.
        :param pulumi.Input[str] request_memory: Sidecar injector Pods on the requested resource.
        :param pulumi.Input[str] sidecar_injector_webhook_as_yaml: Other configurations of automatically injected sidecar (in YAML format).
        """
        if auto_injection_policy_enabled is not None:
            pulumi.set(__self__, "auto_injection_policy_enabled", auto_injection_policy_enabled)
        if enable_namespaces_by_default is not None:
            pulumi.set(__self__, "enable_namespaces_by_default", enable_namespaces_by_default)
        if init_cni_configuration is not None:
            pulumi.set(__self__, "init_cni_configuration", init_cni_configuration)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)
        if sidecar_injector_webhook_as_yaml is not None:
            pulumi.set(__self__, "sidecar_injector_webhook_as_yaml", sidecar_injector_webhook_as_yaml)

    @property
    @pulumi.getter(name="autoInjectionPolicyEnabled")
    def auto_injection_policy_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable by Pod Annotations automatic injection Sidecar.
        """
        return pulumi.get(self, "auto_injection_policy_enabled")

    @auto_injection_policy_enabled.setter
    def auto_injection_policy_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_injection_policy_enabled", value)

    @property
    @pulumi.getter(name="enableNamespacesByDefault")
    def enable_namespaces_by_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether it is the all namespaces you turn on the auto injection capabilities.
        """
        return pulumi.get(self, "enable_namespaces_by_default")

    @enable_namespaces_by_default.setter
    def enable_namespaces_by_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_namespaces_by_default", value)

    @property
    @pulumi.getter(name="initCniConfiguration")
    def init_cni_configuration(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs']]:
        """
        CNI configuration. See `init_cni_configuration` below.
        """
        return pulumi.get(self, "init_cni_configuration")

    @init_cni_configuration.setter
    def init_cni_configuration(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs']]):
        pulumi.set(self, "init_cni_configuration", value)

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @limit_cpu.setter
    def limit_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_cpu", value)

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @limit_memory.setter
    def limit_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "limit_memory", value)

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @request_cpu.setter
    def request_cpu(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_cpu", value)

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[pulumi.Input[str]]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")

    @request_memory.setter
    def request_memory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_memory", value)

    @property
    @pulumi.getter(name="sidecarInjectorWebhookAsYaml")
    def sidecar_injector_webhook_as_yaml(self) -> Optional[pulumi.Input[str]]:
        """
        Other configurations of automatically injected sidecar (in YAML format).
        """
        return pulumi.get(self, "sidecar_injector_webhook_as_yaml")

    @sidecar_injector_webhook_as_yaml.setter
    def sidecar_injector_webhook_as_yaml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sidecar_injector_webhook_as_yaml", value)


@pulumi.input_type
class ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 exclude_namespaces: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] enabled: Enable CNI.
        :param pulumi.Input[str] exclude_namespaces: The excluded namespace.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_namespaces is not None:
            pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> Optional[pulumi.Input[str]]:
        """
        The excluded namespace.
        """
        return pulumi.get(self, "exclude_namespaces")

    @exclude_namespaces.setter
    def exclude_namespaces(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_namespaces", value)


@pulumi.input_type
class ServiceMeshNetworkArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 vswitche_list: pulumi.Input[str],
                 security_group_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] vpc_id: VPC ID.
        :param pulumi.Input[str] vswitche_list: Virtual Switch ID.
        :param pulumi.Input[str] security_group_id: Security group ID.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitche_list", vswitche_list)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitcheList")
    def vswitche_list(self) -> pulumi.Input[str]:
        """
        Virtual Switch ID.
        """
        return pulumi.get(self, "vswitche_list")

    @vswitche_list.setter
    def vswitche_list(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitche_list", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)


@pulumi.input_type
class UserPermissionPermissionArgs:
    def __init__(__self__, *,
                 is_custom: Optional[pulumi.Input[bool]] = None,
                 is_ram_role: Optional[pulumi.Input[bool]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 role_type: Optional[pulumi.Input[str]] = None,
                 service_mesh_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] is_custom: Whether the grant object is a RAM role.
        :param pulumi.Input[bool] is_ram_role: Whether the grant object is an entity.
        :param pulumi.Input[str] role_name: The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
               - `istio-admin`:  The administrator.
               - `istio-ops`: The administrator of the service mesh resource.
               - `istio-readonly`: The read only permission.
        :param pulumi.Input[str] role_type: The role type. Valid Value: `custom`.
        :param pulumi.Input[str] service_mesh_id: The service mesh id.
        """
        if is_custom is not None:
            pulumi.set(__self__, "is_custom", is_custom)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if service_mesh_id is not None:
            pulumi.set(__self__, "service_mesh_id", service_mesh_id)

    @property
    @pulumi.getter(name="isCustom")
    def is_custom(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the grant object is a RAM role.
        """
        return pulumi.get(self, "is_custom")

    @is_custom.setter
    def is_custom(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_custom", value)

    @property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the grant object is an entity.
        """
        return pulumi.get(self, "is_ram_role")

    @is_ram_role.setter
    def is_ram_role(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ram_role", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
        - `istio-admin`:  The administrator.
        - `istio-ops`: The administrator of the service mesh resource.
        - `istio-readonly`: The read only permission.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[pulumi.Input[str]]:
        """
        The role type. Valid Value: `custom`.
        """
        return pulumi.get(self, "role_type")

    @role_type.setter
    def role_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_type", value)

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> Optional[pulumi.Input[str]]:
        """
        The service mesh id.
        """
        return pulumi.get(self, "service_mesh_id")

    @service_mesh_id.setter
    def service_mesh_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mesh_id", value)


