# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ExtensionProviderArgs', 'ExtensionProvider']

@pulumi.input_type
class ExtensionProviderArgs:
    def __init__(__self__, *,
                 config: pulumi.Input[str],
                 extension_provider_name: pulumi.Input[str],
                 service_mesh_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        The set of arguments for constructing a ExtensionProvider resource.
        :param pulumi.Input[str] config: The config of the Service Mesh Extension Provider. The `config` format is json.
        :param pulumi.Input[str] extension_provider_name: The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        :param pulumi.Input[str] service_mesh_id: The ID of the Service Mesh.
        :param pulumi.Input[str] type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "extension_provider_name", extension_provider_name)
        pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input[str]:
        """
        The config of the Service Mesh Extension Provider. The `config` format is json.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input[str]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="extensionProviderName")
    def extension_provider_name(self) -> pulumi.Input[str]:
        """
        The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        """
        return pulumi.get(self, "extension_provider_name")

    @extension_provider_name.setter
    def extension_provider_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "extension_provider_name", value)

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> pulumi.Input[str]:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "service_mesh_id")

    @service_mesh_id.setter
    def service_mesh_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_mesh_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ExtensionProviderState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[str]] = None,
                 extension_provider_name: Optional[pulumi.Input[str]] = None,
                 service_mesh_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ExtensionProvider resources.
        :param pulumi.Input[str] config: The config of the Service Mesh Extension Provider. The `config` format is json.
        :param pulumi.Input[str] extension_provider_name: The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        :param pulumi.Input[str] service_mesh_id: The ID of the Service Mesh.
        :param pulumi.Input[str] type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if extension_provider_name is not None:
            pulumi.set(__self__, "extension_provider_name", extension_provider_name)
        if service_mesh_id is not None:
            pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The config of the Service Mesh Extension Provider. The `config` format is json.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="extensionProviderName")
    def extension_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        """
        return pulumi.get(self, "extension_provider_name")

    @extension_provider_name.setter
    def extension_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extension_provider_name", value)

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "service_mesh_id")

    @service_mesh_id.setter
    def service_mesh_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mesh_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ExtensionProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 extension_provider_name: Optional[pulumi.Input[str]] = None,
                 service_mesh_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Service Mesh Extension Provider resource.

        For information about Service Mesh Extension Provider and how to use it, see [What is Extension Provider](https://help.aliyun.com/document_detail/461549.html).

        > **NOTE:** Available in v1.191.0+.

        ## Import

        Service Mesh Extension Provider can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:servicemesh/extensionProvider:ExtensionProvider example <service_mesh_id>:<type>:<extension_provider_name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The config of the Service Mesh Extension Provider. The `config` format is json.
        :param pulumi.Input[str] extension_provider_name: The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        :param pulumi.Input[str] service_mesh_id: The ID of the Service Mesh.
        :param pulumi.Input[str] type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtensionProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Mesh Extension Provider resource.

        For information about Service Mesh Extension Provider and how to use it, see [What is Extension Provider](https://help.aliyun.com/document_detail/461549.html).

        > **NOTE:** Available in v1.191.0+.

        ## Import

        Service Mesh Extension Provider can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:servicemesh/extensionProvider:ExtensionProvider example <service_mesh_id>:<type>:<extension_provider_name>
        ```

        :param str resource_name: The name of the resource.
        :param ExtensionProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtensionProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 extension_provider_name: Optional[pulumi.Input[str]] = None,
                 service_mesh_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtensionProviderArgs.__new__(ExtensionProviderArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if extension_provider_name is None and not opts.urn:
                raise TypeError("Missing required property 'extension_provider_name'")
            __props__.__dict__["extension_provider_name"] = extension_provider_name
            if service_mesh_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_mesh_id'")
            __props__.__dict__["service_mesh_id"] = service_mesh_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(ExtensionProvider, __self__).__init__(
            'alicloud:servicemesh/extensionProvider:ExtensionProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[str]] = None,
            extension_provider_name: Optional[pulumi.Input[str]] = None,
            service_mesh_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ExtensionProvider':
        """
        Get an existing ExtensionProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The config of the Service Mesh Extension Provider. The `config` format is json.
        :param pulumi.Input[str] extension_provider_name: The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        :param pulumi.Input[str] service_mesh_id: The ID of the Service Mesh.
        :param pulumi.Input[str] type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtensionProviderState.__new__(_ExtensionProviderState)

        __props__.__dict__["config"] = config
        __props__.__dict__["extension_provider_name"] = extension_provider_name
        __props__.__dict__["service_mesh_id"] = service_mesh_id
        __props__.__dict__["type"] = type
        return ExtensionProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[str]:
        """
        The config of the Service Mesh Extension Provider. The `config` format is json.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="extensionProviderName")
    def extension_provider_name(self) -> pulumi.Output[str]:
        """
        The name of the Service Mesh Extension Provider. It must be prefixed with `$type-`, for example `httpextauth-xxx`, `grpcextauth-xxx`.
        """
        return pulumi.get(self, "extension_provider_name")

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> pulumi.Output[str]:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "service_mesh_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        return pulumi.get(self, "type")

