# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ServiceMeshExtraConfiguration',
    'ServiceMeshLoadBalancer',
    'ServiceMeshMeshConfig',
    'ServiceMeshMeshConfigAccessLog',
    'ServiceMeshMeshConfigAudit',
    'ServiceMeshMeshConfigControlPlaneLog',
    'ServiceMeshMeshConfigKiali',
    'ServiceMeshMeshConfigOpa',
    'ServiceMeshMeshConfigPilot',
    'ServiceMeshMeshConfigPrometheus',
    'ServiceMeshMeshConfigProxy',
    'ServiceMeshMeshConfigSidecarInjector',
    'ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration',
    'ServiceMeshNetwork',
    'UserPermissionPermission',
    'GetExtensionProvidersProviderResult',
    'GetServiceMeshesMeshResult',
    'GetServiceMeshesMeshEndpointResult',
    'GetServiceMeshesMeshLoadBalancerResult',
    'GetServiceMeshesMeshMeshConfigResult',
    'GetServiceMeshesMeshMeshConfigAccessLogResult',
    'GetServiceMeshesMeshMeshConfigAuditResult',
    'GetServiceMeshesMeshMeshConfigControlPlaneLogResult',
    'GetServiceMeshesMeshMeshConfigKialiResult',
    'GetServiceMeshesMeshMeshConfigOpaResult',
    'GetServiceMeshesMeshMeshConfigPilotResult',
    'GetServiceMeshesMeshMeshConfigPrometheusResult',
    'GetServiceMeshesMeshMeshConfigProxyResult',
    'GetServiceMeshesMeshMeshConfigSidecarInjectorResult',
    'GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult',
    'GetServiceMeshesMeshNetworkResult',
    'GetVersionsVersionResult',
]

@pulumi.output_type
class ServiceMeshExtraConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crAggregationEnabled":
            suggest = "cr_aggregation_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshExtraConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshExtraConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshExtraConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cr_aggregation_enabled: Optional[bool] = None):
        """
        :param bool cr_aggregation_enabled: Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
        """
        if cr_aggregation_enabled is not None:
            pulumi.set(__self__, "cr_aggregation_enabled", cr_aggregation_enabled)

    @property
    @pulumi.getter(name="crAggregationEnabled")
    def cr_aggregation_enabled(self) -> Optional[bool]:
        """
        Whether the data plane KubeAPI access capability is enabled. Indicates whether the Kubernetes API of clusters on the data plane is used to access Istio resources. A value of true indicates that the Kubernetes API is used.
        """
        return pulumi.get(self, "cr_aggregation_enabled")


@pulumi.output_type
class ServiceMeshLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiServerLoadbalancerId":
            suggest = "api_server_loadbalancer_id"
        elif key == "apiServerPublicEip":
            suggest = "api_server_public_eip"
        elif key == "pilotPublicEip":
            suggest = "pilot_public_eip"
        elif key == "pilotPublicLoadbalancerId":
            suggest = "pilot_public_loadbalancer_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_server_loadbalancer_id: Optional[str] = None,
                 api_server_public_eip: Optional[bool] = None,
                 pilot_public_eip: Optional[bool] = None,
                 pilot_public_loadbalancer_id: Optional[str] = None):
        """
        :param str api_server_loadbalancer_id: The IP address of a public network exposed API Server corresponding to the load balancing ID.
        :param bool api_server_public_eip: Indicates whether to use the IP address of a public network exposed API Server.
        :param bool pilot_public_eip: Indicates whether to use the IP address of a public network exposure Istio Pilot.
        :param str pilot_public_loadbalancer_id: The IP address of a public network exposure Istio Pilot corresponds to the load balancing ID.
        """
        if api_server_loadbalancer_id is not None:
            pulumi.set(__self__, "api_server_loadbalancer_id", api_server_loadbalancer_id)
        if api_server_public_eip is not None:
            pulumi.set(__self__, "api_server_public_eip", api_server_public_eip)
        if pilot_public_eip is not None:
            pulumi.set(__self__, "pilot_public_eip", pilot_public_eip)
        if pilot_public_loadbalancer_id is not None:
            pulumi.set(__self__, "pilot_public_loadbalancer_id", pilot_public_loadbalancer_id)

    @property
    @pulumi.getter(name="apiServerLoadbalancerId")
    def api_server_loadbalancer_id(self) -> Optional[str]:
        """
        The IP address of a public network exposed API Server corresponding to the load balancing ID.
        """
        return pulumi.get(self, "api_server_loadbalancer_id")

    @property
    @pulumi.getter(name="apiServerPublicEip")
    def api_server_public_eip(self) -> Optional[bool]:
        """
        Indicates whether to use the IP address of a public network exposed API Server.
        """
        return pulumi.get(self, "api_server_public_eip")

    @property
    @pulumi.getter(name="pilotPublicEip")
    def pilot_public_eip(self) -> Optional[bool]:
        """
        Indicates whether to use the IP address of a public network exposure Istio Pilot.
        """
        return pulumi.get(self, "pilot_public_eip")

    @property
    @pulumi.getter(name="pilotPublicLoadbalancerId")
    def pilot_public_loadbalancer_id(self) -> Optional[str]:
        """
        The IP address of a public network exposure Istio Pilot corresponds to the load balancing ID.
        """
        return pulumi.get(self, "pilot_public_loadbalancer_id")


@pulumi.output_type
class ServiceMeshMeshConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessLog":
            suggest = "access_log"
        elif key == "controlPlaneLog":
            suggest = "control_plane_log"
        elif key == "customizedZipkin":
            suggest = "customized_zipkin"
        elif key == "enableLocalityLb":
            suggest = "enable_locality_lb"
        elif key == "includeIpRanges":
            suggest = "include_ip_ranges"
        elif key == "outboundTrafficPolicy":
            suggest = "outbound_traffic_policy"
        elif key == "sidecarInjector":
            suggest = "sidecar_injector"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_log: Optional['outputs.ServiceMeshMeshConfigAccessLog'] = None,
                 audit: Optional['outputs.ServiceMeshMeshConfigAudit'] = None,
                 control_plane_log: Optional['outputs.ServiceMeshMeshConfigControlPlaneLog'] = None,
                 customized_zipkin: Optional[bool] = None,
                 enable_locality_lb: Optional[bool] = None,
                 include_ip_ranges: Optional[str] = None,
                 kiali: Optional['outputs.ServiceMeshMeshConfigKiali'] = None,
                 opa: Optional['outputs.ServiceMeshMeshConfigOpa'] = None,
                 outbound_traffic_policy: Optional[str] = None,
                 pilot: Optional['outputs.ServiceMeshMeshConfigPilot'] = None,
                 prometheus: Optional['outputs.ServiceMeshMeshConfigPrometheus'] = None,
                 proxy: Optional['outputs.ServiceMeshMeshConfigProxy'] = None,
                 sidecar_injector: Optional['outputs.ServiceMeshMeshConfigSidecarInjector'] = None,
                 telemetry: Optional[bool] = None,
                 tracing: Optional[bool] = None):
        """
        :param 'ServiceMeshMeshConfigAccessLogArgs' access_log: The access logging configuration. See `access_log` below.
        :param 'ServiceMeshMeshConfigAuditArgs' audit: Audit information. See `audit` below.
        :param 'ServiceMeshMeshConfigControlPlaneLogArgs' control_plane_log: Control plane log collection configuration. See `control_plane_log` below.
        :param bool customized_zipkin: Whether or not to enable the use of a custom zipkin.
        :param bool enable_locality_lb: Whether to enable service can access the service through the nearest node access.
        :param str include_ip_ranges: The IP ADDRESS range.
        :param 'ServiceMeshMeshConfigKialiArgs' kiali: Kiali configuration. See `kiali` below.
        :param 'ServiceMeshMeshConfigOpaArgs' opa: The open-door policy of agent (OPA) plug-in information. See `opa` below.
        :param str outbound_traffic_policy: Out to the traffic policy.
        :param 'ServiceMeshMeshConfigPilotArgs' pilot: Link trace sampling information. See `pilot` below.
        :param 'ServiceMeshMeshConfigPrometheusArgs' prometheus: Prometheus configuration.
        :param 'ServiceMeshMeshConfigProxyArgs' proxy: Proxy configuration. See `proxy` below.
        :param 'ServiceMeshMeshConfigSidecarInjectorArgs' sidecar_injector: Sidecar injector configuration. See `sidecar_injector` below.
        :param bool telemetry: Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
        :param bool tracing: Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
        """
        if access_log is not None:
            pulumi.set(__self__, "access_log", access_log)
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if control_plane_log is not None:
            pulumi.set(__self__, "control_plane_log", control_plane_log)
        if customized_zipkin is not None:
            pulumi.set(__self__, "customized_zipkin", customized_zipkin)
        if enable_locality_lb is not None:
            pulumi.set(__self__, "enable_locality_lb", enable_locality_lb)
        if include_ip_ranges is not None:
            pulumi.set(__self__, "include_ip_ranges", include_ip_ranges)
        if kiali is not None:
            pulumi.set(__self__, "kiali", kiali)
        if opa is not None:
            pulumi.set(__self__, "opa", opa)
        if outbound_traffic_policy is not None:
            pulumi.set(__self__, "outbound_traffic_policy", outbound_traffic_policy)
        if pilot is not None:
            pulumi.set(__self__, "pilot", pilot)
        if prometheus is not None:
            pulumi.set(__self__, "prometheus", prometheus)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if sidecar_injector is not None:
            pulumi.set(__self__, "sidecar_injector", sidecar_injector)
        if telemetry is not None:
            pulumi.set(__self__, "telemetry", telemetry)
        if tracing is not None:
            pulumi.set(__self__, "tracing", tracing)

    @property
    @pulumi.getter(name="accessLog")
    def access_log(self) -> Optional['outputs.ServiceMeshMeshConfigAccessLog']:
        """
        The access logging configuration. See `access_log` below.
        """
        return pulumi.get(self, "access_log")

    @property
    @pulumi.getter
    def audit(self) -> Optional['outputs.ServiceMeshMeshConfigAudit']:
        """
        Audit information. See `audit` below.
        """
        return pulumi.get(self, "audit")

    @property
    @pulumi.getter(name="controlPlaneLog")
    def control_plane_log(self) -> Optional['outputs.ServiceMeshMeshConfigControlPlaneLog']:
        """
        Control plane log collection configuration. See `control_plane_log` below.
        """
        return pulumi.get(self, "control_plane_log")

    @property
    @pulumi.getter(name="customizedZipkin")
    def customized_zipkin(self) -> Optional[bool]:
        """
        Whether or not to enable the use of a custom zipkin.
        """
        return pulumi.get(self, "customized_zipkin")

    @property
    @pulumi.getter(name="enableLocalityLb")
    def enable_locality_lb(self) -> Optional[bool]:
        """
        Whether to enable service can access the service through the nearest node access.
        """
        return pulumi.get(self, "enable_locality_lb")

    @property
    @pulumi.getter(name="includeIpRanges")
    def include_ip_ranges(self) -> Optional[str]:
        """
        The IP ADDRESS range.
        """
        return pulumi.get(self, "include_ip_ranges")

    @property
    @pulumi.getter
    def kiali(self) -> Optional['outputs.ServiceMeshMeshConfigKiali']:
        """
        Kiali configuration. See `kiali` below.
        """
        return pulumi.get(self, "kiali")

    @property
    @pulumi.getter
    def opa(self) -> Optional['outputs.ServiceMeshMeshConfigOpa']:
        """
        The open-door policy of agent (OPA) plug-in information. See `opa` below.
        """
        return pulumi.get(self, "opa")

    @property
    @pulumi.getter(name="outboundTrafficPolicy")
    def outbound_traffic_policy(self) -> Optional[str]:
        """
        Out to the traffic policy.
        """
        return pulumi.get(self, "outbound_traffic_policy")

    @property
    @pulumi.getter
    def pilot(self) -> Optional['outputs.ServiceMeshMeshConfigPilot']:
        """
        Link trace sampling information. See `pilot` below.
        """
        return pulumi.get(self, "pilot")

    @property
    @pulumi.getter
    def prometheus(self) -> Optional['outputs.ServiceMeshMeshConfigPrometheus']:
        """
        Prometheus configuration.
        """
        return pulumi.get(self, "prometheus")

    @property
    @pulumi.getter
    def proxy(self) -> Optional['outputs.ServiceMeshMeshConfigProxy']:
        """
        Proxy configuration. See `proxy` below.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="sidecarInjector")
    def sidecar_injector(self) -> Optional['outputs.ServiceMeshMeshConfigSidecarInjector']:
        """
        Sidecar injector configuration. See `sidecar_injector` below.
        """
        return pulumi.get(self, "sidecar_injector")

    @property
    @pulumi.getter
    def telemetry(self) -> Optional[bool]:
        """
        Whether to enable acquisition Prometheus metrics (it is recommended that you use [Alibaba Cloud Prometheus monitoring](https://arms.console.aliyun.com/).
        """
        return pulumi.get(self, "telemetry")

    @property
    @pulumi.getter
    def tracing(self) -> Optional[bool]:
        """
        Whether to enable link trace (you need to have [Alibaba Cloud link tracking service](https://tracing-analysis.console.aliyun.com/).
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class ServiceMeshMeshConfigAccessLog(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 project: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ServiceMeshMeshConfigAudit(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 project: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ServiceMeshMeshConfigControlPlaneLog(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 project: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str project: The name of the SLS Project to which the control plane logs are collected.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The name of the SLS Project to which the control plane logs are collected.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ServiceMeshMeshConfigKiali(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 url: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str url: Grid topology service address.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Grid topology service address.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServiceMeshMeshConfigOpa(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigOpa. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigOpa.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigOpa.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 limit_cpu: Optional[str] = None,
                 limit_memory: Optional[str] = None,
                 log_level: Optional[str] = None,
                 request_cpu: Optional[str] = None,
                 request_memory: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: Sidecar injector Pods on the throttle.
        :param str log_level: OPA proxy container log level.
        :param str request_cpu: Sidecar injector Pods on the requested resource.
        :param str request_memory: Sidecar injector Pods on the requested resource.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[str]:
        """
        OPA proxy container log level.
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class ServiceMeshMeshConfigPilot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "http10Enabled":
            suggest = "http10_enabled"
        elif key == "traceSampling":
            suggest = "trace_sampling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigPilot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigPilot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigPilot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http10_enabled: Optional[bool] = None,
                 trace_sampling: Optional[float] = None):
        """
        :param bool http10_enabled: Whether to support the HTTP1.0.
        :param float trace_sampling: Link trace sampling percentage.
        """
        if http10_enabled is not None:
            pulumi.set(__self__, "http10_enabled", http10_enabled)
        if trace_sampling is not None:
            pulumi.set(__self__, "trace_sampling", trace_sampling)

    @property
    @pulumi.getter(name="http10Enabled")
    def http10_enabled(self) -> Optional[bool]:
        """
        Whether to support the HTTP1.0.
        """
        return pulumi.get(self, "http10_enabled")

    @property
    @pulumi.getter(name="traceSampling")
    def trace_sampling(self) -> Optional[float]:
        """
        Link trace sampling percentage.
        """
        return pulumi.get(self, "trace_sampling")


@pulumi.output_type
class ServiceMeshMeshConfigPrometheus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "externalUrl":
            suggest = "external_url"
        elif key == "useExternal":
            suggest = "use_external"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigPrometheus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigPrometheus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigPrometheus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 external_url: Optional[str] = None,
                 use_external: Optional[bool] = None):
        """
        :param str external_url: Prometheus service addresses (enabled external Prometheus when the system automatically populates).
        :param bool use_external: Whether to enable external Prometheus.
        """
        if external_url is not None:
            pulumi.set(__self__, "external_url", external_url)
        if use_external is not None:
            pulumi.set(__self__, "use_external", use_external)

    @property
    @pulumi.getter(name="externalUrl")
    def external_url(self) -> Optional[str]:
        """
        Prometheus service addresses (enabled external Prometheus when the system automatically populates).
        """
        return pulumi.get(self, "external_url")

    @property
    @pulumi.getter(name="useExternal")
    def use_external(self) -> Optional[bool]:
        """
        Whether to enable external Prometheus.
        """
        return pulumi.get(self, "use_external")


@pulumi.output_type
class ServiceMeshMeshConfigProxy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDomain":
            suggest = "cluster_domain"
        elif key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigProxy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigProxy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigProxy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_domain: Optional[str] = None,
                 limit_cpu: Optional[str] = None,
                 limit_memory: Optional[str] = None,
                 request_cpu: Optional[str] = None,
                 request_memory: Optional[str] = None):
        """
        :param str cluster_domain: Trust cluster domain.
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: Sidecar injector Pods on the throttle.
        :param str request_cpu: Sidecar injector Pods on the requested resource.
        :param str request_memory: Sidecar injector Pods on the requested resource.
        """
        if cluster_domain is not None:
            pulumi.set(__self__, "cluster_domain", cluster_domain)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> Optional[str]:
        """
        Trust cluster domain.
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class ServiceMeshMeshConfigSidecarInjector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoInjectionPolicyEnabled":
            suggest = "auto_injection_policy_enabled"
        elif key == "enableNamespacesByDefault":
            suggest = "enable_namespaces_by_default"
        elif key == "initCniConfiguration":
            suggest = "init_cni_configuration"
        elif key == "limitCpu":
            suggest = "limit_cpu"
        elif key == "limitMemory":
            suggest = "limit_memory"
        elif key == "requestCpu":
            suggest = "request_cpu"
        elif key == "requestMemory":
            suggest = "request_memory"
        elif key == "sidecarInjectorWebhookAsYaml":
            suggest = "sidecar_injector_webhook_as_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigSidecarInjector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigSidecarInjector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigSidecarInjector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_injection_policy_enabled: Optional[bool] = None,
                 enable_namespaces_by_default: Optional[bool] = None,
                 init_cni_configuration: Optional['outputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration'] = None,
                 limit_cpu: Optional[str] = None,
                 limit_memory: Optional[str] = None,
                 request_cpu: Optional[str] = None,
                 request_memory: Optional[str] = None,
                 sidecar_injector_webhook_as_yaml: Optional[str] = None):
        """
        :param bool auto_injection_policy_enabled: Whether to enable by Pod Annotations automatic injection Sidecar.
        :param bool enable_namespaces_by_default: Whether it is the all namespaces you turn on the auto injection capabilities.
        :param 'ServiceMeshMeshConfigSidecarInjectorInitCniConfigurationArgs' init_cni_configuration: CNI configuration. See `init_cni_configuration` below.
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: Sidecar injector Pods on the throttle.
        :param str request_cpu: Sidecar injector Pods on the requested resource.
        :param str request_memory: Sidecar injector Pods on the requested resource.
        :param str sidecar_injector_webhook_as_yaml: Other configurations of automatically injected sidecar (in YAML format).
        """
        if auto_injection_policy_enabled is not None:
            pulumi.set(__self__, "auto_injection_policy_enabled", auto_injection_policy_enabled)
        if enable_namespaces_by_default is not None:
            pulumi.set(__self__, "enable_namespaces_by_default", enable_namespaces_by_default)
        if init_cni_configuration is not None:
            pulumi.set(__self__, "init_cni_configuration", init_cni_configuration)
        if limit_cpu is not None:
            pulumi.set(__self__, "limit_cpu", limit_cpu)
        if limit_memory is not None:
            pulumi.set(__self__, "limit_memory", limit_memory)
        if request_cpu is not None:
            pulumi.set(__self__, "request_cpu", request_cpu)
        if request_memory is not None:
            pulumi.set(__self__, "request_memory", request_memory)
        if sidecar_injector_webhook_as_yaml is not None:
            pulumi.set(__self__, "sidecar_injector_webhook_as_yaml", sidecar_injector_webhook_as_yaml)

    @property
    @pulumi.getter(name="autoInjectionPolicyEnabled")
    def auto_injection_policy_enabled(self) -> Optional[bool]:
        """
        Whether to enable by Pod Annotations automatic injection Sidecar.
        """
        return pulumi.get(self, "auto_injection_policy_enabled")

    @property
    @pulumi.getter(name="enableNamespacesByDefault")
    def enable_namespaces_by_default(self) -> Optional[bool]:
        """
        Whether it is the all namespaces you turn on the auto injection capabilities.
        """
        return pulumi.get(self, "enable_namespaces_by_default")

    @property
    @pulumi.getter(name="initCniConfiguration")
    def init_cni_configuration(self) -> Optional['outputs.ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration']:
        """
        CNI configuration. See `init_cni_configuration` below.
        """
        return pulumi.get(self, "init_cni_configuration")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> Optional[str]:
        """
        Sidecar injector Pods on the requested resource.
        """
        return pulumi.get(self, "request_memory")

    @property
    @pulumi.getter(name="sidecarInjectorWebhookAsYaml")
    def sidecar_injector_webhook_as_yaml(self) -> Optional[str]:
        """
        Other configurations of automatically injected sidecar (in YAML format).
        """
        return pulumi.get(self, "sidecar_injector_webhook_as_yaml")


@pulumi.output_type
class ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeNamespaces":
            suggest = "exclude_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshMeshConfigSidecarInjectorInitCniConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 exclude_namespaces: Optional[str] = None):
        """
        :param bool enabled: Enable CNI.
        :param str exclude_namespaces: The excluded namespace.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if exclude_namespaces is not None:
            pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable CNI.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> Optional[str]:
        """
        The excluded namespace.
        """
        return pulumi.get(self, "exclude_namespaces")


@pulumi.output_type
class ServiceMeshNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitcheList":
            suggest = "vswitche_list"
        elif key == "securityGroupId":
            suggest = "security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str,
                 vswitche_list: str,
                 security_group_id: Optional[str] = None):
        """
        :param str vpc_id: VPC ID.
        :param str vswitche_list: Virtual Switch ID.
        :param str security_group_id: Security group ID.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitche_list", vswitche_list)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitcheList")
    def vswitche_list(self) -> str:
        """
        Virtual Switch ID.
        """
        return pulumi.get(self, "vswitche_list")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        """
        Security group ID.
        """
        return pulumi.get(self, "security_group_id")


@pulumi.output_type
class UserPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCustom":
            suggest = "is_custom"
        elif key == "isRamRole":
            suggest = "is_ram_role"
        elif key == "roleName":
            suggest = "role_name"
        elif key == "roleType":
            suggest = "role_type"
        elif key == "serviceMeshId":
            suggest = "service_mesh_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_custom: Optional[bool] = None,
                 is_ram_role: Optional[bool] = None,
                 role_name: Optional[str] = None,
                 role_type: Optional[str] = None,
                 service_mesh_id: Optional[str] = None):
        """
        :param bool is_custom: Whether the grant object is a RAM role.
        :param bool is_ram_role: Whether the grant object is an entity.
        :param str role_name: The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
               - `istio-admin`:  The administrator.
               - `istio-ops`: The administrator of the service mesh resource.
               - `istio-readonly`: The read only permission.
        :param str role_type: The role type. Valid Value: `custom`.
        :param str service_mesh_id: The service mesh id.
        """
        if is_custom is not None:
            pulumi.set(__self__, "is_custom", is_custom)
        if is_ram_role is not None:
            pulumi.set(__self__, "is_ram_role", is_ram_role)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)
        if service_mesh_id is not None:
            pulumi.set(__self__, "service_mesh_id", service_mesh_id)

    @property
    @pulumi.getter(name="isCustom")
    def is_custom(self) -> Optional[bool]:
        """
        Whether the grant object is a RAM role.
        """
        return pulumi.get(self, "is_custom")

    @property
    @pulumi.getter(name="isRamRole")
    def is_ram_role(self) -> Optional[bool]:
        """
        Whether the grant object is an entity.
        """
        return pulumi.get(self, "is_ram_role")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[str]:
        """
        The permission name. Valid values: `istio-admin`, `istio-ops`, `istio-readonly`.
        - `istio-admin`:  The administrator.
        - `istio-ops`: The administrator of the service mesh resource.
        - `istio-readonly`: The read only permission.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[str]:
        """
        The role type. Valid Value: `custom`.
        """
        return pulumi.get(self, "role_type")

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> Optional[str]:
        """
        The service mesh id.
        """
        return pulumi.get(self, "service_mesh_id")


@pulumi.output_type
class GetExtensionProvidersProviderResult(dict):
    def __init__(__self__, *,
                 config: str,
                 extension_provider_name: str,
                 id: str,
                 service_mesh_id: str,
                 type: str):
        """
        :param str config: The config of the Service Mesh Extension Provider.
        :param str extension_provider_name: The name of the Service Mesh Extension Provider.
        :param str id: The ID of the Service Mesh Extension Provider. It formats as `<service_mesh_id>:<type>:<extension_provider_name>`.
        :param str service_mesh_id: The ID of the Service Mesh.
        :param str type: The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "extension_provider_name", extension_provider_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        The config of the Service Mesh Extension Provider.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="extensionProviderName")
    def extension_provider_name(self) -> str:
        """
        The name of the Service Mesh Extension Provider.
        """
        return pulumi.get(self, "extension_provider_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Service Mesh Extension Provider. It formats as `<service_mesh_id>:<type>:<extension_provider_name>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> str:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "service_mesh_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the Service Mesh Extension Provider. Valid values: `httpextauth`, `grpcextauth`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceMeshesMeshResult(dict):
    def __init__(__self__, *,
                 clusters: Sequence[str],
                 create_time: str,
                 edition: str,
                 endpoints: Sequence['outputs.GetServiceMeshesMeshEndpointResult'],
                 error_message: str,
                 id: str,
                 istio_operator_version: str,
                 kube_config: str,
                 load_balancers: Sequence['outputs.GetServiceMeshesMeshLoadBalancerResult'],
                 mesh_configs: Sequence['outputs.GetServiceMeshesMeshMeshConfigResult'],
                 networks: Sequence['outputs.GetServiceMeshesMeshNetworkResult'],
                 service_mesh_id: str,
                 service_mesh_name: str,
                 sidecar_version: str,
                 status: str,
                 version: str):
        """
        :param Sequence[str] clusters: Cluster List.
        :param str create_time: The created time of the resource.
        :param str edition: Grid instance version type. Valid values: `Default` and `Pro`. `Default`:the standard. `Pro`:the Pro version.
        :param Sequence['GetServiceMeshesMeshEndpointArgs'] endpoints: The endpoint details.
        :param str error_message: The Cause of the Error.
        :param str id: The ID of the Service Mesh.
        :param str istio_operator_version: The Istio Operator Version. **Note:** the `istio_operator_version` is available from the version v1.170.0.
        :param str kube_config: The content of Kube config.
        :param Sequence['GetServiceMeshesMeshLoadBalancerArgs'] load_balancers: The configuration of the Load Balancer.
        :param Sequence['GetServiceMeshesMeshMeshConfigArgs'] mesh_configs: The configuration of the Service grid.
        :param Sequence['GetServiceMeshesMeshNetworkArgs'] networks: The configuration of the Service grid network.
        :param str service_mesh_id: The first ID of the resource.
        :param str service_mesh_name: The name of the resource.
        :param str sidecar_version: The SideCar Version. **Note:** the `sidecar_version` is available from the version v1.170.0.
        :param str status: The status of the resource. Valid values: `running` or `initial`.
        :param str version: The version of the resource.
        """
        pulumi.set(__self__, "clusters", clusters)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "istio_operator_version", istio_operator_version)
        pulumi.set(__self__, "kube_config", kube_config)
        pulumi.set(__self__, "load_balancers", load_balancers)
        pulumi.set(__self__, "mesh_configs", mesh_configs)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "service_mesh_id", service_mesh_id)
        pulumi.set(__self__, "service_mesh_name", service_mesh_name)
        pulumi.set(__self__, "sidecar_version", sidecar_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def clusters(self) -> Sequence[str]:
        """
        Cluster List.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The created time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def edition(self) -> str:
        """
        Grid instance version type. Valid values: `Default` and `Pro`. `Default`:the standard. `Pro`:the Pro version.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetServiceMeshesMeshEndpointResult']:
        """
        The endpoint details.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The Cause of the Error.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Service Mesh.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="istioOperatorVersion")
    def istio_operator_version(self) -> str:
        """
        The Istio Operator Version. **Note:** the `istio_operator_version` is available from the version v1.170.0.
        """
        return pulumi.get(self, "istio_operator_version")

    @property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> str:
        """
        The content of Kube config.
        """
        return pulumi.get(self, "kube_config")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence['outputs.GetServiceMeshesMeshLoadBalancerResult']:
        """
        The configuration of the Load Balancer.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter(name="meshConfigs")
    def mesh_configs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigResult']:
        """
        The configuration of the Service grid.
        """
        return pulumi.get(self, "mesh_configs")

    @property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetServiceMeshesMeshNetworkResult']:
        """
        The configuration of the Service grid network.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="serviceMeshId")
    def service_mesh_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "service_mesh_id")

    @property
    @pulumi.getter(name="serviceMeshName")
    def service_mesh_name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "service_mesh_name")

    @property
    @pulumi.getter(name="sidecarVersion")
    def sidecar_version(self) -> str:
        """
        The SideCar Version. **Note:** the `sidecar_version` is available from the version v1.170.0.
        """
        return pulumi.get(self, "sidecar_version")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values: `running` or `initial`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the resource.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceMeshesMeshEndpointResult(dict):
    def __init__(__self__, *,
                 intranet_api_server_endpoint: str,
                 intranet_pilot_endpoint: str,
                 public_api_server_endpoint: str,
                 public_pilot_endpoint: str):
        """
        :param str intranet_api_server_endpoint: The internal address of the API Server.
        :param str intranet_pilot_endpoint: The internal address of the Istio Pilot.
        :param str public_api_server_endpoint: The public address of the API Server.
        :param str public_pilot_endpoint: The public address of the Istio Pilot.
        """
        pulumi.set(__self__, "intranet_api_server_endpoint", intranet_api_server_endpoint)
        pulumi.set(__self__, "intranet_pilot_endpoint", intranet_pilot_endpoint)
        pulumi.set(__self__, "public_api_server_endpoint", public_api_server_endpoint)
        pulumi.set(__self__, "public_pilot_endpoint", public_pilot_endpoint)

    @property
    @pulumi.getter(name="intranetApiServerEndpoint")
    def intranet_api_server_endpoint(self) -> str:
        """
        The internal address of the API Server.
        """
        return pulumi.get(self, "intranet_api_server_endpoint")

    @property
    @pulumi.getter(name="intranetPilotEndpoint")
    def intranet_pilot_endpoint(self) -> str:
        """
        The internal address of the Istio Pilot.
        """
        return pulumi.get(self, "intranet_pilot_endpoint")

    @property
    @pulumi.getter(name="publicApiServerEndpoint")
    def public_api_server_endpoint(self) -> str:
        """
        The public address of the API Server.
        """
        return pulumi.get(self, "public_api_server_endpoint")

    @property
    @pulumi.getter(name="publicPilotEndpoint")
    def public_pilot_endpoint(self) -> str:
        """
        The public address of the Istio Pilot.
        """
        return pulumi.get(self, "public_pilot_endpoint")


@pulumi.output_type
class GetServiceMeshesMeshLoadBalancerResult(dict):
    def __init__(__self__, *,
                 api_server_loadbalancer_id: str,
                 api_server_public_eip: bool,
                 pilot_public_eip: bool,
                 pilot_public_loadbalancer_id: str):
        """
        :param str api_server_loadbalancer_id: The IP address of a public network exposed API Server corresponding to the Load Balance.
        :param bool api_server_public_eip: Whether to use the IP address of a public network exposed the API Server.
        :param bool pilot_public_eip: Whether to use the IP address of a public network exposure the Istio Pilot.
        :param str pilot_public_loadbalancer_id: The IP address of a public network exposure Istio Pilot corresponds to the Load Balance.
        """
        pulumi.set(__self__, "api_server_loadbalancer_id", api_server_loadbalancer_id)
        pulumi.set(__self__, "api_server_public_eip", api_server_public_eip)
        pulumi.set(__self__, "pilot_public_eip", pilot_public_eip)
        pulumi.set(__self__, "pilot_public_loadbalancer_id", pilot_public_loadbalancer_id)

    @property
    @pulumi.getter(name="apiServerLoadbalancerId")
    def api_server_loadbalancer_id(self) -> str:
        """
        The IP address of a public network exposed API Server corresponding to the Load Balance.
        """
        return pulumi.get(self, "api_server_loadbalancer_id")

    @property
    @pulumi.getter(name="apiServerPublicEip")
    def api_server_public_eip(self) -> bool:
        """
        Whether to use the IP address of a public network exposed the API Server.
        """
        return pulumi.get(self, "api_server_public_eip")

    @property
    @pulumi.getter(name="pilotPublicEip")
    def pilot_public_eip(self) -> bool:
        """
        Whether to use the IP address of a public network exposure the Istio Pilot.
        """
        return pulumi.get(self, "pilot_public_eip")

    @property
    @pulumi.getter(name="pilotPublicLoadbalancerId")
    def pilot_public_loadbalancer_id(self) -> str:
        """
        The IP address of a public network exposure Istio Pilot corresponds to the Load Balance.
        """
        return pulumi.get(self, "pilot_public_loadbalancer_id")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigResult(dict):
    def __init__(__self__, *,
                 access_logs: Sequence['outputs.GetServiceMeshesMeshMeshConfigAccessLogResult'],
                 audits: Sequence['outputs.GetServiceMeshesMeshMeshConfigAuditResult'],
                 control_plane_logs: Sequence['outputs.GetServiceMeshesMeshMeshConfigControlPlaneLogResult'],
                 customized_zipkin: bool,
                 enable_locality_lb: bool,
                 include_ip_ranges: str,
                 kialis: Sequence['outputs.GetServiceMeshesMeshMeshConfigKialiResult'],
                 opas: Sequence['outputs.GetServiceMeshesMeshMeshConfigOpaResult'],
                 outbound_traffic_policy: str,
                 pilots: Sequence['outputs.GetServiceMeshesMeshMeshConfigPilotResult'],
                 prometheuses: Sequence['outputs.GetServiceMeshesMeshMeshConfigPrometheusResult'],
                 proxies: Sequence['outputs.GetServiceMeshesMeshMeshConfigProxyResult'],
                 sidecar_injectors: Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorResult'],
                 telemetry: bool,
                 tracing: bool):
        """
        :param Sequence['GetServiceMeshesMeshMeshConfigAccessLogArgs'] access_logs: The configuration of the access logging.
        :param Sequence['GetServiceMeshesMeshMeshConfigAuditArgs'] audits: The configuration of the Service grid audit.
        :param Sequence['GetServiceMeshesMeshMeshConfigControlPlaneLogArgs'] control_plane_logs: The configuration of the control plane logging. **NOTE:** Available in 1.174.0+
        :param bool customized_zipkin: Whether or not to enable the use of a custom zipkin.
        :param bool enable_locality_lb: Whether to enable service can access the service through the nearest node access.
        :param str include_ip_ranges: The IP ADDRESS range.
        :param Sequence['GetServiceMeshesMeshMeshConfigKialiArgs'] kialis: The configuration of the Kiali.
        :param Sequence['GetServiceMeshesMeshMeshConfigOpaArgs'] opas: The open-door policy of agent (OPA) plug-in information.
        :param str outbound_traffic_policy: The policy of the Out to the traffic. Valid values: `ALLOW_ANY` and `REGISTRY_ONLY`.
        :param Sequence['GetServiceMeshesMeshMeshConfigPilotArgs'] pilots: The configuration of the Link trace sampling.
        :param Sequence['GetServiceMeshesMeshMeshConfigPrometheusArgs'] prometheuses: the configuration of the Prometheus.
        :param Sequence['GetServiceMeshesMeshMeshConfigProxyArgs'] proxies: The configuration of the Proxy.
        :param Sequence['GetServiceMeshesMeshMeshConfigSidecarInjectorArgs'] sidecar_injectors: The configuration of the Sidecar injector.
        :param bool telemetry: Whether to enable acquisition Prometheus metrics.
        :param bool tracing: Whether to enable link trace.
        """
        pulumi.set(__self__, "access_logs", access_logs)
        pulumi.set(__self__, "audits", audits)
        pulumi.set(__self__, "control_plane_logs", control_plane_logs)
        pulumi.set(__self__, "customized_zipkin", customized_zipkin)
        pulumi.set(__self__, "enable_locality_lb", enable_locality_lb)
        pulumi.set(__self__, "include_ip_ranges", include_ip_ranges)
        pulumi.set(__self__, "kialis", kialis)
        pulumi.set(__self__, "opas", opas)
        pulumi.set(__self__, "outbound_traffic_policy", outbound_traffic_policy)
        pulumi.set(__self__, "pilots", pilots)
        pulumi.set(__self__, "prometheuses", prometheuses)
        pulumi.set(__self__, "proxies", proxies)
        pulumi.set(__self__, "sidecar_injectors", sidecar_injectors)
        pulumi.set(__self__, "telemetry", telemetry)
        pulumi.set(__self__, "tracing", tracing)

    @property
    @pulumi.getter(name="accessLogs")
    def access_logs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigAccessLogResult']:
        """
        The configuration of the access logging.
        """
        return pulumi.get(self, "access_logs")

    @property
    @pulumi.getter
    def audits(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigAuditResult']:
        """
        The configuration of the Service grid audit.
        """
        return pulumi.get(self, "audits")

    @property
    @pulumi.getter(name="controlPlaneLogs")
    def control_plane_logs(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigControlPlaneLogResult']:
        """
        The configuration of the control plane logging. **NOTE:** Available in 1.174.0+
        """
        return pulumi.get(self, "control_plane_logs")

    @property
    @pulumi.getter(name="customizedZipkin")
    def customized_zipkin(self) -> bool:
        """
        Whether or not to enable the use of a custom zipkin.
        """
        return pulumi.get(self, "customized_zipkin")

    @property
    @pulumi.getter(name="enableLocalityLb")
    def enable_locality_lb(self) -> bool:
        """
        Whether to enable service can access the service through the nearest node access.
        """
        return pulumi.get(self, "enable_locality_lb")

    @property
    @pulumi.getter(name="includeIpRanges")
    def include_ip_ranges(self) -> str:
        """
        The IP ADDRESS range.
        """
        return pulumi.get(self, "include_ip_ranges")

    @property
    @pulumi.getter
    def kialis(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigKialiResult']:
        """
        The configuration of the Kiali.
        """
        return pulumi.get(self, "kialis")

    @property
    @pulumi.getter
    def opas(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigOpaResult']:
        """
        The open-door policy of agent (OPA) plug-in information.
        """
        return pulumi.get(self, "opas")

    @property
    @pulumi.getter(name="outboundTrafficPolicy")
    def outbound_traffic_policy(self) -> str:
        """
        The policy of the Out to the traffic. Valid values: `ALLOW_ANY` and `REGISTRY_ONLY`.
        """
        return pulumi.get(self, "outbound_traffic_policy")

    @property
    @pulumi.getter
    def pilots(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigPilotResult']:
        """
        The configuration of the Link trace sampling.
        """
        return pulumi.get(self, "pilots")

    @property
    @pulumi.getter
    def prometheuses(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigPrometheusResult']:
        """
        the configuration of the Prometheus.
        """
        return pulumi.get(self, "prometheuses")

    @property
    @pulumi.getter
    def proxies(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigProxyResult']:
        """
        The configuration of the Proxy.
        """
        return pulumi.get(self, "proxies")

    @property
    @pulumi.getter(name="sidecarInjectors")
    def sidecar_injectors(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorResult']:
        """
        The configuration of the Sidecar injector.
        """
        return pulumi.get(self, "sidecar_injectors")

    @property
    @pulumi.getter
    def telemetry(self) -> bool:
        """
        Whether to enable acquisition Prometheus metrics.
        """
        return pulumi.get(self, "telemetry")

    @property
    @pulumi.getter
    def tracing(self) -> bool:
        """
        Whether to enable link trace.
        """
        return pulumi.get(self, "tracing")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigAccessLogResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 project: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigAuditResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 project: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigControlPlaneLogResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 project: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str project: The Service grid audit that to the project.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The Service grid audit that to the project.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigKialiResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 url: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str url: The service address of the Kiali.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The service address of the Kiali.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigOpaResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 limit_cpu: str,
                 limit_memory: str,
                 log_level: str,
                 request_cpu: str,
                 request_memory: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param str log_level: The log level of the OPA proxy container .
        :param str request_cpu: The requested cpu the Sidecar injector Pods.
        :param str request_memory: The requested memory the Sidecar injector Pods.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "log_level", log_level)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> str:
        """
        The log level of the OPA proxy container .
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigPilotResult(dict):
    def __init__(__self__, *,
                 http10_enabled: bool,
                 trace_sampling: float):
        """
        :param bool http10_enabled: Whether to support the HTTP1.0.
        :param float trace_sampling: The  percentage of the Link trace sampling.
        """
        pulumi.set(__self__, "http10_enabled", http10_enabled)
        pulumi.set(__self__, "trace_sampling", trace_sampling)

    @property
    @pulumi.getter(name="http10Enabled")
    def http10_enabled(self) -> bool:
        """
        Whether to support the HTTP1.0.
        """
        return pulumi.get(self, "http10_enabled")

    @property
    @pulumi.getter(name="traceSampling")
    def trace_sampling(self) -> float:
        """
        The  percentage of the Link trace sampling.
        """
        return pulumi.get(self, "trace_sampling")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigPrometheusResult(dict):
    def __init__(__self__, *,
                 external_url: str,
                 use_external: bool):
        """
        :param str external_url: The  service addresses of the Prometheus.
        :param bool use_external: Whether to enable external Prometheus.
        """
        pulumi.set(__self__, "external_url", external_url)
        pulumi.set(__self__, "use_external", use_external)

    @property
    @pulumi.getter(name="externalUrl")
    def external_url(self) -> str:
        """
        The  service addresses of the Prometheus.
        """
        return pulumi.get(self, "external_url")

    @property
    @pulumi.getter(name="useExternal")
    def use_external(self) -> bool:
        """
        Whether to enable external Prometheus.
        """
        return pulumi.get(self, "use_external")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigProxyResult(dict):
    def __init__(__self__, *,
                 cluster_domain: str,
                 limit_cpu: str,
                 limit_memory: str,
                 request_cpu: str,
                 request_memory: str):
        """
        :param str cluster_domain: The domain name of the Cluster.
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param str request_cpu: The requested cpu the Sidecar injector Pods.
        :param str request_memory: The requested memory the Sidecar injector Pods.
        """
        pulumi.set(__self__, "cluster_domain", cluster_domain)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)

    @property
    @pulumi.getter(name="clusterDomain")
    def cluster_domain(self) -> str:
        """
        The domain name of the Cluster.
        """
        return pulumi.get(self, "cluster_domain")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigSidecarInjectorResult(dict):
    def __init__(__self__, *,
                 auto_injection_policy_enabled: bool,
                 enable_namespaces_by_default: bool,
                 init_cni_configurations: Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult'],
                 limit_cpu: str,
                 limit_memory: str,
                 request_cpu: str,
                 request_memory: str,
                 sidecar_injector_webhook_as_yaml: str):
        """
        :param bool auto_injection_policy_enabled: Whether to enable by Pod Annotations automatic injection Sidecar.
        :param bool enable_namespaces_by_default: Whether it is the all namespaces you turn on the auto injection capabilities.
        :param Sequence['GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationArgs'] init_cni_configurations: The configuration of the CNI
        :param str limit_cpu: Sidecar injector Pods on the throttle.
        :param str limit_memory: The memory limit  of the Sidecar injector Pods.
        :param str request_cpu: The requested cpu the Sidecar injector Pods.
        :param str request_memory: The requested memory the Sidecar injector Pods.
        :param str sidecar_injector_webhook_as_yaml: Other automatic injection Sidecar configuration (in YAML format).
        """
        pulumi.set(__self__, "auto_injection_policy_enabled", auto_injection_policy_enabled)
        pulumi.set(__self__, "enable_namespaces_by_default", enable_namespaces_by_default)
        pulumi.set(__self__, "init_cni_configurations", init_cni_configurations)
        pulumi.set(__self__, "limit_cpu", limit_cpu)
        pulumi.set(__self__, "limit_memory", limit_memory)
        pulumi.set(__self__, "request_cpu", request_cpu)
        pulumi.set(__self__, "request_memory", request_memory)
        pulumi.set(__self__, "sidecar_injector_webhook_as_yaml", sidecar_injector_webhook_as_yaml)

    @property
    @pulumi.getter(name="autoInjectionPolicyEnabled")
    def auto_injection_policy_enabled(self) -> bool:
        """
        Whether to enable by Pod Annotations automatic injection Sidecar.
        """
        return pulumi.get(self, "auto_injection_policy_enabled")

    @property
    @pulumi.getter(name="enableNamespacesByDefault")
    def enable_namespaces_by_default(self) -> bool:
        """
        Whether it is the all namespaces you turn on the auto injection capabilities.
        """
        return pulumi.get(self, "enable_namespaces_by_default")

    @property
    @pulumi.getter(name="initCniConfigurations")
    def init_cni_configurations(self) -> Sequence['outputs.GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult']:
        """
        The configuration of the CNI
        """
        return pulumi.get(self, "init_cni_configurations")

    @property
    @pulumi.getter(name="limitCpu")
    def limit_cpu(self) -> str:
        """
        Sidecar injector Pods on the throttle.
        """
        return pulumi.get(self, "limit_cpu")

    @property
    @pulumi.getter(name="limitMemory")
    def limit_memory(self) -> str:
        """
        The memory limit  of the Sidecar injector Pods.
        """
        return pulumi.get(self, "limit_memory")

    @property
    @pulumi.getter(name="requestCpu")
    def request_cpu(self) -> str:
        """
        The requested cpu the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_cpu")

    @property
    @pulumi.getter(name="requestMemory")
    def request_memory(self) -> str:
        """
        The requested memory the Sidecar injector Pods.
        """
        return pulumi.get(self, "request_memory")

    @property
    @pulumi.getter(name="sidecarInjectorWebhookAsYaml")
    def sidecar_injector_webhook_as_yaml(self) -> str:
        """
        Other automatic injection Sidecar configuration (in YAML format).
        """
        return pulumi.get(self, "sidecar_injector_webhook_as_yaml")


@pulumi.output_type
class GetServiceMeshesMeshMeshConfigSidecarInjectorInitCniConfigurationResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 exclude_namespaces: str):
        """
        :param bool enabled: Whether to enable Service grid audit.
        :param str exclude_namespaces: The excluded namespace of the CNI.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "exclude_namespaces", exclude_namespaces)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable Service grid audit.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="excludeNamespaces")
    def exclude_namespaces(self) -> str:
        """
        The excluded namespace of the CNI.
        """
        return pulumi.get(self, "exclude_namespaces")


@pulumi.output_type
class GetServiceMeshesMeshNetworkResult(dict):
    def __init__(__self__, *,
                 security_group_id: str,
                 vpc_id: str,
                 vswitche_lists: Sequence[str]):
        """
        :param str security_group_id: The ID of the Security group
        :param str vpc_id: The ID of the VPC.
        :param Sequence[str] vswitche_lists: The list of Virtual Switch.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitche_lists", vswitche_lists)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of the Security group
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitcheLists")
    def vswitche_lists(self) -> Sequence[str]:
        """
        The list of Virtual Switch.
        """
        return pulumi.get(self, "vswitche_lists")


@pulumi.output_type
class GetVersionsVersionResult(dict):
    def __init__(__self__, *,
                 edition: str,
                 id: str,
                 version: str):
        """
        :param str edition: The edition of the ASM instance.
        :param str id: The ASM version id. It formats as `<edition>:<version>`.
        :param str version: The AMS version.
        """
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def edition(self) -> str:
        """
        The edition of the ASM instance.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ASM version id. It formats as `<edition>:<version>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The AMS version.
        """
        return pulumi.get(self, "version")


