# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceMeshArgs', 'ServiceMesh']

@pulumi.input_type
class ServiceMeshArgs:
    def __init__(__self__, *,
                 network: pulumi.Input['ServiceMeshNetworkArgs'],
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 customized_prometheus: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 extra_configuration: Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']] = None,
                 mesh_config: Optional[pulumi.Input['ServiceMeshMeshConfigArgs']] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 service_mesh_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServiceMesh resource.
        :param pulumi.Input['ServiceMeshNetworkArgs'] network: Service grid network configuration information. See `network` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ids: List of clusters.
        :param pulumi.Input[str] cluster_spec: Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        :param pulumi.Input[bool] customized_prometheus: Whether to customize Prometheus. Value:
               -'true': custom Prometheus.
               -'false': Do not customize Prometheus. Default value: 'false '.
        :param pulumi.Input[str] edition: Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        :param pulumi.Input['ServiceMeshExtraConfigurationArgs'] extra_configuration: Data plane KubeAPI access capability. See `extra_configuration` below.
        :param pulumi.Input[bool] force: Whether to forcibly delete the ASM instance. Value:
               -'true': force deletion of ASM instance
               -'false': no forced deletion of ASM instance. Default value: false.
        :param pulumi.Input['ServiceMeshLoadBalancerArgs'] load_balancer: Load balancing information. See `load_balancer` below.
        :param pulumi.Input['ServiceMeshMeshConfigArgs'] mesh_config: Service grid configuration information. See `mesh_config` below.
        :param pulumi.Input[str] prometheus_url: The Prometheus service address (in non-custom cases, use the ARMS address format).
        :param pulumi.Input[str] service_mesh_name: ServiceMeshName.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] version: Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        pulumi.set(__self__, "network", network)
        if cluster_ids is not None:
            pulumi.set(__self__, "cluster_ids", cluster_ids)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if customized_prometheus is not None:
            pulumi.set(__self__, "customized_prometheus", customized_prometheus)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if extra_configuration is not None:
            pulumi.set(__self__, "extra_configuration", extra_configuration)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if mesh_config is not None:
            pulumi.set(__self__, "mesh_config", mesh_config)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if service_mesh_name is not None:
            pulumi.set(__self__, "service_mesh_name", service_mesh_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input['ServiceMeshNetworkArgs']:
        """
        Service grid network configuration information. See `network` below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input['ServiceMeshNetworkArgs']):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of clusters.
        """
        return pulumi.get(self, "cluster_ids")

    @cluster_ids.setter
    def cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_ids", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter(name="customizedPrometheus")
    def customized_prometheus(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to customize Prometheus. Value:
        -'true': custom Prometheus.
        -'false': Do not customize Prometheus. Default value: 'false '.
        """
        return pulumi.get(self, "customized_prometheus")

    @customized_prometheus.setter
    def customized_prometheus(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "customized_prometheus", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="extraConfiguration")
    def extra_configuration(self) -> Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']]:
        """
        Data plane KubeAPI access capability. See `extra_configuration` below.
        """
        return pulumi.get(self, "extra_configuration")

    @extra_configuration.setter
    def extra_configuration(self, value: Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']]):
        pulumi.set(self, "extra_configuration", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to forcibly delete the ASM instance. Value:
        -'true': force deletion of ASM instance
        -'false': no forced deletion of ASM instance. Default value: false.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']]:
        """
        Load balancing information. See `load_balancer` below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="meshConfig")
    def mesh_config(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigArgs']]:
        """
        Service grid configuration information. See `mesh_config` below.
        """
        return pulumi.get(self, "mesh_config")

    @mesh_config.setter
    def mesh_config(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigArgs']]):
        pulumi.set(self, "mesh_config", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Prometheus service address (in non-custom cases, use the ARMS address format).
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter(name="serviceMeshName")
    def service_mesh_name(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceMeshName.
        """
        return pulumi.get(self, "service_mesh_name")

    @service_mesh_name.setter
    def service_mesh_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mesh_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _ServiceMeshState:
    def __init__(__self__, *,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 customized_prometheus: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 extra_configuration: Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']] = None,
                 mesh_config: Optional[pulumi.Input['ServiceMeshMeshConfigArgs']] = None,
                 network: Optional[pulumi.Input['ServiceMeshNetworkArgs']] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 service_mesh_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceMesh resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ids: List of clusters.
        :param pulumi.Input[str] cluster_spec: Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        :param pulumi.Input[str] create_time: Service grid creation time.
        :param pulumi.Input[bool] customized_prometheus: Whether to customize Prometheus. Value:
               -'true': custom Prometheus.
               -'false': Do not customize Prometheus. Default value: 'false '.
        :param pulumi.Input[str] edition: Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        :param pulumi.Input['ServiceMeshExtraConfigurationArgs'] extra_configuration: Data plane KubeAPI access capability. See `extra_configuration` below.
        :param pulumi.Input[bool] force: Whether to forcibly delete the ASM instance. Value:
               -'true': force deletion of ASM instance
               -'false': no forced deletion of ASM instance. Default value: false.
        :param pulumi.Input['ServiceMeshLoadBalancerArgs'] load_balancer: Load balancing information. See `load_balancer` below.
        :param pulumi.Input['ServiceMeshMeshConfigArgs'] mesh_config: Service grid configuration information. See `mesh_config` below.
        :param pulumi.Input['ServiceMeshNetworkArgs'] network: Service grid network configuration information. See `network` below.
        :param pulumi.Input[str] prometheus_url: The Prometheus service address (in non-custom cases, use the ARMS address format).
        :param pulumi.Input[str] service_mesh_name: ServiceMeshName.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] version: Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        if cluster_ids is not None:
            pulumi.set(__self__, "cluster_ids", cluster_ids)
        if cluster_spec is not None:
            pulumi.set(__self__, "cluster_spec", cluster_spec)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if customized_prometheus is not None:
            pulumi.set(__self__, "customized_prometheus", customized_prometheus)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if extra_configuration is not None:
            pulumi.set(__self__, "extra_configuration", extra_configuration)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if mesh_config is not None:
            pulumi.set(__self__, "mesh_config", mesh_config)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if prometheus_url is not None:
            pulumi.set(__self__, "prometheus_url", prometheus_url)
        if service_mesh_name is not None:
            pulumi.set(__self__, "service_mesh_name", service_mesh_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of clusters.
        """
        return pulumi.get(self, "cluster_ids")

    @cluster_ids.setter
    def cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cluster_ids", value)

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> Optional[pulumi.Input[str]]:
        """
        Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        """
        return pulumi.get(self, "cluster_spec")

    @cluster_spec.setter
    def cluster_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_spec", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Service grid creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="customizedPrometheus")
    def customized_prometheus(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to customize Prometheus. Value:
        -'true': custom Prometheus.
        -'false': Do not customize Prometheus. Default value: 'false '.
        """
        return pulumi.get(self, "customized_prometheus")

    @customized_prometheus.setter
    def customized_prometheus(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "customized_prometheus", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="extraConfiguration")
    def extra_configuration(self) -> Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']]:
        """
        Data plane KubeAPI access capability. See `extra_configuration` below.
        """
        return pulumi.get(self, "extra_configuration")

    @extra_configuration.setter
    def extra_configuration(self, value: Optional[pulumi.Input['ServiceMeshExtraConfigurationArgs']]):
        pulumi.set(self, "extra_configuration", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to forcibly delete the ASM instance. Value:
        -'true': force deletion of ASM instance
        -'false': no forced deletion of ASM instance. Default value: false.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']]:
        """
        Load balancing information. See `load_balancer` below.
        """
        return pulumi.get(self, "load_balancer")

    @load_balancer.setter
    def load_balancer(self, value: Optional[pulumi.Input['ServiceMeshLoadBalancerArgs']]):
        pulumi.set(self, "load_balancer", value)

    @property
    @pulumi.getter(name="meshConfig")
    def mesh_config(self) -> Optional[pulumi.Input['ServiceMeshMeshConfigArgs']]:
        """
        Service grid configuration information. See `mesh_config` below.
        """
        return pulumi.get(self, "mesh_config")

    @mesh_config.setter
    def mesh_config(self, value: Optional[pulumi.Input['ServiceMeshMeshConfigArgs']]):
        pulumi.set(self, "mesh_config", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['ServiceMeshNetworkArgs']]:
        """
        Service grid network configuration information. See `network` below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['ServiceMeshNetworkArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> Optional[pulumi.Input[str]]:
        """
        The Prometheus service address (in non-custom cases, use the ARMS address format).
        """
        return pulumi.get(self, "prometheus_url")

    @prometheus_url.setter
    def prometheus_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prometheus_url", value)

    @property
    @pulumi.getter(name="serviceMeshName")
    def service_mesh_name(self) -> Optional[pulumi.Input[str]]:
        """
        ServiceMeshName.
        """
        return pulumi.get(self, "service_mesh_name")

    @service_mesh_name.setter
    def service_mesh_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_mesh_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class ServiceMesh(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 customized_prometheus: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 extra_configuration: Optional[pulumi.Input[pulumi.InputType['ServiceMeshExtraConfigurationArgs']]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input[pulumi.InputType['ServiceMeshLoadBalancerArgs']]] = None,
                 mesh_config: Optional[pulumi.Input[pulumi.InputType['ServiceMeshMeshConfigArgs']]] = None,
                 network: Optional[pulumi.Input[pulumi.InputType['ServiceMeshNetworkArgs']]] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 service_mesh_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Service Mesh Service Mesh resource.

        For information about Service Mesh Service Mesh and how to use it, see [What is Service Mesh](https://www.alibabacloud.com/help/en/asm/developer-reference/api-servicemesh-2020-01-11-createservicemesh).

        > **NOTE:** Available since v1.138.0.

        ## Import

        Service Mesh Service Mesh can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:servicemesh/serviceMesh:ServiceMesh example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ids: List of clusters.
        :param pulumi.Input[str] cluster_spec: Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        :param pulumi.Input[bool] customized_prometheus: Whether to customize Prometheus. Value:
               -'true': custom Prometheus.
               -'false': Do not customize Prometheus. Default value: 'false '.
        :param pulumi.Input[str] edition: Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        :param pulumi.Input[pulumi.InputType['ServiceMeshExtraConfigurationArgs']] extra_configuration: Data plane KubeAPI access capability. See `extra_configuration` below.
        :param pulumi.Input[bool] force: Whether to forcibly delete the ASM instance. Value:
               -'true': force deletion of ASM instance
               -'false': no forced deletion of ASM instance. Default value: false.
        :param pulumi.Input[pulumi.InputType['ServiceMeshLoadBalancerArgs']] load_balancer: Load balancing information. See `load_balancer` below.
        :param pulumi.Input[pulumi.InputType['ServiceMeshMeshConfigArgs']] mesh_config: Service grid configuration information. See `mesh_config` below.
        :param pulumi.Input[pulumi.InputType['ServiceMeshNetworkArgs']] network: Service grid network configuration information. See `network` below.
        :param pulumi.Input[str] prometheus_url: The Prometheus service address (in non-custom cases, use the ARMS address format).
        :param pulumi.Input[str] service_mesh_name: ServiceMeshName.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] version: Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceMeshArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Service Mesh Service Mesh resource.

        For information about Service Mesh Service Mesh and how to use it, see [What is Service Mesh](https://www.alibabacloud.com/help/en/asm/developer-reference/api-servicemesh-2020-01-11-createservicemesh).

        > **NOTE:** Available since v1.138.0.

        ## Import

        Service Mesh Service Mesh can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:servicemesh/serviceMesh:ServiceMesh example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ServiceMeshArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceMeshArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cluster_spec: Optional[pulumi.Input[str]] = None,
                 customized_prometheus: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 extra_configuration: Optional[pulumi.Input[pulumi.InputType['ServiceMeshExtraConfigurationArgs']]] = None,
                 force: Optional[pulumi.Input[bool]] = None,
                 load_balancer: Optional[pulumi.Input[pulumi.InputType['ServiceMeshLoadBalancerArgs']]] = None,
                 mesh_config: Optional[pulumi.Input[pulumi.InputType['ServiceMeshMeshConfigArgs']]] = None,
                 network: Optional[pulumi.Input[pulumi.InputType['ServiceMeshNetworkArgs']]] = None,
                 prometheus_url: Optional[pulumi.Input[str]] = None,
                 service_mesh_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceMeshArgs.__new__(ServiceMeshArgs)

            __props__.__dict__["cluster_ids"] = cluster_ids
            __props__.__dict__["cluster_spec"] = cluster_spec
            __props__.__dict__["customized_prometheus"] = customized_prometheus
            __props__.__dict__["edition"] = edition
            __props__.__dict__["extra_configuration"] = extra_configuration
            __props__.__dict__["force"] = force
            __props__.__dict__["load_balancer"] = load_balancer
            __props__.__dict__["mesh_config"] = mesh_config
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["prometheus_url"] = prometheus_url
            __props__.__dict__["service_mesh_name"] = service_mesh_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(ServiceMesh, __self__).__init__(
            'alicloud:servicemesh/serviceMesh:ServiceMesh',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cluster_spec: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            customized_prometheus: Optional[pulumi.Input[bool]] = None,
            edition: Optional[pulumi.Input[str]] = None,
            extra_configuration: Optional[pulumi.Input[pulumi.InputType['ServiceMeshExtraConfigurationArgs']]] = None,
            force: Optional[pulumi.Input[bool]] = None,
            load_balancer: Optional[pulumi.Input[pulumi.InputType['ServiceMeshLoadBalancerArgs']]] = None,
            mesh_config: Optional[pulumi.Input[pulumi.InputType['ServiceMeshMeshConfigArgs']]] = None,
            network: Optional[pulumi.Input[pulumi.InputType['ServiceMeshNetworkArgs']]] = None,
            prometheus_url: Optional[pulumi.Input[str]] = None,
            service_mesh_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'ServiceMesh':
        """
        Get an existing ServiceMesh resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cluster_ids: List of clusters.
        :param pulumi.Input[str] cluster_spec: Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        :param pulumi.Input[str] create_time: Service grid creation time.
        :param pulumi.Input[bool] customized_prometheus: Whether to customize Prometheus. Value:
               -'true': custom Prometheus.
               -'false': Do not customize Prometheus. Default value: 'false '.
        :param pulumi.Input[str] edition: Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        :param pulumi.Input[pulumi.InputType['ServiceMeshExtraConfigurationArgs']] extra_configuration: Data plane KubeAPI access capability. See `extra_configuration` below.
        :param pulumi.Input[bool] force: Whether to forcibly delete the ASM instance. Value:
               -'true': force deletion of ASM instance
               -'false': no forced deletion of ASM instance. Default value: false.
        :param pulumi.Input[pulumi.InputType['ServiceMeshLoadBalancerArgs']] load_balancer: Load balancing information. See `load_balancer` below.
        :param pulumi.Input[pulumi.InputType['ServiceMeshMeshConfigArgs']] mesh_config: Service grid configuration information. See `mesh_config` below.
        :param pulumi.Input[pulumi.InputType['ServiceMeshNetworkArgs']] network: Service grid network configuration information. See `network` below.
        :param pulumi.Input[str] prometheus_url: The Prometheus service address (in non-custom cases, use the ARMS address format).
        :param pulumi.Input[str] service_mesh_name: ServiceMeshName.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] version: Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceMeshState.__new__(_ServiceMeshState)

        __props__.__dict__["cluster_ids"] = cluster_ids
        __props__.__dict__["cluster_spec"] = cluster_spec
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["customized_prometheus"] = customized_prometheus
        __props__.__dict__["edition"] = edition
        __props__.__dict__["extra_configuration"] = extra_configuration
        __props__.__dict__["force"] = force
        __props__.__dict__["load_balancer"] = load_balancer
        __props__.__dict__["mesh_config"] = mesh_config
        __props__.__dict__["network"] = network
        __props__.__dict__["prometheus_url"] = prometheus_url
        __props__.__dict__["service_mesh_name"] = service_mesh_name
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return ServiceMesh(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of clusters.
        """
        return pulumi.get(self, "cluster_ids")

    @property
    @pulumi.getter(name="clusterSpec")
    def cluster_spec(self) -> pulumi.Output[str]:
        """
        Cluster specification. The service mesh instance specification. Valid values: `standard`,`enterprise`,`ultimate`. Default to `standard`.
        """
        return pulumi.get(self, "cluster_spec")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Service grid creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customizedPrometheus")
    def customized_prometheus(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to customize Prometheus. Value:
        -'true': custom Prometheus.
        -'false': Do not customize Prometheus. Default value: 'false '.
        """
        return pulumi.get(self, "customized_prometheus")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[str]:
        """
        Grid instance version type. Valid values: `Default` and `Pro`. Default: the standard. Pro: the Pro version.
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter(name="extraConfiguration")
    def extra_configuration(self) -> pulumi.Output['outputs.ServiceMeshExtraConfiguration']:
        """
        Data plane KubeAPI access capability. See `extra_configuration` below.
        """
        return pulumi.get(self, "extra_configuration")

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to forcibly delete the ASM instance. Value:
        -'true': force deletion of ASM instance
        -'false': no forced deletion of ASM instance. Default value: false.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> pulumi.Output['outputs.ServiceMeshLoadBalancer']:
        """
        Load balancing information. See `load_balancer` below.
        """
        return pulumi.get(self, "load_balancer")

    @property
    @pulumi.getter(name="meshConfig")
    def mesh_config(self) -> pulumi.Output['outputs.ServiceMeshMeshConfig']:
        """
        Service grid configuration information. See `mesh_config` below.
        """
        return pulumi.get(self, "mesh_config")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.ServiceMeshNetwork']:
        """
        Service grid network configuration information. See `network` below.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="prometheusUrl")
    def prometheus_url(self) -> pulumi.Output[Optional[str]]:
        """
        The Prometheus service address (in non-custom cases, use the ARMS address format).
        """
        return pulumi.get(self, "prometheus_url")

    @property
    @pulumi.getter(name="serviceMeshName")
    def service_mesh_name(self) -> pulumi.Output[Optional[str]]:
        """
        ServiceMeshName.
        """
        return pulumi.get(self, "service_mesh_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Service grid version number. The version of the resource. you can look up the version using alicloud_service_mesh_versions. Note: The version supports updating from v1.170.0, the relevant version can be obtained via istio_operator_version in `servicemesh_get_service_meshes`.
        """
        return pulumi.get(self, "version")

