# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CustomImageArgs', 'CustomImage']

@pulumi.input_type
class CustomImageArgs:
    def __init__(__self__, *,
                 custom_image_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 system_snapshot_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CustomImage resource.
        :param pulumi.Input[str] custom_image_name: The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] system_snapshot_id: The ID of the system snapshot.
        :param pulumi.Input[str] description: The description of the Custom Image.
        :param pulumi.Input[str] status: The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.
               
               **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        """
        pulumi.set(__self__, "custom_image_name", custom_image_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "system_snapshot_id", system_snapshot_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="customImageName")
    def custom_image_name(self) -> pulumi.Input[str]:
        """
        The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "custom_image_name")

    @custom_image_name.setter
    def custom_image_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "custom_image_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="systemSnapshotId")
    def system_snapshot_id(self) -> pulumi.Input[str]:
        """
        The ID of the system snapshot.
        """
        return pulumi.get(self, "system_snapshot_id")

    @system_snapshot_id.setter
    def system_snapshot_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "system_snapshot_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.

        **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _CustomImageState:
    def __init__(__self__, *,
                 custom_image_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CustomImage resources.
        :param pulumi.Input[str] custom_image_name: The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        :param pulumi.Input[str] description: The description of the Custom Image.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] status: The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.
               
               **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        :param pulumi.Input[str] system_snapshot_id: The ID of the system snapshot.
        """
        if custom_image_name is not None:
            pulumi.set(__self__, "custom_image_name", custom_image_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_snapshot_id is not None:
            pulumi.set(__self__, "system_snapshot_id", system_snapshot_id)

    @property
    @pulumi.getter(name="customImageName")
    def custom_image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "custom_image_name")

    @custom_image_name.setter
    def custom_image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_image_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Custom Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.

        **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemSnapshotId")
    def system_snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the system snapshot.
        """
        return pulumi.get(self, "system_snapshot_id")

    @system_snapshot_id.setter
    def system_snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_snapshot_id", value)


class CustomImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_image_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_snapshot_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Simple Application Server Custom Image resource.

        For information about Simple Application Server Custom Image and how to use it, see [What is Custom Image](https://www.alibabacloud.com/help/en/doc-detail/333535.htm).

        > **NOTE:** Available since v1.143.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_images = alicloud.simpleapplicationserver.get_images()
        default_server_plans = alicloud.simpleapplicationserver.get_server_plans()
        default_instance = alicloud.simpleapplicationserver.Instance("defaultInstance",
            payment_type="Subscription",
            plan_id=default_server_plans.plans[0].id,
            instance_name=name,
            image_id=default_images.images[0].id,
            period=1,
            data_disk_size=100)
        default_server_disks = alicloud.simpleapplicationserver.get_server_disks_output(instance_id=default_instance.id)
        default_snapshot = alicloud.simpleapplicationserver.Snapshot("defaultSnapshot",
            disk_id=default_server_disks.ids[0],
            snapshot_name=name)
        default_custom_image = alicloud.simpleapplicationserver.CustomImage("defaultCustomImage",
            custom_image_name=name,
            instance_id=default_instance.id,
            system_snapshot_id=default_snapshot.id,
            status="Share",
            description=name)
        ```

        ## Import

        Simple Application Server Custom Image can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:simpleapplicationserver/customImage:CustomImage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_image_name: The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        :param pulumi.Input[str] description: The description of the Custom Image.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] status: The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.
               
               **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        :param pulumi.Input[str] system_snapshot_id: The ID of the system snapshot.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Simple Application Server Custom Image resource.

        For information about Simple Application Server Custom Image and how to use it, see [What is Custom Image](https://www.alibabacloud.com/help/en/doc-detail/333535.htm).

        > **NOTE:** Available since v1.143.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default_images = alicloud.simpleapplicationserver.get_images()
        default_server_plans = alicloud.simpleapplicationserver.get_server_plans()
        default_instance = alicloud.simpleapplicationserver.Instance("defaultInstance",
            payment_type="Subscription",
            plan_id=default_server_plans.plans[0].id,
            instance_name=name,
            image_id=default_images.images[0].id,
            period=1,
            data_disk_size=100)
        default_server_disks = alicloud.simpleapplicationserver.get_server_disks_output(instance_id=default_instance.id)
        default_snapshot = alicloud.simpleapplicationserver.Snapshot("defaultSnapshot",
            disk_id=default_server_disks.ids[0],
            snapshot_name=name)
        default_custom_image = alicloud.simpleapplicationserver.CustomImage("defaultCustomImage",
            custom_image_name=name,
            instance_id=default_instance.id,
            system_snapshot_id=default_snapshot.id,
            status="Share",
            description=name)
        ```

        ## Import

        Simple Application Server Custom Image can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:simpleapplicationserver/customImage:CustomImage example <id>
        ```

        :param str resource_name: The name of the resource.
        :param CustomImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_image_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_snapshot_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomImageArgs.__new__(CustomImageArgs)

            if custom_image_name is None and not opts.urn:
                raise TypeError("Missing required property 'custom_image_name'")
            __props__.__dict__["custom_image_name"] = custom_image_name
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["status"] = status
            if system_snapshot_id is None and not opts.urn:
                raise TypeError("Missing required property 'system_snapshot_id'")
            __props__.__dict__["system_snapshot_id"] = system_snapshot_id
        super(CustomImage, __self__).__init__(
            'alicloud:simpleapplicationserver/customImage:CustomImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_image_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_snapshot_id: Optional[pulumi.Input[str]] = None) -> 'CustomImage':
        """
        Get an existing CustomImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_image_name: The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        :param pulumi.Input[str] description: The description of the Custom Image.
        :param pulumi.Input[str] instance_id: The ID of the instance.
        :param pulumi.Input[str] status: The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.
               
               **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        :param pulumi.Input[str] system_snapshot_id: The ID of the system snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomImageState.__new__(_CustomImageState)

        __props__.__dict__["custom_image_name"] = custom_image_name
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["status"] = status
        __props__.__dict__["system_snapshot_id"] = system_snapshot_id
        return CustomImage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customImageName")
    def custom_image_name(self) -> pulumi.Output[str]:
        """
        The name of the resource. The name must be `2` to `128` characters in length. It must start with a letter or a number. It can contain letters, digits, colons (:), underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "custom_image_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Custom Image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[Optional[str]]:
        """
        The Shared status of the Custom Image. Valid values: `Share`, `UnShare`.

        **NOTE:** The `status` will be automatically change to `UnShare` when the resource is deleted, please operate with caution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemSnapshotId")
    def system_snapshot_id(self) -> pulumi.Output[str]:
        """
        The ID of the system snapshot.
        """
        return pulumi.get(self, "system_snapshot_id")

