# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AclEntryAttachmentArgs', 'AclEntryAttachment']

@pulumi.input_type
class AclEntryAttachmentArgs:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[str],
                 entry: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AclEntryAttachment resource.
        :param pulumi.Input[str] acl_id: The ID of the Acl.
        :param pulumi.Input[str] entry: The CIDR blocks.
        :param pulumi.Input[str] comment: The comment of the entry.
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "entry", entry)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[str]:
        """
        The ID of the Acl.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[str]:
        """
        The CIDR blocks.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        The comment of the entry.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)


@pulumi.input_type
class _AclEntryAttachmentState:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 entry: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AclEntryAttachment resources.
        :param pulumi.Input[str] acl_id: The ID of the Acl.
        :param pulumi.Input[str] comment: The comment of the entry.
        :param pulumi.Input[str] entry: The CIDR blocks.
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if entry is not None:
            pulumi.set(__self__, "entry", entry)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Acl.
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        The comment of the entry.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def entry(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR blocks.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry", value)


class AclEntryAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 entry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        > **NOTE:** Available in v1.162.0+.

        > **NOTE:** The maximum number of entries per acl is 300.

        For information about acl entry attachment and how to use it, see [Configure an acl entry](https://www.alibabacloud.com/help/en/doc-detail/70023.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        attachment_acl = alicloud.slb.Acl("attachmentAcl", ip_version="ipv4")
        attachment_acl_entry_attachment = alicloud.slb.AclEntryAttachment("attachmentAclEntryAttachment",
            acl_id=attachment_acl.id,
            entry="168.10.10.0/24",
            comment="second")
        ```

        ## Import

        Acl entry attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:slb/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the Acl.
        :param pulumi.Input[str] comment: The comment of the entry.
        :param pulumi.Input[str] entry: The CIDR blocks.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclEntryAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** Available in v1.162.0+.

        > **NOTE:** The maximum number of entries per acl is 300.

        For information about acl entry attachment and how to use it, see [Configure an acl entry](https://www.alibabacloud.com/help/en/doc-detail/70023.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        attachment_acl = alicloud.slb.Acl("attachmentAcl", ip_version="ipv4")
        attachment_acl_entry_attachment = alicloud.slb.AclEntryAttachment("attachmentAclEntryAttachment",
            acl_id=attachment_acl.id,
            entry="168.10.10.0/24",
            comment="second")
        ```

        ## Import

        Acl entry attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:slb/aclEntryAttachment:AclEntryAttachment example <acl_id>:<entry>
        ```

        :param str resource_name: The name of the resource.
        :param AclEntryAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclEntryAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 entry: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclEntryAttachmentArgs.__new__(AclEntryAttachmentArgs)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            __props__.__dict__["comment"] = comment
            if entry is None and not opts.urn:
                raise TypeError("Missing required property 'entry'")
            __props__.__dict__["entry"] = entry
        super(AclEntryAttachment, __self__).__init__(
            'alicloud:slb/aclEntryAttachment:AclEntryAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            entry: Optional[pulumi.Input[str]] = None) -> 'AclEntryAttachment':
        """
        Get an existing AclEntryAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the Acl.
        :param pulumi.Input[str] comment: The comment of the entry.
        :param pulumi.Input[str] entry: The CIDR blocks.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclEntryAttachmentState.__new__(_AclEntryAttachmentState)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["entry"] = entry
        return AclEntryAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[str]:
        """
        The ID of the Acl.
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[str]]:
        """
        The comment of the entry.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Output[str]:
        """
        The CIDR blocks.
        """
        return pulumi.get(self, "entry")

