# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AclEntryList',
    'BackendServerBackendServer',
    'ListenerXForwardedFor',
    'MasterSlaveServerGroupServer',
    'ServerGroupServer',
    'GetAclsAclResult',
    'GetAclsAclEntryListResult',
    'GetAclsAclRelatedListenerResult',
    'GetApplicationLoadBalancersBalancerResult',
    'GetApplicationLoadBalancersBalancerBackendServerResult',
    'GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult',
    'GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult',
    'GetApplicationLoadBalancersSlbResult',
    'GetAttachmentsSlbAttachmentResult',
    'GetBackendServersBackendServerResult',
    'GetCaCertificatesCertificateResult',
    'GetDomainExtensionsExtensionResult',
    'GetListenersSlbListenerResult',
    'GetLoadBalancersBalancerResult',
    'GetLoadBalancersBalancerBackendServerResult',
    'GetLoadBalancersBalancerListenerPortsAndProtocalResult',
    'GetLoadBalancersBalancerListenerPortsAndProtocolResult',
    'GetLoadBalancersSlbResult',
    'GetMasterSlaveServerGroupsGroupResult',
    'GetMasterSlaveServerGroupsGroupServerResult',
    'GetRulesSlbRuleResult',
    'GetServerCertificatesCertificateResult',
    'GetServerGroupsSlbServerGroupResult',
    'GetServerGroupsSlbServerGroupServerResult',
    'GetTlsCipherPoliciesPolicyResult',
    'GetTlsCipherPoliciesPolicyRelateListenerResult',
    'GetZonesZoneResult',
    'GetZonesZoneSupportedResourceResult',
]

@pulumi.output_type
class AclEntryList(dict):
    def __init__(__self__, *,
                 comment: Optional[str] = None,
                 entry: Optional[str] = None):
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if entry is not None:
            pulumi.set(__self__, "entry", entry)

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def entry(self) -> Optional[str]:
        return pulumi.get(self, "entry")


@pulumi.output_type
class BackendServerBackendServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "serverIp":
            suggest = "server_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackendServerBackendServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackendServerBackendServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackendServerBackendServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_id: str,
                 weight: int,
                 server_ip: Optional[str] = None,
                 type: Optional[str] = None):
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "weight", weight)
        if server_ip is not None:
            pulumi.set(__self__, "server_ip", server_ip)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")

    @property
    @pulumi.getter(name="serverIp")
    def server_ip(self) -> Optional[str]:
        return pulumi.get(self, "server_ip")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class ListenerXForwardedFor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retriveClientIp":
            suggest = "retrive_client_ip"
        elif key == "retriveSlbId":
            suggest = "retrive_slb_id"
        elif key == "retriveSlbIp":
            suggest = "retrive_slb_ip"
        elif key == "retriveSlbProto":
            suggest = "retrive_slb_proto"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerXForwardedFor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerXForwardedFor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerXForwardedFor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retrive_client_ip: Optional[bool] = None,
                 retrive_slb_id: Optional[bool] = None,
                 retrive_slb_ip: Optional[bool] = None,
                 retrive_slb_proto: Optional[bool] = None):
        """
        :param bool retrive_client_ip: Whether to retrieve the client ip. It is read-only attribute.
        :param bool retrive_slb_id: Whether to use the XForwardedFor header to obtain the ID of the SLB instance. Default to false.
        :param bool retrive_slb_ip: Whether to use the XForwardedFor_SLBIP header to obtain the public IP address of the SLB instance. Default to false.
        :param bool retrive_slb_proto: Whether to use the XForwardedFor_proto header to obtain the protocol used by the listener. Default to false.
        """
        if retrive_client_ip is not None:
            pulumi.set(__self__, "retrive_client_ip", retrive_client_ip)
        if retrive_slb_id is not None:
            pulumi.set(__self__, "retrive_slb_id", retrive_slb_id)
        if retrive_slb_ip is not None:
            pulumi.set(__self__, "retrive_slb_ip", retrive_slb_ip)
        if retrive_slb_proto is not None:
            pulumi.set(__self__, "retrive_slb_proto", retrive_slb_proto)

    @property
    @pulumi.getter(name="retriveClientIp")
    def retrive_client_ip(self) -> Optional[bool]:
        """
        Whether to retrieve the client ip. It is read-only attribute.
        """
        return pulumi.get(self, "retrive_client_ip")

    @property
    @pulumi.getter(name="retriveSlbId")
    def retrive_slb_id(self) -> Optional[bool]:
        """
        Whether to use the XForwardedFor header to obtain the ID of the SLB instance. Default to false.
        """
        return pulumi.get(self, "retrive_slb_id")

    @property
    @pulumi.getter(name="retriveSlbIp")
    def retrive_slb_ip(self) -> Optional[bool]:
        """
        Whether to use the XForwardedFor_SLBIP header to obtain the public IP address of the SLB instance. Default to false.
        """
        return pulumi.get(self, "retrive_slb_ip")

    @property
    @pulumi.getter(name="retriveSlbProto")
    def retrive_slb_proto(self) -> Optional[bool]:
        """
        Whether to use the XForwardedFor_proto header to obtain the protocol used by the listener. Default to false.
        """
        return pulumi.get(self, "retrive_slb_proto")


@pulumi.output_type
class MasterSlaveServerGroupServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverId":
            suggest = "server_id"
        elif key == "isBackup":
            suggest = "is_backup"
        elif key == "serverType":
            suggest = "server_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterSlaveServerGroupServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterSlaveServerGroupServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterSlaveServerGroupServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 server_id: str,
                 is_backup: Optional[int] = None,
                 server_type: Optional[str] = None,
                 type: Optional[str] = None,
                 weight: Optional[int] = None):
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_id", server_id)
        if is_backup is not None:
            pulumi.set(__self__, "is_backup", is_backup)
        if server_type is not None:
            pulumi.set(__self__, "server_type", server_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> Optional[int]:
        return pulumi.get(self, "is_backup")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> Optional[str]:
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServerGroupServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverIds":
            suggest = "server_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerGroupServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerGroupServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 server_ids: Sequence[str],
                 type: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        :param int port: The port used by the backend server. Valid value range: [1-65535].
        :param Sequence[str] server_ids: A list backend server ID (ECS instance ID).
        :param str type: Type of the backend server. Valid value ecs, eni. Default to eni.
        :param int weight: Weight of the backend server. Valid value range: [0-100]. Default to 100.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_ids", server_ids)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port used by the backend server. Valid value range: [1-65535].
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverIds")
    def server_ids(self) -> Sequence[str]:
        """
        A list backend server ID (ECS instance ID).
        """
        return pulumi.get(self, "server_ids")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of the backend server. Valid value ecs, eni. Default to eni.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        Weight of the backend server. Valid value range: [0-100]. Default to 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetAclsAclResult(dict):
    def __init__(__self__, *,
                 entry_lists: Sequence['outputs.GetAclsAclEntryListResult'],
                 id: str,
                 ip_version: str,
                 name: str,
                 related_listeners: Sequence['outputs.GetAclsAclRelatedListenerResult'],
                 resource_group_id: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param Sequence['GetAclsAclEntryListArgs'] entry_lists: A list of entry (IP addresses or CIDR blocks).  Each entry contains two sub-fields as `Entry Block` follows.
        :param str id: Acl ID.
        :param str name: Acl name.
        :param Sequence['GetAclsAclRelatedListenerArgs'] related_listeners: A list of listener are attached by the acl.  Each listener contains four sub-fields as `Listener Block` follows.
        :param str resource_group_id: The Id of resource group which acl belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "entry_lists", entry_lists)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "related_listeners", related_listeners)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="entryLists")
    def entry_lists(self) -> Sequence['outputs.GetAclsAclEntryListResult']:
        """
        A list of entry (IP addresses or CIDR blocks).  Each entry contains two sub-fields as `Entry Block` follows.
        """
        return pulumi.get(self, "entry_lists")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Acl ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Acl name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="relatedListeners")
    def related_listeners(self) -> Sequence['outputs.GetAclsAclRelatedListenerResult']:
        """
        A list of listener are attached by the acl.  Each listener contains four sub-fields as `Listener Block` follows.
        """
        return pulumi.get(self, "related_listeners")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which acl belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetAclsAclEntryListResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 entry: str):
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "entry", entry)

    @property
    @pulumi.getter
    def comment(self) -> str:
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def entry(self) -> str:
        return pulumi.get(self, "entry")


@pulumi.output_type
class GetAclsAclRelatedListenerResult(dict):
    def __init__(__self__, *,
                 acl_type: str,
                 frontend_port: int,
                 load_balancer_id: str,
                 protocol: str):
        pulumi.set(__self__, "acl_type", acl_type)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="aclType")
    def acl_type(self) -> str:
        return pulumi.get(self, "acl_type")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address: str,
                 address_ip_version: str,
                 address_type: str,
                 auto_release_time: int,
                 backend_servers: Sequence['outputs.GetApplicationLoadBalancersBalancerBackendServerResult'],
                 bandwidth: int,
                 create_time_stamp: int,
                 delete_protection: str,
                 end_time: str,
                 end_time_stamp: int,
                 id: str,
                 internet_charge_type: str,
                 listener_ports_and_protocals: Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult'],
                 listener_ports_and_protocols: Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult'],
                 load_balancer_id: str,
                 load_balancer_name: str,
                 load_balancer_spec: str,
                 master_zone_id: str,
                 modification_protection_reason: str,
                 modification_protection_status: str,
                 network_type: str,
                 payment_type: str,
                 region_id_alias: str,
                 renewal_cyc_unit: str,
                 renewal_duration: int,
                 renewal_status: str,
                 resource_group_id: str,
                 slave_zone_id: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str address: Service address of the SLBs.
        :param str address_ip_version: The address ip version. Valid values `ipv4` and `ipv6`.
        :param str address_type: The address type of the SLB. Valid values `internet` and `intranet`.
        :param int auto_release_time: The auto release time.
        :param Sequence['GetApplicationLoadBalancersBalancerBackendServerArgs'] backend_servers: The backend servers of the SLB.
        :param int bandwidth: The bandwidth of the SLB.
        :param int create_time_stamp: The create time stamp of the SLB.
        :param str delete_protection: Whether the SLB should delete protection.
        :param str end_time: The end time of the SLB.
        :param int end_time_stamp: The end time stamp of the SLB.
        :param str id: ID of the SLB.
        :param str internet_charge_type: The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
        :param Sequence['GetApplicationLoadBalancersBalancerListenerPortsAndProtocalArgs'] listener_ports_and_protocals: The listener ports and protocal of the SLB.
        :param Sequence['GetApplicationLoadBalancersBalancerListenerPortsAndProtocolArgs'] listener_ports_and_protocols: The listener ports and protocol of the SLB.
        :param str load_balancer_id: Thd ID of the SLB.
        :param str load_balancer_name: The name of the SLB.
        :param str load_balancer_spec: The specification of the SLB.
        :param str master_zone_id: The master zone id of the SLB.
        :param str modification_protection_reason: The reason of modification protection.
        :param str modification_protection_status: The status of modification protection.
        :param str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param str payment_type: The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
        :param str region_id_alias: Region ID the SLB belongs to.
        :param str renewal_cyc_unit: The renewal cyc unit of the SLB.
        :param int renewal_duration: The renewal duration of the SLB.
        :param str renewal_status: The renewal status of the SLB.
        :param str resource_group_id: The Id of resource group which SLB belongs.
        :param str slave_zone_id: The slave zone id of the SLB.
        :param str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, Any] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        :param str vpc_id: ID of the VPC linked to the SLBs.
        :param str vswitch_id: ID of the VSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "backend_servers", backend_servers)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time_stamp", create_time_stamp)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "end_time_stamp", end_time_stamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "listener_ports_and_protocals", listener_ports_and_protocals)
        pulumi.set(__self__, "listener_ports_and_protocols", listener_ports_and_protocols)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id_alias", region_id_alias)
        pulumi.set(__self__, "renewal_cyc_unit", renewal_cyc_unit)
        pulumi.set(__self__, "renewal_duration", renewal_duration)
        pulumi.set(__self__, "renewal_status", renewal_status)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> str:
        """
        The address ip version. Valid values `ipv4` and `ipv6`.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> str:
        """
        The address type of the SLB. Valid values `internet` and `intranet`.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> int:
        """
        The auto release time.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="backendServers")
    def backend_servers(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerBackendServerResult']:
        """
        The backend servers of the SLB.
        """
        return pulumi.get(self, "backend_servers")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of the SLB.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTimeStamp")
    def create_time_stamp(self) -> int:
        """
        The create time stamp of the SLB.
        """
        return pulumi.get(self, "create_time_stamp")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> str:
        """
        Whether the SLB should delete protection.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the SLB.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="endTimeStamp")
    def end_time_stamp(self) -> int:
        """
        The end time stamp of the SLB.
        """
        return pulumi.get(self, "end_time_stamp")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The internet charge type. Valid values `PayByBandwidth` and `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="listenerPortsAndProtocals")
    def listener_ports_and_protocals(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult']:
        """
        The listener ports and protocal of the SLB.
        """
        return pulumi.get(self, "listener_ports_and_protocals")

    @property
    @pulumi.getter(name="listenerPortsAndProtocols")
    def listener_ports_and_protocols(self) -> Sequence['outputs.GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult']:
        """
        The listener ports and protocol of the SLB.
        """
        return pulumi.get(self, "listener_ports_and_protocols")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        Thd ID of the SLB.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> str:
        """
        The name of the SLB.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> str:
        """
        The specification of the SLB.
        """
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> str:
        """
        The master zone id of the SLB.
        """
        return pulumi.get(self, "master_zone_id")

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> str:
        """
        The reason of modification protection.
        """
        return pulumi.get(self, "modification_protection_reason")

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> str:
        """
        The status of modification protection.
        """
        return pulumi.get(self, "modification_protection_status")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of SLB. Valid values `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="regionIdAlias")
    def region_id_alias(self) -> str:
        """
        Region ID the SLB belongs to.
        """
        return pulumi.get(self, "region_id_alias")

    @property
    @pulumi.getter(name="renewalCycUnit")
    def renewal_cyc_unit(self) -> str:
        """
        The renewal cyc unit of the SLB.
        """
        return pulumi.get(self, "renewal_cyc_unit")

    @property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> int:
        """
        The renewal duration of the SLB.
        """
        return pulumi.get(self, "renewal_duration")

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> str:
        """
        The renewal status of the SLB.
        """
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> str:
        """
        The slave zone id of the SLB.
        """
        return pulumi.get(self, "slave_zone_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerBackendServerResult(dict):
    def __init__(__self__, *,
                 description: str,
                 server_id: str,
                 type: str,
                 weight: int):
        """
        :param str description: The description of protocol.
        :param str server_id: The server ID.
        :param str type: The type of servers.
        :param int weight: The weight of servers.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of protocol.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of servers.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of servers.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerListenerPortsAndProtocalResult(dict):
    def __init__(__self__, *,
                 listener_port: int,
                 listener_protocal: str):
        """
        :param int listener_port: The listener port.
        :param str listener_protocal: The listener protoal.
        """
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocal", listener_protocal)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> int:
        """
        The listener port.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocal")
    def listener_protocal(self) -> str:
        """
        The listener protoal.
        """
        return pulumi.get(self, "listener_protocal")


@pulumi.output_type
class GetApplicationLoadBalancersBalancerListenerPortsAndProtocolResult(dict):
    def __init__(__self__, *,
                 description: str,
                 forward_port: int,
                 listener_forward: str,
                 listener_port: int,
                 listener_protocol: str):
        """
        :param str description: The description of protocol.
        :param int forward_port: The forward port.
        :param str listener_forward: The listener forward.
        :param int listener_port: The listener port.
        :param str listener_protocol: The listener protocol.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "listener_forward", listener_forward)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of protocol.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> int:
        """
        The forward port.
        """
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="listenerForward")
    def listener_forward(self) -> str:
        """
        The listener forward.
        """
        return pulumi.get(self, "listener_forward")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> int:
        """
        The listener port.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> str:
        """
        The listener protocol.
        """
        return pulumi.get(self, "listener_protocol")


@pulumi.output_type
class GetApplicationLoadBalancersSlbResult(dict):
    def __init__(__self__, *,
                 address: str,
                 creation_time: str,
                 id: str,
                 internet: bool,
                 master_availability_zone: str,
                 name: str,
                 network_type: str,
                 region_id: str,
                 slave_availability_zone: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str address: Service address of the SLBs.
        :param str id: ID of the SLB.
        :param str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, Any] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        :param str vpc_id: ID of the VPC linked to the SLBs.
        :param str vswitch_id: ID of the VSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet", internet)
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "slave_availability_zone", slave_availability_zone)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def internet(self) -> bool:
        return pulumi.get(self, "internet")

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> str:
        return pulumi.get(self, "master_availability_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="slaveAvailabilityZone")
    def slave_availability_zone(self) -> str:
        return pulumi.get(self, "slave_availability_zone")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAttachmentsSlbAttachmentResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 weight: int):
        """
        :param str instance_id: ID of the attached ECS instance.
        :param int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetBackendServersBackendServerResult(dict):
    def __init__(__self__, *,
                 id: str,
                 server_type: str,
                 weight: int):
        """
        :param str id: backend server ID.
        :param str server_type: Type of the backend server.
        :param int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        backend server ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        """
        Type of the backend server.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetCaCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 ca_certificate_id: str,
                 ca_certificate_name: str,
                 common_name: str,
                 created_timestamp: int,
                 expired_time: str,
                 expired_timestamp: int,
                 fingerprint: str,
                 id: str,
                 name: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str ca_certificate_id: (Available in v1.123.1+) CA certificate ID.
        :param str ca_certificate_name: (Available in v1.123.1+) CA certificate name.
        :param str common_name: CA certificate common name.
        :param int created_timestamp: CA certificate created timestamp.
        :param str expired_time: CA certificate expired time.
        :param int expired_timestamp: CA certificate expired timestamp.
        :param str fingerprint: CA certificate fingerprint.
        :param str id: CA certificate ID.
        :param str name: (Deprecated from v1.123.1) Deprecated and replace by `ca_certificate_name`.
        :param str resource_group_id: The Id of resource group which ca certificates belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        pulumi.set(__self__, "ca_certificate_name", ca_certificate_name)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "expired_timestamp", expired_timestamp)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> str:
        """
        (Available in v1.123.1+) CA certificate ID.
        """
        return pulumi.get(self, "ca_certificate_id")

    @property
    @pulumi.getter(name="caCertificateName")
    def ca_certificate_name(self) -> str:
        """
        (Available in v1.123.1+) CA certificate name.
        """
        return pulumi.get(self, "ca_certificate_name")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        CA certificate common name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> int:
        """
        CA certificate created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        CA certificate expired time.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="expiredTimestamp")
    def expired_timestamp(self) -> int:
        """
        CA certificate expired timestamp.
        """
        return pulumi.get(self, "expired_timestamp")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        CA certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        CA certificate ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Deprecated from v1.123.1) Deprecated and replace by `ca_certificate_name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which ca certificates belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDomainExtensionsExtensionResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 id: str,
                 server_certificate_id: str):
        """
        :param str domain: The domain name.
        :param str id: The ID of the domain extension.
        :param str server_certificate_id: The ID of the certificate used by the domain name.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "server_certificate_id", server_certificate_id)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the domain extension.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serverCertificateId")
    def server_certificate_id(self) -> str:
        """
        The ID of the certificate used by the domain name.
        """
        return pulumi.get(self, "server_certificate_id")


@pulumi.output_type
class GetListenersSlbListenerResult(dict):
    def __init__(__self__, *,
                 backend_port: int,
                 bandwidth: int,
                 ca_certificate_id: str,
                 cookie: str,
                 cookie_timeout: int,
                 description: str,
                 enable_http2: str,
                 established_timeout: int,
                 frontend_port: int,
                 gzip: str,
                 health_check: str,
                 health_check_connect_port: int,
                 health_check_connect_timeout: int,
                 health_check_domain: str,
                 health_check_http_code: str,
                 health_check_interval: int,
                 health_check_timeout: int,
                 health_check_type: str,
                 health_check_uri: str,
                 healthy_threshold: int,
                 idle_timeout: int,
                 master_slave_server_group_id: str,
                 persistence_timeout: int,
                 protocol: str,
                 proxy_protocol_v2_enabled: bool,
                 request_timeout: int,
                 scheduler: str,
                 security_status: str,
                 server_certificate_id: str,
                 server_group_id: str,
                 ssl_certificate_id: str,
                 status: str,
                 sticky_session: str,
                 sticky_session_type: str,
                 tls_cipher_policy: str,
                 unhealthy_threshold: int,
                 x_forwarded_for: str,
                 x_forwarded_for_slb_id: str,
                 x_forwarded_for_slb_ip: str,
                 x_forwarded_for_slb_proto: str):
        """
        :param int backend_port: Port opened on the backend server to receive requests.
        :param int bandwidth: Peak bandwidth. If the value is set to -1, the listener is not limited by bandwidth.
        :param str ca_certificate_id: ID of the CA certificate (only required when two-way authentication is used). Only available when the protocol is `https`.
        :param str cookie: Cookie configured by the backend server. Only available when the sticky_session_type is `server`.
        :param int cookie_timeout: Cookie timeout in seconds. Only available when the sticky_session_type is `insert`.
        :param str description: The description of slb listener.
        :param str enable_http2: Whether to enable https listener support http2 or not. Valid values are `on` and `off`. Default to `on`.
        :param int established_timeout: Connection timeout in seconds for the Layer 4 TCP listener. Only available when the protocol is `tcp`.
        :param int frontend_port: Filter listeners by the specified frontend port.
        :param str gzip: Indicate whether Gzip compression is enabled or not. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param str health_check: Indicate whether health check is enabled of not. Possible values are `on` and `off`.
        :param int health_check_connect_port: Port used for health check.
        :param int health_check_connect_timeout: Amount of time in seconds to wait for the response for a health check.
        :param str health_check_domain: Domain name used for health check. The SLB sends HTTP head requests to the backend server, the domain is useful when the backend server verifies the host field in the requests. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param str health_check_http_code: HTTP status codes indicating that the health check is normal. It can contain several comma-separated values such as "http_2xx,http_3xx". Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param int health_check_interval: Time interval between two consecutive health checks.
        :param int health_check_timeout: Amount of time in seconds to wait for the response from a health check. If an ECS instance sends no response within the specified timeout period, the health check fails. Only available when the protocol is `http` or `https`.
        :param str health_check_type: Health check method. Possible values are `tcp` and `http`. Only available when the protocol is `tcp`.
        :param str health_check_uri: URI used for health check. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        :param int healthy_threshold: Number of consecutive successes of health check performed on the same ECS instance (from failure to success).
        :param int idle_timeout: Timeout of http or https listener established connection idle timeout. Valid value range: [1-60] in seconds. Default to 15.
        :param str master_slave_server_group_id: ID of the active/standby server group.
        :param int persistence_timeout: Timeout value of the TCP connection in seconds. If the value is 0, the session persistence function is disabled. Only available when the protocol is `tcp`.
        :param str protocol: Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
        :param bool proxy_protocol_v2_enabled: Whether to support carrying the client source address to the backend server through the Proxy Protocol. Valid values are `true` and `false`. Default to `false`.
        :param int request_timeout: Timeout of http or https listener request (which does not get response from backend) timeout. Valid value range: [1-180] in seconds. Default to 60.
        :param str scheduler: Algorithm used to distribute traffic. Possible values: `wrr` (weighted round robin), `wlc` (weighted least connection) and `rr` (round robin).
        :param str security_status: Security status. Only available when the protocol is `https`.
        :param str server_group_id: ID of the linked VServer group.
        :param str ssl_certificate_id: ID of the server certificate. Only available when the protocol is `https`.
        :param str status: Listener status.
        :param str sticky_session: Indicate whether session persistence is enabled or not. If enabled, all session requests from the same client are sent to the same backend server. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param str sticky_session_type: Method used to handle the cookie. Possible values are `insert` (cookie added to the response) and `server` (cookie set by the backend server). Only available when the protocol is `http` or `https` and sticky_session is `on`.
        :param str tls_cipher_policy: Https listener TLS cipher policy. Valid values are `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`. Default to `tls_cipher_policy_1_0`.
        :param int unhealthy_threshold: Number of consecutive failures of health check performed on the same ECS instance (from success to failure).
        :param str x_forwarded_for: Indicate whether the HTTP header field "X-Forwarded-For" is added or not; it allows the backend server to know about the user's IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param str x_forwarded_for_slb_id: Indicate whether the HTTP header field "X-Forwarded-For_SLBID" is added or not; it allows the backend server to know about the SLB ID. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param str x_forwarded_for_slb_ip: Indicate whether the HTTP header field "X-Forwarded-For_SLBIP" is added or not; it allows the backend server to know about the SLB IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        :param str x_forwarded_for_slb_proto: Indicate whether the HTTP header field "X-Forwarded-For_proto" is added or not; it allows the backend server to know about the user's protocol. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        pulumi.set(__self__, "backend_port", backend_port)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "ca_certificate_id", ca_certificate_id)
        pulumi.set(__self__, "cookie", cookie)
        pulumi.set(__self__, "cookie_timeout", cookie_timeout)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_http2", enable_http2)
        pulumi.set(__self__, "established_timeout", established_timeout)
        pulumi.set(__self__, "frontend_port", frontend_port)
        pulumi.set(__self__, "gzip", gzip)
        pulumi.set(__self__, "health_check", health_check)
        pulumi.set(__self__, "health_check_connect_port", health_check_connect_port)
        pulumi.set(__self__, "health_check_connect_timeout", health_check_connect_timeout)
        pulumi.set(__self__, "health_check_domain", health_check_domain)
        pulumi.set(__self__, "health_check_http_code", health_check_http_code)
        pulumi.set(__self__, "health_check_interval", health_check_interval)
        pulumi.set(__self__, "health_check_timeout", health_check_timeout)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "health_check_uri", health_check_uri)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "master_slave_server_group_id", master_slave_server_group_id)
        pulumi.set(__self__, "persistence_timeout", persistence_timeout)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "proxy_protocol_v2_enabled", proxy_protocol_v2_enabled)
        pulumi.set(__self__, "request_timeout", request_timeout)
        pulumi.set(__self__, "scheduler", scheduler)
        pulumi.set(__self__, "security_status", security_status)
        pulumi.set(__self__, "server_certificate_id", server_certificate_id)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "ssl_certificate_id", ssl_certificate_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sticky_session", sticky_session)
        pulumi.set(__self__, "sticky_session_type", sticky_session_type)
        pulumi.set(__self__, "tls_cipher_policy", tls_cipher_policy)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        pulumi.set(__self__, "x_forwarded_for", x_forwarded_for)
        pulumi.set(__self__, "x_forwarded_for_slb_id", x_forwarded_for_slb_id)
        pulumi.set(__self__, "x_forwarded_for_slb_ip", x_forwarded_for_slb_ip)
        pulumi.set(__self__, "x_forwarded_for_slb_proto", x_forwarded_for_slb_proto)

    @property
    @pulumi.getter(name="backendPort")
    def backend_port(self) -> int:
        """
        Port opened on the backend server to receive requests.
        """
        return pulumi.get(self, "backend_port")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        Peak bandwidth. If the value is set to -1, the listener is not limited by bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="caCertificateId")
    def ca_certificate_id(self) -> str:
        """
        ID of the CA certificate (only required when two-way authentication is used). Only available when the protocol is `https`.
        """
        return pulumi.get(self, "ca_certificate_id")

    @property
    @pulumi.getter
    def cookie(self) -> str:
        """
        Cookie configured by the backend server. Only available when the sticky_session_type is `server`.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> int:
        """
        Cookie timeout in seconds. Only available when the sticky_session_type is `insert`.
        """
        return pulumi.get(self, "cookie_timeout")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of slb listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> str:
        """
        Whether to enable https listener support http2 or not. Valid values are `on` and `off`. Default to `on`.
        """
        return pulumi.get(self, "enable_http2")

    @property
    @pulumi.getter(name="establishedTimeout")
    def established_timeout(self) -> int:
        """
        Connection timeout in seconds for the Layer 4 TCP listener. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "established_timeout")

    @property
    @pulumi.getter(name="frontendPort")
    def frontend_port(self) -> int:
        """
        Filter listeners by the specified frontend port.
        """
        return pulumi.get(self, "frontend_port")

    @property
    @pulumi.getter
    def gzip(self) -> str:
        """
        Indicate whether Gzip compression is enabled or not. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "gzip")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> str:
        """
        Indicate whether health check is enabled of not. Possible values are `on` and `off`.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="healthCheckConnectPort")
    def health_check_connect_port(self) -> int:
        """
        Port used for health check.
        """
        return pulumi.get(self, "health_check_connect_port")

    @property
    @pulumi.getter(name="healthCheckConnectTimeout")
    def health_check_connect_timeout(self) -> int:
        """
        Amount of time in seconds to wait for the response for a health check.
        """
        return pulumi.get(self, "health_check_connect_timeout")

    @property
    @pulumi.getter(name="healthCheckDomain")
    def health_check_domain(self) -> str:
        """
        Domain name used for health check. The SLB sends HTTP head requests to the backend server, the domain is useful when the backend server verifies the host field in the requests. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_domain")

    @property
    @pulumi.getter(name="healthCheckHttpCode")
    def health_check_http_code(self) -> str:
        """
        HTTP status codes indicating that the health check is normal. It can contain several comma-separated values such as "http_2xx,http_3xx". Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_http_code")

    @property
    @pulumi.getter(name="healthCheckInterval")
    def health_check_interval(self) -> int:
        """
        Time interval between two consecutive health checks.
        """
        return pulumi.get(self, "health_check_interval")

    @property
    @pulumi.getter(name="healthCheckTimeout")
    def health_check_timeout(self) -> int:
        """
        Amount of time in seconds to wait for the response from a health check. If an ECS instance sends no response within the specified timeout period, the health check fails. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "health_check_timeout")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> str:
        """
        Health check method. Possible values are `tcp` and `http`. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="healthCheckUri")
    def health_check_uri(self) -> str:
        """
        URI used for health check. Only available when the protocol is `http`, `https` or `tcp` (in this case health_check_type must be `http`).
        """
        return pulumi.get(self, "health_check_uri")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        """
        Number of consecutive successes of health check performed on the same ECS instance (from failure to success).
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> int:
        """
        Timeout of http or https listener established connection idle timeout. Valid value range: [1-60] in seconds. Default to 15.
        """
        return pulumi.get(self, "idle_timeout")

    @property
    @pulumi.getter(name="masterSlaveServerGroupId")
    def master_slave_server_group_id(self) -> str:
        """
        ID of the active/standby server group.
        """
        return pulumi.get(self, "master_slave_server_group_id")

    @property
    @pulumi.getter(name="persistenceTimeout")
    def persistence_timeout(self) -> int:
        """
        Timeout value of the TCP connection in seconds. If the value is 0, the session persistence function is disabled. Only available when the protocol is `tcp`.
        """
        return pulumi.get(self, "persistence_timeout")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Filter listeners by the specified protocol. Valid values: `http`, `https`, `tcp` and `udp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="proxyProtocolV2Enabled")
    def proxy_protocol_v2_enabled(self) -> bool:
        """
        Whether to support carrying the client source address to the backend server through the Proxy Protocol. Valid values are `true` and `false`. Default to `false`.
        """
        return pulumi.get(self, "proxy_protocol_v2_enabled")

    @property
    @pulumi.getter(name="requestTimeout")
    def request_timeout(self) -> int:
        """
        Timeout of http or https listener request (which does not get response from backend) timeout. Valid value range: [1-180] in seconds. Default to 60.
        """
        return pulumi.get(self, "request_timeout")

    @property
    @pulumi.getter
    def scheduler(self) -> str:
        """
        Algorithm used to distribute traffic. Possible values: `wrr` (weighted round robin), `wlc` (weighted least connection) and `rr` (round robin).
        """
        return pulumi.get(self, "scheduler")

    @property
    @pulumi.getter(name="securityStatus")
    def security_status(self) -> str:
        """
        Security status. Only available when the protocol is `https`.
        """
        return pulumi.get(self, "security_status")

    @property
    @pulumi.getter(name="serverCertificateId")
    def server_certificate_id(self) -> str:
        return pulumi.get(self, "server_certificate_id")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> str:
        """
        ID of the linked VServer group.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter(name="sslCertificateId")
    def ssl_certificate_id(self) -> str:
        """
        ID of the server certificate. Only available when the protocol is `https`.
        """
        return pulumi.get(self, "ssl_certificate_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Listener status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stickySession")
    def sticky_session(self) -> str:
        """
        Indicate whether session persistence is enabled or not. If enabled, all session requests from the same client are sent to the same backend server. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "sticky_session")

    @property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> str:
        """
        Method used to handle the cookie. Possible values are `insert` (cookie added to the response) and `server` (cookie set by the backend server). Only available when the protocol is `http` or `https` and sticky_session is `on`.
        """
        return pulumi.get(self, "sticky_session_type")

    @property
    @pulumi.getter(name="tlsCipherPolicy")
    def tls_cipher_policy(self) -> str:
        """
        Https listener TLS cipher policy. Valid values are `tls_cipher_policy_1_0`, `tls_cipher_policy_1_1`, `tls_cipher_policy_1_2`, `tls_cipher_policy_1_2_strict`. Default to `tls_cipher_policy_1_0`.
        """
        return pulumi.get(self, "tls_cipher_policy")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        """
        Number of consecutive failures of health check performed on the same ECS instance (from success to failure).
        """
        return pulumi.get(self, "unhealthy_threshold")

    @property
    @pulumi.getter(name="xForwardedFor")
    def x_forwarded_for(self) -> str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For" is added or not; it allows the backend server to know about the user's IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for")

    @property
    @pulumi.getter(name="xForwardedForSlbId")
    def x_forwarded_for_slb_id(self) -> str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_SLBID" is added or not; it allows the backend server to know about the SLB ID. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_id")

    @property
    @pulumi.getter(name="xForwardedForSlbIp")
    def x_forwarded_for_slb_ip(self) -> str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_SLBIP" is added or not; it allows the backend server to know about the SLB IP address. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_ip")

    @property
    @pulumi.getter(name="xForwardedForSlbProto")
    def x_forwarded_for_slb_proto(self) -> str:
        """
        Indicate whether the HTTP header field "X-Forwarded-For_proto" is added or not; it allows the backend server to know about the user's protocol. Possible values are `on` and `off`. Only available when the protocol is `http` or `https`.
        """
        return pulumi.get(self, "x_forwarded_for_slb_proto")


@pulumi.output_type
class GetLoadBalancersBalancerResult(dict):
    def __init__(__self__, *,
                 address: str,
                 address_ip_version: str,
                 address_type: str,
                 auto_release_time: int,
                 backend_servers: Sequence['outputs.GetLoadBalancersBalancerBackendServerResult'],
                 bandwidth: int,
                 create_time_stamp: int,
                 delete_protection: str,
                 end_time: str,
                 end_time_stamp: int,
                 id: str,
                 internet_charge_type: str,
                 listener_ports_and_protocals: Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocalResult'],
                 listener_ports_and_protocols: Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocolResult'],
                 load_balancer_id: str,
                 load_balancer_name: str,
                 load_balancer_spec: str,
                 master_zone_id: str,
                 modification_protection_reason: str,
                 modification_protection_status: str,
                 network_type: str,
                 payment_type: str,
                 region_id_alias: str,
                 renewal_cyc_unit: str,
                 renewal_duration: int,
                 renewal_status: str,
                 resource_group_id: str,
                 slave_zone_id: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str address: Service address of the SLBs.
        :param str id: ID of the SLB.
        :param str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param str resource_group_id: The Id of resource group which SLB belongs.
        :param str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, Any] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_instances = alicloud.slb.get_load_balancers(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param str vpc_id: ID of the VPC linked to the SLBs.
        :param str vswitch_id: ID of the VSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "backend_servers", backend_servers)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time_stamp", create_time_stamp)
        pulumi.set(__self__, "delete_protection", delete_protection)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "end_time_stamp", end_time_stamp)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "listener_ports_and_protocals", listener_ports_and_protocals)
        pulumi.set(__self__, "listener_ports_and_protocols", listener_ports_and_protocols)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        pulumi.set(__self__, "load_balancer_spec", load_balancer_spec)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "modification_protection_reason", modification_protection_reason)
        pulumi.set(__self__, "modification_protection_status", modification_protection_status)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "region_id_alias", region_id_alias)
        pulumi.set(__self__, "renewal_cyc_unit", renewal_cyc_unit)
        pulumi.set(__self__, "renewal_duration", renewal_duration)
        pulumi.set(__self__, "renewal_status", renewal_status)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> str:
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> str:
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> int:
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="backendServers")
    def backend_servers(self) -> Sequence['outputs.GetLoadBalancersBalancerBackendServerResult']:
        return pulumi.get(self, "backend_servers")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTimeStamp")
    def create_time_stamp(self) -> int:
        return pulumi.get(self, "create_time_stamp")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> str:
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="endTimeStamp")
    def end_time_stamp(self) -> int:
        return pulumi.get(self, "end_time_stamp")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="listenerPortsAndProtocals")
    def listener_ports_and_protocals(self) -> Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocalResult']:
        return pulumi.get(self, "listener_ports_and_protocals")

    @property
    @pulumi.getter(name="listenerPortsAndProtocols")
    def listener_ports_and_protocols(self) -> Sequence['outputs.GetLoadBalancersBalancerListenerPortsAndProtocolResult']:
        return pulumi.get(self, "listener_ports_and_protocols")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> str:
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="loadBalancerSpec")
    def load_balancer_spec(self) -> str:
        return pulumi.get(self, "load_balancer_spec")

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> str:
        return pulumi.get(self, "master_zone_id")

    @property
    @pulumi.getter(name="modificationProtectionReason")
    def modification_protection_reason(self) -> str:
        return pulumi.get(self, "modification_protection_reason")

    @property
    @pulumi.getter(name="modificationProtectionStatus")
    def modification_protection_status(self) -> str:
        return pulumi.get(self, "modification_protection_status")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="regionIdAlias")
    def region_id_alias(self) -> str:
        return pulumi.get(self, "region_id_alias")

    @property
    @pulumi.getter(name="renewalCycUnit")
    def renewal_cyc_unit(self) -> str:
        return pulumi.get(self, "renewal_cyc_unit")

    @property
    @pulumi.getter(name="renewalDuration")
    def renewal_duration(self) -> int:
        return pulumi.get(self, "renewal_duration")

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> str:
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which SLB belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> str:
        return pulumi.get(self, "slave_zone_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_instances = alicloud.slb.get_load_balancers(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetLoadBalancersBalancerBackendServerResult(dict):
    def __init__(__self__, *,
                 description: str,
                 server_id: str,
                 type: str,
                 weight: int):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetLoadBalancersBalancerListenerPortsAndProtocalResult(dict):
    def __init__(__self__, *,
                 listener_port: int,
                 listener_protocal: str):
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocal", listener_protocal)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> int:
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocal")
    def listener_protocal(self) -> str:
        return pulumi.get(self, "listener_protocal")


@pulumi.output_type
class GetLoadBalancersBalancerListenerPortsAndProtocolResult(dict):
    def __init__(__self__, *,
                 description: str,
                 forward_port: int,
                 listener_forward: str,
                 listener_port: int,
                 listener_protocol: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "forward_port", forward_port)
        pulumi.set(__self__, "listener_forward", listener_forward)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_protocol", listener_protocol)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forwardPort")
    def forward_port(self) -> int:
        return pulumi.get(self, "forward_port")

    @property
    @pulumi.getter(name="listenerForward")
    def listener_forward(self) -> str:
        return pulumi.get(self, "listener_forward")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> int:
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerProtocol")
    def listener_protocol(self) -> str:
        return pulumi.get(self, "listener_protocol")


@pulumi.output_type
class GetLoadBalancersSlbResult(dict):
    def __init__(__self__, *,
                 address: str,
                 creation_time: str,
                 id: str,
                 internet: bool,
                 master_availability_zone: str,
                 name: str,
                 network_type: str,
                 region_id: str,
                 slave_availability_zone: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str address: Service address of the SLBs.
        :param str creation_time: SLB creation time.
        :param str id: ID of the SLB.
        :param bool internet: SLB addressType: internet if `true`, intranet if `false`. Must be `false` when `network_type` is `vpc`.
        :param str master_availability_zone: Master availability zone of the SLBs.
        :param str name: SLB name.
        :param str network_type: Network type of the SLBs. Valid values: `vpc` and `classic`.
        :param str region_id: Region ID the SLB belongs to.
        :param str slave_availability_zone: Slave availability zone of the SLBs.
        :param str status: SLB current status. Possible values: `inactive`, `active` and `locked`.
        :param Mapping[str, Any] tags: A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_instances = alicloud.slb.get_load_balancers(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param str vpc_id: ID of the VPC linked to the SLBs.
        :param str vswitch_id: ID of the VSwitch linked to the SLBs.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet", internet)
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "slave_availability_zone", slave_availability_zone)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Service address of the SLBs.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        SLB creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the SLB.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def internet(self) -> bool:
        """
        SLB addressType: internet if `true`, intranet if `false`. Must be `false` when `network_type` is `vpc`.
        """
        return pulumi.get(self, "internet")

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> str:
        """
        Master availability zone of the SLBs.
        """
        return pulumi.get(self, "master_availability_zone")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        SLB name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network type of the SLBs. Valid values: `vpc` and `classic`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the SLB belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="slaveAvailabilityZone")
    def slave_availability_zone(self) -> str:
        """
        Slave availability zone of the SLBs.
        """
        return pulumi.get(self, "slave_availability_zone")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        SLB current status. Possible values: `inactive`, `active` and `locked`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the SLB instances. The `tags` can have a maximum of 5 tag. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_instances = alicloud.slb.get_load_balancers(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC linked to the SLBs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch linked to the SLBs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetMasterSlaveServerGroupsGroupResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 servers: Sequence['outputs.GetMasterSlaveServerGroupsGroupServerResult']):
        """
        :param str id: master slave server group ID.
        :param str name: master slave server group name.
        :param Sequence['GetMasterSlaveServerGroupsGroupServerArgs'] servers: ECS instances associated to the group. Each element contains the following attributes:
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        master slave server group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        master slave server group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetMasterSlaveServerGroupsGroupServerResult']:
        """
        ECS instances associated to the group. Each element contains the following attributes:
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class GetMasterSlaveServerGroupsGroupServerResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 is_backup: int,
                 port: int,
                 server_type: str,
                 weight: int):
        """
        :param str instance_id: ID of the attached ECS instance.
        :param int is_backup: (Removed from v1.63.0) Determine if the server is executing.
        :param int port: The port used by the master slave server group.
        :param str server_type: The server type of the attached ECS instance.
        :param int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_backup", is_backup)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_type", server_type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isBackup")
    def is_backup(self) -> int:
        """
        (Removed from v1.63.0) Determine if the server is executing.
        """
        return pulumi.get(self, "is_backup")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port used by the master slave server group.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverType")
    def server_type(self) -> str:
        """
        The server type of the attached ECS instance.
        """
        return pulumi.get(self, "server_type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetRulesSlbRuleResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 id: str,
                 name: str,
                 server_group_id: str,
                 url: str):
        """
        :param str domain: Domain name in the HTTP request where the rule applies (e.g. "*.aliyun.com").
        :param str id: Rule ID.
        :param str name: Rule name.
        :param str server_group_id: ID of the linked VServer group.
        :param str url: Path in the HTTP request where the rule applies (e.g. "/image").
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "server_group_id", server_group_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Domain name in the HTTP request where the rule applies (e.g. "*.aliyun.com").
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Rule ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverGroupId")
    def server_group_id(self) -> str:
        """
        ID of the linked VServer group.
        """
        return pulumi.get(self, "server_group_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Path in the HTTP request where the rule applies (e.g. "/image").
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetServerCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 alicloud_certificate_id: str,
                 alicloud_certificate_name: str,
                 common_name: str,
                 created_time: str,
                 created_timestamp: int,
                 expired_time: str,
                 expired_timestamp: int,
                 fingerprint: str,
                 id: str,
                 is_alicloud_certificate: bool,
                 name: str,
                 subject_alternative_names: Sequence[str],
                 resource_group_id: Optional[str] = None,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str alicloud_certificate_id: Id of server certificate issued by alibaba cloud.
        :param str alicloud_certificate_name: Name of server certificate issued by alibaba cloud.
        :param str common_name: Server certificate common name.
        :param str created_time: Server certificate created time.
        :param int created_timestamp: Server certificate created timestamp.
        :param str expired_time: Server certificate expired time.
        :param int expired_timestamp: Server certificate expired timestamp.
        :param str fingerprint: Server certificate fingerprint.
        :param str id: Server certificate ID.
        :param bool is_alicloud_certificate: Is server certificate issued by alibaba cloud or not.
        :param str name: Server certificate name.
        :param Sequence[str] subject_alternative_names: Server certificate subject alternative name list.
        :param str resource_group_id: The Id of resource group which the slb server certificates belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "alicloud_certificate_id", alicloud_certificate_id)
        pulumi.set(__self__, "alicloud_certificate_name", alicloud_certificate_name)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "created_timestamp", created_timestamp)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "expired_timestamp", expired_timestamp)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_alicloud_certificate", is_alicloud_certificate)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="alicloudCertificateId")
    def alicloud_certificate_id(self) -> str:
        """
        Id of server certificate issued by alibaba cloud.
        """
        return pulumi.get(self, "alicloud_certificate_id")

    @property
    @pulumi.getter(name="alicloudCertificateName")
    def alicloud_certificate_name(self) -> str:
        """
        Name of server certificate issued by alibaba cloud.
        """
        return pulumi.get(self, "alicloud_certificate_name")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        Server certificate common name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        Server certificate created time.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="createdTimestamp")
    def created_timestamp(self) -> int:
        """
        Server certificate created timestamp.
        """
        return pulumi.get(self, "created_timestamp")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        Server certificate expired time.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="expiredTimestamp")
    def expired_timestamp(self) -> int:
        """
        Server certificate expired timestamp.
        """
        return pulumi.get(self, "expired_timestamp")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        Server certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Server certificate ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAlicloudCertificate")
    def is_alicloud_certificate(self) -> bool:
        """
        Is server certificate issued by alibaba cloud or not.
        """
        return pulumi.get(self, "is_alicloud_certificate")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Server certificate name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Sequence[str]:
        """
        Server certificate subject alternative name list.
        """
        return pulumi.get(self, "subject_alternative_names")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        """
        The Id of resource group which the slb server certificates belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetServerGroupsSlbServerGroupResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str,
                 servers: Sequence['outputs.GetServerGroupsSlbServerGroupServerResult']):
        """
        :param str id: VServer group ID.
        :param str name: VServer group name.
        :param Sequence['GetServerGroupsSlbServerGroupServerArgs'] servers: ECS instances associated to the group. Each element contains the following attributes:
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        VServer group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        VServer group name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetServerGroupsSlbServerGroupServerResult']:
        """
        ECS instances associated to the group. Each element contains the following attributes:
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class GetServerGroupsSlbServerGroupServerResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 weight: int):
        """
        :param str instance_id: ID of the attached ECS instance.
        :param int weight: Weight associated to the ECS instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the attached ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Weight associated to the ECS instance.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetTlsCipherPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 ciphers: Sequence[str],
                 create_time: str,
                 id: str,
                 relate_listeners: Sequence['outputs.GetTlsCipherPoliciesPolicyRelateListenerResult'],
                 status: str,
                 tls_cipher_policy_id: str,
                 tls_cipher_policy_name: str,
                 tls_versions: Sequence[str]):
        """
        :param Sequence[str] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param str create_time: The creation time timestamp.
        :param str id: The ID of the Tls Cipher Policy.
        :param Sequence['GetTlsCipherPoliciesPolicyRelateListenerArgs'] relate_listeners: Array of Relate Listeners.
        :param str status: TLS policy instance state.
        :param str tls_cipher_policy_id: The ID of TLS cipher policy.
        :param str tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param Sequence[str] tls_versions: The version of TLS protocol.
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "relate_listeners", relate_listeners)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tls_cipher_policy_id", tls_cipher_policy_id)
        pulumi.set(__self__, "tls_cipher_policy_name", tls_cipher_policy_name)
        pulumi.set(__self__, "tls_versions", tls_versions)

    @property
    @pulumi.getter
    def ciphers(self) -> Sequence[str]:
        """
        The encryption algorithms supported. It depends on the value of `tls_versions`.
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time timestamp.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Tls Cipher Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="relateListeners")
    def relate_listeners(self) -> Sequence['outputs.GetTlsCipherPoliciesPolicyRelateListenerResult']:
        """
        Array of Relate Listeners.
        """
        return pulumi.get(self, "relate_listeners")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        TLS policy instance state.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tlsCipherPolicyId")
    def tls_cipher_policy_id(self) -> str:
        """
        The ID of TLS cipher policy.
        """
        return pulumi.get(self, "tls_cipher_policy_id")

    @property
    @pulumi.getter(name="tlsCipherPolicyName")
    def tls_cipher_policy_name(self) -> str:
        """
        TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        """
        return pulumi.get(self, "tls_cipher_policy_name")

    @property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Sequence[str]:
        """
        The version of TLS protocol.
        """
        return pulumi.get(self, "tls_versions")


@pulumi.output_type
class GetTlsCipherPoliciesPolicyRelateListenerResult(dict):
    def __init__(__self__, *,
                 load_balancer_id: str,
                 port: int,
                 protocol: str):
        """
        :param str load_balancer_id: The ID of SLB instance.
        :param int port: Listening port. Valid value: 1 to 65535.
        :param str protocol: Snooping protocols. Valid values: `TCP`, `UDP`, `HTTP`, or `HTTPS`.
        """
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        """
        The ID of SLB instance.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Listening port. Valid value: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Snooping protocols. Valid values: `TCP`, `UDP`, `HTTP`, or `HTTPS`.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str,
                 master_zone_id: str,
                 slave_zone_id: str,
                 slb_slave_zone_ids: Sequence[str],
                 supported_resources: Sequence['outputs.GetZonesZoneSupportedResourceResult']):
        """
        :param str id: ID of the zone. It is same as `master_zone_id`.
        :param str master_zone_id: The primary zone.
        :param str slave_zone_id: The secondary zone.
        :param Sequence[str] slb_slave_zone_ids: (Deprecated from 1.157.0) A list of slb slave zone ids in which the slb master zone. 
               It has been deprecated from v1.157.0 and use `slave_zone_id` instead.
        :param Sequence['GetZonesZoneSupportedResourceArgs'] supported_resources: (Available in 1.154.0+)A list of available resource which the slb master zone supported.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "master_zone_id", master_zone_id)
        pulumi.set(__self__, "slave_zone_id", slave_zone_id)
        pulumi.set(__self__, "slb_slave_zone_ids", slb_slave_zone_ids)
        pulumi.set(__self__, "supported_resources", supported_resources)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the zone. It is same as `master_zone_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterZoneId")
    def master_zone_id(self) -> str:
        """
        The primary zone.
        """
        return pulumi.get(self, "master_zone_id")

    @property
    @pulumi.getter(name="slaveZoneId")
    def slave_zone_id(self) -> str:
        """
        The secondary zone.
        """
        return pulumi.get(self, "slave_zone_id")

    @property
    @pulumi.getter(name="slbSlaveZoneIds")
    def slb_slave_zone_ids(self) -> Sequence[str]:
        """
        (Deprecated from 1.157.0) A list of slb slave zone ids in which the slb master zone. 
        It has been deprecated from v1.157.0 and use `slave_zone_id` instead.
        """
        warnings.warn("""the attribute slb_slave_zone_ids has been deprecated from version 1.157.0 and use slave_zone_id instead.""", DeprecationWarning)
        pulumi.log.warn("""slb_slave_zone_ids is deprecated: the attribute slb_slave_zone_ids has been deprecated from version 1.157.0 and use slave_zone_id instead.""")

        return pulumi.get(self, "slb_slave_zone_ids")

    @property
    @pulumi.getter(name="supportedResources")
    def supported_resources(self) -> Sequence['outputs.GetZonesZoneSupportedResourceResult']:
        """
        (Available in 1.154.0+)A list of available resource which the slb master zone supported.
        """
        return pulumi.get(self, "supported_resources")


@pulumi.output_type
class GetZonesZoneSupportedResourceResult(dict):
    def __init__(__self__, *,
                 address_ip_version: str,
                 address_type: str):
        """
        :param str address_ip_version: The type of IP address.
        :param str address_type: The type of network.
        """
        pulumi.set(__self__, "address_ip_version", address_ip_version)
        pulumi.set(__self__, "address_type", address_type)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> str:
        """
        The type of IP address.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> str:
        """
        The type of network.
        """
        return pulumi.get(self, "address_type")


