# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TlsCipherPolicyArgs', 'TlsCipherPolicy']

@pulumi.input_type
class TlsCipherPolicyArgs:
    def __init__(__self__, *,
                 ciphers: pulumi.Input[Sequence[pulumi.Input[str]]],
                 tls_cipher_policy_name: pulumi.Input[str],
                 tls_versions: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a TlsCipherPolicy resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param pulumi.Input[str] tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_versions: The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        pulumi.set(__self__, "ciphers", ciphers)
        pulumi.set(__self__, "tls_cipher_policy_name", tls_cipher_policy_name)
        pulumi.set(__self__, "tls_versions", tls_versions)

    @property
    @pulumi.getter
    def ciphers(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The encryption algorithms supported. It depends on the value of `tls_versions`.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ciphers", value)

    @property
    @pulumi.getter(name="tlsCipherPolicyName")
    def tls_cipher_policy_name(self) -> pulumi.Input[str]:
        """
        TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        """
        return pulumi.get(self, "tls_cipher_policy_name")

    @tls_cipher_policy_name.setter
    def tls_cipher_policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tls_cipher_policy_name", value)

    @property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "tls_versions", value)


@pulumi.input_type
class _TlsCipherPolicyState:
    def __init__(__self__, *,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tls_cipher_policy_name: Optional[pulumi.Input[str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering TlsCipherPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param pulumi.Input[str] status: TLS policy instance state.
        :param pulumi.Input[str] tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_versions: The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tls_cipher_policy_name is not None:
            pulumi.set(__self__, "tls_cipher_policy_name", tls_cipher_policy_name)
        if tls_versions is not None:
            pulumi.set(__self__, "tls_versions", tls_versions)

    @property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The encryption algorithms supported. It depends on the value of `tls_versions`.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ciphers", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        TLS policy instance state.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tlsCipherPolicyName")
    def tls_cipher_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        """
        return pulumi.get(self, "tls_cipher_policy_name")

    @tls_cipher_policy_name.setter
    def tls_cipher_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_cipher_policy_name", value)

    @property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        return pulumi.get(self, "tls_versions")

    @tls_versions.setter
    def tls_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tls_versions", value)


class TlsCipherPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_cipher_policy_name: Optional[pulumi.Input[str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a SLB Tls Cipher Policy resource.

        For information about SLB Tls Cipher Policy and how to use it, see [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).

        > **NOTE:** Available in v1.135.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.slb.TlsCipherPolicy("example",
            ciphers=[
                "AES256-SHA256",
                "AES128-GCM-SHA256",
            ],
            tls_cipher_policy_name="Test-example_value",
            tls_versions=["TLSv1.2"])
        ```

        ## Import

        SLB Tls Cipher Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:slb/tlsCipherPolicy:TlsCipherPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param pulumi.Input[str] tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_versions: The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsCipherPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a SLB Tls Cipher Policy resource.

        For information about SLB Tls Cipher Policy and how to use it, see [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).

        > **NOTE:** Available in v1.135.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example = alicloud.slb.TlsCipherPolicy("example",
            ciphers=[
                "AES256-SHA256",
                "AES128-GCM-SHA256",
            ],
            tls_cipher_policy_name="Test-example_value",
            tls_versions=["TLSv1.2"])
        ```

        ## Import

        SLB Tls Cipher Policy can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:slb/tlsCipherPolicy:TlsCipherPolicy example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TlsCipherPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsCipherPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_cipher_policy_name: Optional[pulumi.Input[str]] = None,
                 tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsCipherPolicyArgs.__new__(TlsCipherPolicyArgs)

            if ciphers is None and not opts.urn:
                raise TypeError("Missing required property 'ciphers'")
            __props__.__dict__["ciphers"] = ciphers
            if tls_cipher_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'tls_cipher_policy_name'")
            __props__.__dict__["tls_cipher_policy_name"] = tls_cipher_policy_name
            if tls_versions is None and not opts.urn:
                raise TypeError("Missing required property 'tls_versions'")
            __props__.__dict__["tls_versions"] = tls_versions
            __props__.__dict__["status"] = None
        super(TlsCipherPolicy, __self__).__init__(
            'alicloud:slb/tlsCipherPolicy:TlsCipherPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tls_cipher_policy_name: Optional[pulumi.Input[str]] = None,
            tls_versions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'TlsCipherPolicy':
        """
        Get an existing TlsCipherPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The encryption algorithms supported. It depends on the value of `tls_versions`.
        :param pulumi.Input[str] status: TLS policy instance state.
        :param pulumi.Input[str] tls_cipher_policy_name: TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tls_versions: The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsCipherPolicyState.__new__(_TlsCipherPolicyState)

        __props__.__dict__["ciphers"] = ciphers
        __props__.__dict__["status"] = status
        __props__.__dict__["tls_cipher_policy_name"] = tls_cipher_policy_name
        __props__.__dict__["tls_versions"] = tls_versions
        return TlsCipherPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def ciphers(self) -> pulumi.Output[Sequence[str]]:
        """
        The encryption algorithms supported. It depends on the value of `tls_versions`.
        """
        return pulumi.get(self, "ciphers")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        TLS policy instance state.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tlsCipherPolicyName")
    def tls_cipher_policy_name(self) -> pulumi.Output[str]:
        """
        TLS policy name. Length is from 2 to 128, or in both the English and Chinese characters must be with an uppercase/lowercase letter or a Chinese character and the beginning, may contain numbers, in dot `.`, underscore `_` or dash `-`.
        """
        return pulumi.get(self, "tls_cipher_policy_name")

    @property
    @pulumi.getter(name="tlsVersions")
    def tls_versions(self) -> pulumi.Output[Sequence[str]]:
        """
        The version of TLS protocol. You can find the corresponding value description in the document center [What is Tls Cipher Policy](https://www.alibabacloud.com/help/doc-detail/196714.htm).
        """
        return pulumi.get(self, "tls_versions")

