# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PolicyAttachmentArgs', 'PolicyAttachment']

@pulumi.input_type
class PolicyAttachmentArgs:
    def __init__(__self__, *,
                 policy_id: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 target_type: pulumi.Input[str]):
        """
        The set of arguments for constructing a PolicyAttachment resource.
        :param pulumi.Input[str] policy_id: The ID of the tag policy.
        :param pulumi.Input[str] target_id: The ID of the object.
        :param pulumi.Input[str] target_type: The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        The ID of the tag policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        The ID of the object.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input[str]:
        """
        The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_type", value)


@pulumi.input_type
class _PolicyAttachmentState:
    def __init__(__self__, *,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PolicyAttachment resources.
        :param pulumi.Input[str] policy_id: The ID of the tag policy.
        :param pulumi.Input[str] target_id: The ID of the object.
        :param pulumi.Input[str] target_type: The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the tag policy.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the object.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_type", value)


class PolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Tag Policy Attachment resource to attaches a policy to an object. After you attach a tag policy to an object.
        For information about Tag Policy Attachment and how to use it,
        see [What is Policy Attachment](https://www.alibabacloud.com/help/en/resource-management/latest/attach-policy).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_account()
        example_policy = alicloud.tag.Policy("examplePolicy",
            policy_name=name,
            policy_desc=name,
            user_type="USER",
            policy_content="		{\\"tags\\":{\\"CostCenter\\":{\\"tag_value\\":{\\"@@assign\\":[\\"Beijing\\",\\"Shanghai\\"]},\\"tag_key\\":{\\"@@assign\\":\\"CostCenter\\"}}}}\\n")
        example_policy_attachment = alicloud.tag.PolicyAttachment("examplePolicyAttachment",
            policy_id=example_policy.id,
            target_id=default.id,
            target_type="USER")
        ```

        ## Import

        Tag Policy Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:tag/policyAttachment:PolicyAttachment example <policy_id>:<target_id>:<target_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_id: The ID of the tag policy.
        :param pulumi.Input[str] target_id: The ID of the object.
        :param pulumi.Input[str] target_type: The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Tag Policy Attachment resource to attaches a policy to an object. After you attach a tag policy to an object.
        For information about Tag Policy Attachment and how to use it,
        see [What is Policy Attachment](https://www.alibabacloud.com/help/en/resource-management/latest/attach-policy).

        > **NOTE:** Available since v1.204.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.get_account()
        example_policy = alicloud.tag.Policy("examplePolicy",
            policy_name=name,
            policy_desc=name,
            user_type="USER",
            policy_content="		{\\"tags\\":{\\"CostCenter\\":{\\"tag_value\\":{\\"@@assign\\":[\\"Beijing\\",\\"Shanghai\\"]},\\"tag_key\\":{\\"@@assign\\":\\"CostCenter\\"}}}}\\n")
        example_policy_attachment = alicloud.tag.PolicyAttachment("examplePolicyAttachment",
            policy_id=example_policy.id,
            target_id=default.id,
            target_type="USER")
        ```

        ## Import

        Tag Policy Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:tag/policyAttachment:PolicyAttachment example <policy_id>:<target_id>:<target_type>
        ```

        :param str resource_name: The name of the resource.
        :param PolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 target_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyAttachmentArgs.__new__(PolicyAttachmentArgs)

            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
        super(PolicyAttachment, __self__).__init__(
            'alicloud:tag/policyAttachment:PolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            target_type: Optional[pulumi.Input[str]] = None) -> 'PolicyAttachment':
        """
        Get an existing PolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] policy_id: The ID of the tag policy.
        :param pulumi.Input[str] target_id: The ID of the object.
        :param pulumi.Input[str] target_type: The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyAttachmentState.__new__(_PolicyAttachmentState)

        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["target_type"] = target_type
        return PolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the tag policy.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The ID of the object.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output[str]:
        """
        The type of the object. Valid values: `USER`, `ROOT`, `FOLDER`, `ACCOUNT`.
        """
        return pulumi.get(self, "target_type")

