# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClientUserDefineRuleArgs', 'ClientUserDefineRule']

@pulumi.input_type
class ClientUserDefineRuleArgs:
    def __init__(__self__, *,
                 action_type: pulumi.Input[int],
                 client_user_define_rule_name: pulumi.Input[str],
                 platform: pulumi.Input[str],
                 type: pulumi.Input[int],
                 cmdline: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 hash: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 new_file_path: Optional[pulumi.Input[str]] = None,
                 parent_cmdline: Optional[pulumi.Input[str]] = None,
                 parent_proc_path: Optional[pulumi.Input[str]] = None,
                 port_str: Optional[pulumi.Input[str]] = None,
                 proc_path: Optional[pulumi.Input[str]] = None,
                 registry_content: Optional[pulumi.Input[str]] = None,
                 registry_key: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ClientUserDefineRule resource.
        :param pulumi.Input[int] action_type: The operation type. Value:
               - **0**: plus White
               - **1**: Plus Black.
        :param pulumi.Input[str] client_user_define_rule_name: The custom rule name.
        :param pulumi.Input[str] platform: The operating system type. Value:
               - **windows**:widows
               - **linux**:linux
               - **all**: all.
        :param pulumi.Input[int] type: The rule type. Value:
               - **1**: Process hash
               - **2**: command line
               - **3**: Process network
               - **4**: File reading and writing
               - **5**: Operate the registry
               - **6**: Load Dynamic Link Library
               - **7**: File Rename.
        :param pulumi.Input[str] cmdline: Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        :param pulumi.Input[str] file_path: The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        :param pulumi.Input[str] hash: Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        :param pulumi.Input[str] ip: IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        :param pulumi.Input[str] new_file_path: The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        :param pulumi.Input[str] parent_cmdline: The parent command line.
        :param pulumi.Input[str] parent_proc_path: Parent process path.
        :param pulumi.Input[str] port_str: The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        :param pulumi.Input[str] proc_path: The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        :param pulumi.Input[str] registry_content: The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[str] registry_key: The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "client_user_define_rule_name", client_user_define_rule_name)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "type", type)
        if cmdline is not None:
            pulumi.set(__self__, "cmdline", cmdline)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if new_file_path is not None:
            pulumi.set(__self__, "new_file_path", new_file_path)
        if parent_cmdline is not None:
            pulumi.set(__self__, "parent_cmdline", parent_cmdline)
        if parent_proc_path is not None:
            pulumi.set(__self__, "parent_proc_path", parent_proc_path)
        if port_str is not None:
            pulumi.set(__self__, "port_str", port_str)
        if proc_path is not None:
            pulumi.set(__self__, "proc_path", proc_path)
        if registry_content is not None:
            pulumi.set(__self__, "registry_content", registry_content)
        if registry_key is not None:
            pulumi.set(__self__, "registry_key", registry_key)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Input[int]:
        """
        The operation type. Value:
        - **0**: plus White
        - **1**: Plus Black.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="clientUserDefineRuleName")
    def client_user_define_rule_name(self) -> pulumi.Input[str]:
        """
        The custom rule name.
        """
        return pulumi.get(self, "client_user_define_rule_name")

    @client_user_define_rule_name.setter
    def client_user_define_rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_user_define_rule_name", value)

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Input[str]:
        """
        The operating system type. Value:
        - **windows**:widows
        - **linux**:linux
        - **all**: all.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: pulumi.Input[str]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[int]:
        """
        The rule type. Value:
        - **1**: Process hash
        - **2**: command line
        - **3**: Process network
        - **4**: File reading and writing
        - **5**: Operate the registry
        - **6**: Load Dynamic Link Library
        - **7**: File Rename.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[int]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def cmdline(self) -> Optional[pulumi.Input[str]]:
        """
        Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        """
        return pulumi.get(self, "cmdline")

    @cmdline.setter
    def cmdline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmdline", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input[str]]:
        """
        Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="newFilePath")
    def new_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        """
        return pulumi.get(self, "new_file_path")

    @new_file_path.setter
    def new_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_file_path", value)

    @property
    @pulumi.getter(name="parentCmdline")
    def parent_cmdline(self) -> Optional[pulumi.Input[str]]:
        """
        The parent command line.
        """
        return pulumi.get(self, "parent_cmdline")

    @parent_cmdline.setter
    def parent_cmdline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_cmdline", value)

    @property
    @pulumi.getter(name="parentProcPath")
    def parent_proc_path(self) -> Optional[pulumi.Input[str]]:
        """
        Parent process path.
        """
        return pulumi.get(self, "parent_proc_path")

    @parent_proc_path.setter
    def parent_proc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_proc_path", value)

    @property
    @pulumi.getter(name="portStr")
    def port_str(self) -> Optional[pulumi.Input[str]]:
        """
        The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        """
        return pulumi.get(self, "port_str")

    @port_str.setter
    def port_str(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_str", value)

    @property
    @pulumi.getter(name="procPath")
    def proc_path(self) -> Optional[pulumi.Input[str]]:
        """
        The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        """
        return pulumi.get(self, "proc_path")

    @proc_path.setter
    def proc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proc_path", value)

    @property
    @pulumi.getter(name="registryContent")
    def registry_content(self) -> Optional[pulumi.Input[str]]:
        """
        The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_content")

    @registry_content.setter
    def registry_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_content", value)

    @property
    @pulumi.getter(name="registryKey")
    def registry_key(self) -> Optional[pulumi.Input[str]]:
        """
        The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_key")

    @registry_key.setter
    def registry_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_key", value)


@pulumi.input_type
class _ClientUserDefineRuleState:
    def __init__(__self__, *,
                 action_type: Optional[pulumi.Input[int]] = None,
                 client_user_define_rule_name: Optional[pulumi.Input[str]] = None,
                 cmdline: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[int]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 hash: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 new_file_path: Optional[pulumi.Input[str]] = None,
                 parent_cmdline: Optional[pulumi.Input[str]] = None,
                 parent_proc_path: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 port_str: Optional[pulumi.Input[str]] = None,
                 proc_path: Optional[pulumi.Input[str]] = None,
                 registry_content: Optional[pulumi.Input[str]] = None,
                 registry_key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ClientUserDefineRule resources.
        :param pulumi.Input[int] action_type: The operation type. Value:
               - **0**: plus White
               - **1**: Plus Black.
        :param pulumi.Input[str] client_user_define_rule_name: The custom rule name.
        :param pulumi.Input[str] cmdline: Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        :param pulumi.Input[int] create_time: The creation time of the resource.
        :param pulumi.Input[str] file_path: The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        :param pulumi.Input[str] hash: Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        :param pulumi.Input[str] ip: IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        :param pulumi.Input[str] new_file_path: The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        :param pulumi.Input[str] parent_cmdline: The parent command line.
        :param pulumi.Input[str] parent_proc_path: Parent process path.
        :param pulumi.Input[str] platform: The operating system type. Value:
               - **windows**:widows
               - **linux**:linux
               - **all**: all.
        :param pulumi.Input[str] port_str: The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        :param pulumi.Input[str] proc_path: The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        :param pulumi.Input[str] registry_content: The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[str] registry_key: The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[int] type: The rule type. Value:
               - **1**: Process hash
               - **2**: command line
               - **3**: Process network
               - **4**: File reading and writing
               - **5**: Operate the registry
               - **6**: Load Dynamic Link Library
               - **7**: File Rename.
        """
        if action_type is not None:
            pulumi.set(__self__, "action_type", action_type)
        if client_user_define_rule_name is not None:
            pulumi.set(__self__, "client_user_define_rule_name", client_user_define_rule_name)
        if cmdline is not None:
            pulumi.set(__self__, "cmdline", cmdline)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if new_file_path is not None:
            pulumi.set(__self__, "new_file_path", new_file_path)
        if parent_cmdline is not None:
            pulumi.set(__self__, "parent_cmdline", parent_cmdline)
        if parent_proc_path is not None:
            pulumi.set(__self__, "parent_proc_path", parent_proc_path)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if port_str is not None:
            pulumi.set(__self__, "port_str", port_str)
        if proc_path is not None:
            pulumi.set(__self__, "proc_path", proc_path)
        if registry_content is not None:
            pulumi.set(__self__, "registry_content", registry_content)
        if registry_key is not None:
            pulumi.set(__self__, "registry_key", registry_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> Optional[pulumi.Input[int]]:
        """
        The operation type. Value:
        - **0**: plus White
        - **1**: Plus Black.
        """
        return pulumi.get(self, "action_type")

    @action_type.setter
    def action_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "action_type", value)

    @property
    @pulumi.getter(name="clientUserDefineRuleName")
    def client_user_define_rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The custom rule name.
        """
        return pulumi.get(self, "client_user_define_rule_name")

    @client_user_define_rule_name.setter
    def client_user_define_rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_user_define_rule_name", value)

    @property
    @pulumi.getter
    def cmdline(self) -> Optional[pulumi.Input[str]]:
        """
        Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        """
        return pulumi.get(self, "cmdline")

    @cmdline.setter
    def cmdline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmdline", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        """
        return pulumi.get(self, "file_path")

    @file_path.setter
    def file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_path", value)

    @property
    @pulumi.getter
    def hash(self) -> Optional[pulumi.Input[str]]:
        """
        Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        """
        return pulumi.get(self, "hash")

    @hash.setter
    def hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hash", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)

    @property
    @pulumi.getter(name="newFilePath")
    def new_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        """
        return pulumi.get(self, "new_file_path")

    @new_file_path.setter
    def new_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_file_path", value)

    @property
    @pulumi.getter(name="parentCmdline")
    def parent_cmdline(self) -> Optional[pulumi.Input[str]]:
        """
        The parent command line.
        """
        return pulumi.get(self, "parent_cmdline")

    @parent_cmdline.setter
    def parent_cmdline(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_cmdline", value)

    @property
    @pulumi.getter(name="parentProcPath")
    def parent_proc_path(self) -> Optional[pulumi.Input[str]]:
        """
        Parent process path.
        """
        return pulumi.get(self, "parent_proc_path")

    @parent_proc_path.setter
    def parent_proc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_proc_path", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system type. Value:
        - **windows**:widows
        - **linux**:linux
        - **all**: all.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="portStr")
    def port_str(self) -> Optional[pulumi.Input[str]]:
        """
        The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        """
        return pulumi.get(self, "port_str")

    @port_str.setter
    def port_str(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_str", value)

    @property
    @pulumi.getter(name="procPath")
    def proc_path(self) -> Optional[pulumi.Input[str]]:
        """
        The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        """
        return pulumi.get(self, "proc_path")

    @proc_path.setter
    def proc_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "proc_path", value)

    @property
    @pulumi.getter(name="registryContent")
    def registry_content(self) -> Optional[pulumi.Input[str]]:
        """
        The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_content")

    @registry_content.setter
    def registry_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_content", value)

    @property
    @pulumi.getter(name="registryKey")
    def registry_key(self) -> Optional[pulumi.Input[str]]:
        """
        The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_key")

    @registry_key.setter
    def registry_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[int]]:
        """
        The rule type. Value:
        - **1**: Process hash
        - **2**: command line
        - **3**: Process network
        - **4**: File reading and writing
        - **5**: Operate the registry
        - **6**: Load Dynamic Link Library
        - **7**: File Rename.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type", value)


class ClientUserDefineRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[int]] = None,
                 client_user_define_rule_name: Optional[pulumi.Input[str]] = None,
                 cmdline: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 hash: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 new_file_path: Optional[pulumi.Input[str]] = None,
                 parent_cmdline: Optional[pulumi.Input[str]] = None,
                 parent_proc_path: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 port_str: Optional[pulumi.Input[str]] = None,
                 proc_path: Optional[pulumi.Input[str]] = None,
                 registry_content: Optional[pulumi.Input[str]] = None,
                 registry_key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Threat Detection Client User Define Rule resource. Malicious Behavior Defense Custom Rules.

        For information about Threat Detection Client User Define Rule and how to use it, see [What is Client User Define Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-addclientuserdefinerule).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.ClientUserDefineRule("default",
            action_type=0,
            platform="windows",
            registry_content="123",
            client_user_define_rule_name=name,
            parent_proc_path="/root/bash",
            type=5,
            cmdline="bash",
            proc_path="/root/bash",
            parent_cmdline="bash",
            registry_key="123")
        ```

        ## Import

        Threat Detection Client User Define Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/clientUserDefineRule:ClientUserDefineRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] action_type: The operation type. Value:
               - **0**: plus White
               - **1**: Plus Black.
        :param pulumi.Input[str] client_user_define_rule_name: The custom rule name.
        :param pulumi.Input[str] cmdline: Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        :param pulumi.Input[str] file_path: The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        :param pulumi.Input[str] hash: Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        :param pulumi.Input[str] ip: IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        :param pulumi.Input[str] new_file_path: The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        :param pulumi.Input[str] parent_cmdline: The parent command line.
        :param pulumi.Input[str] parent_proc_path: Parent process path.
        :param pulumi.Input[str] platform: The operating system type. Value:
               - **windows**:widows
               - **linux**:linux
               - **all**: all.
        :param pulumi.Input[str] port_str: The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        :param pulumi.Input[str] proc_path: The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        :param pulumi.Input[str] registry_content: The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[str] registry_key: The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[int] type: The rule type. Value:
               - **1**: Process hash
               - **2**: command line
               - **3**: Process network
               - **4**: File reading and writing
               - **5**: Operate the registry
               - **6**: Load Dynamic Link Library
               - **7**: File Rename.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientUserDefineRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Client User Define Rule resource. Malicious Behavior Defense Custom Rules.

        For information about Threat Detection Client User Define Rule and how to use it, see [What is Client User Define Rule](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-addclientuserdefinerule).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.ClientUserDefineRule("default",
            action_type=0,
            platform="windows",
            registry_content="123",
            client_user_define_rule_name=name,
            parent_proc_path="/root/bash",
            type=5,
            cmdline="bash",
            proc_path="/root/bash",
            parent_cmdline="bash",
            registry_key="123")
        ```

        ## Import

        Threat Detection Client User Define Rule can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/clientUserDefineRule:ClientUserDefineRule example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClientUserDefineRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientUserDefineRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_type: Optional[pulumi.Input[int]] = None,
                 client_user_define_rule_name: Optional[pulumi.Input[str]] = None,
                 cmdline: Optional[pulumi.Input[str]] = None,
                 file_path: Optional[pulumi.Input[str]] = None,
                 hash: Optional[pulumi.Input[str]] = None,
                 ip: Optional[pulumi.Input[str]] = None,
                 new_file_path: Optional[pulumi.Input[str]] = None,
                 parent_cmdline: Optional[pulumi.Input[str]] = None,
                 parent_proc_path: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 port_str: Optional[pulumi.Input[str]] = None,
                 proc_path: Optional[pulumi.Input[str]] = None,
                 registry_content: Optional[pulumi.Input[str]] = None,
                 registry_key: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientUserDefineRuleArgs.__new__(ClientUserDefineRuleArgs)

            if action_type is None and not opts.urn:
                raise TypeError("Missing required property 'action_type'")
            __props__.__dict__["action_type"] = action_type
            if client_user_define_rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'client_user_define_rule_name'")
            __props__.__dict__["client_user_define_rule_name"] = client_user_define_rule_name
            __props__.__dict__["cmdline"] = cmdline
            __props__.__dict__["file_path"] = file_path
            __props__.__dict__["hash"] = hash
            __props__.__dict__["ip"] = ip
            __props__.__dict__["new_file_path"] = new_file_path
            __props__.__dict__["parent_cmdline"] = parent_cmdline
            __props__.__dict__["parent_proc_path"] = parent_proc_path
            if platform is None and not opts.urn:
                raise TypeError("Missing required property 'platform'")
            __props__.__dict__["platform"] = platform
            __props__.__dict__["port_str"] = port_str
            __props__.__dict__["proc_path"] = proc_path
            __props__.__dict__["registry_content"] = registry_content
            __props__.__dict__["registry_key"] = registry_key
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["create_time"] = None
        super(ClientUserDefineRule, __self__).__init__(
            'alicloud:threatdetection/clientUserDefineRule:ClientUserDefineRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_type: Optional[pulumi.Input[int]] = None,
            client_user_define_rule_name: Optional[pulumi.Input[str]] = None,
            cmdline: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            file_path: Optional[pulumi.Input[str]] = None,
            hash: Optional[pulumi.Input[str]] = None,
            ip: Optional[pulumi.Input[str]] = None,
            new_file_path: Optional[pulumi.Input[str]] = None,
            parent_cmdline: Optional[pulumi.Input[str]] = None,
            parent_proc_path: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None,
            port_str: Optional[pulumi.Input[str]] = None,
            proc_path: Optional[pulumi.Input[str]] = None,
            registry_content: Optional[pulumi.Input[str]] = None,
            registry_key: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[int]] = None) -> 'ClientUserDefineRule':
        """
        Get an existing ClientUserDefineRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] action_type: The operation type. Value:
               - **0**: plus White
               - **1**: Plus Black.
        :param pulumi.Input[str] client_user_define_rule_name: The custom rule name.
        :param pulumi.Input[str] cmdline: Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        :param pulumi.Input[int] create_time: The creation time of the resource.
        :param pulumi.Input[str] file_path: The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        :param pulumi.Input[str] hash: Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        :param pulumi.Input[str] ip: IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        :param pulumi.Input[str] new_file_path: The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        :param pulumi.Input[str] parent_cmdline: The parent command line.
        :param pulumi.Input[str] parent_proc_path: Parent process path.
        :param pulumi.Input[str] platform: The operating system type. Value:
               - **windows**:widows
               - **linux**:linux
               - **all**: all.
        :param pulumi.Input[str] port_str: The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        :param pulumi.Input[str] proc_path: The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        :param pulumi.Input[str] registry_content: The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[str] registry_key: The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        :param pulumi.Input[int] type: The rule type. Value:
               - **1**: Process hash
               - **2**: command line
               - **3**: Process network
               - **4**: File reading and writing
               - **5**: Operate the registry
               - **6**: Load Dynamic Link Library
               - **7**: File Rename.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientUserDefineRuleState.__new__(_ClientUserDefineRuleState)

        __props__.__dict__["action_type"] = action_type
        __props__.__dict__["client_user_define_rule_name"] = client_user_define_rule_name
        __props__.__dict__["cmdline"] = cmdline
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["file_path"] = file_path
        __props__.__dict__["hash"] = hash
        __props__.__dict__["ip"] = ip
        __props__.__dict__["new_file_path"] = new_file_path
        __props__.__dict__["parent_cmdline"] = parent_cmdline
        __props__.__dict__["parent_proc_path"] = parent_proc_path
        __props__.__dict__["platform"] = platform
        __props__.__dict__["port_str"] = port_str
        __props__.__dict__["proc_path"] = proc_path
        __props__.__dict__["registry_content"] = registry_content
        __props__.__dict__["registry_key"] = registry_key
        __props__.__dict__["type"] = type
        return ClientUserDefineRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> pulumi.Output[int]:
        """
        The operation type. Value:
        - **0**: plus White
        - **1**: Plus Black.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="clientUserDefineRuleName")
    def client_user_define_rule_name(self) -> pulumi.Output[str]:
        """
        The custom rule name.
        """
        return pulumi.get(self, "client_user_define_rule_name")

    @property
    @pulumi.getter
    def cmdline(self) -> pulumi.Output[Optional[str]]:
        """
        Command line. When the value of the Type attribute is 2, 3, 4, 5, 6, or 7, the command line field is required.
        """
        return pulumi.get(self, "cmdline")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> pulumi.Output[Optional[str]]:
        """
        The file path. When the value of the Type attribute is 4 or 6, 7, the FilePath field is required.
        """
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def hash(self) -> pulumi.Output[Optional[str]]:
        """
        Process hash list. When the value of the Type attribute is 1, the Hash attribute is required.
        """
        return pulumi.get(self, "hash")

    @property
    @pulumi.getter
    def ip(self) -> pulumi.Output[Optional[str]]:
        """
        IP address. When the value of the Type attribute is 3, the Ip attribute is required.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="newFilePath")
    def new_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        The new file path to rename the file. When the value of the Type attribute is 7, the NewFilePath attribute is required.
        """
        return pulumi.get(self, "new_file_path")

    @property
    @pulumi.getter(name="parentCmdline")
    def parent_cmdline(self) -> pulumi.Output[Optional[str]]:
        """
        The parent command line.
        """
        return pulumi.get(self, "parent_cmdline")

    @property
    @pulumi.getter(name="parentProcPath")
    def parent_proc_path(self) -> pulumi.Output[Optional[str]]:
        """
        Parent process path.
        """
        return pulumi.get(self, "parent_proc_path")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        The operating system type. Value:
        - **windows**:widows
        - **linux**:linux
        - **all**: all.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="portStr")
    def port_str(self) -> pulumi.Output[str]:
        """
        The port number. When the value of the Type attribute is 3, the PortStr attribute is required. Value range: **1-65535**.
        """
        return pulumi.get(self, "port_str")

    @property
    @pulumi.getter(name="procPath")
    def proc_path(self) -> pulumi.Output[Optional[str]]:
        """
        The process path. When the Type attribute is set to 2, 3, 4, 5, 6, or 7, the ProcPath attribute is required.
        """
        return pulumi.get(self, "proc_path")

    @property
    @pulumi.getter(name="registryContent")
    def registry_content(self) -> pulumi.Output[Optional[str]]:
        """
        The registry value. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_content")

    @property
    @pulumi.getter(name="registryKey")
    def registry_key(self) -> pulumi.Output[Optional[str]]:
        """
        The registry key. When the value of the Type attribute is 5, the RegistryKey attribute is required.
        """
        return pulumi.get(self, "registry_key")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[int]:
        """
        The rule type. Value:
        - **1**: Process hash
        - **2**: command line
        - **3**: Process network
        - **4**: File reading and writing
        - **5**: Operate the registry
        - **6**: Load Dynamic Link Library
        - **7**: File Rename.
        """
        return pulumi.get(self, "type")

