# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetBaselineStrategiesResult',
    'AwaitableGetBaselineStrategiesResult',
    'get_baseline_strategies',
    'get_baseline_strategies_output',
]

@pulumi.output_type
class GetBaselineStrategiesResult:
    """
    A collection of values returned by getBaselineStrategies.
    """
    def __init__(__self__, custom_type=None, id=None, ids=None, name_regex=None, names=None, output_file=None, strategies=None, strategy_ids=None):
        if custom_type and not isinstance(custom_type, str):
            raise TypeError("Expected argument 'custom_type' to be a str")
        pulumi.set(__self__, "custom_type", custom_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if strategies and not isinstance(strategies, list):
            raise TypeError("Expected argument 'strategies' to be a list")
        pulumi.set(__self__, "strategies", strategies)
        if strategy_ids and not isinstance(strategy_ids, str):
            raise TypeError("Expected argument 'strategy_ids' to be a str")
        pulumi.set(__self__, "strategy_ids", strategy_ids)

    @property
    @pulumi.getter(name="customType")
    def custom_type(self) -> Optional[str]:
        """
        The type of policy. Value:
        * **common**: standard policy
        * **custom**: custom policy
        """
        return pulumi.get(self, "custom_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of Baseline Strategy IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of name of Baseline Strategys.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def strategies(self) -> Sequence['outputs.GetBaselineStrategiesStrategyResult']:
        return pulumi.get(self, "strategies")

    @property
    @pulumi.getter(name="strategyIds")
    def strategy_ids(self) -> Optional[str]:
        return pulumi.get(self, "strategy_ids")


class AwaitableGetBaselineStrategiesResult(GetBaselineStrategiesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBaselineStrategiesResult(
            custom_type=self.custom_type,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            strategies=self.strategies,
            strategy_ids=self.strategy_ids)


def get_baseline_strategies(custom_type: Optional[str] = None,
                            ids: Optional[Sequence[str]] = None,
                            name_regex: Optional[str] = None,
                            output_file: Optional[str] = None,
                            strategy_ids: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBaselineStrategiesResult:
    """
    This data source provides Threat Detection Baseline Strategy available to the user.[What is Baseline Strategy](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describestrategy)

    > **NOTE:** Available in 1.195.0+


    :param str custom_type: The type of policy. Value:-**common**: standard policy-**custom**: custom policy
    :param Sequence[str] ids: A list of Baseline Strategy IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['customType'] = custom_type
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['strategyIds'] = strategy_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:threatdetection/getBaselineStrategies:getBaselineStrategies', __args__, opts=opts, typ=GetBaselineStrategiesResult).value

    return AwaitableGetBaselineStrategiesResult(
        custom_type=pulumi.get(__ret__, 'custom_type'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        strategies=pulumi.get(__ret__, 'strategies'),
        strategy_ids=pulumi.get(__ret__, 'strategy_ids'))


@_utilities.lift_output_func(get_baseline_strategies)
def get_baseline_strategies_output(custom_type: Optional[pulumi.Input[Optional[str]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   strategy_ids: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBaselineStrategiesResult]:
    """
    This data source provides Threat Detection Baseline Strategy available to the user.[What is Baseline Strategy](https://www.alibabacloud.com/help/en/security-center/developer-reference/api-sas-2018-12-03-describestrategy)

    > **NOTE:** Available in 1.195.0+


    :param str custom_type: The type of policy. Value:-**common**: standard policy-**custom**: custom policy
    :param Sequence[str] ids: A list of Baseline Strategy IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
