# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 payment_type: pulumi.Input[str],
                 version_code: pulumi.Input[str],
                 buy_number: Optional[pulumi.Input[str]] = None,
                 container_image_scan: Optional[pulumi.Input[str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[str]] = None,
                 honeypot: Optional[pulumi.Input[str]] = None,
                 honeypot_switch: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rasp_count: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[str]] = None,
                 sas_cspm: Optional[pulumi.Input[str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[str]] = None,
                 sas_sc: Optional[pulumi.Input[bool]] = None,
                 sas_sdk: Optional[pulumi.Input[str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[str]] = None,
                 threat_analysis: Optional[pulumi.Input[str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 vul_count: Optional[pulumi.Input[str]] = None,
                 vul_switch: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[str] buy_number: Number of servers.
        :param pulumi.Input[str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[int] renew_period: Automatic renewal cycle, in months.
               > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        :param pulumi.Input[str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[str] renewal_status: Automatic renewal status, default ManualRenewal, valid values:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
        :param pulumi.Input[str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               - 1: Yes.
        :param pulumi.Input[str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] v_core: Number of cores.
        :param pulumi.Input[str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "version_code", version_code)
        if buy_number is not None:
            pulumi.set(__self__, "buy_number", buy_number)
        if container_image_scan is not None:
            warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
            pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
        if container_image_scan is not None:
            pulumi.set(__self__, "container_image_scan", container_image_scan)
        if container_image_scan_new is not None:
            pulumi.set(__self__, "container_image_scan_new", container_image_scan_new)
        if honeypot is not None:
            pulumi.set(__self__, "honeypot", honeypot)
        if honeypot_switch is not None:
            pulumi.set(__self__, "honeypot_switch", honeypot_switch)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if rasp_count is not None:
            pulumi.set(__self__, "rasp_count", rasp_count)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if sas_anti_ransomware is not None:
            pulumi.set(__self__, "sas_anti_ransomware", sas_anti_ransomware)
        if sas_cspm is not None:
            pulumi.set(__self__, "sas_cspm", sas_cspm)
        if sas_cspm_switch is not None:
            pulumi.set(__self__, "sas_cspm_switch", sas_cspm_switch)
        if sas_sc is not None:
            pulumi.set(__self__, "sas_sc", sas_sc)
        if sas_sdk is not None:
            pulumi.set(__self__, "sas_sdk", sas_sdk)
        if sas_sdk_switch is not None:
            pulumi.set(__self__, "sas_sdk_switch", sas_sdk_switch)
        if sas_sls_storage is not None:
            pulumi.set(__self__, "sas_sls_storage", sas_sls_storage)
        if sas_webguard_boolean is not None:
            pulumi.set(__self__, "sas_webguard_boolean", sas_webguard_boolean)
        if sas_webguard_order_num is not None:
            pulumi.set(__self__, "sas_webguard_order_num", sas_webguard_order_num)
        if threat_analysis is not None:
            pulumi.set(__self__, "threat_analysis", threat_analysis)
        if threat_analysis_switch is not None:
            pulumi.set(__self__, "threat_analysis_switch", threat_analysis_switch)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if vul_count is not None:
            pulumi.set(__self__, "vul_count", vul_count)
        if vul_switch is not None:
            pulumi.set(__self__, "vul_switch", vul_switch)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> pulumi.Input[str]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: pulumi.Input[str]):
        pulumi.set(self, "version_code", value)

    @property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> Optional[pulumi.Input[str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @buy_number.setter
    def buy_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buy_number", value)

    @property
    @pulumi.getter(name="containerImageScan")
    def container_image_scan(self) -> Optional[pulumi.Input[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
        pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")

        return pulumi.get(self, "container_image_scan")

    @container_image_scan.setter
    def container_image_scan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image_scan", value)

    @property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> Optional[pulumi.Input[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @container_image_scan_new.setter
    def container_image_scan_new(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image_scan_new", value)

    @property
    @pulumi.getter
    def honeypot(self) -> Optional[pulumi.Input[str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].
        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @honeypot.setter
    def honeypot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot", value)

    @property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @honeypot_switch.setter
    def honeypot_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_switch", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> Optional[pulumi.Input[str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @rasp_count.setter
    def rasp_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rasp_count", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Automatic renewal cycle, in months.
        > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.
        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic renewal status, default ManualRenewal, valid values:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> Optional[pulumi.Input[str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @sas_anti_ransomware.setter
    def sas_anti_ransomware(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_anti_ransomware", value)

    @property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @sas_cspm.setter
    def sas_cspm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_cspm", value)

    @property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @sas_cspm_switch.setter
    def sas_cspm_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_cspm_switch", value)

    @property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> Optional[pulumi.Input[bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @sas_sc.setter
    def sas_sc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sas_sc", value)

    @property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> Optional[pulumi.Input[str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @sas_sdk.setter
    def sas_sdk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sdk", value)

    @property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @sas_sdk_switch.setter
    def sas_sdk_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sdk_switch", value)

    @property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> Optional[pulumi.Input[str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @sas_sls_storage.setter
    def sas_sls_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sls_storage", value)

    @property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> Optional[pulumi.Input[str]]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @sas_webguard_boolean.setter
    def sas_webguard_boolean(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_webguard_boolean", value)

    @property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> Optional[pulumi.Input[str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @sas_webguard_order_num.setter
    def sas_webguard_order_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_webguard_order_num", value)

    @property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> Optional[pulumi.Input[str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @threat_analysis.setter
    def threat_analysis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threat_analysis", value)

    @property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @threat_analysis_switch.setter
    def threat_analysis_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threat_analysis_switch", value)

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_core", value)

    @property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> Optional[pulumi.Input[str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].
        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @vul_count.setter
    def vul_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vul_count", value)

    @property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.
        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

    @vul_switch.setter
    def vul_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vul_switch", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 buy_number: Optional[pulumi.Input[str]] = None,
                 container_image_scan: Optional[pulumi.Input[str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 honeypot: Optional[pulumi.Input[str]] = None,
                 honeypot_switch: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rasp_count: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[str]] = None,
                 sas_cspm: Optional[pulumi.Input[str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[str]] = None,
                 sas_sc: Optional[pulumi.Input[bool]] = None,
                 sas_sdk: Optional[pulumi.Input[str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 threat_analysis: Optional[pulumi.Input[str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 version_code: Optional[pulumi.Input[str]] = None,
                 vul_count: Optional[pulumi.Input[str]] = None,
                 vul_switch: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] buy_number: Number of servers.
        :param pulumi.Input[str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[int] renew_period: Automatic renewal cycle, in months.
               > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        :param pulumi.Input[str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[str] renewal_status: Automatic renewal status, default ManualRenewal, valid values:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
        :param pulumi.Input[str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               - 1: Yes.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] v_core: Number of cores.
        :param pulumi.Input[str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        if buy_number is not None:
            pulumi.set(__self__, "buy_number", buy_number)
        if container_image_scan is not None:
            warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
            pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")
        if container_image_scan is not None:
            pulumi.set(__self__, "container_image_scan", container_image_scan)
        if container_image_scan_new is not None:
            pulumi.set(__self__, "container_image_scan_new", container_image_scan_new)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if honeypot is not None:
            pulumi.set(__self__, "honeypot", honeypot)
        if honeypot_switch is not None:
            pulumi.set(__self__, "honeypot_switch", honeypot_switch)
        if modify_type is not None:
            pulumi.set(__self__, "modify_type", modify_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if rasp_count is not None:
            pulumi.set(__self__, "rasp_count", rasp_count)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renewal_period_unit is not None:
            pulumi.set(__self__, "renewal_period_unit", renewal_period_unit)
        if renewal_status is not None:
            pulumi.set(__self__, "renewal_status", renewal_status)
        if sas_anti_ransomware is not None:
            pulumi.set(__self__, "sas_anti_ransomware", sas_anti_ransomware)
        if sas_cspm is not None:
            pulumi.set(__self__, "sas_cspm", sas_cspm)
        if sas_cspm_switch is not None:
            pulumi.set(__self__, "sas_cspm_switch", sas_cspm_switch)
        if sas_sc is not None:
            pulumi.set(__self__, "sas_sc", sas_sc)
        if sas_sdk is not None:
            pulumi.set(__self__, "sas_sdk", sas_sdk)
        if sas_sdk_switch is not None:
            pulumi.set(__self__, "sas_sdk_switch", sas_sdk_switch)
        if sas_sls_storage is not None:
            pulumi.set(__self__, "sas_sls_storage", sas_sls_storage)
        if sas_webguard_boolean is not None:
            pulumi.set(__self__, "sas_webguard_boolean", sas_webguard_boolean)
        if sas_webguard_order_num is not None:
            pulumi.set(__self__, "sas_webguard_order_num", sas_webguard_order_num)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if threat_analysis is not None:
            pulumi.set(__self__, "threat_analysis", threat_analysis)
        if threat_analysis_switch is not None:
            pulumi.set(__self__, "threat_analysis_switch", threat_analysis_switch)
        if v_core is not None:
            pulumi.set(__self__, "v_core", v_core)
        if version_code is not None:
            pulumi.set(__self__, "version_code", version_code)
        if vul_count is not None:
            pulumi.set(__self__, "vul_count", vul_count)
        if vul_switch is not None:
            pulumi.set(__self__, "vul_switch", vul_switch)

    @property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> Optional[pulumi.Input[str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @buy_number.setter
    def buy_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "buy_number", value)

    @property
    @pulumi.getter(name="containerImageScan")
    def container_image_scan(self) -> Optional[pulumi.Input[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
        pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")

        return pulumi.get(self, "container_image_scan")

    @container_image_scan.setter
    def container_image_scan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image_scan", value)

    @property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> Optional[pulumi.Input[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @container_image_scan_new.setter
    def container_image_scan_new(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_image_scan_new", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def honeypot(self) -> Optional[pulumi.Input[str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].
        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @honeypot.setter
    def honeypot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot", value)

    @property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @honeypot_switch.setter
    def honeypot_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "honeypot_switch", value)

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> Optional[pulumi.Input[str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @modify_type.setter
    def modify_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> Optional[pulumi.Input[str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @rasp_count.setter
    def rasp_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rasp_count", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Automatic renewal cycle, in months.
        > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.
        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @renewal_period_unit.setter
    def renewal_period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_period_unit", value)

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> Optional[pulumi.Input[str]]:
        """
        Automatic renewal status, default ManualRenewal, valid values:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.
        """
        return pulumi.get(self, "renewal_status")

    @renewal_status.setter
    def renewal_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_status", value)

    @property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> Optional[pulumi.Input[str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @sas_anti_ransomware.setter
    def sas_anti_ransomware(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_anti_ransomware", value)

    @property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @sas_cspm.setter
    def sas_cspm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_cspm", value)

    @property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @sas_cspm_switch.setter
    def sas_cspm_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_cspm_switch", value)

    @property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> Optional[pulumi.Input[bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @sas_sc.setter
    def sas_sc(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sas_sc", value)

    @property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> Optional[pulumi.Input[str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @sas_sdk.setter
    def sas_sdk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sdk", value)

    @property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @sas_sdk_switch.setter
    def sas_sdk_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sdk_switch", value)

    @property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> Optional[pulumi.Input[str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @sas_sls_storage.setter
    def sas_sls_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_sls_storage", value)

    @property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> Optional[pulumi.Input[str]]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @sas_webguard_boolean.setter
    def sas_webguard_boolean(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_webguard_boolean", value)

    @property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> Optional[pulumi.Input[str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @sas_webguard_order_num.setter
    def sas_webguard_order_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_webguard_order_num", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> Optional[pulumi.Input[str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @threat_analysis.setter
    def threat_analysis(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threat_analysis", value)

    @property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @threat_analysis_switch.setter
    def threat_analysis_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threat_analysis_switch", value)

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> Optional[pulumi.Input[str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @v_core.setter
    def v_core(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "v_core", value)

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> Optional[pulumi.Input[str]]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @version_code.setter
    def version_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_code", value)

    @property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> Optional[pulumi.Input[str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].
        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @vul_count.setter
    def vul_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vul_count", value)

    @property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> Optional[pulumi.Input[str]]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.
        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

    @vul_switch.setter
    def vul_switch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vul_switch", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buy_number: Optional[pulumi.Input[str]] = None,
                 container_image_scan: Optional[pulumi.Input[str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[str]] = None,
                 honeypot: Optional[pulumi.Input[str]] = None,
                 honeypot_switch: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rasp_count: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[str]] = None,
                 sas_cspm: Optional[pulumi.Input[str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[str]] = None,
                 sas_sc: Optional[pulumi.Input[bool]] = None,
                 sas_sdk: Optional[pulumi.Input[str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[str]] = None,
                 threat_analysis: Optional[pulumi.Input[str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 version_code: Optional[pulumi.Input[str]] = None,
                 vul_count: Optional[pulumi.Input[str]] = None,
                 vul_switch: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Threat Detection Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] buy_number: Number of servers.
        :param pulumi.Input[str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[int] renew_period: Automatic renewal cycle, in months.
               > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        :param pulumi.Input[str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[str] renewal_status: Automatic renewal status, default ManualRenewal, valid values:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
        :param pulumi.Input[str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               - 1: Yes.
        :param pulumi.Input[str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] v_core: Number of cores.
        :param pulumi.Input[str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Threat Detection Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 buy_number: Optional[pulumi.Input[str]] = None,
                 container_image_scan: Optional[pulumi.Input[str]] = None,
                 container_image_scan_new: Optional[pulumi.Input[str]] = None,
                 honeypot: Optional[pulumi.Input[str]] = None,
                 honeypot_switch: Optional[pulumi.Input[str]] = None,
                 modify_type: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 rasp_count: Optional[pulumi.Input[str]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renewal_period_unit: Optional[pulumi.Input[str]] = None,
                 renewal_status: Optional[pulumi.Input[str]] = None,
                 sas_anti_ransomware: Optional[pulumi.Input[str]] = None,
                 sas_cspm: Optional[pulumi.Input[str]] = None,
                 sas_cspm_switch: Optional[pulumi.Input[str]] = None,
                 sas_sc: Optional[pulumi.Input[bool]] = None,
                 sas_sdk: Optional[pulumi.Input[str]] = None,
                 sas_sdk_switch: Optional[pulumi.Input[str]] = None,
                 sas_sls_storage: Optional[pulumi.Input[str]] = None,
                 sas_webguard_boolean: Optional[pulumi.Input[str]] = None,
                 sas_webguard_order_num: Optional[pulumi.Input[str]] = None,
                 threat_analysis: Optional[pulumi.Input[str]] = None,
                 threat_analysis_switch: Optional[pulumi.Input[str]] = None,
                 v_core: Optional[pulumi.Input[str]] = None,
                 version_code: Optional[pulumi.Input[str]] = None,
                 vul_count: Optional[pulumi.Input[str]] = None,
                 vul_switch: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["buy_number"] = buy_number
            __props__.__dict__["container_image_scan"] = container_image_scan
            __props__.__dict__["container_image_scan_new"] = container_image_scan_new
            __props__.__dict__["honeypot"] = honeypot
            __props__.__dict__["honeypot_switch"] = honeypot_switch
            __props__.__dict__["modify_type"] = modify_type
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["rasp_count"] = rasp_count
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renewal_period_unit"] = renewal_period_unit
            __props__.__dict__["renewal_status"] = renewal_status
            __props__.__dict__["sas_anti_ransomware"] = sas_anti_ransomware
            __props__.__dict__["sas_cspm"] = sas_cspm
            __props__.__dict__["sas_cspm_switch"] = sas_cspm_switch
            __props__.__dict__["sas_sc"] = sas_sc
            __props__.__dict__["sas_sdk"] = sas_sdk
            __props__.__dict__["sas_sdk_switch"] = sas_sdk_switch
            __props__.__dict__["sas_sls_storage"] = sas_sls_storage
            __props__.__dict__["sas_webguard_boolean"] = sas_webguard_boolean
            __props__.__dict__["sas_webguard_order_num"] = sas_webguard_order_num
            __props__.__dict__["threat_analysis"] = threat_analysis
            __props__.__dict__["threat_analysis_switch"] = threat_analysis_switch
            __props__.__dict__["v_core"] = v_core
            if version_code is None and not opts.urn:
                raise TypeError("Missing required property 'version_code'")
            __props__.__dict__["version_code"] = version_code
            __props__.__dict__["vul_count"] = vul_count
            __props__.__dict__["vul_switch"] = vul_switch
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:threatdetection/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            buy_number: Optional[pulumi.Input[str]] = None,
            container_image_scan: Optional[pulumi.Input[str]] = None,
            container_image_scan_new: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            honeypot: Optional[pulumi.Input[str]] = None,
            honeypot_switch: Optional[pulumi.Input[str]] = None,
            modify_type: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            rasp_count: Optional[pulumi.Input[str]] = None,
            renew_period: Optional[pulumi.Input[int]] = None,
            renewal_period_unit: Optional[pulumi.Input[str]] = None,
            renewal_status: Optional[pulumi.Input[str]] = None,
            sas_anti_ransomware: Optional[pulumi.Input[str]] = None,
            sas_cspm: Optional[pulumi.Input[str]] = None,
            sas_cspm_switch: Optional[pulumi.Input[str]] = None,
            sas_sc: Optional[pulumi.Input[bool]] = None,
            sas_sdk: Optional[pulumi.Input[str]] = None,
            sas_sdk_switch: Optional[pulumi.Input[str]] = None,
            sas_sls_storage: Optional[pulumi.Input[str]] = None,
            sas_webguard_boolean: Optional[pulumi.Input[str]] = None,
            sas_webguard_order_num: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            threat_analysis: Optional[pulumi.Input[str]] = None,
            threat_analysis_switch: Optional[pulumi.Input[str]] = None,
            v_core: Optional[pulumi.Input[str]] = None,
            version_code: Optional[pulumi.Input[str]] = None,
            vul_count: Optional[pulumi.Input[str]] = None,
            vul_switch: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] buy_number: Number of servers.
        :param pulumi.Input[str] container_image_scan: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] container_image_scan_new: Container Image security scan. Interval type, value interval:[0,200000].
               > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] honeypot: Number of cloud honeypot licenses. Interval type, value interval:[20,500].
               > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        :param pulumi.Input[str] honeypot_switch: Cloud honeypot. Value:
               - 1: Yes.
               - 2: No.
        :param pulumi.Input[str] modify_type: Change configuration type, value
               - Upgrade: Upgrade.
               - Downgrade: Downgrade.
        :param pulumi.Input[str] payment_type: The payment type of the resource.
        :param pulumi.Input[int] period: Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
               > **NOTE:**  must be set when creating a prepaid instance.
        :param pulumi.Input[str] rasp_count: Number of application protection licenses. Interval type, value interval:[1,100000000].
        :param pulumi.Input[int] renew_period: Automatic renewal cycle, in months.
               > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        :param pulumi.Input[str] renewal_period_unit: Automatic renewal period unit, value:
               - M: month.
               - Y: years.
               > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        :param pulumi.Input[str] renewal_status: Automatic renewal status, default ManualRenewal, valid values:
               - AutoRenewal: automatic renewal.
               - ManualRenewal: manual renewal.
        :param pulumi.Input[str] sas_anti_ransomware: Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm: Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
               > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_cspm_switch: Cloud platform configuration check switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[bool] sas_sc: Security screen. Value:
               - true: Yes.
               - false: No.
        :param pulumi.Input[str] sas_sdk: Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
               > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_sdk_switch: Malicious file detection SDK.
        :param pulumi.Input[str] sas_sls_storage: Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
               > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] sas_webguard_boolean: Web tamper-proof switch. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] sas_webguard_order_num: Tamper-proof authorization number. Value:
               - 0: No
               - 1: Yes.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] threat_analysis: Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
               > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        :param pulumi.Input[str] threat_analysis_switch: Threat analysis. Value:
               - 0: No.
               - 1: Yes.
        :param pulumi.Input[str] v_core: Number of cores.
        :param pulumi.Input[str] version_code: Select the security center version. Value:
               - level7: Antivirus Edition.
               - level3: Premium version.
               - level2: Enterprise Edition.
               - level8: Ultimate.
               - level10: Purchase value-added services only.
        :param pulumi.Input[str] vul_count: Vulnerability repair times, interval type, value range:[20,100000000].
               > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        :param pulumi.Input[str] vul_switch: Vulnerability fix switch. Value:
               - 0: No.
               - 1: Yes.
               > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["buy_number"] = buy_number
        __props__.__dict__["container_image_scan"] = container_image_scan
        __props__.__dict__["container_image_scan_new"] = container_image_scan_new
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["honeypot"] = honeypot
        __props__.__dict__["honeypot_switch"] = honeypot_switch
        __props__.__dict__["modify_type"] = modify_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["rasp_count"] = rasp_count
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renewal_period_unit"] = renewal_period_unit
        __props__.__dict__["renewal_status"] = renewal_status
        __props__.__dict__["sas_anti_ransomware"] = sas_anti_ransomware
        __props__.__dict__["sas_cspm"] = sas_cspm
        __props__.__dict__["sas_cspm_switch"] = sas_cspm_switch
        __props__.__dict__["sas_sc"] = sas_sc
        __props__.__dict__["sas_sdk"] = sas_sdk
        __props__.__dict__["sas_sdk_switch"] = sas_sdk_switch
        __props__.__dict__["sas_sls_storage"] = sas_sls_storage
        __props__.__dict__["sas_webguard_boolean"] = sas_webguard_boolean
        __props__.__dict__["sas_webguard_order_num"] = sas_webguard_order_num
        __props__.__dict__["status"] = status
        __props__.__dict__["threat_analysis"] = threat_analysis
        __props__.__dict__["threat_analysis_switch"] = threat_analysis_switch
        __props__.__dict__["v_core"] = v_core
        __props__.__dict__["version_code"] = version_code
        __props__.__dict__["vul_count"] = vul_count
        __props__.__dict__["vul_switch"] = vul_switch
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buyNumber")
    def buy_number(self) -> pulumi.Output[Optional[str]]:
        """
        Number of servers.
        """
        return pulumi.get(self, "buy_number")

    @property
    @pulumi.getter(name="containerImageScan")
    def container_image_scan(self) -> pulumi.Output[Optional[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        warnings.warn("""Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""", DeprecationWarning)
        pulumi.log.warn("""container_image_scan is deprecated: Field 'container_image_scan' has been deprecated from provider version 1.212.0. Container Image security scan. Interval type, value interval:[0,200000].> The step size is 20, that is, only multiples of 20 can be filled in.""")

        return pulumi.get(self, "container_image_scan")

    @property
    @pulumi.getter(name="containerImageScanNew")
    def container_image_scan_new(self) -> pulumi.Output[Optional[str]]:
        """
        Container Image security scan. Interval type, value interval:[0,200000].
        > **NOTE:**  The step size is 20, that is, only multiples of 20 can be filled in.
        """
        return pulumi.get(self, "container_image_scan_new")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def honeypot(self) -> pulumi.Output[Optional[str]]:
        """
        Number of cloud honeypot licenses. Interval type, value interval:[20,500].
        > **NOTE:**  This module can only be purchased when honeypot_switch = 1, starting with 20.
        """
        return pulumi.get(self, "honeypot")

    @property
    @pulumi.getter(name="honeypotSwitch")
    def honeypot_switch(self) -> pulumi.Output[str]:
        """
        Cloud honeypot. Value:
        - 1: Yes.
        - 2: No.
        """
        return pulumi.get(self, "honeypot_switch")

    @property
    @pulumi.getter(name="modifyType")
    def modify_type(self) -> pulumi.Output[Optional[str]]:
        """
        Change configuration type, value
        - Upgrade: Upgrade.
        - Downgrade: Downgrade.
        """
        return pulumi.get(self, "modify_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Prepaid cycle. The unit is Monthly, please enter an integer multiple of 12 for annual paid products.
        > **NOTE:**  must be set when creating a prepaid instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="raspCount")
    def rasp_count(self) -> pulumi.Output[Optional[str]]:
        """
        Number of application protection licenses. Interval type, value interval:[1,100000000].
        """
        return pulumi.get(self, "rasp_count")

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[int]:
        """
        Automatic renewal cycle, in months.
        > **NOTE:**  When **RenewalStatus** is set to **AutoRenewal**, it must be set.
        """
        return pulumi.get(self, "renew_period")

    @property
    @pulumi.getter(name="renewalPeriodUnit")
    def renewal_period_unit(self) -> pulumi.Output[str]:
        """
        Automatic renewal period unit, value:
        - M: month.
        - Y: years.
        > **NOTE:**  Must be set when RenewalStatus = AutoRenewal.
        """
        return pulumi.get(self, "renewal_period_unit")

    @property
    @pulumi.getter(name="renewalStatus")
    def renewal_status(self) -> pulumi.Output[Optional[str]]:
        """
        Automatic renewal status, default ManualRenewal, valid values:
        - AutoRenewal: automatic renewal.
        - ManualRenewal: manual renewal.
        """
        return pulumi.get(self, "renewal_status")

    @property
    @pulumi.getter(name="sasAntiRansomware")
    def sas_anti_ransomware(self) -> pulumi.Output[Optional[str]]:
        """
        Anti-ransomware capacity. Unit: GB. Interval type, value interval:[0,9999999999].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_anti_ransomware")

    @property
    @pulumi.getter(name="sasCspm")
    def sas_cspm(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud platform configuration check scan times, interval type, value range:[1000,9999999999].
        > **NOTE:**  You must have sas_cspm_switch = 1 to purchase this module. The step size is 100, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_cspm")

    @property
    @pulumi.getter(name="sasCspmSwitch")
    def sas_cspm_switch(self) -> pulumi.Output[str]:
        """
        Cloud platform configuration check switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_cspm_switch")

    @property
    @pulumi.getter(name="sasSc")
    def sas_sc(self) -> pulumi.Output[Optional[bool]]:
        """
        Security screen. Value:
        - true: Yes.
        - false: No.
        """
        return pulumi.get(self, "sas_sc")

    @property
    @pulumi.getter(name="sasSdk")
    def sas_sdk(self) -> pulumi.Output[Optional[str]]:
        """
        Number of malicious file detections. Unit: 10,000 times. Interval type, value interval:[10,9999999999].
        > **NOTE:**  This module can only be purchased when sas_sdk_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sdk")

    @property
    @pulumi.getter(name="sasSdkSwitch")
    def sas_sdk_switch(self) -> pulumi.Output[str]:
        """
        Malicious file detection SDK.
        """
        return pulumi.get(self, "sas_sdk_switch")

    @property
    @pulumi.getter(name="sasSlsStorage")
    def sas_sls_storage(self) -> pulumi.Output[Optional[str]]:
        """
        Log analysis storage capacity. Unit: GB. Interval type, value interval:[0,600000].
        > **NOTE:**  The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "sas_sls_storage")

    @property
    @pulumi.getter(name="sasWebguardBoolean")
    def sas_webguard_boolean(self) -> pulumi.Output[str]:
        """
        Web tamper-proof switch. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_boolean")

    @property
    @pulumi.getter(name="sasWebguardOrderNum")
    def sas_webguard_order_num(self) -> pulumi.Output[Optional[str]]:
        """
        Tamper-proof authorization number. Value:
        - 0: No
        - 1: Yes.
        """
        return pulumi.get(self, "sas_webguard_order_num")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="threatAnalysis")
    def threat_analysis(self) -> pulumi.Output[Optional[str]]:
        """
        Threat Analysis log storage capacity. Interval type, value interval:[0,9999999999].
        > **NOTE:**  This module can only be purchased when Threat_analysis_switch = 1. The step size is 10, that is, only multiples of 10 can be filled in.
        """
        return pulumi.get(self, "threat_analysis")

    @property
    @pulumi.getter(name="threatAnalysisSwitch")
    def threat_analysis_switch(self) -> pulumi.Output[str]:
        """
        Threat analysis. Value:
        - 0: No.
        - 1: Yes.
        """
        return pulumi.get(self, "threat_analysis_switch")

    @property
    @pulumi.getter(name="vCore")
    def v_core(self) -> pulumi.Output[Optional[str]]:
        """
        Number of cores.
        """
        return pulumi.get(self, "v_core")

    @property
    @pulumi.getter(name="versionCode")
    def version_code(self) -> pulumi.Output[str]:
        """
        Select the security center version. Value:
        - level7: Antivirus Edition.
        - level3: Premium version.
        - level2: Enterprise Edition.
        - level8: Ultimate.
        - level10: Purchase value-added services only.
        """
        return pulumi.get(self, "version_code")

    @property
    @pulumi.getter(name="vulCount")
    def vul_count(self) -> pulumi.Output[Optional[str]]:
        """
        Vulnerability repair times, interval type, value range:[20,100000000].
        > **NOTE:**  This module can only be purchased when vul_switch = 1. Only when the version_code value is level7 or level10. other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_count")

    @property
    @pulumi.getter(name="vulSwitch")
    def vul_switch(self) -> pulumi.Output[str]:
        """
        Vulnerability fix switch. Value:
        - 0: No.
        - 1: Yes.
        > **NOTE:**  When the value of version_code is level7 or level10, the purchase is allowed. Other versions do not need to be purchased separately.
        """
        return pulumi.get(self, "vul_switch")

