# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'HoneypotPresetMeta',
    'HoneypotProbeHoneypotBindList',
    'HoneypotProbeHoneypotBindListBindPortList',
    'SasTrailServiceTrail',
    'GetAntiBruteForceRulesRuleResult',
    'GetAssetsAssetResult',
    'GetBackupPoliciesPolicyResult',
    'GetBaselineStrategiesStrategyResult',
    'GetHoneyPotsPotResult',
    'GetHoneypotImagesImageResult',
    'GetHoneypotNodesNodeResult',
    'GetHoneypotPresetsPresetResult',
    'GetHoneypotPresetsPresetMetaResult',
    'GetHoneypotProbesProbeResult',
    'GetHoneypotProbesProbeHoneypotBindListResult',
    'GetHoneypotProbesProbeHoneypotBindListBindPortListResult',
    'GetInstancesInstanceResult',
    'GetVulWhitelistsWhitelistResult',
    'GetWebLockConfigsConfigResult',
]

@pulumi.output_type
class HoneypotPresetMeta(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portraitOption":
            suggest = "portrait_option"
        elif key == "trojanGit":
            suggest = "trojan_git"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotPresetMeta. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotPresetMeta.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotPresetMeta.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 burp: str,
                 portrait_option: Optional[bool] = None,
                 trojan_git: Optional[str] = None):
        """
        :param str burp: Burp counter.
        :param bool portrait_option: Social traceability.
        :param str trojan_git: Git countered.
        """
        pulumi.set(__self__, "burp", burp)
        if portrait_option is not None:
            pulumi.set(__self__, "portrait_option", portrait_option)
        if trojan_git is not None:
            pulumi.set(__self__, "trojan_git", trojan_git)

    @property
    @pulumi.getter
    def burp(self) -> str:
        """
        Burp counter.
        """
        return pulumi.get(self, "burp")

    @property
    @pulumi.getter(name="portraitOption")
    def portrait_option(self) -> Optional[bool]:
        """
        Social traceability.
        """
        return pulumi.get(self, "portrait_option")

    @property
    @pulumi.getter(name="trojanGit")
    def trojan_git(self) -> Optional[str]:
        """
        Git countered.
        """
        return pulumi.get(self, "trojan_git")


@pulumi.output_type
class HoneypotProbeHoneypotBindList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindPortLists":
            suggest = "bind_port_lists"
        elif key == "honeypotId":
            suggest = "honeypot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotProbeHoneypotBindList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotProbeHoneypotBindList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotProbeHoneypotBindList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bind_port_lists: Optional[Sequence['outputs.HoneypotProbeHoneypotBindListBindPortList']] = None,
                 honeypot_id: Optional[str] = None):
        """
        :param Sequence['HoneypotProbeHoneypotBindListBindPortListArgs'] bind_port_lists: List of listening ports.See the following `Block BindPortList`.
        :param str honeypot_id: Honeypot ID.
        """
        if bind_port_lists is not None:
            pulumi.set(__self__, "bind_port_lists", bind_port_lists)
        if honeypot_id is not None:
            pulumi.set(__self__, "honeypot_id", honeypot_id)

    @property
    @pulumi.getter(name="bindPortLists")
    def bind_port_lists(self) -> Optional[Sequence['outputs.HoneypotProbeHoneypotBindListBindPortList']]:
        """
        List of listening ports.See the following `Block BindPortList`.
        """
        return pulumi.get(self, "bind_port_lists")

    @property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> Optional[str]:
        """
        Honeypot ID.
        """
        return pulumi.get(self, "honeypot_id")


@pulumi.output_type
class HoneypotProbeHoneypotBindListBindPortList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bindPort":
            suggest = "bind_port"
        elif key == "endPort":
            suggest = "end_port"
        elif key == "startPort":
            suggest = "start_port"
        elif key == "targetPort":
            suggest = "target_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HoneypotProbeHoneypotBindListBindPortList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HoneypotProbeHoneypotBindListBindPortList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HoneypotProbeHoneypotBindListBindPortList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bind_port: Optional[bool] = None,
                 end_port: Optional[int] = None,
                 fixed: Optional[bool] = None,
                 start_port: Optional[int] = None,
                 target_port: Optional[int] = None):
        """
        :param bool bind_port: Whether to bind the port.
        :param int end_port: End port.
        :param bool fixed: Whether the port is fixed.
        :param int start_port: Start port.
        :param int target_port: Destination port.
        """
        if bind_port is not None:
            pulumi.set(__self__, "bind_port", bind_port)
        if end_port is not None:
            pulumi.set(__self__, "end_port", end_port)
        if fixed is not None:
            pulumi.set(__self__, "fixed", fixed)
        if start_port is not None:
            pulumi.set(__self__, "start_port", start_port)
        if target_port is not None:
            pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="bindPort")
    def bind_port(self) -> Optional[bool]:
        """
        Whether to bind the port.
        """
        return pulumi.get(self, "bind_port")

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> Optional[int]:
        """
        End port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter
    def fixed(self) -> Optional[bool]:
        """
        Whether the port is fixed.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> Optional[int]:
        """
        Start port.
        """
        return pulumi.get(self, "start_port")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> Optional[int]:
        """
        Destination port.
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class SasTrailServiceTrail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SasTrailServiceTrail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SasTrailServiceTrail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SasTrailServiceTrail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional[str] = None,
                 update_time: Optional[int] = None):
        """
        :param str config: Service tracking on status. The value is:
               - **on:** Open
               - **off:** off.
        :param int update_time: The timestamp of the last service update. Unit: milliseconds.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def config(self) -> Optional[str]:
        """
        Service tracking on status. The value is:
        - **on:** Open
        - **off:** off.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[int]:
        """
        The timestamp of the last service update. Unit: milliseconds.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetAntiBruteForceRulesRuleResult(dict):
    def __init__(__self__, *,
                 anti_brute_force_rule_id: str,
                 anti_brute_force_rule_name: str,
                 default_rule: bool,
                 fail_count: int,
                 forbidden_time: int,
                 id: str,
                 span: int,
                 uuid_lists: Sequence[str]):
        """
        :param str anti_brute_force_rule_id: The ID of the defense rule.
        :param str anti_brute_force_rule_name: The name of the defense rule.
        :param bool default_rule: Specifies whether to set the defense rule as the default rule.
        :param int fail_count: The threshold for the number of failed user logins when the brute-force defense rule takes effect.
        :param int forbidden_time: The period of time during which logons from an account are not allowed. Unit: minutes.
        :param str id: The ID of the defense rule.
        :param int span: The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
        :param Sequence[str] uuid_lists: An array consisting of the UUIDs of servers to which the defense rule is applied.
        """
        pulumi.set(__self__, "anti_brute_force_rule_id", anti_brute_force_rule_id)
        pulumi.set(__self__, "anti_brute_force_rule_name", anti_brute_force_rule_name)
        pulumi.set(__self__, "default_rule", default_rule)
        pulumi.set(__self__, "fail_count", fail_count)
        pulumi.set(__self__, "forbidden_time", forbidden_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "span", span)
        pulumi.set(__self__, "uuid_lists", uuid_lists)

    @property
    @pulumi.getter(name="antiBruteForceRuleId")
    def anti_brute_force_rule_id(self) -> str:
        """
        The ID of the defense rule.
        """
        return pulumi.get(self, "anti_brute_force_rule_id")

    @property
    @pulumi.getter(name="antiBruteForceRuleName")
    def anti_brute_force_rule_name(self) -> str:
        """
        The name of the defense rule.
        """
        return pulumi.get(self, "anti_brute_force_rule_name")

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> bool:
        """
        Specifies whether to set the defense rule as the default rule.
        """
        return pulumi.get(self, "default_rule")

    @property
    @pulumi.getter(name="failCount")
    def fail_count(self) -> int:
        """
        The threshold for the number of failed user logins when the brute-force defense rule takes effect.
        """
        return pulumi.get(self, "fail_count")

    @property
    @pulumi.getter(name="forbiddenTime")
    def forbidden_time(self) -> int:
        """
        The period of time during which logons from an account are not allowed. Unit: minutes.
        """
        return pulumi.get(self, "forbidden_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the defense rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def span(self) -> int:
        """
        The period of time during which logon failures from an account are measured. Unit: minutes. If Span is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
        """
        return pulumi.get(self, "span")

    @property
    @pulumi.getter(name="uuidLists")
    def uuid_lists(self) -> Sequence[str]:
        """
        An array consisting of the UUIDs of servers to which the defense rule is applied.
        """
        return pulumi.get(self, "uuid_lists")


@pulumi.output_type
class GetAssetsAssetResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 uuid: str):
        """
        :param str create_time: The creation time of the resource
        :param str id: The ID of the instance.
        :param str uuid: The UUID of the instance.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The UUID of the instance.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetBackupPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 backup_policy_id: int,
                 backup_policy_name: str,
                 id: int,
                 policy: str,
                 policy_region_id: str,
                 policy_version: str,
                 status: str,
                 uuid_lists: Sequence[str]):
        """
        :param int backup_policy_id: The ID of the anti-ransomware policy.
        :param str backup_policy_name: The name of the anti-ransomware policy.
        :param int id: The ID of the anti-ransomware policy.
        :param str policy: The configurations of the anti-ransomware policy.
        :param str policy_region_id: The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        :param str policy_version: The version of the anti-ransomware policy.
        :param str status: The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
        :param Sequence[str] uuid_lists: The UUIDs of the servers to which the anti-ransomware policy is applied.
        """
        pulumi.set(__self__, "backup_policy_id", backup_policy_id)
        pulumi.set(__self__, "backup_policy_name", backup_policy_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "policy_region_id", policy_region_id)
        pulumi.set(__self__, "policy_version", policy_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid_lists", uuid_lists)

    @property
    @pulumi.getter(name="backupPolicyId")
    def backup_policy_id(self) -> int:
        """
        The ID of the anti-ransomware policy.
        """
        return pulumi.get(self, "backup_policy_id")

    @property
    @pulumi.getter(name="backupPolicyName")
    def backup_policy_name(self) -> str:
        """
        The name of the anti-ransomware policy.
        """
        return pulumi.get(self, "backup_policy_name")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the anti-ransomware policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The configurations of the anti-ransomware policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyRegionId")
    def policy_region_id(self) -> str:
        """
        The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        """
        return pulumi.get(self, "policy_region_id")

    @property
    @pulumi.getter(name="policyVersion")
    def policy_version(self) -> str:
        """
        The version of the anti-ransomware policy.
        """
        return pulumi.get(self, "policy_version")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the anti-ransomware policy. Valid Value: `enabled`, `disabled`, `closed`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="uuidLists")
    def uuid_lists(self) -> Sequence[str]:
        """
        The UUIDs of the servers to which the anti-ransomware policy is applied.
        """
        return pulumi.get(self, "uuid_lists")


@pulumi.output_type
class GetBaselineStrategiesStrategyResult(dict):
    def __init__(__self__, *,
                 baseline_strategy_id: str,
                 baseline_strategy_name: str,
                 custom_type: str,
                 cycle_days: int,
                 cycle_start_time: int,
                 end_time: str,
                 id: str,
                 risk_sub_type_name: str,
                 start_time: str,
                 target_type: str):
        """
        :param str baseline_strategy_id: The ID of the baseline check policy.
        :param str baseline_strategy_name: Policy name.
        :param str custom_type: The type of policy. Value:-**common**: standard policy-**custom**: custom policy
        :param int cycle_days: The detection period of the policy.
        :param int cycle_start_time: The detection period of the policy. Value:
               * **0**: 0:00~06:00
               * **6**: 6:00~12:00
               * *12**: 12:00~18:00
               * **18**: 18:00~24:00
        :param str end_time: The baseline check policy execution end time.
        :param str id: The ID of the baseline check policy.
        :param str start_time: The baseline check policy start time.
        """
        pulumi.set(__self__, "baseline_strategy_id", baseline_strategy_id)
        pulumi.set(__self__, "baseline_strategy_name", baseline_strategy_name)
        pulumi.set(__self__, "custom_type", custom_type)
        pulumi.set(__self__, "cycle_days", cycle_days)
        pulumi.set(__self__, "cycle_start_time", cycle_start_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "risk_sub_type_name", risk_sub_type_name)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="baselineStrategyId")
    def baseline_strategy_id(self) -> str:
        """
        The ID of the baseline check policy.
        """
        return pulumi.get(self, "baseline_strategy_id")

    @property
    @pulumi.getter(name="baselineStrategyName")
    def baseline_strategy_name(self) -> str:
        """
        Policy name.
        """
        return pulumi.get(self, "baseline_strategy_name")

    @property
    @pulumi.getter(name="customType")
    def custom_type(self) -> str:
        """
        The type of policy. Value:-**common**: standard policy-**custom**: custom policy
        """
        return pulumi.get(self, "custom_type")

    @property
    @pulumi.getter(name="cycleDays")
    def cycle_days(self) -> int:
        """
        The detection period of the policy.
        """
        return pulumi.get(self, "cycle_days")

    @property
    @pulumi.getter(name="cycleStartTime")
    def cycle_start_time(self) -> int:
        """
        The detection period of the policy. Value:
        * **0**: 0:00~06:00
        * **6**: 6:00~12:00
        * *12**: 12:00~18:00
        * **18**: 18:00~24:00
        """
        return pulumi.get(self, "cycle_start_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The baseline check policy execution end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the baseline check policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="riskSubTypeName")
    def risk_sub_type_name(self) -> str:
        return pulumi.get(self, "risk_sub_type_name")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The baseline check policy start time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> str:
        return pulumi.get(self, "target_type")


@pulumi.output_type
class GetHoneyPotsPotResult(dict):
    def __init__(__self__, *,
                 honeypot_id: str,
                 honeypot_image_id: str,
                 honeypot_image_name: str,
                 honeypot_name: str,
                 id: str,
                 node_id: str,
                 preset_id: str,
                 states: Sequence[str],
                 status: str):
        """
        :param str honeypot_id: Honeypot ID.
        :param str honeypot_image_id: The image ID of the honeypot.
        :param str honeypot_image_name: Honeypot mirror name.
        :param str honeypot_name: Honeypot custom name.
        :param str id: Honeypot ID. The value is the same as `honeypot_id`.
        :param str node_id: The ID of the honeypot management node.
        :param str preset_id: The custom parameter ID of honeypot.
        :param Sequence[str] states: Honeypot status.
        :param str status: The status of the resource
        """
        pulumi.set(__self__, "honeypot_id", honeypot_id)
        pulumi.set(__self__, "honeypot_image_id", honeypot_image_id)
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_name", honeypot_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "preset_id", preset_id)
        pulumi.set(__self__, "states", states)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> str:
        """
        Honeypot ID.
        """
        return pulumi.get(self, "honeypot_id")

    @property
    @pulumi.getter(name="honeypotImageId")
    def honeypot_image_id(self) -> str:
        """
        The image ID of the honeypot.
        """
        return pulumi.get(self, "honeypot_image_id")

    @property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> str:
        """
        Honeypot mirror name.
        """
        return pulumi.get(self, "honeypot_image_name")

    @property
    @pulumi.getter(name="honeypotName")
    def honeypot_name(self) -> str:
        """
        Honeypot custom name.
        """
        return pulumi.get(self, "honeypot_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Honeypot ID. The value is the same as `honeypot_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the honeypot management node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="presetId")
    def preset_id(self) -> str:
        """
        The custom parameter ID of honeypot.
        """
        return pulumi.get(self, "preset_id")

    @property
    @pulumi.getter
    def states(self) -> Sequence[str]:
        """
        Honeypot status.
        """
        return pulumi.get(self, "states")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHoneypotImagesImageResult(dict):
    def __init__(__self__, *,
                 honeypot_image_display_name: str,
                 honeypot_image_id: str,
                 honeypot_image_name: str,
                 honeypot_image_type: str,
                 honeypot_image_version: str,
                 id: str,
                 multiports: str,
                 proto: str,
                 service_port: str,
                 template: str):
        """
        :param str honeypot_image_display_name: The name of the honeypot image display.
        :param str honeypot_image_id: The image ID of the honeypot.
        :param str honeypot_image_name: Honeypot mirror name.
        :param str honeypot_image_type: Honeypot mirror type.
        :param str honeypot_image_version: Honeypot Mirror version.
        :param str id: The image ID of the honeypot.The value is the same as `honeypot_image_id`.
        :param str multiports: Ports supported by honeypots. In JSON format. Contains the following fields:-**log_type**: log type-**proto**: Support Protocol-**description**: description-**ports**: supports Port collection-**port_str**: supports port strings-**type**: type
        :param str proto: Honeypot-supported protocols.
        :param str service_port: Honeypot service port.
        :param str template: Honeypot configuration parameter template.
        """
        pulumi.set(__self__, "honeypot_image_display_name", honeypot_image_display_name)
        pulumi.set(__self__, "honeypot_image_id", honeypot_image_id)
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_image_type", honeypot_image_type)
        pulumi.set(__self__, "honeypot_image_version", honeypot_image_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "multiports", multiports)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "service_port", service_port)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter(name="honeypotImageDisplayName")
    def honeypot_image_display_name(self) -> str:
        """
        The name of the honeypot image display.
        """
        return pulumi.get(self, "honeypot_image_display_name")

    @property
    @pulumi.getter(name="honeypotImageId")
    def honeypot_image_id(self) -> str:
        """
        The image ID of the honeypot.
        """
        return pulumi.get(self, "honeypot_image_id")

    @property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> str:
        """
        Honeypot mirror name.
        """
        return pulumi.get(self, "honeypot_image_name")

    @property
    @pulumi.getter(name="honeypotImageType")
    def honeypot_image_type(self) -> str:
        """
        Honeypot mirror type.
        """
        return pulumi.get(self, "honeypot_image_type")

    @property
    @pulumi.getter(name="honeypotImageVersion")
    def honeypot_image_version(self) -> str:
        """
        Honeypot Mirror version.
        """
        return pulumi.get(self, "honeypot_image_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The image ID of the honeypot.The value is the same as `honeypot_image_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def multiports(self) -> str:
        """
        Ports supported by honeypots. In JSON format. Contains the following fields:-**log_type**: log type-**proto**: Support Protocol-**description**: description-**ports**: supports Port collection-**port_str**: supports port strings-**type**: type
        """
        return pulumi.get(self, "multiports")

    @property
    @pulumi.getter
    def proto(self) -> str:
        """
        Honeypot-supported protocols.
        """
        return pulumi.get(self, "proto")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> str:
        """
        Honeypot service port.
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        Honeypot configuration parameter template.
        """
        return pulumi.get(self, "template")


@pulumi.output_type
class GetHoneypotNodesNodeResult(dict):
    def __init__(__self__, *,
                 allow_honeypot_access_internet: bool,
                 available_probe_num: int,
                 create_time: str,
                 id: str,
                 node_id: str,
                 node_name: str,
                 security_group_probe_ip_lists: Sequence[str],
                 status: int):
        """
        :param bool allow_honeypot_access_internet: Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
        :param int available_probe_num: Number of probes available.
        :param str id: The ID of the Honeypot management node.
        :param str node_id: Honeypot management node id.
        :param str node_name: The name of the management node.
        :param Sequence[str] security_group_probe_ip_lists: Release the collection of network segments.
        """
        pulumi.set(__self__, "allow_honeypot_access_internet", allow_honeypot_access_internet)
        pulumi.set(__self__, "available_probe_num", available_probe_num)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_name", node_name)
        pulumi.set(__self__, "security_group_probe_ip_lists", security_group_probe_ip_lists)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="allowHoneypotAccessInternet")
    def allow_honeypot_access_internet(self) -> bool:
        """
        Whether to allow honeypot access to the external network. Value:-**true**: Allow-**false**: Disabled
        """
        return pulumi.get(self, "allow_honeypot_access_internet")

    @property
    @pulumi.getter(name="availableProbeNum")
    def available_probe_num(self) -> int:
        """
        Number of probes available.
        """
        return pulumi.get(self, "available_probe_num")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Honeypot management node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Honeypot management node id.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of the management node.
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter(name="securityGroupProbeIpLists")
    def security_group_probe_ip_lists(self) -> Sequence[str]:
        """
        Release the collection of network segments.
        """
        return pulumi.get(self, "security_group_probe_ip_lists")

    @property
    @pulumi.getter
    def status(self) -> int:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHoneypotPresetsPresetResult(dict):
    def __init__(__self__, *,
                 honeypot_image_name: str,
                 honeypot_preset_id: str,
                 id: str,
                 metas: Sequence['outputs.GetHoneypotPresetsPresetMetaResult'],
                 node_id: str,
                 preset_name: str):
        """
        :param str honeypot_image_name: Honeypot mirror name
        :param str honeypot_preset_id: Unique ID of honeypot Template.
        :param str id: The id of the Honeypot template.
        :param Sequence['GetHoneypotPresetsPresetMetaArgs'] metas: Honeypot template custom parameters.
        :param str node_id: Unique id of management node
        :param str preset_name: Honeypot template custom name
        """
        pulumi.set(__self__, "honeypot_image_name", honeypot_image_name)
        pulumi.set(__self__, "honeypot_preset_id", honeypot_preset_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metas", metas)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "preset_name", preset_name)

    @property
    @pulumi.getter(name="honeypotImageName")
    def honeypot_image_name(self) -> str:
        """
        Honeypot mirror name
        """
        return pulumi.get(self, "honeypot_image_name")

    @property
    @pulumi.getter(name="honeypotPresetId")
    def honeypot_preset_id(self) -> str:
        """
        Unique ID of honeypot Template.
        """
        return pulumi.get(self, "honeypot_preset_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the Honeypot template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetHoneypotPresetsPresetMetaResult']:
        """
        Honeypot template custom parameters.
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Unique id of management node
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="presetName")
    def preset_name(self) -> str:
        """
        Honeypot template custom name
        """
        return pulumi.get(self, "preset_name")


@pulumi.output_type
class GetHoneypotPresetsPresetMetaResult(dict):
    def __init__(__self__, *,
                 burp: str,
                 portrait_option: bool,
                 trojan_git: str):
        """
        :param str burp: Burp counter.
        :param bool portrait_option: Social traceability.
        :param str trojan_git: Git countered.
        """
        pulumi.set(__self__, "burp", burp)
        pulumi.set(__self__, "portrait_option", portrait_option)
        pulumi.set(__self__, "trojan_git", trojan_git)

    @property
    @pulumi.getter
    def burp(self) -> str:
        """
        Burp counter.
        """
        return pulumi.get(self, "burp")

    @property
    @pulumi.getter(name="portraitOption")
    def portrait_option(self) -> bool:
        """
        Social traceability.
        """
        return pulumi.get(self, "portrait_option")

    @property
    @pulumi.getter(name="trojanGit")
    def trojan_git(self) -> str:
        """
        Git countered.
        """
        return pulumi.get(self, "trojan_git")


@pulumi.output_type
class GetHoneypotProbesProbeResult(dict):
    def __init__(__self__, *,
                 arp: bool,
                 control_node_id: str,
                 display_name: str,
                 honeypot_bind_lists: Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListResult'],
                 honeypot_probe_id: str,
                 id: str,
                 ping: bool,
                 probe_type: str,
                 service_ip_lists: Sequence[str],
                 status: str,
                 uuid: str,
                 vpc_id: str):
        """
        :param bool arp: ARP spoofing detection.-**true**: Enable-**false**: Disabled. Available when `enable_details` is on.
        :param str control_node_id: The ID of the management node.
        :param str display_name: Probe name
        :param str honeypot_probe_id: The first ID of the resource
        :param str id: The ID of the honeypot probe. Its value is the same as `honeypot_probe_id`.
        :param bool ping: Ping scan detection. Value:**true**: Enable **false**: Disabled. Available when `enable_details` is on.
        :param str probe_type: Probe type
        :param Sequence[str] service_ip_lists: Listen to the IP address list. Available when `enable_details` is on.
        :param str status: The status of the resource.
        :param str uuid: Machine uuid. Has a value when the type is `host_probe`.
        :param str vpc_id: The ID of the VPC. Has a value when the type is `vpc_black_hole_probe`.
        """
        pulumi.set(__self__, "arp", arp)
        pulumi.set(__self__, "control_node_id", control_node_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "honeypot_bind_lists", honeypot_bind_lists)
        pulumi.set(__self__, "honeypot_probe_id", honeypot_probe_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ping", ping)
        pulumi.set(__self__, "probe_type", probe_type)
        pulumi.set(__self__, "service_ip_lists", service_ip_lists)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "uuid", uuid)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def arp(self) -> bool:
        """
        ARP spoofing detection.-**true**: Enable-**false**: Disabled. Available when `enable_details` is on.
        """
        return pulumi.get(self, "arp")

    @property
    @pulumi.getter(name="controlNodeId")
    def control_node_id(self) -> str:
        """
        The ID of the management node.
        """
        return pulumi.get(self, "control_node_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Probe name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="honeypotBindLists")
    def honeypot_bind_lists(self) -> Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListResult']:
        return pulumi.get(self, "honeypot_bind_lists")

    @property
    @pulumi.getter(name="honeypotProbeId")
    def honeypot_probe_id(self) -> str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "honeypot_probe_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the honeypot probe. Its value is the same as `honeypot_probe_id`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ping(self) -> bool:
        """
        Ping scan detection. Value:**true**: Enable **false**: Disabled. Available when `enable_details` is on.
        """
        return pulumi.get(self, "ping")

    @property
    @pulumi.getter(name="probeType")
    def probe_type(self) -> str:
        """
        Probe type
        """
        return pulumi.get(self, "probe_type")

    @property
    @pulumi.getter(name="serviceIpLists")
    def service_ip_lists(self) -> Sequence[str]:
        """
        Listen to the IP address list. Available when `enable_details` is on.
        """
        return pulumi.get(self, "service_ip_lists")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        Machine uuid. Has a value when the type is `host_probe`.
        """
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC. Has a value when the type is `vpc_black_hole_probe`.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetHoneypotProbesProbeHoneypotBindListResult(dict):
    def __init__(__self__, *,
                 bind_port_lists: Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListBindPortListResult'],
                 honeypot_id: str):
        """
        :param Sequence['GetHoneypotProbesProbeHoneypotBindListBindPortListArgs'] bind_port_lists: List of listening ports. Available when `enable_details` is on.
        """
        pulumi.set(__self__, "bind_port_lists", bind_port_lists)
        pulumi.set(__self__, "honeypot_id", honeypot_id)

    @property
    @pulumi.getter(name="bindPortLists")
    def bind_port_lists(self) -> Sequence['outputs.GetHoneypotProbesProbeHoneypotBindListBindPortListResult']:
        """
        List of listening ports. Available when `enable_details` is on.
        """
        return pulumi.get(self, "bind_port_lists")

    @property
    @pulumi.getter(name="honeypotId")
    def honeypot_id(self) -> str:
        return pulumi.get(self, "honeypot_id")


@pulumi.output_type
class GetHoneypotProbesProbeHoneypotBindListBindPortListResult(dict):
    def __init__(__self__, *,
                 bind_port: bool,
                 end_port: int,
                 fixed: bool,
                 start_port: int,
                 target_port: int):
        """
        :param bool bind_port: Whether to bind the port.
        :param int end_port: End port.
        :param bool fixed: Whether the port is fixed.
        :param int start_port: Start port.
        :param int target_port: Destination port.
        """
        pulumi.set(__self__, "bind_port", bind_port)
        pulumi.set(__self__, "end_port", end_port)
        pulumi.set(__self__, "fixed", fixed)
        pulumi.set(__self__, "start_port", start_port)
        pulumi.set(__self__, "target_port", target_port)

    @property
    @pulumi.getter(name="bindPort")
    def bind_port(self) -> bool:
        """
        Whether to bind the port.
        """
        return pulumi.get(self, "bind_port")

    @property
    @pulumi.getter(name="endPort")
    def end_port(self) -> int:
        """
        End port.
        """
        return pulumi.get(self, "end_port")

    @property
    @pulumi.getter
    def fixed(self) -> bool:
        """
        Whether the port is fixed.
        """
        return pulumi.get(self, "fixed")

    @property
    @pulumi.getter(name="startPort")
    def start_port(self) -> int:
        """
        Start port.
        """
        return pulumi.get(self, "start_port")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        Destination port.
        """
        return pulumi.get(self, "target_port")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 instance_id: str,
                 payment_type: str,
                 status: str):
        """
        :param str create_time: The creation time of the resource
        :param str id: ID of the instance.
        :param str instance_id: The first ID of the resource
        :param str payment_type: The payment type of the resource.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetVulWhitelistsWhitelistResult(dict):
    def __init__(__self__, *,
                 id: str,
                 reason: str,
                 target_info: str,
                 vul_whitelist_id: str,
                 whitelist: str):
        """
        :param str id: The ID of the Vul Whitelist.
        :param str reason: Reason for adding whitelist.
        :param str target_info: Set the effective range of the whitelist.
        :param str vul_whitelist_id: The ID of the Vul Whitelist.
        :param str whitelist: Information about the vulnerability to be added to the whitelist.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "target_info", target_info)
        pulumi.set(__self__, "vul_whitelist_id", vul_whitelist_id)
        pulumi.set(__self__, "whitelist", whitelist)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vul Whitelist.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Reason for adding whitelist.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="targetInfo")
    def target_info(self) -> str:
        """
        Set the effective range of the whitelist.
        """
        return pulumi.get(self, "target_info")

    @property
    @pulumi.getter(name="vulWhitelistId")
    def vul_whitelist_id(self) -> str:
        """
        The ID of the Vul Whitelist.
        """
        return pulumi.get(self, "vul_whitelist_id")

    @property
    @pulumi.getter
    def whitelist(self) -> str:
        """
        Information about the vulnerability to be added to the whitelist.
        """
        return pulumi.get(self, "whitelist")


@pulumi.output_type
class GetWebLockConfigsConfigResult(dict):
    def __init__(__self__, *,
                 defence_mode: str,
                 dir: str,
                 exclusive_dir: str,
                 exclusive_file: str,
                 exclusive_file_type: str,
                 id: str,
                 inclusive_file_type: str,
                 local_backup_dir: str,
                 mode: str,
                 uuid: str):
        """
        :param str defence_mode: The prevention mode.
        :param str dir: The directory that has web tamper proofing enabled.
        :param str exclusive_dir: The directory that has web tamper proofing disabled.
        :param str exclusive_file: The file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        :param str exclusive_file_type: The type of the file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        :param str id: The ID of the resource.
        :param str inclusive_file_type: The type of the file that has web tamper proofing enabled. **Note:** If the value of `mode` is `whitelist`, this parameter is returned.
        :param str local_backup_dir: The local path to the backup files of the protected directory.
        :param str mode: The protection mode of web tamper proofing.
        :param str uuid: The UUID of the server that has web tamper proofing enabled.
        """
        pulumi.set(__self__, "defence_mode", defence_mode)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "exclusive_dir", exclusive_dir)
        pulumi.set(__self__, "exclusive_file", exclusive_file)
        pulumi.set(__self__, "exclusive_file_type", exclusive_file_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inclusive_file_type", inclusive_file_type)
        pulumi.set(__self__, "local_backup_dir", local_backup_dir)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="defenceMode")
    def defence_mode(self) -> str:
        """
        The prevention mode.
        """
        return pulumi.get(self, "defence_mode")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        The directory that has web tamper proofing enabled.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="exclusiveDir")
    def exclusive_dir(self) -> str:
        """
        The directory that has web tamper proofing disabled.
        """
        return pulumi.get(self, "exclusive_dir")

    @property
    @pulumi.getter(name="exclusiveFile")
    def exclusive_file(self) -> str:
        """
        The file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        """
        return pulumi.get(self, "exclusive_file")

    @property
    @pulumi.getter(name="exclusiveFileType")
    def exclusive_file_type(self) -> str:
        """
        The type of the file that has web tamper proofing disabled. **Note:** If the value of `mode` is `blacklist`, this parameter is returned.
        """
        return pulumi.get(self, "exclusive_file_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inclusiveFileType")
    def inclusive_file_type(self) -> str:
        """
        The type of the file that has web tamper proofing enabled. **Note:** If the value of `mode` is `whitelist`, this parameter is returned.
        """
        return pulumi.get(self, "inclusive_file_type")

    @property
    @pulumi.getter(name="localBackupDir")
    def local_backup_dir(self) -> str:
        """
        The local path to the backup files of the protected directory.
        """
        return pulumi.get(self, "local_backup_dir")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        The protection mode of web tamper proofing.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The UUID of the server that has web tamper proofing enabled.
        """
        return pulumi.get(self, "uuid")


