# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SasTrailArgs', 'SasTrail']

@pulumi.input_type
class SasTrailArgs:
    def __init__(__self__):
        """
        The set of arguments for constructing a SasTrail resource.
        """
        pass


@pulumi.input_type
class _SasTrailState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[int]] = None,
                 service_trail: Optional[pulumi.Input['SasTrailServiceTrailArgs']] = None):
        """
        Input properties used for looking up and filtering SasTrail resources.
        :param pulumi.Input[int] create_time: The service trace creation timestamp, in milliseconds.
        :param pulumi.Input['SasTrailServiceTrailArgs'] service_trail: Service trace configuration information.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if service_trail is not None:
            pulumi.set(__self__, "service_trail", service_trail)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[int]]:
        """
        The service trace creation timestamp, in milliseconds.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="serviceTrail")
    def service_trail(self) -> Optional[pulumi.Input['SasTrailServiceTrailArgs']]:
        """
        Service trace configuration information.
        """
        return pulumi.get(self, "service_trail")

    @service_trail.setter
    def service_trail(self, value: Optional[pulumi.Input['SasTrailServiceTrailArgs']]):
        pulumi.set(self, "service_trail", value)


class SasTrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 __props__=None):
        """
        Provides a Threat Detection Sas Trail resource.

        For information about Threat Detection Sas Trail and how to use it, see [What is Sas Trail](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createservicetrail).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.SasTrail("default")
        ```

        ## Import

        Threat Detection Sas Trail can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/sasTrail:SasTrail example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SasTrailArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Threat Detection Sas Trail resource.

        For information about Threat Detection Sas Trail and how to use it, see [What is Sas Trail](https://www.alibabacloud.com/help/zh/security-center/developer-reference/api-sas-2018-12-03-createservicetrail).

        > **NOTE:** Available since v1.212.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.threatdetection.SasTrail("default")
        ```

        ## Import

        Threat Detection Sas Trail can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:threatdetection/sasTrail:SasTrail example
        ```

        :param str resource_name: The name of the resource.
        :param SasTrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SasTrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SasTrailArgs.__new__(SasTrailArgs)

            __props__.__dict__["create_time"] = None
            __props__.__dict__["service_trail"] = None
        super(SasTrail, __self__).__init__(
            'alicloud:threatdetection/sasTrail:SasTrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[int]] = None,
            service_trail: Optional[pulumi.Input[pulumi.InputType['SasTrailServiceTrailArgs']]] = None) -> 'SasTrail':
        """
        Get an existing SasTrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] create_time: The service trace creation timestamp, in milliseconds.
        :param pulumi.Input[pulumi.InputType['SasTrailServiceTrailArgs']] service_trail: Service trace configuration information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SasTrailState.__new__(_SasTrailState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["service_trail"] = service_trail
        return SasTrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[int]:
        """
        The service trace creation timestamp, in milliseconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="serviceTrail")
    def service_trail(self) -> pulumi.Output['outputs.SasTrailServiceTrail']:
        """
        Service trace configuration information.
        """
        return pulumi.get(self, "service_trail")

