# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_class: pulumi.Input[str],
                 instance_storage: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 app_key: Optional[pulumi.Input[str]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] instance_class: The specification of the instance. 
               - Following enumerative value for TSDB for InfluxDB️ standart edition:
               - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB for InfluxDB High-availability edition:
               - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB:
               - `tsdb.1x.basic` refers to basic edition I;
               - `tsdb.3x.basic` refers to basic edition II;
               - `tsdb.4x.basic` refers to basic edtion III;
               - `tsdb.12x.standard` refers to standard edition I;
               - `tsdb.24x.standard` refers to standard edition II;
               - `tsdb.48x.large` refers to ultimate edition I;
               - `tsdb.96x.large` refers to ultimate edition II.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] app_key: The app key.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        :param pulumi.Input[str] duration: The duration.
        :param pulumi.Input[str] engine_type: The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        :param pulumi.Input[str] instance_alias: The alias of the instance.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        pulumi.set(__self__, "instance_class", instance_class)
        pulumi.set(__self__, "instance_storage", instance_storage)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Input[str]:
        """
        The specification of the instance. 
        - Following enumerative value for TSDB for InfluxDB️ standart edition:
        - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB for InfluxDB High-availability edition:
        - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB:
        - `tsdb.1x.basic` refers to basic edition I;
        - `tsdb.3x.basic` refers to basic edition II;
        - `tsdb.4x.basic` refers to basic edtion III;
        - `tsdb.12x.standard` refers to standard edition I;
        - `tsdb.24x.standard` refers to standard edition II;
        - `tsdb.48x.large` refers to ultimate edition I;
        - `tsdb.96x.large` refers to ultimate edition II.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Input[str]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        The app key.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_category", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the instance.
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_alias", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 app_key: Optional[pulumi.Input[str]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] app_key: The app key.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        :param pulumi.Input[str] duration: The duration.
        :param pulumi.Input[str] engine_type: The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        :param pulumi.Input[str] instance_alias: The alias of the instance.
        :param pulumi.Input[str] instance_class: The specification of the instance. 
               - Following enumerative value for TSDB for InfluxDB️ standart edition:
               - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB for InfluxDB High-availability edition:
               - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB:
               - `tsdb.1x.basic` refers to basic edition I;
               - `tsdb.3x.basic` refers to basic edition II;
               - `tsdb.4x.basic` refers to basic edtion III;
               - `tsdb.12x.standard` refers to standard edition I;
               - `tsdb.24x.standard` refers to standard edition II;
               - `tsdb.48x.large` refers to ultimate edition I;
               - `tsdb.96x.large` refers to ultimate edition II.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        :param pulumi.Input[str] status: Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)
        if instance_class is not None:
            pulumi.set(__self__, "instance_class", instance_class)
        if instance_storage is not None:
            pulumi.set(__self__, "instance_storage", instance_storage)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[str]]:
        """
        The app key.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_key", value)

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        """
        return pulumi.get(self, "disk_category")

    @disk_category.setter
    def disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_category", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        The duration.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the instance.
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_alias", value)

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of the instance. 
        - Following enumerative value for TSDB for InfluxDB️ standart edition:
        - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB for InfluxDB High-availability edition:
        - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB:
        - `tsdb.1x.basic` refers to basic edition I;
        - `tsdb.3x.basic` refers to basic edition II;
        - `tsdb.4x.basic` refers to basic edtion III;
        - `tsdb.12x.standard` refers to standard edition I;
        - `tsdb.24x.standard` refers to standard edition II;
        - `tsdb.48x.large` refers to ultimate edition I;
        - `tsdb.96x.large` refers to ultimate edition II.
        """
        return pulumi.get(self, "instance_class")

    @instance_class.setter
    def instance_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_class", value)

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> Optional[pulumi.Input[str]]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        """
        return pulumi.get(self, "instance_storage")

    @instance_storage.setter
    def instance_storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_storage", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Time Series Database (TSDB) Instance resource.

        For information about Time Series Database (TSDB) Instance and how to use it, see [What is Time Series Database (TSDB)](https://www.alibabacloud.com/help/en/doc-detail/55652.htm).

        > **NOTE:** Available in v1.112.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.tsdb.get_zones()
        example_network = alicloud.vpc.Network("exampleNetwork", cidr_block="192.168.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            availability_zone=example_zones.ids[0],
            cidr_block="192.168.1.0/24",
            vpc_id=example_network.id)
        example_instance = alicloud.tsdb.Instance("exampleInstance",
            payment_type="PayAsYouGo",
            vswitch_id=example_switch.id,
            instance_storage="50",
            instance_class="tsdb.1x.basic",
            engine_type="tsdb_tsdb",
            instance_alias="tf-testaccTsdbInstance")
        ```

        ## Import

        TSDB Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:tsdb/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_key: The app key.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        :param pulumi.Input[str] duration: The duration.
        :param pulumi.Input[str] engine_type: The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        :param pulumi.Input[str] instance_alias: The alias of the instance.
        :param pulumi.Input[str] instance_class: The specification of the instance. 
               - Following enumerative value for TSDB for InfluxDB️ standart edition:
               - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB for InfluxDB High-availability edition:
               - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB:
               - `tsdb.1x.basic` refers to basic edition I;
               - `tsdb.3x.basic` refers to basic edition II;
               - `tsdb.4x.basic` refers to basic edtion III;
               - `tsdb.12x.standard` refers to standard edition I;
               - `tsdb.24x.standard` refers to standard edition II;
               - `tsdb.48x.large` refers to ultimate edition I;
               - `tsdb.96x.large` refers to ultimate edition II.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Time Series Database (TSDB) Instance resource.

        For information about Time Series Database (TSDB) Instance and how to use it, see [What is Time Series Database (TSDB)](https://www.alibabacloud.com/help/en/doc-detail/55652.htm).

        > **NOTE:** Available in v1.112.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.tsdb.get_zones()
        example_network = alicloud.vpc.Network("exampleNetwork", cidr_block="192.168.0.0/16")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            availability_zone=example_zones.ids[0],
            cidr_block="192.168.1.0/24",
            vpc_id=example_network.id)
        example_instance = alicloud.tsdb.Instance("exampleInstance",
            payment_type="PayAsYouGo",
            vswitch_id=example_switch.id,
            instance_storage="50",
            instance_class="tsdb.1x.basic",
            engine_type="tsdb_tsdb",
            instance_alias="tf-testaccTsdbInstance")
        ```

        ## Import

        TSDB Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:tsdb/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_key: Optional[pulumi.Input[str]] = None,
                 disk_category: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 instance_class: Optional[pulumi.Input[str]] = None,
                 instance_storage: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["app_key"] = app_key
            __props__.__dict__["disk_category"] = disk_category
            __props__.__dict__["duration"] = duration
            __props__.__dict__["engine_type"] = engine_type
            __props__.__dict__["instance_alias"] = instance_alias
            if instance_class is None and not opts.urn:
                raise TypeError("Missing required property 'instance_class'")
            __props__.__dict__["instance_class"] = instance_class
            if instance_storage is None and not opts.urn:
                raise TypeError("Missing required property 'instance_storage'")
            __props__.__dict__["instance_storage"] = instance_storage
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'alicloud:tsdb/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_key: Optional[pulumi.Input[str]] = None,
            disk_category: Optional[pulumi.Input[str]] = None,
            duration: Optional[pulumi.Input[str]] = None,
            engine_type: Optional[pulumi.Input[str]] = None,
            instance_alias: Optional[pulumi.Input[str]] = None,
            instance_class: Optional[pulumi.Input[str]] = None,
            instance_storage: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_key: The app key.
        :param pulumi.Input[str] disk_category: The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        :param pulumi.Input[str] duration: The duration.
        :param pulumi.Input[str] engine_type: The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        :param pulumi.Input[str] instance_alias: The alias of the instance.
        :param pulumi.Input[str] instance_class: The specification of the instance. 
               - Following enumerative value for TSDB for InfluxDB️ standart edition:
               - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB for InfluxDB High-availability edition:
               - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
               - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
               - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
               - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
               - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
               - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
               - Following enumerative value for TSDB:
               - `tsdb.1x.basic` refers to basic edition I;
               - `tsdb.3x.basic` refers to basic edition II;
               - `tsdb.4x.basic` refers to basic edtion III;
               - `tsdb.12x.standard` refers to standard edition I;
               - `tsdb.24x.standard` refers to standard edition II;
               - `tsdb.48x.large` refers to ultimate edition I;
               - `tsdb.96x.large` refers to ultimate edition II.
        :param pulumi.Input[str] instance_storage: The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        :param pulumi.Input[str] payment_type: The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        :param pulumi.Input[str] status: Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
        :param pulumi.Input[str] vswitch_id: The vswitch id.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["app_key"] = app_key
        __props__.__dict__["disk_category"] = disk_category
        __props__.__dict__["duration"] = duration
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["instance_alias"] = instance_alias
        __props__.__dict__["instance_class"] = instance_class
        __props__.__dict__["instance_storage"] = instance_storage
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["status"] = status
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[Optional[str]]:
        """
        The app key.
        """
        return pulumi.get(self, "app_key")

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        The disk type of instance. Valid when the engine type is `tsdb_influxdb`. `cloud_ssd` refers to SSD disk, `cloud_efficiency` refers to efficiency disk, `cloud_essd` refers to ESSD PL1 disk. Valid values: `cloud_efficiency`, `cloud_essd`, `cloud_ssd`.
        """
        return pulumi.get(self, "disk_category")

    @property
    @pulumi.getter
    def duration(self) -> pulumi.Output[Optional[str]]:
        """
        The duration.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[Optional[str]]:
        """
        The engine type of instance Enumerative: `tsdb_tsdb` refers to TSDB, `tsdb_influxdb` refers to TSDB for InfluxDB️.
        """
        return pulumi.get(self, "engine_type")

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> pulumi.Output[Optional[str]]:
        """
        The alias of the instance.
        """
        return pulumi.get(self, "instance_alias")

    @property
    @pulumi.getter(name="instanceClass")
    def instance_class(self) -> pulumi.Output[str]:
        """
        The specification of the instance. 
        - Following enumerative value for TSDB for InfluxDB️ standart edition:
        - `influxdata.n1.mxlarge` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB for InfluxDB High-availability edition:
        - `influxdata.n1.mxlarge_ha` refers to 2 CPU 8GB memory;
        - `influxdata.n1.xlarge_ha` refers to 4 CPU 16GB memory;
        - `influxdata.n1.2xlarge_ha` refers to 8 CPU 32 GB memory;
        - `influxdata.n1.4xlarge_ha` refers to 16 CPU 64 GB memory;
        - `influxdata.n1.8xlarge_ha` refers to 32 CPU 128 GB memory;
        - `influxdata.n1.16xlarge_ha` refers to 64 CPU 256 GB memory.
        - Following enumerative value for TSDB:
        - `tsdb.1x.basic` refers to basic edition I;
        - `tsdb.3x.basic` refers to basic edition II;
        - `tsdb.4x.basic` refers to basic edtion III;
        - `tsdb.12x.standard` refers to standard edition I;
        - `tsdb.24x.standard` refers to standard edition II;
        - `tsdb.48x.large` refers to ultimate edition I;
        - `tsdb.96x.large` refers to ultimate edition II.
        """
        return pulumi.get(self, "instance_class")

    @property
    @pulumi.getter(name="instanceStorage")
    def instance_storage(self) -> pulumi.Output[str]:
        """
        The storage capacity of the instance. Unit: GB. For example, the value 50 indicates 50 GB. Does not support shrink storage.
        """
        return pulumi.get(self, "instance_storage")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The billing method. Valid values: `PayAsYouGo` and `Subscription`. The `PayAsYouGo` value indicates the pay-as-you-go method, and the `Subscription` value indicates the subscription method.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Instance status, enumerative: `ACTIVATION`, `DELETED`, `CREATING`, `CLASS_CHANGING`, `LOCKED`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

