# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSystemGroupsGroupResult',
    'GetSystemGroupsGroupStatResult',
]

@pulumi.output_type
class GetSystemGroupsGroupResult(dict):
    def __init__(__self__, *,
                 app: str,
                 callback: str,
                 create_time: str,
                 description: str,
                 enabled: bool,
                 gb_id: str,
                 gb_ip: str,
                 group_id: str,
                 group_name: str,
                 id: str,
                 in_protocol: str,
                 out_protocol: str,
                 play_domain: str,
                 push_domain: str,
                 stats: Sequence['outputs.GetSystemGroupsGroupStatResult']):
        """
        :param str app: The App Name of Group.
        :param str callback: The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
        :param str create_time: The creation time of the Group.
        :param str description: The description of the Group.
        :param bool enabled: Whether to open Group.
        :param str gb_id: Space of national standard ID. **NOTE:** Available only in the national standard access space.
        :param str gb_ip: Space of national standard signaling server address. **NOTE:** Available only in the national standard access space.
        :param str group_id: The ID of Group.
        :param str group_name: The name of Group.
        :param str id: The ID of the Group.
        :param str in_protocol: The use of the access protocol support `gb28181`,`rtmp`(Real Time Messaging Protocol).
        :param str out_protocol: The use of space play Protocol multi-valued separate them with commas (,). Valid values: `flv`,`hls`, `rtmp`(Real Time Messaging Protocol).
        :param str play_domain: The domain name of plan streaming used by the group.
        :param str push_domain: The domain name of push streaming used by the group.
        :param Sequence['GetSystemGroupsGroupStatArgs'] stats: The Device statistics of Group.
        """
        pulumi.set(__self__, "app", app)
        pulumi.set(__self__, "callback", callback)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "gb_id", gb_id)
        pulumi.set(__self__, "gb_ip", gb_ip)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_protocol", in_protocol)
        pulumi.set(__self__, "out_protocol", out_protocol)
        pulumi.set(__self__, "play_domain", play_domain)
        pulumi.set(__self__, "push_domain", push_domain)
        pulumi.set(__self__, "stats", stats)

    @property
    @pulumi.getter
    def app(self) -> str:
        """
        The App Name of Group.
        """
        return pulumi.get(self, "app")

    @property
    @pulumi.getter
    def callback(self) -> str:
        """
        The space within the device status update of the callback, need to start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "callback")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the Group.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to open Group.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="gbId")
    def gb_id(self) -> str:
        """
        Space of national standard ID. **NOTE:** Available only in the national standard access space.
        """
        return pulumi.get(self, "gb_id")

    @property
    @pulumi.getter(name="gbIp")
    def gb_ip(self) -> str:
        """
        Space of national standard signaling server address. **NOTE:** Available only in the national standard access space.
        """
        return pulumi.get(self, "gb_ip")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The ID of Group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        The name of Group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inProtocol")
    def in_protocol(self) -> str:
        """
        The use of the access protocol support `gb28181`,`rtmp`(Real Time Messaging Protocol).
        """
        return pulumi.get(self, "in_protocol")

    @property
    @pulumi.getter(name="outProtocol")
    def out_protocol(self) -> str:
        """
        The use of space play Protocol multi-valued separate them with commas (,). Valid values: `flv`,`hls`, `rtmp`(Real Time Messaging Protocol).
        """
        return pulumi.get(self, "out_protocol")

    @property
    @pulumi.getter(name="playDomain")
    def play_domain(self) -> str:
        """
        The domain name of plan streaming used by the group.
        """
        return pulumi.get(self, "play_domain")

    @property
    @pulumi.getter(name="pushDomain")
    def push_domain(self) -> str:
        """
        The domain name of push streaming used by the group.
        """
        return pulumi.get(self, "push_domain")

    @property
    @pulumi.getter
    def stats(self) -> Sequence['outputs.GetSystemGroupsGroupStatResult']:
        """
        The Device statistics of Group.
        """
        return pulumi.get(self, "stats")


@pulumi.output_type
class GetSystemGroupsGroupStatResult(dict):
    def __init__(__self__, *,
                 device_num: str,
                 ied_num: str,
                 ipc_num: str,
                 platform_num: str):
        """
        :param str device_num: The total number of devices in the group.
        :param str ied_num: The total number of smart devices in the group.
        :param str ipc_num: The total number of cameras in the group.
        :param str platform_num: The total number of platforms in the group.
        """
        pulumi.set(__self__, "device_num", device_num)
        pulumi.set(__self__, "ied_num", ied_num)
        pulumi.set(__self__, "ipc_num", ipc_num)
        pulumi.set(__self__, "platform_num", platform_num)

    @property
    @pulumi.getter(name="deviceNum")
    def device_num(self) -> str:
        """
        The total number of devices in the group.
        """
        return pulumi.get(self, "device_num")

    @property
    @pulumi.getter(name="iedNum")
    def ied_num(self) -> str:
        """
        The total number of smart devices in the group.
        """
        return pulumi.get(self, "ied_num")

    @property
    @pulumi.getter(name="ipcNum")
    def ipc_num(self) -> str:
        """
        The total number of cameras in the group.
        """
        return pulumi.get(self, "ipc_num")

    @property
    @pulumi.getter(name="platformNum")
    def platform_num(self) -> str:
        """
        The total number of platforms in the group.
        """
        return pulumi.get(self, "platform_num")


