# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DhcpOptionsSetAssociateVpcArgs',
    'NetworkAclAttachmentResourceArgs',
    'NetworkAclEgressAclEntryArgs',
    'NetworkAclEntriesEgressArgs',
    'NetworkAclEntriesIngressArgs',
    'NetworkAclIngressAclEntryArgs',
    'NetworkAclResourceArgs',
    'NetworkIpv6CidrBlockArgs',
    'PrefixListEntryArgs',
    'PrefixListPrefixListAssociationArgs',
    'TrafficMirrorFilterEgressRuleArgs',
    'TrafficMirrorFilterIngressRuleArgs',
]

@pulumi.input_type
class DhcpOptionsSetAssociateVpcArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 associate_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] vpc_id: The ID of the VPC network that is associated with the DHCP options set.
        :param pulumi.Input[str] associate_status: The status of the VPC associated with the DHCP option set.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if associate_status is not None:
            pulumi.set(__self__, "associate_status", associate_status)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        The ID of the VPC network that is associated with the DHCP options set.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="associateStatus")
    def associate_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the VPC associated with the DHCP option set.
        """
        return pulumi.get(self, "associate_status")

    @associate_status.setter
    def associate_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associate_status", value)


@pulumi.input_type
class NetworkAclAttachmentResourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 resource_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] resource_id: The resource id that the network acl will associate with.
        :param pulumi.Input[str] resource_type: The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The resource id that the network acl will associate with.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class NetworkAclEgressAclEntryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_cidr_ip: Optional[pulumi.Input[str]] = None,
                 network_acl_entry_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The description of the outbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[str] destination_cidr_ip: The network of the destination address.
        :param pulumi.Input[str] network_acl_entry_name: Name of the outbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param pulumi.Input[str] policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param pulumi.Input[str] port: The destination port range of the outbound rule.When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param pulumi.Input[str] protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the outbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The network of the destination address.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @destination_cidr_ip.setter
    def destination_cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_ip", value)

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the outbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @network_acl_entry_name.setter
    def network_acl_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_acl_entry_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port range of the outbound rule.When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class NetworkAclEntriesEgressArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 destination_cidr_ip: Optional[pulumi.Input[str]] = None,
                 entry_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The description of the egress entry.
        :param pulumi.Input[str] destination_cidr_ip: The destination ip of the egress entry.
        :param pulumi.Input[str] entry_type: The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        :param pulumi.Input[str] name: The name of the egress entry.
        :param pulumi.Input[str] policy: The policy of the egress entry. It must be `accept` or `drop`.
        :param pulumi.Input[str] port: The port of the egress entry.
        :param pulumi.Input[str] protocol: The protocol of the egress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the egress entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The destination ip of the egress entry.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @destination_cidr_ip.setter
    def destination_cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_ip", value)

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[str]]:
        """
        The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the egress entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy of the egress entry. It must be `accept` or `drop`.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of the egress entry.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol of the egress entry.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class NetworkAclEntriesIngressArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 entry_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The description of the egress entry.
        :param pulumi.Input[str] entry_type: The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        :param pulumi.Input[str] name: The name of the egress entry.
        :param pulumi.Input[str] policy: The policy of the egress entry. It must be `accept` or `drop`.
        :param pulumi.Input[str] port: The port of the egress entry.
        :param pulumi.Input[str] protocol: The protocol of the egress entry.
        :param pulumi.Input[str] source_cidr_ip: The source ip of the ingress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the egress entry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[pulumi.Input[str]]:
        """
        The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        """
        return pulumi.get(self, "entry_type")

    @entry_type.setter
    def entry_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the egress entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy of the egress entry. It must be `accept` or `drop`.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The port of the egress entry.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol of the egress entry.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The source ip of the ingress entry.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr_ip", value)


@pulumi.input_type
class NetworkAclIngressAclEntryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 network_acl_entry_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 source_cidr_ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: Description of the inbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param pulumi.Input[str] network_acl_entry_name: The name of the inbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param pulumi.Input[str] policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param pulumi.Input[str] port: The source port range of the inbound rule.When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param pulumi.Input[str] protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        :param pulumi.Input[str] source_cidr_ip: Source address network segment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the inbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the inbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @network_acl_entry_name.setter
    def network_acl_entry_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_acl_entry_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        The source port range of the inbound rule.When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Source address network segment.
        """
        return pulumi.get(self, "source_cidr_ip")

    @source_cidr_ip.setter
    def source_cidr_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr_ip", value)


@pulumi.input_type
class NetworkAclResourceArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] resource_id: The ID of the associated resource.
        :param pulumi.Input[str] resource_type: The type of the associated resource.
        :param pulumi.Input[str] status: The status of the associated resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the associated resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class NetworkIpv6CidrBlockArgs:
    def __init__(__self__, *,
                 ipv6_cidr_block: Optional[pulumi.Input[str]] = None,
                 ipv6_isp: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param pulumi.Input[str] ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - **BGP** (default): Alibaba Cloud BGP IPv6.
               - **ChinaMobile**: China Mobile (single line).
               - **ChinaUnicom**: China Unicom (single line).
               - **ChinaTelecom**: China Telecom (single line).
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to **ChinaTelecom** (China Telecom), **ChinaUnicom** (China Unicom), or **ChinaMobile** (China Mobile).
        """
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_block", value)

    @property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address segment type of the VPC. Value:
        - **BGP** (default): Alibaba Cloud BGP IPv6.
        - **ChinaMobile**: China Mobile (single line).
        - **ChinaUnicom**: China Unicom (single line).
        - **ChinaTelecom**: China Telecom (single line).
        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to **ChinaTelecom** (China Telecom), **ChinaUnicom** (China Unicom), or **ChinaMobile** (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")

    @ipv6_isp.setter
    def ipv6_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_isp", value)


@pulumi.input_type
class PrefixListEntryArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: The CIDR address block of the prefix list.
        :param pulumi.Input[str] description: The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class PrefixListPrefixListAssociationArgs:
    def __init__(__self__, *,
                 owner_id: Optional[pulumi.Input[str]] = None,
                 prefix_list_id: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 resource_uid: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] owner_id: The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        :param pulumi.Input[str] prefix_list_id: The ID of the query Prefix List.
        :param pulumi.Input[str] reason: Reason when the association fails.
        :param pulumi.Input[str] region_id: The region ID of the prefix list to be queried.
        :param pulumi.Input[str] resource_id: The ID of the associated resource.
        :param pulumi.Input[str] resource_type: The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        :param pulumi.Input[str] resource_uid: The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        :param pulumi.Input[str] status: Resource attribute fields that represent the status of the resource.
        """
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if prefix_list_id is not None:
            pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uid is not None:
            pulumi.set(__self__, "resource_uid", resource_uid)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_id")

    @owner_id.setter
    def owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner_id", value)

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @prefix_list_id.setter
    def prefix_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix_list_id", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Reason when the association fails.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the prefix list to be queried.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="resourceUid")
    def resource_uid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        """
        return pulumi.get(self, "resource_uid")

    @resource_uid.setter
    def resource_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uid", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Resource attribute fields that represent the status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class TrafficMirrorFilterEgressRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_cidr_block: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_filter_rule_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Collection strategy for outbound rules. Value:
               - accept: collects network traffic.
               - drop: No network traffic is collected.
        :param pulumi.Input[str] protocol: The type of protocol used by the outbound network traffic to be mirrored. Value:
               - ALL: ALL agreements.
               - ICMP: Network Control Message Protocol.
               - TCP: Transmission Control Protocol.
               - UDP: User Datagram Protocol.
        :param pulumi.Input[str] destination_cidr_block: DestinationCidrBlock.
        :param pulumi.Input[str] destination_port_range: The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] source_cidr_block: The source address of the outbound rule network traffic.
        :param pulumi.Input[str] source_port_range: The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Collection strategy for outbound rules. Value:
        - accept: collects network traffic.
        - drop: No network traffic is collected.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The type of protocol used by the outbound network traffic to be mirrored. Value:
        - ALL: ALL agreements.
        - ICMP: Network Control Message Protocol.
        - TCP: Transmission Control Protocol.
        - UDP: User Datagram Protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        DestinationCidrBlock.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The source address of the outbound rule network traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr_block", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")

    @traffic_mirror_filter_rule_status.setter
    def traffic_mirror_filter_rule_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_filter_rule_status", value)


@pulumi.input_type
class TrafficMirrorFilterIngressRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 destination_cidr_block: Optional[pulumi.Input[str]] = None,
                 destination_port_range: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 source_cidr_block: Optional[pulumi.Input[str]] = None,
                 source_port_range: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_filter_rule_status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Collection strategy for outbound rules. Value:
               - accept: collects network traffic.
               - drop: No network traffic is collected.
        :param pulumi.Input[str] protocol: The type of protocol used by the outbound network traffic to be mirrored. Value:
               - ALL: ALL agreements.
               - ICMP: Network Control Message Protocol.
               - TCP: Transmission Control Protocol.
               - UDP: User Datagram Protocol.
        :param pulumi.Input[str] destination_cidr_block: DestinationCidrBlock.
        :param pulumi.Input[str] destination_port_range: The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        :param pulumi.Input[int] priority: Priority.
        :param pulumi.Input[str] source_cidr_block: The source address of the outbound rule network traffic.
        :param pulumi.Input[str] source_port_range: The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Collection strategy for outbound rules. Value:
        - accept: collects network traffic.
        - drop: No network traffic is collected.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        The type of protocol used by the outbound network traffic to be mirrored. Value:
        - ALL: ALL agreements.
        - ICMP: Network Control Message Protocol.
        - TCP: Transmission Control Protocol.
        - UDP: User Datagram Protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        DestinationCidrBlock.
        """
        return pulumi.get(self, "destination_cidr_block")

    @destination_cidr_block.setter
    def destination_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_cidr_block", value)

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "destination_port_range")

    @destination_port_range.setter
    def destination_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_port_range", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        The source address of the outbound rule network traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @source_cidr_block.setter
    def source_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_cidr_block", value)

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[pulumi.Input[str]]:
        """
        The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "source_port_range")

    @source_port_range.setter
    def source_port_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_port_range", value)

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")

    @traffic_mirror_filter_rule_status.setter
    def traffic_mirror_filter_rule_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_filter_rule_status", value)


