# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPbrRouteEntriesResult',
    'AwaitableGetPbrRouteEntriesResult',
    'get_pbr_route_entries',
    'get_pbr_route_entries_output',
]

@pulumi.output_type
class GetPbrRouteEntriesResult:
    """
    A collection of values returned by getPbrRouteEntries.
    """
    def __init__(__self__, entries=None, id=None, ids=None, output_file=None, vpn_gateway_id=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if vpn_gateway_id and not isinstance(vpn_gateway_id, str):
            raise TypeError("Expected argument 'vpn_gateway_id' to be a str")
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetPbrRouteEntriesEntryResult']:
        """
        A list of VPN Pbr Route Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> str:
        """
        The ID of the vpn gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")


class AwaitableGetPbrRouteEntriesResult(GetPbrRouteEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPbrRouteEntriesResult(
            entries=self.entries,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            vpn_gateway_id=self.vpn_gateway_id)


def get_pbr_route_entries(ids: Optional[Sequence[str]] = None,
                          output_file: Optional[str] = None,
                          vpn_gateway_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPbrRouteEntriesResult:
    """
    > **NOTE:** Available in v1.162.0+.

    The data source lists a number of VPN Pbr Route Entries resource information owned by an Alicloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_pbr_route_entries(vpn_gateway_id="example_vpn_gateway_id",
        ids=["example_id"])
    pulumi.export("vpnIpsecServerId1", ids.entries[0].id)
    ```


    :param Sequence[str] ids: A list of VPN Pbr Route Entries IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str vpn_gateway_id: The ID of the VPN gateway.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['vpnGatewayId'] = vpn_gateway_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getPbrRouteEntries:getPbrRouteEntries', __args__, opts=opts, typ=GetPbrRouteEntriesResult).value

    return AwaitableGetPbrRouteEntriesResult(
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        vpn_gateway_id=pulumi.get(__ret__, 'vpn_gateway_id'))


@_utilities.lift_output_func(get_pbr_route_entries)
def get_pbr_route_entries_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPbrRouteEntriesResult]:
    """
    > **NOTE:** Available in v1.162.0+.

    The data source lists a number of VPN Pbr Route Entries resource information owned by an Alicloud account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_pbr_route_entries(vpn_gateway_id="example_vpn_gateway_id",
        ids=["example_id"])
    pulumi.export("vpnIpsecServerId1", ids.entries[0].id)
    ```


    :param Sequence[str] ids: A list of VPN Pbr Route Entries IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str vpn_gateway_id: The ID of the VPN gateway.
    """
    ...
