# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetPublicIpAddressPoolsResult',
    'AwaitableGetPublicIpAddressPoolsResult',
    'get_public_ip_address_pools',
    'get_public_ip_address_pools_output',
]

@pulumi.output_type
class GetPublicIpAddressPoolsResult:
    """
    A collection of values returned by getPublicIpAddressPools.
    """
    def __init__(__self__, id=None, ids=None, isp=None, name_regex=None, names=None, output_file=None, pools=None, public_ip_address_pool_ids=None, public_ip_address_pool_name=None, status=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if isp and not isinstance(isp, str):
            raise TypeError("Expected argument 'isp' to be a str")
        pulumi.set(__self__, "isp", isp)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if pools and not isinstance(pools, list):
            raise TypeError("Expected argument 'pools' to be a list")
        pulumi.set(__self__, "pools", pools)
        if public_ip_address_pool_ids and not isinstance(public_ip_address_pool_ids, list):
            raise TypeError("Expected argument 'public_ip_address_pool_ids' to be a list")
        pulumi.set(__self__, "public_ip_address_pool_ids", public_ip_address_pool_ids)
        if public_ip_address_pool_name and not isinstance(public_ip_address_pool_name, str):
            raise TypeError("Expected argument 'public_ip_address_pool_name' to be a str")
        pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def isp(self) -> Optional[str]:
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def pools(self) -> Sequence['outputs.GetPublicIpAddressPoolsPoolResult']:
        return pulumi.get(self, "pools")

    @property
    @pulumi.getter(name="publicIpAddressPoolIds")
    def public_ip_address_pool_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "public_ip_address_pool_ids")

    @property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> Optional[str]:
        return pulumi.get(self, "public_ip_address_pool_name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetPublicIpAddressPoolsResult(GetPublicIpAddressPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIpAddressPoolsResult(
            id=self.id,
            ids=self.ids,
            isp=self.isp,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            pools=self.pools,
            public_ip_address_pool_ids=self.public_ip_address_pool_ids,
            public_ip_address_pool_name=self.public_ip_address_pool_name,
            status=self.status)


def get_public_ip_address_pools(ids: Optional[Sequence[str]] = None,
                                isp: Optional[str] = None,
                                name_regex: Optional[str] = None,
                                output_file: Optional[str] = None,
                                public_ip_address_pool_ids: Optional[Sequence[str]] = None,
                                public_ip_address_pool_name: Optional[str] = None,
                                status: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIpAddressPoolsResult:
    """
    This data source provides the Vpc Public Ip Address Pools of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.186.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_public_ip_address_pools(ids=["example_id"])
    pulumi.export("vpcPublicIpAddressPoolId1", ids.pools[0].id)
    name_regex = alicloud.vpc.get_public_ip_address_pools(name_regex="example_name")
    pulumi.export("vpcPublicIpAddressPoolId2", name_regex.pools[0].id)
    ```


    :param Sequence[str] ids: A list of Vpc Public Ip Address Pool IDs.
    :param str isp: The Internet service provider.
    :param str name_regex: A regex string to filter results by Vpc Public Ip Address Pool name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[str] public_ip_address_pool_ids: The IDs of the Vpc Public IP address pools.
    :param str public_ip_address_pool_name: The name of the Vpc Public Ip Address Pool.
    :param str status: The status of the Vpc Public Ip Address Pool.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['isp'] = isp
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['publicIpAddressPoolIds'] = public_ip_address_pool_ids
    __args__['publicIpAddressPoolName'] = public_ip_address_pool_name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getPublicIpAddressPools:getPublicIpAddressPools', __args__, opts=opts, typ=GetPublicIpAddressPoolsResult).value

    return AwaitableGetPublicIpAddressPoolsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        isp=pulumi.get(__ret__, 'isp'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        pools=pulumi.get(__ret__, 'pools'),
        public_ip_address_pool_ids=pulumi.get(__ret__, 'public_ip_address_pool_ids'),
        public_ip_address_pool_name=pulumi.get(__ret__, 'public_ip_address_pool_name'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_public_ip_address_pools)
def get_public_ip_address_pools_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       isp: Optional[pulumi.Input[Optional[str]]] = None,
                                       name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                       public_ip_address_pool_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       public_ip_address_pool_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       status: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPublicIpAddressPoolsResult]:
    """
    This data source provides the Vpc Public Ip Address Pools of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.186.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_public_ip_address_pools(ids=["example_id"])
    pulumi.export("vpcPublicIpAddressPoolId1", ids.pools[0].id)
    name_regex = alicloud.vpc.get_public_ip_address_pools(name_regex="example_name")
    pulumi.export("vpcPublicIpAddressPoolId2", name_regex.pools[0].id)
    ```


    :param Sequence[str] ids: A list of Vpc Public Ip Address Pool IDs.
    :param str isp: The Internet service provider.
    :param str name_regex: A regex string to filter results by Vpc Public Ip Address Pool name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param Sequence[str] public_ip_address_pool_ids: The IDs of the Vpc Public IP address pools.
    :param str public_ip_address_pool_name: The name of the Vpc Public Ip Address Pool.
    :param str status: The status of the Vpc Public Ip Address Pool.
    """
    ...
