# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSnatEntriesResult',
    'AwaitableGetSnatEntriesResult',
    'get_snat_entries',
    'get_snat_entries_output',
]

@pulumi.output_type
class GetSnatEntriesResult:
    """
    A collection of values returned by getSnatEntries.
    """
    def __init__(__self__, entries=None, id=None, ids=None, name_regex=None, names=None, output_file=None, snat_entry_name=None, snat_ip=None, snat_table_id=None, source_cidr=None, source_vswitch_id=None, status=None):
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if snat_entry_name and not isinstance(snat_entry_name, str):
            raise TypeError("Expected argument 'snat_entry_name' to be a str")
        pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        if snat_ip and not isinstance(snat_ip, str):
            raise TypeError("Expected argument 'snat_ip' to be a str")
        pulumi.set(__self__, "snat_ip", snat_ip)
        if snat_table_id and not isinstance(snat_table_id, str):
            raise TypeError("Expected argument 'snat_table_id' to be a str")
        pulumi.set(__self__, "snat_table_id", snat_table_id)
        if source_cidr and not isinstance(source_cidr, str):
            raise TypeError("Expected argument 'source_cidr' to be a str")
        pulumi.set(__self__, "source_cidr", source_cidr)
        if source_vswitch_id and not isinstance(source_vswitch_id, str):
            raise TypeError("Expected argument 'source_vswitch_id' to be a str")
        pulumi.set(__self__, "source_vswitch_id", source_vswitch_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetSnatEntriesEntryResult']:
        """
        A list of Snat Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        (Optional) A list of Snat Entries IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> Optional[str]:
        """
        The name of snat entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> Optional[str]:
        """
        The public IP of the Snat Entry.
        """
        return pulumi.get(self, "snat_ip")

    @property
    @pulumi.getter(name="snatTableId")
    def snat_table_id(self) -> str:
        return pulumi.get(self, "snat_table_id")

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> Optional[str]:
        """
        The source CIDR block of the Snat Entry.
        """
        return pulumi.get(self, "source_cidr")

    @property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> Optional[str]:
        """
        The source vswitch ID.
        """
        return pulumi.get(self, "source_vswitch_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the Snat Entry.
        """
        return pulumi.get(self, "status")


class AwaitableGetSnatEntriesResult(GetSnatEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnatEntriesResult(
            entries=self.entries,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            snat_entry_name=self.snat_entry_name,
            snat_ip=self.snat_ip,
            snat_table_id=self.snat_table_id,
            source_cidr=self.source_cidr,
            source_vswitch_id=self.source_vswitch_id,
            status=self.status)


def get_snat_entries(ids: Optional[Sequence[str]] = None,
                     name_regex: Optional[str] = None,
                     output_file: Optional[str] = None,
                     snat_entry_name: Optional[str] = None,
                     snat_ip: Optional[str] = None,
                     snat_table_id: Optional[str] = None,
                     source_cidr: Optional[str] = None,
                     source_vswitch_id: Optional[str] = None,
                     status: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnatEntriesResult:
    """
    This data source provides a list of Snat Entries owned by an Alibaba Cloud account.

    > **NOTE:** Available in 1.37.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "snat-entry-example-name"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    foo_network = alicloud.vpc.Network("fooNetwork", cidr_block="172.16.0.0/12")
    foo_switch = alicloud.vpc.Switch("fooSwitch",
        vpc_id=foo_network.id,
        cidr_block="172.16.0.0/21",
        availability_zone=default.zones[0].id,
        vswitch_name=name)
    foo_nat_gateway = alicloud.vpc.NatGateway("fooNatGateway",
        vpc_id=foo_network.id,
        specification="Small")
    foo_eip_address = alicloud.ecs.EipAddress("fooEipAddress", address_name=name)
    foo_eip_association = alicloud.ecs.EipAssociation("fooEipAssociation",
        allocation_id=foo_eip_address.id,
        instance_id=foo_nat_gateway.id)
    foo_snat_entry = alicloud.vpc.SnatEntry("fooSnatEntry",
        snat_table_id=foo_nat_gateway.snat_table_ids,
        source_vswitch_id=foo_switch.id,
        snat_ip=foo_eip_address.ip_address)
    foo_snat_entries = alicloud.vpc.get_snat_entries_output(snat_table_id=foo_snat_entry.snat_table_id)
    ```


    :param Sequence[str] ids: A list of Snat Entries IDs.
    :param str name_regex: A regex string to filter results by the resource name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str snat_entry_name: The name of snat entry.
    :param str snat_ip: The public IP of the Snat Entry.
    :param str snat_table_id: The ID of the Snat table.
    :param str source_cidr: The source CIDR block of the Snat Entry.
    :param str source_vswitch_id: The source vswitch ID.
    :param str status: The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['snatEntryName'] = snat_entry_name
    __args__['snatIp'] = snat_ip
    __args__['snatTableId'] = snat_table_id
    __args__['sourceCidr'] = source_cidr
    __args__['sourceVswitchId'] = source_vswitch_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getSnatEntries:getSnatEntries', __args__, opts=opts, typ=GetSnatEntriesResult).value

    return AwaitableGetSnatEntriesResult(
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        snat_entry_name=pulumi.get(__ret__, 'snat_entry_name'),
        snat_ip=pulumi.get(__ret__, 'snat_ip'),
        snat_table_id=pulumi.get(__ret__, 'snat_table_id'),
        source_cidr=pulumi.get(__ret__, 'source_cidr'),
        source_vswitch_id=pulumi.get(__ret__, 'source_vswitch_id'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_snat_entries)
def get_snat_entries_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[str]]] = None,
                            snat_entry_name: Optional[pulumi.Input[Optional[str]]] = None,
                            snat_ip: Optional[pulumi.Input[Optional[str]]] = None,
                            snat_table_id: Optional[pulumi.Input[str]] = None,
                            source_cidr: Optional[pulumi.Input[Optional[str]]] = None,
                            source_vswitch_id: Optional[pulumi.Input[Optional[str]]] = None,
                            status: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnatEntriesResult]:
    """
    This data source provides a list of Snat Entries owned by an Alibaba Cloud account.

    > **NOTE:** Available in 1.37.0+.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    config = pulumi.Config()
    name = config.get("name")
    if name is None:
        name = "snat-entry-example-name"
    default = alicloud.get_zones(available_resource_creation="VSwitch")
    foo_network = alicloud.vpc.Network("fooNetwork", cidr_block="172.16.0.0/12")
    foo_switch = alicloud.vpc.Switch("fooSwitch",
        vpc_id=foo_network.id,
        cidr_block="172.16.0.0/21",
        availability_zone=default.zones[0].id,
        vswitch_name=name)
    foo_nat_gateway = alicloud.vpc.NatGateway("fooNatGateway",
        vpc_id=foo_network.id,
        specification="Small")
    foo_eip_address = alicloud.ecs.EipAddress("fooEipAddress", address_name=name)
    foo_eip_association = alicloud.ecs.EipAssociation("fooEipAssociation",
        allocation_id=foo_eip_address.id,
        instance_id=foo_nat_gateway.id)
    foo_snat_entry = alicloud.vpc.SnatEntry("fooSnatEntry",
        snat_table_id=foo_nat_gateway.snat_table_ids,
        source_vswitch_id=foo_switch.id,
        snat_ip=foo_eip_address.ip_address)
    foo_snat_entries = alicloud.vpc.get_snat_entries_output(snat_table_id=foo_snat_entry.snat_table_id)
    ```


    :param Sequence[str] ids: A list of Snat Entries IDs.
    :param str name_regex: A regex string to filter results by the resource name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str snat_entry_name: The name of snat entry.
    :param str snat_ip: The public IP of the Snat Entry.
    :param str snat_table_id: The ID of the Snat table.
    :param str source_cidr: The source CIDR block of the Snat Entry.
    :param str source_vswitch_id: The source vswitch ID.
    :param str status: The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
    """
    ...
