# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrafficMirrorFiltersResult',
    'AwaitableGetTrafficMirrorFiltersResult',
    'get_traffic_mirror_filters',
    'get_traffic_mirror_filters_output',
]

@pulumi.output_type
class GetTrafficMirrorFiltersResult:
    """
    A collection of values returned by getTrafficMirrorFilters.
    """
    def __init__(__self__, filters=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None, traffic_mirror_filter_name=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if traffic_mirror_filter_name and not isinstance(traffic_mirror_filter_name, str):
            raise TypeError("Expected argument 'traffic_mirror_filter_name' to be a str")
        pulumi.set(__self__, "traffic_mirror_filter_name", traffic_mirror_filter_name)

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetTrafficMirrorFiltersFilterResult']:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterName")
    def traffic_mirror_filter_name(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_filter_name")


class AwaitableGetTrafficMirrorFiltersResult(GetTrafficMirrorFiltersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrafficMirrorFiltersResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status,
            traffic_mirror_filter_name=self.traffic_mirror_filter_name)


def get_traffic_mirror_filters(ids: Optional[Sequence[str]] = None,
                               name_regex: Optional[str] = None,
                               output_file: Optional[str] = None,
                               status: Optional[str] = None,
                               traffic_mirror_filter_name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrafficMirrorFiltersResult:
    """
    This data source provides the Vpc Traffic Mirror Filters of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.140.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_traffic_mirror_filters(ids=["example_id"])
    pulumi.export("vpcTrafficMirrorFilterId1", ids.filters[0].id)
    name_regex = alicloud.vpc.get_traffic_mirror_filters(name_regex="^my-TrafficMirrorFilter")
    pulumi.export("vpcTrafficMirrorFilterId2", name_regex.filters[0].id)
    filter_name = alicloud.vpc.get_traffic_mirror_filters(traffic_mirror_filter_name="example_traffic_mirror_filter_name")
    pulumi.export("vpcTrafficMirrorFilterId3", filter_name.filters[0].id)
    status = alicloud.vpc.get_traffic_mirror_filters(status="^my-TrafficMirrorFilter")
    pulumi.export("vpcTrafficMirrorFilterId4", status.filters[0].id)
    ```


    :param Sequence[str] ids: A list of Traffic Mirror Filter IDs.
    :param str name_regex: A regex string to filter results by Traffic Mirror Filter name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
    :param str traffic_mirror_filter_name: The name of the filter.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['trafficMirrorFilterName'] = traffic_mirror_filter_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getTrafficMirrorFilters:getTrafficMirrorFilters', __args__, opts=opts, typ=GetTrafficMirrorFiltersResult).value

    return AwaitableGetTrafficMirrorFiltersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        traffic_mirror_filter_name=pulumi.get(__ret__, 'traffic_mirror_filter_name'))


@_utilities.lift_output_func(get_traffic_mirror_filters)
def get_traffic_mirror_filters_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                      status: Optional[pulumi.Input[Optional[str]]] = None,
                                      traffic_mirror_filter_name: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrafficMirrorFiltersResult]:
    """
    This data source provides the Vpc Traffic Mirror Filters of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.140.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_traffic_mirror_filters(ids=["example_id"])
    pulumi.export("vpcTrafficMirrorFilterId1", ids.filters[0].id)
    name_regex = alicloud.vpc.get_traffic_mirror_filters(name_regex="^my-TrafficMirrorFilter")
    pulumi.export("vpcTrafficMirrorFilterId2", name_regex.filters[0].id)
    filter_name = alicloud.vpc.get_traffic_mirror_filters(traffic_mirror_filter_name="example_traffic_mirror_filter_name")
    pulumi.export("vpcTrafficMirrorFilterId3", filter_name.filters[0].id)
    status = alicloud.vpc.get_traffic_mirror_filters(status="^my-TrafficMirrorFilter")
    pulumi.export("vpcTrafficMirrorFilterId4", status.filters[0].id)
    ```


    :param Sequence[str] ids: A list of Traffic Mirror Filter IDs.
    :param str name_regex: A regex string to filter results by Traffic Mirror Filter name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
    :param str traffic_mirror_filter_name: The name of the filter.
    """
    ...
