# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTrafficMirrorSessionsResult',
    'AwaitableGetTrafficMirrorSessionsResult',
    'get_traffic_mirror_sessions',
    'get_traffic_mirror_sessions_output',
]

@pulumi.output_type
class GetTrafficMirrorSessionsResult:
    """
    A collection of values returned by getTrafficMirrorSessions.
    """
    def __init__(__self__, enabled=None, id=None, ids=None, name_regex=None, names=None, output_file=None, priority=None, sessions=None, status=None, traffic_mirror_filter_id=None, traffic_mirror_session_name=None, traffic_mirror_source_id=None, traffic_mirror_target_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if sessions and not isinstance(sessions, list):
            raise TypeError("Expected argument 'sessions' to be a list")
        pulumi.set(__self__, "sessions", sessions)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if traffic_mirror_filter_id and not isinstance(traffic_mirror_filter_id, str):
            raise TypeError("Expected argument 'traffic_mirror_filter_id' to be a str")
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        if traffic_mirror_session_name and not isinstance(traffic_mirror_session_name, str):
            raise TypeError("Expected argument 'traffic_mirror_session_name' to be a str")
        pulumi.set(__self__, "traffic_mirror_session_name", traffic_mirror_session_name)
        if traffic_mirror_source_id and not isinstance(traffic_mirror_source_id, str):
            raise TypeError("Expected argument 'traffic_mirror_source_id' to be a str")
        pulumi.set(__self__, "traffic_mirror_source_id", traffic_mirror_source_id)
        if traffic_mirror_target_id and not isinstance(traffic_mirror_target_id, str):
            raise TypeError("Expected argument 'traffic_mirror_target_id' to be a str")
        pulumi.set(__self__, "traffic_mirror_target_id", traffic_mirror_target_id)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def sessions(self) -> Sequence['outputs.GetTrafficMirrorSessionsSessionResult']:
        return pulumi.get(self, "sessions")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_session_name")

    @property
    @pulumi.getter(name="trafficMirrorSourceId")
    def traffic_mirror_source_id(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_source_id")

    @property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_target_id")


class AwaitableGetTrafficMirrorSessionsResult(GetTrafficMirrorSessionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrafficMirrorSessionsResult(
            enabled=self.enabled,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            priority=self.priority,
            sessions=self.sessions,
            status=self.status,
            traffic_mirror_filter_id=self.traffic_mirror_filter_id,
            traffic_mirror_session_name=self.traffic_mirror_session_name,
            traffic_mirror_source_id=self.traffic_mirror_source_id,
            traffic_mirror_target_id=self.traffic_mirror_target_id)


def get_traffic_mirror_sessions(enabled: Optional[bool] = None,
                                ids: Optional[Sequence[str]] = None,
                                name_regex: Optional[str] = None,
                                output_file: Optional[str] = None,
                                priority: Optional[int] = None,
                                status: Optional[str] = None,
                                traffic_mirror_filter_id: Optional[str] = None,
                                traffic_mirror_session_name: Optional[str] = None,
                                traffic_mirror_source_id: Optional[str] = None,
                                traffic_mirror_target_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrafficMirrorSessionsResult:
    """
    This data source provides the Vpc Traffic Mirror Sessions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"])
    pulumi.export("vpcTrafficMirrorSessionId1", ids.sessions[0].id)
    name_regex = alicloud.vpc.get_traffic_mirror_sessions(name_regex="^my-TrafficMirrorSession")
    pulumi.export("vpcTrafficMirrorSessionId2", name_regex.sessions[0].id)
    enabled = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        enabled=False)
    pulumi.export("vpcTrafficMirrorSessionId3", enabled.sessions[0].id)
    priority = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        priority=1)
    pulumi.export("vpcTrafficMirrorSessionId4", priority.sessions[0].id)
    filter_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_filter_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId5", filter_id.sessions[0].id)
    session_name = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_session_name="example_value")
    pulumi.export("vpcTrafficMirrorSessionId6", session_name.sessions[0].id)
    source_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_source_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId7", source_id.sessions[0].id)
    target_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_target_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId8", target_id.sessions[0].id)
    status = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        status="Created")
    pulumi.export("vpcTrafficMirrorSessionId9", status.sessions[0].id)
    ```


    :param bool enabled: Indicates whether traffic mirror sessions are enabled. default to `false`.
    :param Sequence[str] ids: A list of Traffic Mirror Session IDs.
    :param str name_regex: A regex string to filter results by Traffic Mirror Session name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int priority: The priority of the traffic mirror session. A smaller value indicates a higher priority.
    :param str status: The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
    :param str traffic_mirror_filter_id: The ID of the filter.
    :param str traffic_mirror_session_name: The name of the traffic mirror session.
    :param str traffic_mirror_source_id: The ID of the mirror source. You can specify only an elastic network interface (ENI) as the mirror source.
    :param str traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
    """
    __args__ = dict()
    __args__['enabled'] = enabled
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['priority'] = priority
    __args__['status'] = status
    __args__['trafficMirrorFilterId'] = traffic_mirror_filter_id
    __args__['trafficMirrorSessionName'] = traffic_mirror_session_name
    __args__['trafficMirrorSourceId'] = traffic_mirror_source_id
    __args__['trafficMirrorTargetId'] = traffic_mirror_target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getTrafficMirrorSessions:getTrafficMirrorSessions', __args__, opts=opts, typ=GetTrafficMirrorSessionsResult).value

    return AwaitableGetTrafficMirrorSessionsResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        priority=pulumi.get(__ret__, 'priority'),
        sessions=pulumi.get(__ret__, 'sessions'),
        status=pulumi.get(__ret__, 'status'),
        traffic_mirror_filter_id=pulumi.get(__ret__, 'traffic_mirror_filter_id'),
        traffic_mirror_session_name=pulumi.get(__ret__, 'traffic_mirror_session_name'),
        traffic_mirror_source_id=pulumi.get(__ret__, 'traffic_mirror_source_id'),
        traffic_mirror_target_id=pulumi.get(__ret__, 'traffic_mirror_target_id'))


@_utilities.lift_output_func(get_traffic_mirror_sessions)
def get_traffic_mirror_sessions_output(enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                       name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                       priority: Optional[pulumi.Input[Optional[int]]] = None,
                                       status: Optional[pulumi.Input[Optional[str]]] = None,
                                       traffic_mirror_filter_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       traffic_mirror_session_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       traffic_mirror_source_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       traffic_mirror_target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrafficMirrorSessionsResult]:
    """
    This data source provides the Vpc Traffic Mirror Sessions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"])
    pulumi.export("vpcTrafficMirrorSessionId1", ids.sessions[0].id)
    name_regex = alicloud.vpc.get_traffic_mirror_sessions(name_regex="^my-TrafficMirrorSession")
    pulumi.export("vpcTrafficMirrorSessionId2", name_regex.sessions[0].id)
    enabled = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        enabled=False)
    pulumi.export("vpcTrafficMirrorSessionId3", enabled.sessions[0].id)
    priority = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        priority=1)
    pulumi.export("vpcTrafficMirrorSessionId4", priority.sessions[0].id)
    filter_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_filter_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId5", filter_id.sessions[0].id)
    session_name = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_session_name="example_value")
    pulumi.export("vpcTrafficMirrorSessionId6", session_name.sessions[0].id)
    source_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_source_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId7", source_id.sessions[0].id)
    target_id = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        traffic_mirror_target_id="example_value")
    pulumi.export("vpcTrafficMirrorSessionId8", target_id.sessions[0].id)
    status = alicloud.vpc.get_traffic_mirror_sessions(ids=["example_id"],
        status="Created")
    pulumi.export("vpcTrafficMirrorSessionId9", status.sessions[0].id)
    ```


    :param bool enabled: Indicates whether traffic mirror sessions are enabled. default to `false`.
    :param Sequence[str] ids: A list of Traffic Mirror Session IDs.
    :param str name_regex: A regex string to filter results by Traffic Mirror Session name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param int priority: The priority of the traffic mirror session. A smaller value indicates a higher priority.
    :param str status: The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
    :param str traffic_mirror_filter_id: The ID of the filter.
    :param str traffic_mirror_session_name: The name of the traffic mirror session.
    :param str traffic_mirror_source_id: The ID of the mirror source. You can specify only an elastic network interface (ENI) as the mirror source.
    :param str traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
    """
    ...
