# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpcFlowLogsResult',
    'AwaitableGetVpcFlowLogsResult',
    'get_vpc_flow_logs',
    'get_vpc_flow_logs_output',
]

@pulumi.output_type
class GetVpcFlowLogsResult:
    """
    A collection of values returned by getVpcFlowLogs.
    """
    def __init__(__self__, description=None, flow_log_name=None, id=None, ids=None, log_store_name=None, logs=None, name_regex=None, names=None, output_file=None, project_name=None, resource_id=None, resource_type=None, status=None, traffic_type=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if flow_log_name and not isinstance(flow_log_name, str):
            raise TypeError("Expected argument 'flow_log_name' to be a str")
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if log_store_name and not isinstance(log_store_name, str):
            raise TypeError("Expected argument 'log_store_name' to be a str")
        pulumi.set(__self__, "log_store_name", log_store_name)
        if logs and not isinstance(logs, list):
            raise TypeError("Expected argument 'logs' to be a list")
        pulumi.set(__self__, "logs", logs)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if traffic_type and not isinstance(traffic_type, str):
            raise TypeError("Expected argument 'traffic_type' to be a str")
        pulumi.set(__self__, "traffic_type", traffic_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> Optional[str]:
        return pulumi.get(self, "flow_log_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> Optional[str]:
        return pulumi.get(self, "log_store_name")

    @property
    @pulumi.getter
    def logs(self) -> Sequence['outputs.GetVpcFlowLogsLogResult']:
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> Optional[str]:
        return pulumi.get(self, "traffic_type")


class AwaitableGetVpcFlowLogsResult(GetVpcFlowLogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcFlowLogsResult(
            description=self.description,
            flow_log_name=self.flow_log_name,
            id=self.id,
            ids=self.ids,
            log_store_name=self.log_store_name,
            logs=self.logs,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            project_name=self.project_name,
            resource_id=self.resource_id,
            resource_type=self.resource_type,
            status=self.status,
            traffic_type=self.traffic_type)


def get_vpc_flow_logs(description: Optional[str] = None,
                      flow_log_name: Optional[str] = None,
                      ids: Optional[Sequence[str]] = None,
                      log_store_name: Optional[str] = None,
                      name_regex: Optional[str] = None,
                      output_file: Optional[str] = None,
                      project_name: Optional[str] = None,
                      resource_id: Optional[str] = None,
                      resource_type: Optional[str] = None,
                      status: Optional[str] = None,
                      traffic_type: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcFlowLogsResult:
    """
    This data source provides the Vpc Flow Logs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.122.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.vpc.get_vpc_flow_logs(ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstVpcFlowLogId", example.logs[0].id)
    ```


    :param str description: The Description of flow log.
    :param str flow_log_name: The flow log name.
    :param Sequence[str] ids: A list of Flow Log IDs.
    :param str log_store_name: The log store name.
    :param str name_regex: A regex string to filter results by Flow Log name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str project_name: The project name.
    :param str resource_id: The resource id.
    :param str resource_type: The resource type.
    :param str status: The status of flow log.
    :param str traffic_type: The traffic type.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['flowLogName'] = flow_log_name
    __args__['ids'] = ids
    __args__['logStoreName'] = log_store_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['resourceId'] = resource_id
    __args__['resourceType'] = resource_type
    __args__['status'] = status
    __args__['trafficType'] = traffic_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpc/getVpcFlowLogs:getVpcFlowLogs', __args__, opts=opts, typ=GetVpcFlowLogsResult).value

    return AwaitableGetVpcFlowLogsResult(
        description=pulumi.get(__ret__, 'description'),
        flow_log_name=pulumi.get(__ret__, 'flow_log_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        log_store_name=pulumi.get(__ret__, 'log_store_name'),
        logs=pulumi.get(__ret__, 'logs'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        status=pulumi.get(__ret__, 'status'),
        traffic_type=pulumi.get(__ret__, 'traffic_type'))


@_utilities.lift_output_func(get_vpc_flow_logs)
def get_vpc_flow_logs_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                             flow_log_name: Optional[pulumi.Input[Optional[str]]] = None,
                             ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                             log_store_name: Optional[pulumi.Input[Optional[str]]] = None,
                             name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                             output_file: Optional[pulumi.Input[Optional[str]]] = None,
                             project_name: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                             resource_type: Optional[pulumi.Input[Optional[str]]] = None,
                             status: Optional[pulumi.Input[Optional[str]]] = None,
                             traffic_type: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpcFlowLogsResult]:
    """
    This data source provides the Vpc Flow Logs of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.122.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.vpc.get_vpc_flow_logs(ids=["example_value"],
        name_regex="the_resource_name")
    pulumi.export("firstVpcFlowLogId", example.logs[0].id)
    ```


    :param str description: The Description of flow log.
    :param str flow_log_name: The flow log name.
    :param Sequence[str] ids: A list of Flow Log IDs.
    :param str log_store_name: The log store name.
    :param str name_regex: A regex string to filter results by Flow Log name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str project_name: The project name.
    :param str resource_id: The resource id.
    :param str resource_type: The resource type.
    :param str status: The status of flow log.
    :param str traffic_type: The traffic type.
    """
    ...
