# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NatIpArgs', 'NatIp']

@pulumi.input_type
class NatIpArgs:
    def __init__(__self__, *,
                 nat_gateway_id: pulumi.Input[str],
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 nat_ip: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr_id: Optional[pulumi.Input[str]] = None,
                 nat_ip_description: Optional[pulumi.Input[str]] = None,
                 nat_ip_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NatIp resource.
        :param pulumi.Input[str] nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        :param pulumi.Input[bool] dry_run: Specifies whether to check the validity of the request without actually making the request.
        :param pulumi.Input[str] nat_ip: The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        :param pulumi.Input[str] nat_ip_cidr: NAT IP ADDRESS of the address segment.
        :param pulumi.Input[str] nat_ip_cidr_id: The ID of the CIDR block to which the NAT IP address belongs.
        :param pulumi.Input[str] nat_ip_description: NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param pulumi.Input[str] nat_ip_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)
        if nat_ip_cidr is not None:
            pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        if nat_ip_cidr_id is not None:
            pulumi.set(__self__, "nat_ip_cidr_id", nat_ip_cidr_id)
        if nat_ip_description is not None:
            pulumi.set(__self__, "nat_ip_description", nat_ip_description)
        if nat_ip_name is not None:
            pulumi.set(__self__, "nat_ip_name", nat_ip_name)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Input[str]:
        """
        The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to check the validity of the request without actually making the request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip", value)

    @property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS of the address segment.
        """
        return pulumi.get(self, "nat_ip_cidr")

    @nat_ip_cidr.setter
    def nat_ip_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_cidr", value)

    @property
    @pulumi.getter(name="natIpCidrId")
    def nat_ip_cidr_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the CIDR block to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_ip_cidr_id")

    @nat_ip_cidr_id.setter
    def nat_ip_cidr_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_cidr_id", value)

    @property
    @pulumi.getter(name="natIpDescription")
    def nat_ip_description(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_description")

    @nat_ip_description.setter
    def nat_ip_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_description", value)

    @property
    @pulumi.getter(name="natIpName")
    def nat_ip_name(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_name")

    @nat_ip_name.setter
    def nat_ip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_name", value)


@pulumi.input_type
class _NatIpState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 nat_ip: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr_id: Optional[pulumi.Input[str]] = None,
                 nat_ip_description: Optional[pulumi.Input[str]] = None,
                 nat_ip_id: Optional[pulumi.Input[str]] = None,
                 nat_ip_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NatIp resources.
        :param pulumi.Input[bool] dry_run: Specifies whether to check the validity of the request without actually making the request.
        :param pulumi.Input[str] nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        :param pulumi.Input[str] nat_ip: The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        :param pulumi.Input[str] nat_ip_cidr: NAT IP ADDRESS of the address segment.
        :param pulumi.Input[str] nat_ip_cidr_id: The ID of the CIDR block to which the NAT IP address belongs.
        :param pulumi.Input[str] nat_ip_description: NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param pulumi.Input[str] nat_ip_id: Ihe ID of the Nat Ip.
        :param pulumi.Input[str] nat_ip_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        :param pulumi.Input[str] status: The status of the NAT IP address. Valid values: `Available`, `Deleting`, `Creating` and `Deleted`.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if nat_gateway_id is not None:
            pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)
        if nat_ip_cidr is not None:
            pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        if nat_ip_cidr_id is not None:
            pulumi.set(__self__, "nat_ip_cidr_id", nat_ip_cidr_id)
        if nat_ip_description is not None:
            pulumi.set(__self__, "nat_ip_description", nat_ip_description)
        if nat_ip_id is not None:
            pulumi.set(__self__, "nat_ip_id", nat_ip_id)
        if nat_ip_name is not None:
            pulumi.set(__self__, "nat_ip_name", nat_ip_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to check the validity of the request without actually making the request.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        """
        return pulumi.get(self, "nat_gateway_id")

    @nat_gateway_id.setter
    def nat_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_gateway_id", value)

    @property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        """
        return pulumi.get(self, "nat_ip")

    @nat_ip.setter
    def nat_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip", value)

    @property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS of the address segment.
        """
        return pulumi.get(self, "nat_ip_cidr")

    @nat_ip_cidr.setter
    def nat_ip_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_cidr", value)

    @property
    @pulumi.getter(name="natIpCidrId")
    def nat_ip_cidr_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the CIDR block to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_ip_cidr_id")

    @nat_ip_cidr_id.setter
    def nat_ip_cidr_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_cidr_id", value)

    @property
    @pulumi.getter(name="natIpDescription")
    def nat_ip_description(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_description")

    @nat_ip_description.setter
    def nat_ip_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_description", value)

    @property
    @pulumi.getter(name="natIpId")
    def nat_ip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Ihe ID of the Nat Ip.
        """
        return pulumi.get(self, "nat_ip_id")

    @nat_ip_id.setter
    def nat_ip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_id", value)

    @property
    @pulumi.getter(name="natIpName")
    def nat_ip_name(self) -> Optional[pulumi.Input[str]]:
        """
        NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_name")

    @nat_ip_name.setter
    def nat_ip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nat_ip_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the NAT IP address. Valid values: `Available`, `Deleting`, `Creating` and `Deleted`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class NatIp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 nat_ip: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr_id: Optional[pulumi.Input[str]] = None,
                 nat_ip_description: Optional[pulumi.Input[str]] = None,
                 nat_ip_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a VPC Nat Ip resource.

        For information about VPC Nat Ip and how to use it, see [What is Nat Ip](https://www.alibabacloud.com/help/doc-detail/281976.htm).

        > **NOTE:** Available in v1.136.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/12")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=example_zones.zones[0].id,
            vswitch_name="terraform-example")
        example_nat_gateway = alicloud.vpc.NatGateway("exampleNatGateway",
            vpc_id=example_network.id,
            internet_charge_type="PayByLcu",
            nat_gateway_name="terraform-example",
            description="terraform-example",
            nat_type="Enhanced",
            vswitch_id=example_switch.id,
            network_type="intranet")
        example_nat_ip_cidr = alicloud.vpc.NatIpCidr("exampleNatIpCidr",
            nat_ip_cidr="192.168.0.0/16",
            nat_gateway_id=example_nat_gateway.id,
            nat_ip_cidr_description="terraform-example",
            nat_ip_cidr_name="terraform-example")
        example_nat_ip = alicloud.vpc.NatIp("exampleNatIp",
            nat_ip="192.168.0.37",
            nat_gateway_id=example_nat_gateway.id,
            nat_ip_description="example_value",
            nat_ip_name="example_value",
            nat_ip_cidr=example_nat_ip_cidr.nat_ip_cidr)
        ```

        ## Import

        VPC Nat Ip can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/natIp:NatIp example <nat_gateway_id>:<nat_ip_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Specifies whether to check the validity of the request without actually making the request.
        :param pulumi.Input[str] nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        :param pulumi.Input[str] nat_ip: The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        :param pulumi.Input[str] nat_ip_cidr: NAT IP ADDRESS of the address segment.
        :param pulumi.Input[str] nat_ip_cidr_id: The ID of the CIDR block to which the NAT IP address belongs.
        :param pulumi.Input[str] nat_ip_description: NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param pulumi.Input[str] nat_ip_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatIpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Nat Ip resource.

        For information about VPC Nat Ip and how to use it, see [What is Nat Ip](https://www.alibabacloud.com/help/doc-detail/281976.htm).

        > **NOTE:** Available in v1.136.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        example_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        example_network = alicloud.vpc.Network("exampleNetwork",
            vpc_name="terraform-example",
            cidr_block="172.16.0.0/12")
        example_switch = alicloud.vpc.Switch("exampleSwitch",
            vpc_id=example_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=example_zones.zones[0].id,
            vswitch_name="terraform-example")
        example_nat_gateway = alicloud.vpc.NatGateway("exampleNatGateway",
            vpc_id=example_network.id,
            internet_charge_type="PayByLcu",
            nat_gateway_name="terraform-example",
            description="terraform-example",
            nat_type="Enhanced",
            vswitch_id=example_switch.id,
            network_type="intranet")
        example_nat_ip_cidr = alicloud.vpc.NatIpCidr("exampleNatIpCidr",
            nat_ip_cidr="192.168.0.0/16",
            nat_gateway_id=example_nat_gateway.id,
            nat_ip_cidr_description="terraform-example",
            nat_ip_cidr_name="terraform-example")
        example_nat_ip = alicloud.vpc.NatIp("exampleNatIp",
            nat_ip="192.168.0.37",
            nat_gateway_id=example_nat_gateway.id,
            nat_ip_description="example_value",
            nat_ip_name="example_value",
            nat_ip_cidr=example_nat_ip_cidr.nat_ip_cidr)
        ```

        ## Import

        VPC Nat Ip can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/natIp:NatIp example <nat_gateway_id>:<nat_ip_id>
        ```

        :param str resource_name: The name of the resource.
        :param NatIpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatIpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 nat_gateway_id: Optional[pulumi.Input[str]] = None,
                 nat_ip: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr: Optional[pulumi.Input[str]] = None,
                 nat_ip_cidr_id: Optional[pulumi.Input[str]] = None,
                 nat_ip_description: Optional[pulumi.Input[str]] = None,
                 nat_ip_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatIpArgs.__new__(NatIpArgs)

            __props__.__dict__["dry_run"] = dry_run
            if nat_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'nat_gateway_id'")
            __props__.__dict__["nat_gateway_id"] = nat_gateway_id
            __props__.__dict__["nat_ip"] = nat_ip
            __props__.__dict__["nat_ip_cidr"] = nat_ip_cidr
            __props__.__dict__["nat_ip_cidr_id"] = nat_ip_cidr_id
            __props__.__dict__["nat_ip_description"] = nat_ip_description
            __props__.__dict__["nat_ip_name"] = nat_ip_name
            __props__.__dict__["nat_ip_id"] = None
            __props__.__dict__["status"] = None
        super(NatIp, __self__).__init__(
            'alicloud:vpc/natIp:NatIp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            nat_gateway_id: Optional[pulumi.Input[str]] = None,
            nat_ip: Optional[pulumi.Input[str]] = None,
            nat_ip_cidr: Optional[pulumi.Input[str]] = None,
            nat_ip_cidr_id: Optional[pulumi.Input[str]] = None,
            nat_ip_description: Optional[pulumi.Input[str]] = None,
            nat_ip_id: Optional[pulumi.Input[str]] = None,
            nat_ip_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'NatIp':
        """
        Get an existing NatIp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Specifies whether to check the validity of the request without actually making the request.
        :param pulumi.Input[str] nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        :param pulumi.Input[str] nat_ip: The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        :param pulumi.Input[str] nat_ip_cidr: NAT IP ADDRESS of the address segment.
        :param pulumi.Input[str] nat_ip_cidr_id: The ID of the CIDR block to which the NAT IP address belongs.
        :param pulumi.Input[str] nat_ip_description: NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param pulumi.Input[str] nat_ip_id: Ihe ID of the Nat Ip.
        :param pulumi.Input[str] nat_ip_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        :param pulumi.Input[str] status: The status of the NAT IP address. Valid values: `Available`, `Deleting`, `Creating` and `Deleted`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatIpState.__new__(_NatIpState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["nat_gateway_id"] = nat_gateway_id
        __props__.__dict__["nat_ip"] = nat_ip
        __props__.__dict__["nat_ip_cidr"] = nat_ip_cidr
        __props__.__dict__["nat_ip_cidr_id"] = nat_ip_cidr_id
        __props__.__dict__["nat_ip_description"] = nat_ip_description
        __props__.__dict__["nat_ip_id"] = nat_ip_id
        __props__.__dict__["nat_ip_name"] = nat_ip_name
        __props__.__dict__["status"] = status
        return NatIp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[bool]:
        """
        Specifies whether to check the validity of the request without actually making the request.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the Virtual Private Cloud (VPC) NAT gateway for which you want to create the NAT IP address.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> pulumi.Output[str]:
        """
        The NAT IP address that you want to create. If you do not specify an IP address, the system selects a random IP address from the specified CIDR block.
        """
        return pulumi.get(self, "nat_ip")

    @property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        NAT IP ADDRESS of the address segment.
        """
        return pulumi.get(self, "nat_ip_cidr")

    @property
    @pulumi.getter(name="natIpCidrId")
    def nat_ip_cidr_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the CIDR block to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_ip_cidr_id")

    @property
    @pulumi.getter(name="natIpDescription")
    def nat_ip_description(self) -> pulumi.Output[Optional[str]]:
        """
        NAT IP ADDRESS description of information. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_description")

    @property
    @pulumi.getter(name="natIpId")
    def nat_ip_id(self) -> pulumi.Output[str]:
        """
        Ihe ID of the Nat Ip.
        """
        return pulumi.get(self, "nat_ip_id")

    @property
    @pulumi.getter(name="natIpName")
    def nat_ip_name(self) -> pulumi.Output[Optional[str]]:
        """
        NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the NAT IP address. Valid values: `Available`, `Deleting`, `Creating` and `Deleted`.
        """
        return pulumi.get(self, "status")

