# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DhcpOptionsSetAssociateVpc',
    'NetworkAclAttachmentResource',
    'NetworkAclEgressAclEntry',
    'NetworkAclEntriesEgress',
    'NetworkAclEntriesIngress',
    'NetworkAclIngressAclEntry',
    'NetworkAclResource',
    'NetworkIpv6CidrBlock',
    'PrefixListEntry',
    'PrefixListPrefixListAssociation',
    'TrafficMirrorFilterEgressRule',
    'TrafficMirrorFilterIngressRule',
    'GetBgpGroupsGroupResult',
    'GetBgpNetworksNetworkResult',
    'GetBgpPeersPeerResult',
    'GetCommonBandwidthPackagesPackageResult',
    'GetCommonBandwidthPackagesPackagePublicIpAddressResult',
    'GetDhcpOptionsSetsSetResult',
    'GetEnhancedNatAvailableZonesZoneResult',
    'GetForwardEntriesEntryResult',
    'GetHavipsHavipResult',
    'GetIpsecServersServerResult',
    'GetIpsecServersServerIkeConfigResult',
    'GetIpsecServersServerIpsecConfigResult',
    'GetIpv4GatewaysGatewayResult',
    'GetIpv6AddressesAddressResult',
    'GetIpv6EgressRulesRuleResult',
    'GetIpv6GatewaysGatewayResult',
    'GetIpv6InternetBandwidthsBandwidthResult',
    'GetNatGatewaysGatewayResult',
    'GetNatIpCidrsCidrResult',
    'GetNatIpsIpResult',
    'GetNetworkAclsAclResult',
    'GetNetworkAclsAclEgressAclEntryResult',
    'GetNetworkAclsAclIngressAclEntryResult',
    'GetNetworkAclsAclResourceResult',
    'GetNetworksVpcResult',
    'GetPbrRouteEntriesEntryResult',
    'GetPeerConnectionsConnectionResult',
    'GetPrefixListsListResult',
    'GetPrefixListsListEntryResult',
    'GetPublicIpAddressPoolCidrBlocksBlockResult',
    'GetPublicIpAddressPoolsPoolResult',
    'GetRouteEntriesEntryResult',
    'GetRouteTablesTableResult',
    'GetRouterInterfacesInterfaceResult',
    'GetSnatEntriesEntryResult',
    'GetSslVpnClientCertsCertResult',
    'GetSslVpnServersServerResult',
    'GetSwitchesVswitchResult',
    'GetTrafficMirrorFilterEgressRulesRuleResult',
    'GetTrafficMirrorFilterIngressRulesRuleResult',
    'GetTrafficMirrorFiltersFilterResult',
    'GetTrafficMirrorSessionsSessionResult',
    'GetVpcFlowLogsLogResult',
]

@pulumi.output_type
class DhcpOptionsSetAssociateVpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcId":
            suggest = "vpc_id"
        elif key == "associateStatus":
            suggest = "associate_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DhcpOptionsSetAssociateVpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DhcpOptionsSetAssociateVpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DhcpOptionsSetAssociateVpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vpc_id: str,
                 associate_status: Optional[str] = None):
        """
        :param str vpc_id: The ID of the VPC network that is associated with the DHCP options set.
        :param str associate_status: The status of the VPC associated with the DHCP option set.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if associate_status is not None:
            pulumi.set(__self__, "associate_status", associate_status)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC network that is associated with the DHCP options set.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="associateStatus")
    def associate_status(self) -> Optional[str]:
        """
        The status of the VPC associated with the DHCP option set.
        """
        return pulumi.get(self, "associate_status")


@pulumi.output_type
class NetworkAclAttachmentResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclAttachmentResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclAttachmentResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclAttachmentResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 resource_type: str):
        """
        :param str resource_id: The resource id that the network acl will associate with.
        :param str resource_type: The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id that the network acl will associate with.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource id that the network acl will associate with. Only support `VSwitch` now.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class NetworkAclEgressAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrIp":
            suggest = "destination_cidr_ip"
        elif key == "networkAclEntryName":
            suggest = "network_acl_entry_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEgressAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEgressAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEgressAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_cidr_ip: Optional[str] = None,
                 network_acl_entry_name: Optional[str] = None,
                 policy: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str description: The description of the outbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param str destination_cidr_ip: The network of the destination address.
        :param str network_acl_entry_name: Name of the outbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param str policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param str port: The destination port range of the outbound rule.When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param str protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the outbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[str]:
        """
        The network of the destination address.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[str]:
        """
        Name of the outbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The destination port range of the outbound rule.When the Protocol type of the outbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the outbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkAclEntriesEgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrIp":
            suggest = "destination_cidr_ip"
        elif key == "entryType":
            suggest = "entry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEntriesEgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEntriesEgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEntriesEgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 destination_cidr_ip: Optional[str] = None,
                 entry_type: Optional[str] = None,
                 name: Optional[str] = None,
                 policy: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None):
        """
        :param str description: The description of the egress entry.
        :param str destination_cidr_ip: The destination ip of the egress entry.
        :param str entry_type: The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        :param str name: The name of the egress entry.
        :param str policy: The policy of the egress entry. It must be `accept` or `drop`.
        :param str port: The port of the egress entry.
        :param str protocol: The protocol of the egress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_cidr_ip is not None:
            pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the egress entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> Optional[str]:
        """
        The destination ip of the egress entry.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[str]:
        """
        The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        """
        return pulumi.get(self, "entry_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the egress entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The policy of the egress entry. It must be `accept` or `drop`.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port of the egress entry.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol of the egress entry.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class NetworkAclEntriesIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryType":
            suggest = "entry_type"
        elif key == "sourceCidrIp":
            suggest = "source_cidr_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclEntriesIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclEntriesIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclEntriesIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 entry_type: Optional[str] = None,
                 name: Optional[str] = None,
                 policy: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 source_cidr_ip: Optional[str] = None):
        """
        :param str description: The description of the egress entry.
        :param str entry_type: The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        :param str name: The name of the egress entry.
        :param str policy: The policy of the egress entry. It must be `accept` or `drop`.
        :param str port: The port of the egress entry.
        :param str protocol: The protocol of the egress entry.
        :param str source_cidr_ip: The source ip of the ingress entry.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entry_type is not None:
            pulumi.set(__self__, "entry_type", entry_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the egress entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entryType")
    def entry_type(self) -> Optional[str]:
        """
        The entry type of the egress entry. It must be `custom` or `system`. Default value is `custom`.
        """
        return pulumi.get(self, "entry_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the egress entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The policy of the egress entry. It must be `accept` or `drop`.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The port of the egress entry.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol of the egress entry.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[str]:
        """
        The source ip of the ingress entry.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class NetworkAclIngressAclEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkAclEntryName":
            suggest = "network_acl_entry_name"
        elif key == "sourceCidrIp":
            suggest = "source_cidr_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclIngressAclEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclIngressAclEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclIngressAclEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 network_acl_entry_name: Optional[str] = None,
                 policy: Optional[str] = None,
                 port: Optional[str] = None,
                 protocol: Optional[str] = None,
                 source_cidr_ip: Optional[str] = None):
        """
        :param str description: Description of the inbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        :param str network_acl_entry_name: The name of the inbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        :param str policy: Authorization policy. Value:
               - accept: Allow.
               - drop: Refused.
        :param str port: The source port range of the inbound rule.When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        :param str protocol: The protocol type. Value:
               - icmp: Network Control Message Protocol.
               - gre: Generic Routing Encapsulation Protocol.
               - tcp: Transmission Control Protocol.
               - udp: User Datagram Protocol.
               - all: Supports all protocols.
        :param str source_cidr_ip: Source address network segment.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_acl_entry_name is not None:
            pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source_cidr_ip is not None:
            pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the inbound rule.The description must be 1 to 256 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> Optional[str]:
        """
        The name of the inbound rule entry.The name must be 1 to 128 characters in length and cannot start with http:// or https.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Authorization policy. Value:
        - accept: Allow.
        - drop: Refused.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The source port range of the inbound rule.When the Protocol type of the inbound rule is all, icmp, or gre, the port range is - 1/-1, indicating that the port is not restricted.When the Protocol type of the inbound rule is tcp or udp, the port range is 1 to 65535, and the format is 1/200 or 80/80, indicating port 1 to port 200 or port 80.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol type. Value:
        - icmp: Network Control Message Protocol.
        - gre: Generic Routing Encapsulation Protocol.
        - tcp: Transmission Control Protocol.
        - udp: User Datagram Protocol.
        - all: Supports all protocols.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> Optional[str]:
        """
        Source address network segment.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class NetworkAclResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkAclResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkAclResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkAclResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 resource_type: str,
                 status: Optional[str] = None):
        """
        :param str resource_id: The ID of the associated resource.
        :param str resource_type: The type of the associated resource.
        :param str status: The status of the associated resource.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the associated resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NetworkIpv6CidrBlock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipv6CidrBlock":
            suggest = "ipv6_cidr_block"
        elif key == "ipv6Isp":
            suggest = "ipv6_isp"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkIpv6CidrBlock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkIpv6CidrBlock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkIpv6CidrBlock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipv6_cidr_block: Optional[str] = None,
                 ipv6_isp: Optional[str] = None):
        """
        :param str ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param str ipv6_isp: The IPv6 address segment type of the VPC. Value:
               - **BGP** (default): Alibaba Cloud BGP IPv6.
               - **ChinaMobile**: China Mobile (single line).
               - **ChinaUnicom**: China Unicom (single line).
               - **ChinaTelecom**: China Telecom (single line).
               > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to **ChinaTelecom** (China Telecom), **ChinaUnicom** (China Unicom), or **ChinaMobile** (China Mobile).
        """
        if ipv6_cidr_block is not None:
            pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        if ipv6_isp is not None:
            pulumi.set(__self__, "ipv6_isp", ipv6_isp)

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> Optional[str]:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="ipv6Isp")
    def ipv6_isp(self) -> Optional[str]:
        """
        The IPv6 address segment type of the VPC. Value:
        - **BGP** (default): Alibaba Cloud BGP IPv6.
        - **ChinaMobile**: China Mobile (single line).
        - **ChinaUnicom**: China Unicom (single line).
        - **ChinaTelecom**: China Telecom (single line).
        > **NOTE:**  If a single-line bandwidth whitelist is enabled, this field can be set to **ChinaTelecom** (China Telecom), **ChinaUnicom** (China Unicom), or **ChinaMobile** (China Mobile).
        """
        return pulumi.get(self, "ipv6_isp")


@pulumi.output_type
class PrefixListEntry(dict):
    def __init__(__self__, *,
                 cidr: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str cidr: The CIDR address block of the prefix list.
        :param str description: The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the cidr entry. It must be 2 to 256 characters in length and must start with a letter or Chinese, but cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class PrefixListPrefixListAssociation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ownerId":
            suggest = "owner_id"
        elif key == "prefixListId":
            suggest = "prefix_list_id"
        elif key == "regionId":
            suggest = "region_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "resourceUid":
            suggest = "resource_uid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrefixListPrefixListAssociation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrefixListPrefixListAssociation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrefixListPrefixListAssociation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 owner_id: Optional[str] = None,
                 prefix_list_id: Optional[str] = None,
                 reason: Optional[str] = None,
                 region_id: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 resource_type: Optional[str] = None,
                 resource_uid: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str owner_id: The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        :param str prefix_list_id: The ID of the query Prefix List.
        :param str reason: Reason when the association fails.
        :param str region_id: The region ID of the prefix list to be queried.
        :param str resource_id: The ID of the associated resource.
        :param str resource_type: The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        :param str resource_uid: The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        :param str status: Resource attribute fields that represent the status of the resource.
        """
        if owner_id is not None:
            pulumi.set(__self__, "owner_id", owner_id)
        if prefix_list_id is not None:
            pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if resource_uid is not None:
            pulumi.set(__self__, "resource_uid", resource_uid)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> Optional[str]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the prefix list belongs.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> Optional[str]:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter
    def reason(self) -> Optional[str]:
        """
        Reason when the association fails.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[str]:
        """
        The region ID of the prefix list to be queried.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        The associated resource type. Value:-**vpcRouteTable**: The VPC route table.-**trRouteTable**: the routing table of the forwarding router.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="resourceUid")
    def resource_uid(self) -> Optional[str]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the resource bound to the prefix list belongs.
        """
        return pulumi.get(self, "resource_uid")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Resource attribute fields that represent the status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class TrafficMirrorFilterEgressRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrBlock":
            suggest = "destination_cidr_block"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "sourceCidrBlock":
            suggest = "source_cidr_block"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "trafficMirrorFilterRuleStatus":
            suggest = "traffic_mirror_filter_rule_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficMirrorFilterEgressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficMirrorFilterEgressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficMirrorFilterEgressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 protocol: str,
                 destination_cidr_block: Optional[str] = None,
                 destination_port_range: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_cidr_block: Optional[str] = None,
                 source_port_range: Optional[str] = None,
                 traffic_mirror_filter_rule_status: Optional[str] = None):
        """
        :param str action: Collection strategy for outbound rules. Value:
               - accept: collects network traffic.
               - drop: No network traffic is collected.
        :param str protocol: The type of protocol used by the outbound network traffic to be mirrored. Value:
               - ALL: ALL agreements.
               - ICMP: Network Control Message Protocol.
               - TCP: Transmission Control Protocol.
               - UDP: User Datagram Protocol.
        :param str destination_cidr_block: DestinationCidrBlock.
        :param str destination_port_range: The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        :param int priority: Priority.
        :param str source_cidr_block: The source address of the outbound rule network traffic.
        :param str source_port_range: The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Collection strategy for outbound rules. Value:
        - accept: collects network traffic.
        - drop: No network traffic is collected.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of protocol used by the outbound network traffic to be mirrored. Value:
        - ALL: ALL agreements.
        - ICMP: Network Control Message Protocol.
        - TCP: Transmission Control Protocol.
        - UDP: User Datagram Protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[str]:
        """
        DestinationCidrBlock.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[str]:
        """
        The source address of the outbound rule network traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")


@pulumi.output_type
class TrafficMirrorFilterIngressRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationCidrBlock":
            suggest = "destination_cidr_block"
        elif key == "destinationPortRange":
            suggest = "destination_port_range"
        elif key == "sourceCidrBlock":
            suggest = "source_cidr_block"
        elif key == "sourcePortRange":
            suggest = "source_port_range"
        elif key == "trafficMirrorFilterRuleStatus":
            suggest = "traffic_mirror_filter_rule_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TrafficMirrorFilterIngressRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TrafficMirrorFilterIngressRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TrafficMirrorFilterIngressRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: str,
                 protocol: str,
                 destination_cidr_block: Optional[str] = None,
                 destination_port_range: Optional[str] = None,
                 priority: Optional[int] = None,
                 source_cidr_block: Optional[str] = None,
                 source_port_range: Optional[str] = None,
                 traffic_mirror_filter_rule_status: Optional[str] = None):
        """
        :param str action: Collection strategy for outbound rules. Value:
               - accept: collects network traffic.
               - drop: No network traffic is collected.
        :param str protocol: The type of protocol used by the outbound network traffic to be mirrored. Value:
               - ALL: ALL agreements.
               - ICMP: Network Control Message Protocol.
               - TCP: Transmission Control Protocol.
               - UDP: User Datagram Protocol.
        :param str destination_cidr_block: DestinationCidrBlock.
        :param str destination_port_range: The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        :param int priority: Priority.
        :param str source_cidr_block: The source address of the outbound rule network traffic.
        :param str source_port_range: The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
               > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "protocol", protocol)
        if destination_cidr_block is not None:
            pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if destination_port_range is not None:
            pulumi.set(__self__, "destination_port_range", destination_port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if source_cidr_block is not None:
            pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        if source_port_range is not None:
            pulumi.set(__self__, "source_port_range", source_port_range)
        if traffic_mirror_filter_rule_status is not None:
            pulumi.set(__self__, "traffic_mirror_filter_rule_status", traffic_mirror_filter_rule_status)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Collection strategy for outbound rules. Value:
        - accept: collects network traffic.
        - drop: No network traffic is collected.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of protocol used by the outbound network traffic to be mirrored. Value:
        - ALL: ALL agreements.
        - ICMP: Network Control Message Protocol.
        - TCP: Transmission Control Protocol.
        - UDP: User Datagram Protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[str]:
        """
        DestinationCidrBlock.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> Optional[str]:
        """
        The destination port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        Priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> Optional[str]:
        """
        The source address of the outbound rule network traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> Optional[str]:
        """
        The source port range of the outbound rule network traffic. The port range is 1 to 65535. Use a forward slash (/) to separate the start port and the end Port. The format is 1/200 and 80/80. Among them, - 1/-1 cannot be set separately, which means that the port is not limited.
        > **NOTE:**  When egresrules. N.Protocol is set to ALL or ICMP, this parameter does not need to be configured, indicating that the port is not restricted.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleStatus")
    def traffic_mirror_filter_rule_status(self) -> Optional[str]:
        return pulumi.get(self, "traffic_mirror_filter_rule_status")


@pulumi.output_type
class GetBgpGroupsGroupResult(dict):
    def __init__(__self__, *,
                 auth_key: str,
                 bgp_group_name: str,
                 description: str,
                 hold: str,
                 id: str,
                 ip_version: str,
                 is_fake_asn: bool,
                 keepalive: str,
                 local_asn: int,
                 peer_asn: int,
                 route_limit: str,
                 router_id: str,
                 status: str):
        """
        :param str auth_key: The key used by the BGP group.
        :param str bgp_group_name: The name of the BGP group.
        :param str description: Description of the BGP group.
        :param str hold: The hold time to wait for the incoming BGP message. If no message has been passed in after the hold time, the BGP neighbor is considered disconnected.
        :param str id: The ID of the Bgp Group.
        :param str ip_version: IP version.
        :param bool is_fake_asn: Whether the AS number is false.
        :param str keepalive: The keepalive time.
        :param int local_asn: The local AS number.
        :param int peer_asn: The autonomous system (AS) number of the BGP peer.
        :param str route_limit: Routing limits.
        :param str router_id: The ID of the VBR.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "auth_key", auth_key)
        pulumi.set(__self__, "bgp_group_name", bgp_group_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hold", hold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_fake_asn", is_fake_asn)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "route_limit", route_limit)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> str:
        """
        The key used by the BGP group.
        """
        return pulumi.get(self, "auth_key")

    @property
    @pulumi.getter(name="bgpGroupName")
    def bgp_group_name(self) -> str:
        """
        The name of the BGP group.
        """
        return pulumi.get(self, "bgp_group_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the BGP group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hold(self) -> str:
        """
        The hold time to wait for the incoming BGP message. If no message has been passed in after the hold time, the BGP neighbor is considered disconnected.
        """
        return pulumi.get(self, "hold")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Bgp Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        IP version.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isFakeAsn")
    def is_fake_asn(self) -> bool:
        """
        Whether the AS number is false.
        """
        return pulumi.get(self, "is_fake_asn")

    @property
    @pulumi.getter
    def keepalive(self) -> str:
        """
        The keepalive time.
        """
        return pulumi.get(self, "keepalive")

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> int:
        """
        The local AS number.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> int:
        """
        The autonomous system (AS) number of the BGP peer.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="routeLimit")
    def route_limit(self) -> str:
        """
        Routing limits.
        """
        return pulumi.get(self, "route_limit")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The ID of the VBR.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBgpNetworksNetworkResult(dict):
    def __init__(__self__, *,
                 dst_cidr_block: str,
                 id: str,
                 router_id: str,
                 status: str):
        """
        :param str dst_cidr_block: Advertised BGP networks.
        :param str id: The ID of the Bgp Network. The value formats as `<router_id>:<dst_cidr_block>`.
        :param str router_id: The ID of the vRouter.
        :param str status: The state of the advertised BGP network.
        """
        pulumi.set(__self__, "dst_cidr_block", dst_cidr_block)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dstCidrBlock")
    def dst_cidr_block(self) -> str:
        """
        Advertised BGP networks.
        """
        return pulumi.get(self, "dst_cidr_block")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Bgp Network. The value formats as `<router_id>:<dst_cidr_block>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The ID of the vRouter.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the advertised BGP network.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetBgpPeersPeerResult(dict):
    def __init__(__self__, *,
                 auth_key: str,
                 bfd_multi_hop: int,
                 bgp_group_id: str,
                 bgp_peer_id: str,
                 bgp_peer_name: str,
                 bgp_status: str,
                 description: str,
                 enable_bfd: bool,
                 hold: str,
                 id: str,
                 ip_version: str,
                 is_fake: bool,
                 keepalive: str,
                 local_asn: str,
                 peer_asn: str,
                 peer_ip_address: str,
                 route_limit: str,
                 router_id: str,
                 status: str):
        """
        :param str auth_key: The authentication key of the BGP group.
        :param int bfd_multi_hop: The BFD hop count.
        :param str bgp_group_id: The ID of the BGP group.
        :param str bgp_peer_id: The ID of the BGP neighbor.
        :param str bgp_peer_name: The name of the BGP neighbor.
        :param str bgp_status: The status of the BGP connection.
        :param str description: The description of the BGP group.
        :param bool enable_bfd: Indicates whether the Bidirectional Forwarding Detection (BFD) protocol is enabled.
        :param str hold: The hold time.
        :param str id: The ID of the Bgp Peer.
        :param str ip_version: The IP version.
        :param bool is_fake: Indicates whether a fake AS number is used.
        :param str keepalive: The keepalive time.
        :param str local_asn: The AS number of the device on the Alibaba Cloud side.
        :param str peer_asn: The autonomous system (AS) number of the BGP peer.
        :param str peer_ip_address: The IP address of the BGP neighbor.
        :param str route_limit: The limit on routes.
        :param str router_id: The ID of the router.
        :param str status: The status of the BGP peer.
        """
        pulumi.set(__self__, "auth_key", auth_key)
        pulumi.set(__self__, "bfd_multi_hop", bfd_multi_hop)
        pulumi.set(__self__, "bgp_group_id", bgp_group_id)
        pulumi.set(__self__, "bgp_peer_id", bgp_peer_id)
        pulumi.set(__self__, "bgp_peer_name", bgp_peer_name)
        pulumi.set(__self__, "bgp_status", bgp_status)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_bfd", enable_bfd)
        pulumi.set(__self__, "hold", hold)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "is_fake", is_fake)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        pulumi.set(__self__, "route_limit", route_limit)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> str:
        """
        The authentication key of the BGP group.
        """
        return pulumi.get(self, "auth_key")

    @property
    @pulumi.getter(name="bfdMultiHop")
    def bfd_multi_hop(self) -> int:
        """
        The BFD hop count.
        """
        return pulumi.get(self, "bfd_multi_hop")

    @property
    @pulumi.getter(name="bgpGroupId")
    def bgp_group_id(self) -> str:
        """
        The ID of the BGP group.
        """
        return pulumi.get(self, "bgp_group_id")

    @property
    @pulumi.getter(name="bgpPeerId")
    def bgp_peer_id(self) -> str:
        """
        The ID of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_id")

    @property
    @pulumi.getter(name="bgpPeerName")
    def bgp_peer_name(self) -> str:
        """
        The name of the BGP neighbor.
        """
        return pulumi.get(self, "bgp_peer_name")

    @property
    @pulumi.getter(name="bgpStatus")
    def bgp_status(self) -> str:
        """
        The status of the BGP connection.
        """
        return pulumi.get(self, "bgp_status")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the BGP group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableBfd")
    def enable_bfd(self) -> bool:
        """
        Indicates whether the Bidirectional Forwarding Detection (BFD) protocol is enabled.
        """
        return pulumi.get(self, "enable_bfd")

    @property
    @pulumi.getter
    def hold(self) -> str:
        """
        The hold time.
        """
        return pulumi.get(self, "hold")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Bgp Peer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The IP version.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isFake")
    def is_fake(self) -> bool:
        """
        Indicates whether a fake AS number is used.
        """
        return pulumi.get(self, "is_fake")

    @property
    @pulumi.getter
    def keepalive(self) -> str:
        """
        The keepalive time.
        """
        return pulumi.get(self, "keepalive")

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> str:
        """
        The AS number of the device on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> str:
        """
        The autonomous system (AS) number of the BGP peer.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> str:
        """
        The IP address of the BGP neighbor.
        """
        return pulumi.get(self, "peer_ip_address")

    @property
    @pulumi.getter(name="routeLimit")
    def route_limit(self) -> str:
        """
        The limit on routes.
        """
        return pulumi.get(self, "route_limit")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The ID of the router.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the BGP peer.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCommonBandwidthPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: str,
                 bandwidth_package_id: str,
                 bandwidth_package_name: str,
                 business_status: str,
                 deletion_protection: bool,
                 description: str,
                 expired_time: str,
                 has_reservation_data: bool,
                 id: str,
                 internet_charge_type: str,
                 isp: str,
                 name: str,
                 payment_type: str,
                 public_ip_addresses: Sequence['outputs.GetCommonBandwidthPackagesPackagePublicIpAddressResult'],
                 ratio: int,
                 reservation_active_time: str,
                 reservation_bandwidth: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 resource_group_id: str,
                 service_managed: int,
                 status: str):
        """
        :param str bandwidth: The peak bandwidth of the Internet Shared Bandwidth instance.
        :param str bandwidth_package_id: The resource ID of bandwidth package.
        :param str bandwidth_package_name: The name of bandwidth package.
        :param str business_status: The business status of the Common Bandwidth Package instance.
        :param bool deletion_protection: The deletion protection of bandwidth package.
        :param str description: The description of the Common Bandwidth Package instance.
        :param str expired_time: The expired time of bandwidth package.
        :param bool has_reservation_data: Is has reservation data.
        :param str id: ID of the Common Bandwidth Package.
        :param str internet_charge_type: The internet charge type of bandwidth package.
        :param str isp: ISP of the Common Bandwidth Package.
        :param str name: Name of the Common Bandwidth Package.
        :param str payment_type: The payment type of bandwidth package.
        :param Sequence['GetCommonBandwidthPackagesPackagePublicIpAddressArgs'] public_ip_addresses: Public ip addresses that in the Common Bandwidth Pakcage.
        :param int ratio: The ratio of bandwidth package.
        :param str reservation_active_time: The active time of reservation.
        :param str reservation_bandwidth: The bandwidth of reservation.
        :param str reservation_internet_charge_type: The charge type of reservation internet.
        :param str reservation_order_type: The type of reservation order.
        :param str resource_group_id: The Id of resource group which the common bandwidth package belongs.
        :param int service_managed: The service managed.
        :param str status: The status of bandwidth package. Valid values: `Available` and `Pending`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "bandwidth_package_name", bandwidth_package_name)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "ratio", ratio)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "service_managed", service_managed)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        The peak bandwidth of the Internet Shared Bandwidth instance.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> str:
        """
        The resource ID of bandwidth package.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @property
    @pulumi.getter(name="bandwidthPackageName")
    def bandwidth_package_name(self) -> str:
        """
        The name of bandwidth package.
        """
        return pulumi.get(self, "bandwidth_package_name")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The business status of the Common Bandwidth Package instance.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        The deletion protection of bandwidth package.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Common Bandwidth Package instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expired time of bandwidth package.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> bool:
        """
        Is has reservation data.
        """
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the Common Bandwidth Package.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The internet charge type of bandwidth package.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        ISP of the Common Bandwidth Package.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Common Bandwidth Package.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of bandwidth package.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence['outputs.GetCommonBandwidthPackagesPackagePublicIpAddressResult']:
        """
        Public ip addresses that in the Common Bandwidth Pakcage.
        """
        return pulumi.get(self, "public_ip_addresses")

    @property
    @pulumi.getter
    def ratio(self) -> int:
        """
        The ratio of bandwidth package.
        """
        return pulumi.get(self, "ratio")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        """
        The active time of reservation.
        """
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> str:
        """
        The bandwidth of reservation.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        """
        The charge type of reservation internet.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        """
        The type of reservation order.
        """
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the common bandwidth package belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> int:
        """
        The service managed.
        """
        return pulumi.get(self, "service_managed")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of bandwidth package. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCommonBandwidthPackagesPackagePublicIpAddressResult(dict):
    def __init__(__self__, *,
                 allocation_id: str,
                 bandwidth_package_ip_relation_status: str,
                 ip_address: str):
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "bandwidth_package_ip_relation_status", bandwidth_package_ip_relation_status)
        pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> str:
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="bandwidthPackageIpRelationStatus")
    def bandwidth_package_ip_relation_status(self) -> str:
        return pulumi.get(self, "bandwidth_package_ip_relation_status")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class GetDhcpOptionsSetsSetResult(dict):
    def __init__(__self__, *,
                 associate_vpc_count: int,
                 dhcp_options_set_description: str,
                 dhcp_options_set_id: str,
                 dhcp_options_set_name: str,
                 domain_name: str,
                 domain_name_servers: str,
                 id: str,
                 owner_id: str,
                 status: str):
        """
        :param int associate_vpc_count: The Number of VPCs bound by the DHCP option set.
        :param str dhcp_options_set_description: The description of the DHCP options set. The description must be 2 to 256
               characters in length and cannot start with `http://` or `https://`.
        :param str dhcp_options_set_name: The root domain, for example, example.com. After a DHCP options set is associated with a
               Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the
               ECS instances in the VPC network.
        :param str domain_name: The root domain, for example, example.com. After a DHCP options set is associated with a Virtual
               Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS
               instances in the VPC network.
        :param str domain_name_servers: The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP
               addresses must be separated with commas (,).
        :param str owner_id: The ID of the account to which the DHCP options set belongs.
        :param str status: The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
        """
        pulumi.set(__self__, "associate_vpc_count", associate_vpc_count)
        pulumi.set(__self__, "dhcp_options_set_description", dhcp_options_set_description)
        pulumi.set(__self__, "dhcp_options_set_id", dhcp_options_set_id)
        pulumi.set(__self__, "dhcp_options_set_name", dhcp_options_set_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_name_servers", domain_name_servers)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="associateVpcCount")
    def associate_vpc_count(self) -> int:
        """
        The Number of VPCs bound by the DHCP option set.
        """
        return pulumi.get(self, "associate_vpc_count")

    @property
    @pulumi.getter(name="dhcpOptionsSetDescription")
    def dhcp_options_set_description(self) -> str:
        """
        The description of the DHCP options set. The description must be 2 to 256
        characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "dhcp_options_set_description")

    @property
    @pulumi.getter(name="dhcpOptionsSetId")
    def dhcp_options_set_id(self) -> str:
        return pulumi.get(self, "dhcp_options_set_id")

    @property
    @pulumi.getter(name="dhcpOptionsSetName")
    def dhcp_options_set_name(self) -> str:
        """
        The root domain, for example, example.com. After a DHCP options set is associated with a
        Virtual Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the
        ECS instances in the VPC network.
        """
        return pulumi.get(self, "dhcp_options_set_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The root domain, for example, example.com. After a DHCP options set is associated with a Virtual
        Private Cloud (VPC) network, the root domain in the DHCP options set is automatically synchronized to the ECS
        instances in the VPC network.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainNameServers")
    def domain_name_servers(self) -> str:
        """
        The DNS server IP addresses. Up to four DNS server IP addresses can be specified. IP
        addresses must be separated with commas (,).
        """
        return pulumi.get(self, "domain_name_servers")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The ID of the account to which the DHCP options set belongs.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the DHCP options set. Valid values: `Available`, `InUse` or `Pending`. `Available`: The DHCP options set is available for use. `InUse`: The DHCP options set is in use. `Pending`: The DHCP options set is being configured.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEnhancedNatAvailableZonesZoneResult(dict):
    def __init__(__self__, *,
                 local_name: str,
                 zone_id: str):
        pulumi.set(__self__, "local_name", local_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="localName")
    def local_name(self) -> str:
        return pulumi.get(self, "local_name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetForwardEntriesEntryResult(dict):
    def __init__(__self__, *,
                 external_ip: str,
                 external_port: str,
                 forward_entry_id: str,
                 forward_entry_name: str,
                 id: str,
                 internal_ip: str,
                 internal_port: str,
                 ip_protocol: str,
                 name: str,
                 status: str):
        """
        :param str external_ip: The public IP address.
        :param str external_port: The public port.
        :param str forward_entry_id: The forward entry ID.
        :param str forward_entry_name: The name of forward entry.
        :param str id: The ID of the Forward Entry.
        :param str internal_ip: The private IP address.
        :param str internal_port: The internal port.
        :param str ip_protocol: The ip protocol. Valid values: `any`,`tcp` and `udp`.
        :param str name: The forward entry name.
        :param str status: The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
        """
        pulumi.set(__self__, "external_ip", external_ip)
        pulumi.set(__self__, "external_port", external_port)
        pulumi.set(__self__, "forward_entry_id", forward_entry_id)
        pulumi.set(__self__, "forward_entry_name", forward_entry_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internal_ip", internal_ip)
        pulumi.set(__self__, "internal_port", internal_port)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="externalIp")
    def external_ip(self) -> str:
        """
        The public IP address.
        """
        return pulumi.get(self, "external_ip")

    @property
    @pulumi.getter(name="externalPort")
    def external_port(self) -> str:
        """
        The public port.
        """
        return pulumi.get(self, "external_port")

    @property
    @pulumi.getter(name="forwardEntryId")
    def forward_entry_id(self) -> str:
        """
        The forward entry ID.
        """
        return pulumi.get(self, "forward_entry_id")

    @property
    @pulumi.getter(name="forwardEntryName")
    def forward_entry_name(self) -> str:
        """
        The name of forward entry.
        """
        return pulumi.get(self, "forward_entry_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Forward Entry.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalIp")
    def internal_ip(self) -> str:
        """
        The private IP address.
        """
        return pulumi.get(self, "internal_ip")

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> str:
        """
        The internal port.
        """
        return pulumi.get(self, "internal_port")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The ip protocol. Valid values: `any`,`tcp` and `udp`.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The forward entry name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of farward entry. Valid value `Available`, `Deleting` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetHavipsHavipResult(dict):
    def __init__(__self__, *,
                 associated_eip_addresses: Sequence[str],
                 associated_instances: Sequence[str],
                 description: str,
                 havip_id: str,
                 havip_name: str,
                 id: str,
                 ip_address: str,
                 master_instance_id: str,
                 status: str,
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param Sequence[str] associated_eip_addresses: EIP bound to HaVip.
        :param Sequence[str] associated_instances: An ECS instance that is bound to HaVip.
        :param str description: Dependence of a HaVip instance.
        :param str havip_id: The  ID of the resource.
        :param str havip_name: The name of the HaVip instance.
        :param str id: The ID of the Ha Vip.
        :param str ip_address: IP address of private network.
        :param str master_instance_id: The primary instance ID bound to HaVip.
        :param str status: The status.
        :param str vpc_id: The VPC ID to which the HaVip instance belongs.
        :param str vswitch_id: The vswitch id.
        """
        pulumi.set(__self__, "associated_eip_addresses", associated_eip_addresses)
        pulumi.set(__self__, "associated_instances", associated_instances)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "havip_id", havip_id)
        pulumi.set(__self__, "havip_name", havip_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "master_instance_id", master_instance_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="associatedEipAddresses")
    def associated_eip_addresses(self) -> Sequence[str]:
        """
        EIP bound to HaVip.
        """
        return pulumi.get(self, "associated_eip_addresses")

    @property
    @pulumi.getter(name="associatedInstances")
    def associated_instances(self) -> Sequence[str]:
        """
        An ECS instance that is bound to HaVip.
        """
        return pulumi.get(self, "associated_instances")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Dependence of a HaVip instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="havipId")
    def havip_id(self) -> str:
        """
        The  ID of the resource.
        """
        return pulumi.get(self, "havip_id")

    @property
    @pulumi.getter(name="havipName")
    def havip_name(self) -> str:
        """
        The name of the HaVip instance.
        """
        return pulumi.get(self, "havip_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ha Vip.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        IP address of private network.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> str:
        """
        The primary instance ID bound to HaVip.
        """
        return pulumi.get(self, "master_instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC ID to which the HaVip instance belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetIpsecServersServerResult(dict):
    def __init__(__self__, *,
                 client_ip_pool: str,
                 create_time: str,
                 effect_immediately: bool,
                 id: str,
                 idaas_instance_id: str,
                 ike_configs: Sequence['outputs.GetIpsecServersServerIkeConfigResult'],
                 internet_ip: str,
                 ipsec_configs: Sequence['outputs.GetIpsecServersServerIpsecConfigResult'],
                 ipsec_server_id: str,
                 ipsec_server_name: str,
                 local_subnet: str,
                 max_connections: int,
                 multi_factor_auth_enabled: bool,
                 online_client_count: int,
                 psk: str,
                 psk_enabled: bool,
                 vpn_gateway_id: str):
        """
        :param str client_ip_pool: The CIDR block of the client, which is assigned an access address to the virtual NIC of the client.
        :param str create_time: The creation time of the IPsec server. T represents the delimiter, and Z represents UTC, which is World Standard Time.
        :param bool effect_immediately: Indicates whether the current IPsec tunnel is deleted and negotiations are reinitiated.
        :param str id: The ID of the Ipsec Server.
        :param str idaas_instance_id: The ID of the Identity as a Service (IDaaS) instance.
        :param Sequence['GetIpsecServersServerIkeConfigArgs'] ike_configs: The configurations of Phase 1 negotiations.
        :param str internet_ip: The public IP address of the VPN gateway.
        :param Sequence['GetIpsecServersServerIpsecConfigArgs'] ipsec_configs: The configuration of Phase 2 negotiations.
        :param str ipsec_server_id: The ID of the IPsec server.
        :param str ipsec_server_name: The name of the IPsec server.
        :param str local_subnet: Local network segment: the network segment on The VPC side that needs to be interconnected with the client network segment.
        :param int max_connections: The number of SSL connections of the VPN gateway. SSL-VPN the number of SSL connections shared with the IPsec server. For example, if the number of SSL connections is 5 and you have three SSL clients connected to the SSL-VPN, you can also use two clients to connect to the IPsec server.
        :param bool multi_factor_auth_enabled: Whether the two-factor authentication function has been turned on.
        :param int online_client_count: The number of clients that have connected to the IPsec server.
        :param str psk: The pre-shared key.
        :param bool psk_enabled: Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
        :param str vpn_gateway_id: The ID of the VPN gateway.
        """
        pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idaas_instance_id", idaas_instance_id)
        pulumi.set(__self__, "ike_configs", ike_configs)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        pulumi.set(__self__, "ipsec_server_id", ipsec_server_id)
        pulumi.set(__self__, "ipsec_server_name", ipsec_server_name)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "multi_factor_auth_enabled", multi_factor_auth_enabled)
        pulumi.set(__self__, "online_client_count", online_client_count)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "psk_enabled", psk_enabled)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> str:
        """
        The CIDR block of the client, which is assigned an access address to the virtual NIC of the client.
        """
        return pulumi.get(self, "client_ip_pool")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the IPsec server. T represents the delimiter, and Z represents UTC, which is World Standard Time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> bool:
        """
        Indicates whether the current IPsec tunnel is deleted and negotiations are reinitiated.
        """
        return pulumi.get(self, "effect_immediately")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipsec Server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idaasInstanceId")
    def idaas_instance_id(self) -> str:
        """
        The ID of the Identity as a Service (IDaaS) instance.
        """
        return pulumi.get(self, "idaas_instance_id")

    @property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Sequence['outputs.GetIpsecServersServerIkeConfigResult']:
        """
        The configurations of Phase 1 negotiations.
        """
        return pulumi.get(self, "ike_configs")

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> str:
        """
        The public IP address of the VPN gateway.
        """
        return pulumi.get(self, "internet_ip")

    @property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Sequence['outputs.GetIpsecServersServerIpsecConfigResult']:
        """
        The configuration of Phase 2 negotiations.
        """
        return pulumi.get(self, "ipsec_configs")

    @property
    @pulumi.getter(name="ipsecServerId")
    def ipsec_server_id(self) -> str:
        """
        The ID of the IPsec server.
        """
        return pulumi.get(self, "ipsec_server_id")

    @property
    @pulumi.getter(name="ipsecServerName")
    def ipsec_server_name(self) -> str:
        """
        The name of the IPsec server.
        """
        return pulumi.get(self, "ipsec_server_name")

    @property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> str:
        """
        Local network segment: the network segment on The VPC side that needs to be interconnected with the client network segment.
        """
        return pulumi.get(self, "local_subnet")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        The number of SSL connections of the VPN gateway. SSL-VPN the number of SSL connections shared with the IPsec server. For example, if the number of SSL connections is 5 and you have three SSL clients connected to the SSL-VPN, you can also use two clients to connect to the IPsec server.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter(name="multiFactorAuthEnabled")
    def multi_factor_auth_enabled(self) -> bool:
        """
        Whether the two-factor authentication function has been turned on.
        """
        return pulumi.get(self, "multi_factor_auth_enabled")

    @property
    @pulumi.getter(name="onlineClientCount")
    def online_client_count(self) -> int:
        """
        The number of clients that have connected to the IPsec server.
        """
        return pulumi.get(self, "online_client_count")

    @property
    @pulumi.getter
    def psk(self) -> str:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="pskEnabled")
    def psk_enabled(self) -> bool:
        """
        Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
        """
        return pulumi.get(self, "psk_enabled")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> str:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")


@pulumi.output_type
class GetIpsecServersServerIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: str,
                 ike_enc_alg: str,
                 ike_lifetime: int,
                 ike_mode: str,
                 ike_pfs: str,
                 ike_version: str,
                 local_id: str,
                 remote_id: str):
        """
        :param str ike_auth_alg: The IKE authentication algorithm.
        :param str ike_enc_alg: The IKE encryption algorithm.
        :param int ike_lifetime: The IKE lifetime. Unit: seconds.
        :param str ike_mode: The IKE negotiation mode.
        :param str ike_pfs: Diffie-Hellman key exchange algorithm.
        :param str ike_version: The IKE version.
        :param str local_id: IPsec server identifier. Supports the format of FQDN and IP address. The public IP address of the VPN gateway is selected by default.
        :param str remote_id: The peer identifier. Supports the format of FQDN and IP address, which is empty by default.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "remote_id", remote_id)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> str:
        """
        The IKE authentication algorithm.
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> str:
        """
        The IKE encryption algorithm.
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> int:
        """
        The IKE lifetime. Unit: seconds.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> str:
        """
        The IKE negotiation mode.
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> str:
        """
        Diffie-Hellman key exchange algorithm.
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> str:
        """
        The IKE version.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> str:
        """
        IPsec server identifier. Supports the format of FQDN and IP address. The public IP address of the VPN gateway is selected by default.
        """
        return pulumi.get(self, "local_id")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> str:
        """
        The peer identifier. Supports the format of FQDN and IP address, which is empty by default.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetIpsecServersServerIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: str,
                 ipsec_enc_alg: str,
                 ipsec_lifetime: int,
                 ipsec_pfs: str):
        """
        :param str ipsec_auth_alg: IPsec authentication algorithm.
        :param str ipsec_enc_alg: IPsec encryption algorithm.
        :param int ipsec_lifetime: IPsec survival time. Unit: seconds.
        :param str ipsec_pfs: Diffie-Hellman key exchange algorithm.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> str:
        """
        IPsec authentication algorithm.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> str:
        """
        IPsec encryption algorithm.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> int:
        """
        IPsec survival time. Unit: seconds.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> str:
        """
        Diffie-Hellman key exchange algorithm.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetIpv4GatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 enabled: bool,
                 id: str,
                 ipv4_gateway_description: str,
                 ipv4_gateway_id: str,
                 ipv4_gateway_name: str,
                 ipv4_gateway_route_table_id: str,
                 status: str,
                 vpc_id: str):
        """
        :param str create_time: The creation time of the resource.
        :param bool enabled: Indicates whether the IPv4 gateway is activated.
        :param str id: The ID of the Ipv4 Gateway.
        :param str ipv4_gateway_description: The description of the IPv4 gateway.
        :param str ipv4_gateway_id: The resource attribute field that represents the resource level 1 ID.
        :param str ipv4_gateway_name: The name of the IPv4 gateway.
        :param str ipv4_gateway_route_table_id: ID of the route table associated with IPv4 Gateway.
        :param str status: The status of the resource.
        :param str vpc_id: The ID of the VPC associated with the IPv4 Gateway.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4_gateway_description", ipv4_gateway_description)
        pulumi.set(__self__, "ipv4_gateway_id", ipv4_gateway_id)
        pulumi.set(__self__, "ipv4_gateway_name", ipv4_gateway_name)
        pulumi.set(__self__, "ipv4_gateway_route_table_id", ipv4_gateway_route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether the IPv4 gateway is activated.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipv4 Gateway.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4GatewayDescription")
    def ipv4_gateway_description(self) -> str:
        """
        The description of the IPv4 gateway.
        """
        return pulumi.get(self, "ipv4_gateway_description")

    @property
    @pulumi.getter(name="ipv4GatewayId")
    def ipv4_gateway_id(self) -> str:
        """
        The resource attribute field that represents the resource level 1 ID.
        """
        return pulumi.get(self, "ipv4_gateway_id")

    @property
    @pulumi.getter(name="ipv4GatewayName")
    def ipv4_gateway_name(self) -> str:
        """
        The name of the IPv4 gateway.
        """
        return pulumi.get(self, "ipv4_gateway_name")

    @property
    @pulumi.getter(name="ipv4GatewayRouteTableId")
    def ipv4_gateway_route_table_id(self) -> str:
        """
        ID of the route table associated with IPv4 Gateway.
        """
        return pulumi.get(self, "ipv4_gateway_route_table_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC associated with the IPv4 Gateway.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetIpv6AddressesAddressResult(dict):
    def __init__(__self__, *,
                 associated_instance_id: str,
                 associated_instance_type: str,
                 create_time: str,
                 id: str,
                 ipv6_address: str,
                 ipv6_address_id: str,
                 ipv6_address_name: str,
                 ipv6_gateway_id: str,
                 network_type: str,
                 status: str,
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str associated_instance_id: The ID of the instance that is assigned the IPv6 address.
        :param str associated_instance_type: The type of the instance that is assigned the IPv6 address.
        :param str create_time: The time when the IPv6 address was created.
        :param str id: The ID of the Ipv6 Address.
        :param str ipv6_address: The address of the Ipv6 Address.
        :param str ipv6_address_id: The ID of the IPv6 address.
        :param str ipv6_address_name: The name of the IPv6 address.
        :param str ipv6_gateway_id: The ID of the IPv6 gateway to which the IPv6 address belongs.
        :param str network_type: The type of communication supported by the IPv6 address. Valid values:`Private` or `Public`. `Private`: communication within the private network. `Public`: communication over the public network
        :param str status: The status of the IPv6 address. Valid values:`Pending` or `Available`.
        :param str vpc_id: The ID of the VPC to which the IPv6 address belongs.
        :param str vswitch_id: The ID of the vSwitch to which the IPv6 address belongs.
        """
        pulumi.set(__self__, "associated_instance_id", associated_instance_id)
        pulumi.set(__self__, "associated_instance_type", associated_instance_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_address_id", ipv6_address_id)
        pulumi.set(__self__, "ipv6_address_name", ipv6_address_name)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="associatedInstanceId")
    def associated_instance_id(self) -> str:
        """
        The ID of the instance that is assigned the IPv6 address.
        """
        return pulumi.get(self, "associated_instance_id")

    @property
    @pulumi.getter(name="associatedInstanceType")
    def associated_instance_type(self) -> str:
        """
        The type of the instance that is assigned the IPv6 address.
        """
        return pulumi.get(self, "associated_instance_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the IPv6 address was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipv6 Address.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The address of the Ipv6 Address.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6AddressId")
    def ipv6_address_id(self) -> str:
        """
        The ID of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_id")

    @property
    @pulumi.getter(name="ipv6AddressName")
    def ipv6_address_name(self) -> str:
        """
        The name of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_name")

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> str:
        """
        The ID of the IPv6 gateway to which the IPv6 address belongs.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The type of communication supported by the IPv6 address. Valid values:`Private` or `Public`. `Private`: communication within the private network. `Public`: communication over the public network
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the IPv6 address. Valid values:`Pending` or `Available`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC to which the IPv6 address belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch to which the IPv6 address belongs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetIpv6EgressRulesRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 instance_id: str,
                 instance_type: str,
                 ipv6_egress_rule_id: str,
                 ipv6_egress_rule_name: str,
                 ipv6_gateway_id: str,
                 status: str):
        """
        :param str description: The description of the egress-only rule.
        :param str id: The ID of the Ipv6 Egress Rule. The value formats as `<ipv6_gateway_id>:<ipv6_egress_rule_id>`.
        :param str instance_id: The ID of the instance to which the egress-only rule is applied.
        :param str instance_type: The type of the instance to which the egress-only rule is applied.
        :param str ipv6_egress_rule_id: The first ID of the resource.
        :param str ipv6_egress_rule_name: The name of the resource.
        :param str ipv6_gateway_id: The ID of the IPv6 gateway.
        :param str status: The status of the resource. Valid values: `Available`, `Pending` and `Deleting`.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "ipv6_egress_rule_id", ipv6_egress_rule_id)
        pulumi.set(__self__, "ipv6_egress_rule_name", ipv6_egress_rule_name)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the egress-only rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipv6 Egress Rule. The value formats as `<ipv6_gateway_id>:<ipv6_egress_rule_id>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance to which the egress-only rule is applied.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the instance to which the egress-only rule is applied.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6EgressRuleId")
    def ipv6_egress_rule_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipv6_egress_rule_id")

    @property
    @pulumi.getter(name="ipv6EgressRuleName")
    def ipv6_egress_rule_name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "ipv6_egress_rule_name")

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> str:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values: `Available`, `Pending` and `Deleting`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetIpv6GatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 business_status: str,
                 create_time: str,
                 description: str,
                 expired_time: str,
                 id: str,
                 instance_charge_type: str,
                 ipv6_gateway_id: str,
                 ipv6_gateway_name: str,
                 spec: str,
                 status: str,
                 vpc_id: str):
        """
        :param str business_status: The status of the IPv6 gateway. Valid values:`Normal`, `FinancialLocked` and `SecurityLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments. `SecurityLocked`: locked due to security reasons.
        :param str create_time: The creation time of the resource.
        :param str description: The description of the IPv6 gateway.
        :param str expired_time: The time when the IPv6 gateway expires.
        :param str id: The ID of the Ipv6 Gateway.
        :param str instance_charge_type: The metering method of the IPv6 gateway. Valid values: `PayAsYouGo`.
        :param str ipv6_gateway_id: The first ID of the resource.
        :param str ipv6_gateway_name: The name of the IPv6 gateway.
        :param str spec: The specification of the IPv6 gateway. Valid values: `Large`, `Medium` and `Small`. `Small` (default): Free Edition. `Medium`: Enterprise Edition . `Large`: Enhanced Enterprise Edition. The throughput capacity of an IPv6 gateway varies based on the edition. For more information, see [Editions of IPv6 gateways](https://www.alibabacloud.com/help/doc-detail/98926.htm).
        :param str status: The status of the IPv6 gateway. Valid values: `Available`, `Deleting`, `Pending`.
        :param str vpc_id: The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
        """
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "ipv6_gateway_name", ipv6_gateway_name)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The status of the IPv6 gateway. Valid values:`Normal`, `FinancialLocked` and `SecurityLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments. `SecurityLocked`: locked due to security reasons.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the IPv6 gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The time when the IPv6 gateway expires.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipv6 Gateway.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> str:
        """
        The metering method of the IPv6 gateway. Valid values: `PayAsYouGo`.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @property
    @pulumi.getter(name="ipv6GatewayName")
    def ipv6_gateway_name(self) -> str:
        """
        The name of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_name")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The specification of the IPv6 gateway. Valid values: `Large`, `Medium` and `Small`. `Small` (default): Free Edition. `Medium`: Enterprise Edition . `Large`: Enhanced Enterprise Edition. The throughput capacity of an IPv6 gateway varies based on the edition. For more information, see [Editions of IPv6 gateways](https://www.alibabacloud.com/help/doc-detail/98926.htm).
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the IPv6 gateway. Valid values: `Available`, `Deleting`, `Pending`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetIpv6InternetBandwidthsBandwidthResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 id: str,
                 internet_charge_type: str,
                 ipv6_address_id: str,
                 ipv6_gateway_id: str,
                 ipv6_internet_bandwidth_id: str,
                 payment_type: str,
                 status: str):
        """
        :param int bandwidth: The amount of Internet bandwidth resources of the IPv6 address, Unit: `Mbit/s`.
        :param str id: The ID of the Ipv6 Internet Bandwidth.
        :param str internet_charge_type: The metering method of the Internet bandwidth resources of the IPv6 gateway.
        :param str ipv6_address_id: The ID of the IPv6 address.
        :param str ipv6_gateway_id: The ID of the IPv6 gateway.
        :param str ipv6_internet_bandwidth_id: The ID of the Ipv6 Internet Bandwidth.
        :param str payment_type: The payment type of the resource.
        :param str status: The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ipv6_address_id", ipv6_address_id)
        pulumi.set(__self__, "ipv6_gateway_id", ipv6_gateway_id)
        pulumi.set(__self__, "ipv6_internet_bandwidth_id", ipv6_internet_bandwidth_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The amount of Internet bandwidth resources of the IPv6 address, Unit: `Mbit/s`.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ipv6 Internet Bandwidth.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The metering method of the Internet bandwidth resources of the IPv6 gateway.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipv6AddressId")
    def ipv6_address_id(self) -> str:
        """
        The ID of the IPv6 address.
        """
        return pulumi.get(self, "ipv6_address_id")

    @property
    @pulumi.getter(name="ipv6GatewayId")
    def ipv6_gateway_id(self) -> str:
        """
        The ID of the IPv6 gateway.
        """
        return pulumi.get(self, "ipv6_gateway_id")

    @property
    @pulumi.getter(name="ipv6InternetBandwidthId")
    def ipv6_internet_bandwidth_id(self) -> str:
        """
        The ID of the Ipv6 Internet Bandwidth.
        """
        return pulumi.get(self, "ipv6_internet_bandwidth_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNatGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 business_status: str,
                 deletion_protection: bool,
                 description: str,
                 ecs_metric_enabled: bool,
                 expired_time: str,
                 forward_table_ids: Sequence[str],
                 id: str,
                 internet_charge_type: str,
                 ip_lists: Sequence[str],
                 name: str,
                 nat_gateway_id: str,
                 nat_gateway_name: str,
                 nat_type: str,
                 network_type: str,
                 payment_type: str,
                 resource_group_id: str,
                 snat_table_ids: Sequence[str],
                 spec: str,
                 specification: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str):
        """
        :param str business_status: The state of the NAT gateway.
        :param bool deletion_protection: Indicates whether deletion protection is enabled.
        :param str description: The description of the NAT gateway.
        :param bool ecs_metric_enabled: Indicates whether the traffic monitoring feature is enabled.
        :param str expired_time: The time when the NAT gateway expires.
        :param Sequence[str] forward_table_ids: The ID of the DNAT table.
        :param str id: The ID of the NAT gateway.
        :param str internet_charge_type: The metering method of the NAT gateway.
        :param Sequence[str] ip_lists: The ip address of the bind eip.
        :param str name: Name of the NAT gateway.
        :param str nat_gateway_id: The ID of the NAT gateway.
        :param str nat_gateway_name: The name of NAT gateway.
        :param str nat_type: The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
        :param str network_type: (Available in 1.137.0+) Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`.
        :param str payment_type: The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
        :param str resource_group_id: The resource group id of NAT gateway.
        :param Sequence[str] snat_table_ids: The ID of the SNAT table that is associated with the NAT gateway.
        :param str spec: The specification of the NAT gateway.
        :param str specification: The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
        :param str status: The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
        :param Mapping[str, Any] tags: The tags of NAT gateway.
        :param str vpc_id: The ID of the VPC.
        :param str vswitch_id: The ID of the vSwitch to which the NAT gateway belongs.
        """
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ecs_metric_enabled", ecs_metric_enabled)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "forward_table_ids", forward_table_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_lists", ip_lists)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        pulumi.set(__self__, "nat_type", nat_type)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "snat_table_ids", snat_table_ids)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The state of the NAT gateway.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Indicates whether deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the NAT gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ecsMetricEnabled")
    def ecs_metric_enabled(self) -> bool:
        """
        Indicates whether the traffic monitoring feature is enabled.
        """
        return pulumi.get(self, "ecs_metric_enabled")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The time when the NAT gateway expires.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="forwardTableIds")
    def forward_table_ids(self) -> Sequence[str]:
        """
        The ID of the DNAT table.
        """
        return pulumi.get(self, "forward_table_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the NAT gateway.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The metering method of the NAT gateway.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipLists")
    def ip_lists(self) -> Sequence[str]:
        """
        The ip address of the bind eip.
        """
        return pulumi.get(self, "ip_lists")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the NAT gateway.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of the NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> str:
        """
        The name of NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_name")

    @property
    @pulumi.getter(name="natType")
    def nat_type(self) -> str:
        """
        The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
        """
        return pulumi.get(self, "nat_type")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        (Available in 1.137.0+) Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id of NAT gateway.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="snatTableIds")
    def snat_table_ids(self) -> Sequence[str]:
        """
        The ID of the SNAT table that is associated with the NAT gateway.
        """
        return pulumi.get(self, "snat_table_ids")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The specification of the NAT gateway.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def specification(self) -> str:
        """
        The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch to which the NAT gateway belongs.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetNatIpCidrsCidrResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 is_default: bool,
                 nat_gateway_id: str,
                 nat_ip_cidr: str,
                 nat_ip_cidr_description: str,
                 nat_ip_cidr_id: str,
                 nat_ip_cidr_name: str,
                 status: str):
        """
        :param str create_time: The time when the CIDR block was created.
        :param str id: The ID of the Nat Ip Cidr.
        :param bool is_default: Whether it is the default NAT IP ADDRESS. Valid values:`true` or `false`.`true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        :param str nat_gateway_id: The ID of the VPC NAT gateway.
        :param str nat_ip_cidr: The NAT CIDR block to be created. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
        :param str nat_ip_cidr_description: NAT IP ADDRESS range to the description of. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        :param str nat_ip_cidr_id: NAT IP ADDRESS instance ID.
        :param str nat_ip_cidr_name: NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        :param str status: The status of the CIDR block of the NAT gateway. If the value is `Available`, the CIDR block is available.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        pulumi.set(__self__, "nat_ip_cidr_description", nat_ip_cidr_description)
        pulumi.set(__self__, "nat_ip_cidr_id", nat_ip_cidr_id)
        pulumi.set(__self__, "nat_ip_cidr_name", nat_ip_cidr_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the CIDR block was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Nat Ip Cidr.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Whether it is the default NAT IP ADDRESS. Valid values:`true` or `false`.`true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of the VPC NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> str:
        """
        The NAT CIDR block to be created. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
        """
        return pulumi.get(self, "nat_ip_cidr")

    @property
    @pulumi.getter(name="natIpCidrDescription")
    def nat_ip_cidr_description(self) -> str:
        """
        NAT IP ADDRESS range to the description of. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_cidr_description")

    @property
    @pulumi.getter(name="natIpCidrId")
    def nat_ip_cidr_id(self) -> str:
        """
        NAT IP ADDRESS instance ID.
        """
        return pulumi.get(self, "nat_ip_cidr_id")

    @property
    @pulumi.getter(name="natIpCidrName")
    def nat_ip_cidr_name(self) -> str:
        """
        NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
        """
        return pulumi.get(self, "nat_ip_cidr_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the CIDR block of the NAT gateway. If the value is `Available`, the CIDR block is available.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNatIpsIpResult(dict):
    def __init__(__self__, *,
                 id: str,
                 is_default: bool,
                 nat_gateway_id: str,
                 nat_ip: str,
                 nat_ip_cidr: str,
                 nat_ip_description: str,
                 nat_ip_id: str,
                 nat_ip_name: str,
                 status: str):
        """
        :param str id: The ID of the Nat Ip.
        :param bool is_default: Indicates whether the BGP Group is the default NAT IP ADDRESS. Valid values: `true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        :param str nat_gateway_id: The ID of the Virtual Private Cloud (VPC) NAT gateway to which the NAT IP address belongs.
        :param str nat_ip: The NAT IP address that is queried.
        :param str nat_ip_cidr: The CIDR block to which the NAT IP address belongs.
        :param str nat_ip_description: The description of the NAT IP address.
        :param str nat_ip_id: The ID of the NAT IP address.
        :param str nat_ip_name: The name of the NAT IP address.
        :param str status: The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        pulumi.set(__self__, "nat_ip", nat_ip)
        pulumi.set(__self__, "nat_ip_cidr", nat_ip_cidr)
        pulumi.set(__self__, "nat_ip_description", nat_ip_description)
        pulumi.set(__self__, "nat_ip_id", nat_ip_id)
        pulumi.set(__self__, "nat_ip_name", nat_ip_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Nat Ip.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicates whether the BGP Group is the default NAT IP ADDRESS. Valid values: `true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> str:
        """
        The ID of the Virtual Private Cloud (VPC) NAT gateway to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> str:
        """
        The NAT IP address that is queried.
        """
        return pulumi.get(self, "nat_ip")

    @property
    @pulumi.getter(name="natIpCidr")
    def nat_ip_cidr(self) -> str:
        """
        The CIDR block to which the NAT IP address belongs.
        """
        return pulumi.get(self, "nat_ip_cidr")

    @property
    @pulumi.getter(name="natIpDescription")
    def nat_ip_description(self) -> str:
        """
        The description of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_description")

    @property
    @pulumi.getter(name="natIpId")
    def nat_ip_id(self) -> str:
        """
        The ID of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_id")

    @property
    @pulumi.getter(name="natIpName")
    def nat_ip_name(self) -> str:
        """
        The name of the NAT IP address.
        """
        return pulumi.get(self, "nat_ip_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworkAclsAclResult(dict):
    def __init__(__self__, *,
                 description: str,
                 egress_acl_entries: Sequence['outputs.GetNetworkAclsAclEgressAclEntryResult'],
                 id: str,
                 ingress_acl_entries: Sequence['outputs.GetNetworkAclsAclIngressAclEntryResult'],
                 network_acl_id: str,
                 network_acl_name: str,
                 resources: Sequence['outputs.GetNetworkAclsAclResourceResult'],
                 status: str,
                 vpc_id: str):
        """
        :param str description: Description of the entry direction rule.
        :param Sequence['GetNetworkAclsAclEgressAclEntryArgs'] egress_acl_entries: Output direction rule information.
        :param str id: The ID of the Network Acl.
        :param Sequence['GetNetworkAclsAclIngressAclEntryArgs'] ingress_acl_entries: Entry direction rule information.
        :param str network_acl_id: The first ID of the resource.
        :param str network_acl_name: The name of the network ACL.
        :param Sequence['GetNetworkAclsAclResourceArgs'] resources: The associated resource.
        :param str status: The state of the network ACL.
        :param str vpc_id: The ID of the associated VPC.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "egress_acl_entries", egress_acl_entries)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ingress_acl_entries", ingress_acl_entries)
        pulumi.set(__self__, "network_acl_id", network_acl_id)
        pulumi.set(__self__, "network_acl_name", network_acl_name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the entry direction rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressAclEntries")
    def egress_acl_entries(self) -> Sequence['outputs.GetNetworkAclsAclEgressAclEntryResult']:
        """
        Output direction rule information.
        """
        return pulumi.get(self, "egress_acl_entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Network Acl.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressAclEntries")
    def ingress_acl_entries(self) -> Sequence['outputs.GetNetworkAclsAclIngressAclEntryResult']:
        """
        Entry direction rule information.
        """
        return pulumi.get(self, "ingress_acl_entries")

    @property
    @pulumi.getter(name="networkAclId")
    def network_acl_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "network_acl_id")

    @property
    @pulumi.getter(name="networkAclName")
    def network_acl_name(self) -> str:
        """
        The name of the network ACL.
        """
        return pulumi.get(self, "network_acl_name")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetNetworkAclsAclResourceResult']:
        """
        The associated resource.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the network ACL.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the associated VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetNetworkAclsAclEgressAclEntryResult(dict):
    def __init__(__self__, *,
                 description: str,
                 destination_cidr_ip: str,
                 network_acl_entry_name: str,
                 policy: str,
                 port: str,
                 protocol: str):
        """
        :param str description: Description of the entry direction rule.
        :param str destination_cidr_ip: The destination address segment.
        :param str network_acl_entry_name: The name of the entry direction rule entry.
        :param str policy: The authorization policy.
        :param str port: Source port range.
        :param str protocol: Transport layer protocol.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_cidr_ip", destination_cidr_ip)
        pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the entry direction rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrIp")
    def destination_cidr_ip(self) -> str:
        """
        The destination address segment.
        """
        return pulumi.get(self, "destination_cidr_ip")

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> str:
        """
        The name of the entry direction rule entry.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The authorization policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Source port range.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Transport layer protocol.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class GetNetworkAclsAclIngressAclEntryResult(dict):
    def __init__(__self__, *,
                 description: str,
                 network_acl_entry_name: str,
                 policy: str,
                 port: str,
                 protocol: str,
                 source_cidr_ip: str):
        """
        :param str description: Description of the entry direction rule.
        :param str network_acl_entry_name: The name of the entry direction rule entry.
        :param str policy: The authorization policy.
        :param str port: Source port range.
        :param str protocol: Transport layer protocol.
        :param str source_cidr_ip: The source address field.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "network_acl_entry_name", network_acl_entry_name)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the entry direction rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkAclEntryName")
    def network_acl_entry_name(self) -> str:
        """
        The name of the entry direction rule entry.
        """
        return pulumi.get(self, "network_acl_entry_name")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The authorization policy.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Source port range.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Transport layer protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> str:
        """
        The source address field.
        """
        return pulumi.get(self, "source_cidr_ip")


@pulumi.output_type
class GetNetworkAclsAclResourceResult(dict):
    def __init__(__self__, *,
                 resource_id: str,
                 resource_type: str,
                 status: str):
        """
        :param str resource_id: The ID of the associated resource.
        :param str resource_type: The type of the associated resource.
        :param str status: The state of the network ACL.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The ID of the associated resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of the associated resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the network ACL.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNetworksVpcResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 creation_time: str,
                 description: str,
                 id: str,
                 ipv6_cidr_block: str,
                 is_default: bool,
                 region_id: str,
                 resource_group_id: str,
                 route_table_id: str,
                 router_id: str,
                 secondary_cidr_blocks: Sequence[str],
                 status: str,
                 tags: Mapping[str, Any],
                 user_cidrs: Sequence[str],
                 vpc_id: str,
                 vpc_name: str,
                 vrouter_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        :param str creation_time: Time of creation.
        :param str description: Description of the VPC
        :param str id: ID of the VPC.
        :param str ipv6_cidr_block: The IPv6 CIDR block of the VPC.
        :param bool is_default: Indicate whether the VPC is the default one in the specified region.
        :param str region_id: ID of the region where the VPC is located.
        :param str resource_group_id: The Id of resource group which VPC belongs.
        :param str route_table_id: Route table ID of the VRouter.
        :param str router_id: The ID of the VRouter.
        :param Sequence[str] secondary_cidr_blocks: A list of secondary IPv4 CIDR blocks of the VPC.
        :param str status: Filter results by a specific status. Valid value are `Pending` and `Available`.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param Sequence[str] user_cidrs: A list of user CIDRs.
        :param str vpc_id: ID of the VPC.
        :param str vpc_name: The name of the VPC.
        :param str vrouter_id: ID of the VRouter.
        :param Sequence[str] vswitch_ids: List of VSwitch IDs in the specified VPC
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "secondary_cidr_blocks", secondary_cidr_blocks)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_cidrs", user_cidrs)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_name", vpc_name)
        pulumi.set(__self__, "vrouter_id", vrouter_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the VPC
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> str:
        """
        The IPv6 CIDR block of the VPC.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicate whether the VPC is the default one in the specified region.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        ID of the region where the VPC is located.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which VPC belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        Route table ID of the VRouter.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The ID of the VRouter.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="secondaryCidrBlocks")
    def secondary_cidr_blocks(self) -> Sequence[str]:
        """
        A list of secondary IPv4 CIDR blocks of the VPC.
        """
        return pulumi.get(self, "secondary_cidr_blocks")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Filter results by a specific status. Valid value are `Pending` and `Available`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userCidrs")
    def user_cidrs(self) -> Sequence[str]:
        """
        A list of user CIDRs.
        """
        return pulumi.get(self, "user_cidrs")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        The name of the VPC.
        """
        return pulumi.get(self, "vpc_name")

    @property
    @pulumi.getter(name="vrouterId")
    def vrouter_id(self) -> str:
        """
        ID of the VRouter.
        """
        return pulumi.get(self, "vrouter_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        List of VSwitch IDs in the specified VPC
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetPbrRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 next_hop: str,
                 route_dest: str,
                 route_source: str,
                 status: str,
                 vpn_gateway_id: str,
                 weight: int):
        """
        :param str create_time: The creation time of the VPN Pbr Route Entry.
        :param str id: The id of the vpn pbr route entry. The value formats as `<vpn_gateway_id>:<next_hop>:<route_source>:<route_dest>`.
        :param str next_hop: The next hop of the policy-based route.
        :param str route_dest: The destination CIDR block of the policy-based route.
        :param str route_source: The source CIDR block of the policy-based route.
        :param str status: The status of the VPN Pbr Route Entry.
        :param str vpn_gateway_id: The ID of the VPN gateway.
        :param int weight: The weight of the policy-based route. Valid values: 0 and 100.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_dest", route_dest)
        pulumi.set(__self__, "route_source", route_source)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the VPN Pbr Route Entry.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the vpn pbr route entry. The value formats as `<vpn_gateway_id>:<next_hop>:<route_source>:<route_dest>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The next hop of the policy-based route.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> str:
        """
        The destination CIDR block of the policy-based route.
        """
        return pulumi.get(self, "route_dest")

    @property
    @pulumi.getter(name="routeSource")
    def route_source(self) -> str:
        """
        The source CIDR block of the policy-based route.
        """
        return pulumi.get(self, "route_source")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the VPN Pbr Route Entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> str:
        """
        The ID of the VPN gateway.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the policy-based route. Valid values: 0 and 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetPeerConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 accepting_ali_uid: int,
                 accepting_region_id: str,
                 accepting_vpc_id: str,
                 bandwidth: int,
                 create_time: str,
                 description: str,
                 id: str,
                 peer_connection_id: str,
                 peer_connection_name: str,
                 status: str,
                 vpc_id: str):
        """
        :param int accepting_ali_uid: The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
        :param str accepting_region_id: The region ID of the recipient of the VPC peering connection to be created.
        :param str accepting_vpc_id: The VPC ID of the receiving end of the VPC peer connection.
        :param int bandwidth: The bandwidth of the VPC peering connection to be modified. Unit: Mbps.
        :param str create_time: The creation time of the resource.
        :param str description: The description of the VPC peer connection to be created.
        :param str id: The ID of the PeerConnection.
        :param str peer_connection_id: The first ID of the resource.
        :param str peer_connection_name: The name of the resource.
        :param str status: The status of the resource.
        :param str vpc_id: The ID of the requester VPC.
        """
        pulumi.set(__self__, "accepting_ali_uid", accepting_ali_uid)
        pulumi.set(__self__, "accepting_region_id", accepting_region_id)
        pulumi.set(__self__, "accepting_vpc_id", accepting_vpc_id)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_connection_id", peer_connection_id)
        pulumi.set(__self__, "peer_connection_name", peer_connection_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="acceptingAliUid")
    def accepting_ali_uid(self) -> int:
        """
        The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
        """
        return pulumi.get(self, "accepting_ali_uid")

    @property
    @pulumi.getter(name="acceptingRegionId")
    def accepting_region_id(self) -> str:
        """
        The region ID of the recipient of the VPC peering connection to be created.
        """
        return pulumi.get(self, "accepting_region_id")

    @property
    @pulumi.getter(name="acceptingVpcId")
    def accepting_vpc_id(self) -> str:
        """
        The VPC ID of the receiving end of the VPC peer connection.
        """
        return pulumi.get(self, "accepting_vpc_id")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of the VPC peering connection to be modified. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the VPC peer connection to be created.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the PeerConnection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerConnectionId")
    def peer_connection_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "peer_connection_id")

    @property
    @pulumi.getter(name="peerConnectionName")
    def peer_connection_name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "peer_connection_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the requester VPC.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetPrefixListsListResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 entrys: Sequence['outputs.GetPrefixListsListEntryResult'],
                 id: str,
                 ip_version: str,
                 max_entries: int,
                 prefix_list_description: str,
                 prefix_list_id: str,
                 prefix_list_name: str,
                 share_type: str):
        """
        :param str create_time: The time when the prefix list was created.
        :param Sequence['GetPrefixListsListEntryArgs'] entrys: The CIDR address block list of the prefix list.
        :param str id: The ID of the Prefix List.
        :param str ip_version: The IP version of the prefix list.
        :param int max_entries: The maximum number of entries for CIDR address blocks in the prefix list.
        :param str prefix_list_description: The description of the prefix list.
        :param str prefix_list_id: The ID of the query Prefix List.
        :param str prefix_list_name: The name of the prefix list.
        :param str share_type: The share type of the prefix list.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "entrys", entrys)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "max_entries", max_entries)
        pulumi.set(__self__, "prefix_list_description", prefix_list_description)
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "prefix_list_name", prefix_list_name)
        pulumi.set(__self__, "share_type", share_type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the prefix list was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def entrys(self) -> Sequence['outputs.GetPrefixListsListEntryResult']:
        """
        The CIDR address block list of the prefix list.
        """
        return pulumi.get(self, "entrys")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Prefix List.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The IP version of the prefix list.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> int:
        """
        The maximum number of entries for CIDR address blocks in the prefix list.
        """
        return pulumi.get(self, "max_entries")

    @property
    @pulumi.getter(name="prefixListDescription")
    def prefix_list_description(self) -> str:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "prefix_list_description")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> str:
        """
        The ID of the query Prefix List.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> str:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        The share type of the prefix list.
        """
        return pulumi.get(self, "share_type")


@pulumi.output_type
class GetPrefixListsListEntryResult(dict):
    def __init__(__self__, *,
                 cidr: str,
                 description: str):
        """
        :param str cidr: The CIDR address block of the prefix list.
        :param str description: The description of the cidr entry.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        The CIDR address block of the prefix list.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the cidr entry.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetPublicIpAddressPoolCidrBlocksBlockResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 create_time: str,
                 id: str,
                 public_ip_address_pool_id: str,
                 status: str,
                 total_ip_num: int,
                 used_ip_num: int):
        """
        :param str cidr_block: The CIDR block.
        :param str create_time: The time when the CIDR block was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        :param str id: The ID of the Public Ip Address Pool Cidr Block.
        :param str public_ip_address_pool_id: The ID of the Vpc Public IP address pool.
        :param str status: The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
        :param int total_ip_num: The number of occupied IP addresses in the CIDR block.
        :param int used_ip_num: The total number of available IP addresses in the CIDR block.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_ip_num", total_ip_num)
        pulumi.set(__self__, "used_ip_num", used_ip_num)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        The CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the CIDR block was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Public Ip Address Pool Cidr Block.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> str:
        """
        The ID of the Vpc Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> int:
        """
        The number of occupied IP addresses in the CIDR block.
        """
        return pulumi.get(self, "total_ip_num")

    @property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> int:
        """
        The total number of available IP addresses in the CIDR block.
        """
        return pulumi.get(self, "used_ip_num")


@pulumi.output_type
class GetPublicIpAddressPoolsPoolResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 id: str,
                 ip_address_remaining: bool,
                 isp: str,
                 public_ip_address_pool_id: str,
                 public_ip_address_pool_name: str,
                 region_id: str,
                 status: str,
                 total_ip_num: int,
                 used_ip_num: int,
                 user_type: str):
        """
        :param str create_time: The time when the Vpc Public Ip Address Pool was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        :param str description: The description of the Vpc Public Ip Address Pool.
        :param str id: The ID of the Vpc Public Ip Address Pool.
        :param bool ip_address_remaining: Indicates whether the Vpc Public Ip Address Pool has idle IP addresses.
        :param str isp: The Internet service provider.
        :param str public_ip_address_pool_id: The ID of the Vpc Public Ip Address Pool.
        :param str public_ip_address_pool_name: The name of the Vpc Public Ip Address Pool.
        :param str region_id: The region ID of the Vpc Public Ip Address Pool.
        :param str status: The status of the Vpc Public Ip Address Pool.
        :param int total_ip_num: The total number of IP addresses in the Vpc Public Ip Address Pool.
        :param int used_ip_num: The number of occupied IP addresses in the Vpc Public Ip Address Pool.
        :param str user_type: The user type.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address_remaining", ip_address_remaining)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_ip_num", total_ip_num)
        pulumi.set(__self__, "used_ip_num", used_ip_num)
        pulumi.set(__self__, "user_type", user_type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the Vpc Public Ip Address Pool was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> bool:
        """
        Indicates whether the Vpc Public Ip Address Pool has idle IP addresses.
        """
        return pulumi.get(self, "ip_address_remaining")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The Internet service provider.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> str:
        """
        The ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> str:
        """
        The name of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region ID of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> int:
        """
        The total number of IP addresses in the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "total_ip_num")

    @property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> int:
        """
        The number of occupied IP addresses in the Vpc Public Ip Address Pool.
        """
        return pulumi.get(self, "used_ip_num")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> str:
        """
        The user type.
        """
        return pulumi.get(self, "user_type")


@pulumi.output_type
class GetRouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 cidr_block: str,
                 instance_id: str,
                 next_hop_type: str,
                 route_table_id: str,
                 status: str,
                 type: str):
        """
        :param str cidr_block: The destination CIDR block of the route entry.
        :param str instance_id: The instance ID of the next hop.
        :param str next_hop_type: The type of the next hop.
        :param str route_table_id: The ID of the router table to which the route entry belongs.
        :param str status: The status of the route entry.
        :param str type: The type of the route entry.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "next_hop_type", next_hop_type)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        The destination CIDR block of the route entry.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID of the next hop.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="nextHopType")
    def next_hop_type(self) -> str:
        """
        The type of the next hop.
        """
        return pulumi.get(self, "next_hop_type")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        The ID of the router table to which the route entry belongs.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the route entry.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRouteTablesTableResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 name: str,
                 resource_group_id: str,
                 route_table_id: str,
                 route_table_name: str,
                 route_table_type: str,
                 router_id: str,
                 router_type: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param str description: The description of the route table instance.
        :param str id: ID of the Route Table.
        :param str name: Name of the route table.
        :param str resource_group_id: The Id of resource group which route tables belongs.
        :param str route_table_id: The route table id.
        :param str route_table_name: The route table name.
        :param str route_table_type: The type of route table.
        :param str router_id: The router ID.
        :param str router_type: The route type of route table. Valid values: `VRouter` and `VBR`.
        :param str status: The status of resource. Valid values: `Available` and `Pending`.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str vpc_id: Vpc id of the route table.
        :param Sequence[str] vswitch_ids: A list of vswitch id.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "route_table_name", route_table_name)
        pulumi.set(__self__, "route_table_type", route_table_type)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the route table instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the Route Table.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the route table.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which route tables belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        The route table id.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter(name="routeTableName")
    def route_table_name(self) -> str:
        """
        The route table name.
        """
        return pulumi.get(self, "route_table_name")

    @property
    @pulumi.getter(name="routeTableType")
    def route_table_type(self) -> str:
        """
        The type of route table.
        """
        return pulumi.get(self, "route_table_type")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The router ID.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerType")
    def router_type(self) -> str:
        """
        The route type of route table. Valid values: `VRouter` and `VBR`.
        """
        return pulumi.get(self, "router_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of resource. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Vpc id of the route table.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        A list of vswitch id.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetRouterInterfacesInterfaceResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 creation_time: str,
                 description: str,
                 health_check_source_ip: str,
                 health_check_target_ip: str,
                 id: str,
                 name: str,
                 opposite_interface_id: str,
                 opposite_interface_owner_id: str,
                 opposite_region_id: str,
                 opposite_router_id: str,
                 opposite_router_type: str,
                 role: str,
                 router_id: str,
                 router_type: str,
                 specification: str,
                 status: str,
                 vpc_id: str):
        """
        :param str access_point_id: ID of the access point used by the VBR.
        :param str creation_time: Router interface creation time.
        :param str description: Router interface description.
        :param str health_check_source_ip: Source IP address used to perform health check on the physical connection.
        :param str health_check_target_ip: Destination IP address used to perform health check on the physical connection.
        :param str id: Router interface ID.
        :param str name: Router interface name.
        :param str opposite_interface_id: ID of the peer router interface.
        :param str opposite_interface_owner_id: Account ID of the owner of the peer router interface.
        :param str opposite_region_id: Peer router region ID.
        :param str opposite_router_id: Peer router ID.
        :param str opposite_router_type: Router type in the peer region. Possible values: `VRouter` and `VBR`.
        :param str role: Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and 
               `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
        :param str router_id: ID of the VRouter located in the local region.
        :param str router_type: Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
        :param str specification: Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
        :param str status: Expected status. Valid values are `Active`, `Inactive` and `Idle`.
        :param str vpc_id: ID of the VPC that owns the router in the local region.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        ID of the access point used by the VBR.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Router interface creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Router interface description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> str:
        """
        Source IP address used to perform health check on the physical connection.
        """
        return pulumi.get(self, "health_check_source_ip")

    @property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> str:
        """
        Destination IP address used to perform health check on the physical connection.
        """
        return pulumi.get(self, "health_check_target_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Router interface ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Router interface name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> str:
        """
        ID of the peer router interface.
        """
        return pulumi.get(self, "opposite_interface_id")

    @property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> str:
        """
        Account ID of the owner of the peer router interface.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> str:
        """
        Peer router region ID.
        """
        return pulumi.get(self, "opposite_region_id")

    @property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> str:
        """
        Peer router ID.
        """
        return pulumi.get(self, "opposite_router_id")

    @property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> str:
        """
        Router type in the peer region. Possible values: `VRouter` and `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and 
        `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        ID of the VRouter located in the local region.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerType")
    def router_type(self) -> str:
        """
        Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
        """
        return pulumi.get(self, "router_type")

    @property
    @pulumi.getter
    def specification(self) -> str:
        """
        Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Expected status. Valid values are `Active`, `Inactive` and `Idle`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC that owns the router in the local region.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetSnatEntriesEntryResult(dict):
    def __init__(__self__, *,
                 id: str,
                 snat_entry_id: str,
                 snat_entry_name: str,
                 snat_ip: str,
                 source_cidr: str,
                 source_vswitch_id: str,
                 status: str):
        """
        :param str id: The ID of the Snat Entry.
        :param str snat_entry_id: The ID of snat entry.
        :param str snat_entry_name: The name of snat entry.
        :param str snat_ip: The public IP of the Snat Entry.
        :param str source_cidr: The source CIDR block of the Snat Entry.
        :param str source_vswitch_id: The source vswitch ID.
        :param str status: The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "snat_entry_id", snat_entry_id)
        pulumi.set(__self__, "snat_entry_name", snat_entry_name)
        pulumi.set(__self__, "snat_ip", snat_ip)
        pulumi.set(__self__, "source_cidr", source_cidr)
        pulumi.set(__self__, "source_vswitch_id", source_vswitch_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Snat Entry.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="snatEntryId")
    def snat_entry_id(self) -> str:
        """
        The ID of snat entry.
        """
        return pulumi.get(self, "snat_entry_id")

    @property
    @pulumi.getter(name="snatEntryName")
    def snat_entry_name(self) -> str:
        """
        The name of snat entry.
        """
        return pulumi.get(self, "snat_entry_name")

    @property
    @pulumi.getter(name="snatIp")
    def snat_ip(self) -> str:
        """
        The public IP of the Snat Entry.
        """
        return pulumi.get(self, "snat_ip")

    @property
    @pulumi.getter(name="sourceCidr")
    def source_cidr(self) -> str:
        """
        The source CIDR block of the Snat Entry.
        """
        return pulumi.get(self, "source_cidr")

    @property
    @pulumi.getter(name="sourceVswitchId")
    def source_vswitch_id(self) -> str:
        """
        The source vswitch ID.
        """
        return pulumi.get(self, "source_vswitch_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSslVpnClientCertsCertResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 end_time: int,
                 id: str,
                 name: str,
                 ssl_vpn_server_id: str,
                 status: str):
        """
        :param str create_time: The time of creation.
        :param int end_time: The expiration time of the client certificate.
        :param str id: ID of the SSL-VPN client certificate.
        :param str name: The name of the SSL-VPN client certificate.
        :param str ssl_vpn_server_id: Use the SSL-VPN server ID as the search key.
        :param str status: The status of the client certificate. valid value:expiring-soon, normal, expired.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ssl_vpn_server_id", ssl_vpn_server_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time of creation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> int:
        """
        The expiration time of the client certificate.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the SSL-VPN client certificate.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SSL-VPN client certificate.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sslVpnServerId")
    def ssl_vpn_server_id(self) -> str:
        """
        Use the SSL-VPN server ID as the search key.
        """
        return pulumi.get(self, "ssl_vpn_server_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the client certificate. valid value:expiring-soon, normal, expired.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetSslVpnServersServerResult(dict):
    def __init__(__self__, *,
                 cipher: str,
                 client_ip_pool: str,
                 compress: bool,
                 connections: int,
                 create_time: str,
                 id: str,
                 internet_ip: str,
                 local_subnet: str,
                 max_connections: int,
                 name: str,
                 port: int,
                 proto: str,
                 vpn_gateway_id: str):
        """
        :param str cipher: The encryption algorithm used.
        :param str client_ip_pool: The IP address pool of the client.
        :param bool compress: Whether to compress.
        :param int connections: The number of current connections.
        :param str create_time: The time of creation.
        :param str id: The ID of the SSL-VPN server.
        :param str internet_ip: The public IP.
        :param str local_subnet: The local subnet of the VPN connection.
        :param int max_connections: The maximum number of connections.
        :param str name: The name of the SSL-VPN server.
        :param int port: The port used by the SSL-VPN server.
        :param str proto: The protocol used by the SSL-VPN server.
        :param str vpn_gateway_id: Use the VPN gateway ID as the search key.
        """
        pulumi.set(__self__, "cipher", cipher)
        pulumi.set(__self__, "client_ip_pool", client_ip_pool)
        pulumi.set(__self__, "compress", compress)
        pulumi.set(__self__, "connections", connections)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "max_connections", max_connections)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)

    @property
    @pulumi.getter
    def cipher(self) -> str:
        """
        The encryption algorithm used.
        """
        return pulumi.get(self, "cipher")

    @property
    @pulumi.getter(name="clientIpPool")
    def client_ip_pool(self) -> str:
        """
        The IP address pool of the client.
        """
        return pulumi.get(self, "client_ip_pool")

    @property
    @pulumi.getter
    def compress(self) -> bool:
        """
        Whether to compress.
        """
        return pulumi.get(self, "compress")

    @property
    @pulumi.getter
    def connections(self) -> int:
        """
        The number of current connections.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time of creation.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the SSL-VPN server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> str:
        """
        The public IP.
        """
        return pulumi.get(self, "internet_ip")

    @property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> str:
        """
        The local subnet of the VPN connection.
        """
        return pulumi.get(self, "local_subnet")

    @property
    @pulumi.getter(name="maxConnections")
    def max_connections(self) -> int:
        """
        The maximum number of connections.
        """
        return pulumi.get(self, "max_connections")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the SSL-VPN server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port used by the SSL-VPN server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def proto(self) -> str:
        """
        The protocol used by the SSL-VPN server.
        """
        return pulumi.get(self, "proto")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> str:
        """
        Use the VPN gateway ID as the search key.
        """
        return pulumi.get(self, "vpn_gateway_id")


@pulumi.output_type
class GetSwitchesVswitchResult(dict):
    def __init__(__self__, *,
                 available_ip_address_count: int,
                 cidr_block: str,
                 creation_time: str,
                 description: str,
                 id: str,
                 ipv6_cidr_block: str,
                 is_default: bool,
                 name: str,
                 resource_group_id: str,
                 route_table_id: str,
                 status: str,
                 tags: Mapping[str, Any],
                 vpc_id: str,
                 vswitch_id: str,
                 vswitch_name: str,
                 zone_id: str):
        """
        :param int available_ip_address_count: The available ip address count of the VSwitch.
        :param str cidr_block: Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        :param str creation_time: Time of creation.
        :param str description: Description of the VSwitch.
        :param str id: ID of the VSwitch.
        :param str ipv6_cidr_block: The IPv6 CIDR block of the switch.
        :param bool is_default: Indicate whether the VSwitch is created by the system.
        :param str name: Name of the VSwitch.
        :param str resource_group_id: The Id of resource group which VSWitch belongs.
        :param str route_table_id: The route table ID of the VSwitch.
        :param str status: The status of the VSwitch. Valid values: `Available` and `Pending`.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str vpc_id: ID of the VPC that owns the VSwitch.
        :param str vswitch_id: ID of the VSwitch.
        :param str vswitch_name: The name of the VSwitch.
        :param str zone_id: The availability zone of the VSwitch.
        """
        pulumi.set(__self__, "available_ip_address_count", available_ip_address_count)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv6_cidr_block", ipv6_cidr_block)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "vswitch_name", vswitch_name)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="availableIpAddressCount")
    def available_ip_address_count(self) -> int:
        """
        The available ip address count of the VSwitch.
        """
        return pulumi.get(self, "available_ip_address_count")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        Filter results by a specific CIDR block. For example: "172.16.0.0/12".
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the VSwitch.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the VSwitch.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv6CidrBlock")
    def ipv6_cidr_block(self) -> str:
        """
        The IPv6 CIDR block of the switch.
        """
        return pulumi.get(self, "ipv6_cidr_block")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicate whether the VSwitch is created by the system.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the VSwitch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which VSWitch belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        The route table ID of the VSwitch.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the VSwitch. Valid values: `Available` and `Pending`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC that owns the VSwitch.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="vswitchName")
    def vswitch_name(self) -> str:
        """
        The name of the VSwitch.
        """
        return pulumi.get(self, "vswitch_name")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The availability zone of the VSwitch.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetTrafficMirrorFilterEgressRulesRuleResult(dict):
    def __init__(__self__, *,
                 destination_cidr_block: str,
                 destination_port_range: str,
                 id: str,
                 priority: int,
                 protocol: str,
                 rule_action: str,
                 source_cidr_block: str,
                 source_port_range: str,
                 status: str,
                 traffic_mirror_filter_id: str,
                 traffic_mirror_filter_rule_id: str):
        """
        :param str destination_cidr_block: The destination CIDR block of the outbound traffic.
        :param str destination_port_range: The destination port range of the outbound traffic.
        :param str id: The ID of the Traffic Mirror Filter Egress Rule.
        :param int priority: The priority of the outbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        :param str protocol: The transport protocol used by outbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        :param str rule_action: The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        :param str source_cidr_block: The source CIDR block of the outbound traffic.
        :param str source_port_range: The source port range of the outbound traffic.
        :param str status: The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        :param str traffic_mirror_filter_id: The ID of the filter associated with the outbound rule.
        :param str traffic_mirror_filter_rule_id: The first ID of the resource.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "destination_port_range", destination_port_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        pulumi.set(__self__, "source_port_range", source_port_range)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_rule_id", traffic_mirror_filter_rule_id)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> str:
        """
        The destination CIDR block of the outbound traffic.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> str:
        """
        The destination port range of the outbound traffic.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Traffic Mirror Filter Egress Rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the outbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol used by outbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> str:
        """
        The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        """
        return pulumi.get(self, "rule_action")

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> str:
        """
        The source CIDR block of the outbound traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> str:
        """
        The source port range of the outbound traffic.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> str:
        """
        The ID of the filter associated with the outbound rule.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleId")
    def traffic_mirror_filter_rule_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_filter_rule_id")


@pulumi.output_type
class GetTrafficMirrorFilterIngressRulesRuleResult(dict):
    def __init__(__self__, *,
                 destination_cidr_block: str,
                 destination_port_range: str,
                 id: str,
                 priority: int,
                 protocol: str,
                 rule_action: str,
                 source_cidr_block: str,
                 source_port_range: str,
                 status: str,
                 traffic_mirror_filter_id: str,
                 traffic_mirror_filter_rule_id: str):
        """
        :param str destination_cidr_block: The destination CIDR block of the inbound traffic.
        :param str destination_port_range: The destination port range of the inbound traffic.
        :param str id: The ID of the Traffic Mirror Filter Egress Rule.
        :param int priority: The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        :param str protocol: The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        :param str rule_action: The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        :param str source_cidr_block: The source CIDR block of the inbound traffic.
        :param str source_port_range: The source port range of the inbound traffic.
        :param str status: The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        :param str traffic_mirror_filter_id: The ID of the filter associated with the inbound rule.
        :param str traffic_mirror_filter_rule_id: The first ID of the resource.
        """
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "destination_port_range", destination_port_range)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "rule_action", rule_action)
        pulumi.set(__self__, "source_cidr_block", source_cidr_block)
        pulumi.set(__self__, "source_port_range", source_port_range)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_rule_id", traffic_mirror_filter_rule_id)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> str:
        """
        The destination CIDR block of the inbound traffic.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter(name="destinationPortRange")
    def destination_port_range(self) -> str:
        """
        The destination port range of the inbound traffic.
        """
        return pulumi.get(self, "destination_port_range")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Traffic Mirror Filter Egress Rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="ruleAction")
    def rule_action(self) -> str:
        """
        The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
        """
        return pulumi.get(self, "rule_action")

    @property
    @pulumi.getter(name="sourceCidrBlock")
    def source_cidr_block(self) -> str:
        """
        The source CIDR block of the inbound traffic.
        """
        return pulumi.get(self, "source_cidr_block")

    @property
    @pulumi.getter(name="sourcePortRange")
    def source_port_range(self) -> str:
        """
        The source port range of the inbound traffic.
        """
        return pulumi.get(self, "source_port_range")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> str:
        """
        The ID of the filter associated with the inbound rule.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorFilterRuleId")
    def traffic_mirror_filter_rule_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_filter_rule_id")


@pulumi.output_type
class GetTrafficMirrorFiltersFilterResult(dict):
    def __init__(__self__, *,
                 id: str,
                 status: str,
                 traffic_mirror_filter_description: str,
                 traffic_mirror_filter_id: str,
                 traffic_mirror_filter_name: str):
        """
        :param str id: The ID of the Traffic Mirror Filter.
        :param str status: The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
        :param str traffic_mirror_filter_description: The description of the filter.
        :param str traffic_mirror_filter_id: The ID of the filter.
        :param str traffic_mirror_filter_name: The name of the filter.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_description", traffic_mirror_filter_description)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_filter_name", traffic_mirror_filter_name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Traffic Mirror Filter.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the filter. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`. `Creating`: The filter is being created. `Created`: The filter is created. `Modifying`: The filter is being modified. `Deleting`: The filter is being deleted.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterDescription")
    def traffic_mirror_filter_description(self) -> str:
        """
        The description of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_description")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> str:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorFilterName")
    def traffic_mirror_filter_name(self) -> str:
        """
        The name of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_name")


@pulumi.output_type
class GetTrafficMirrorSessionsSessionResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 id: str,
                 packet_length: int,
                 priority: int,
                 status: str,
                 traffic_mirror_filter_id: str,
                 traffic_mirror_session_business_status: str,
                 traffic_mirror_session_description: str,
                 traffic_mirror_session_id: str,
                 traffic_mirror_session_name: str,
                 traffic_mirror_source_ids: Sequence[str],
                 traffic_mirror_target_id: str,
                 traffic_mirror_target_type: str,
                 virtual_network_id: int):
        """
        :param bool enabled: Indicates whether traffic mirror sessions are enabled. default to `false`.
        :param str id: The ID of the Traffic Mirror Session.
        :param int packet_length: The maximum transmission unit (MTU).
        :param int priority: The priority of the traffic mirror session. A smaller value indicates a higher priority.
        :param str status: The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
        :param str traffic_mirror_filter_id: The ID of the filter.
        :param str traffic_mirror_session_business_status: The state of the traffic mirror session. Valid values: `Normal` or `FinancialLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments.
        :param str traffic_mirror_session_description: The description of the traffic mirror session.
        :param str traffic_mirror_session_id: The first ID of the resource.
        :param str traffic_mirror_session_name: The name of the traffic mirror session.
        :param Sequence[str] traffic_mirror_source_ids: The ID of the mirror source.
        :param str traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param str traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance
        :param int virtual_network_id: You can specify VNIs to distinguish different mirrored traffic.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "packet_length", packet_length)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_session_business_status", traffic_mirror_session_business_status)
        pulumi.set(__self__, "traffic_mirror_session_description", traffic_mirror_session_description)
        pulumi.set(__self__, "traffic_mirror_session_id", traffic_mirror_session_id)
        pulumi.set(__self__, "traffic_mirror_session_name", traffic_mirror_session_name)
        pulumi.set(__self__, "traffic_mirror_source_ids", traffic_mirror_source_ids)
        pulumi.set(__self__, "traffic_mirror_target_id", traffic_mirror_target_id)
        pulumi.set(__self__, "traffic_mirror_target_type", traffic_mirror_target_type)
        pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether traffic mirror sessions are enabled. default to `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Traffic Mirror Session.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> int:
        """
        The maximum transmission unit (MTU).
        """
        return pulumi.get(self, "packet_length")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority of the traffic mirror session. A smaller value indicates a higher priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The state of the traffic mirror session. Valid values: `Creating`, `Created`, `Modifying` and `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> str:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorSessionBusinessStatus")
    def traffic_mirror_session_business_status(self) -> str:
        """
        The state of the traffic mirror session. Valid values: `Normal` or `FinancialLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments.
        """
        return pulumi.get(self, "traffic_mirror_session_business_status")

    @property
    @pulumi.getter(name="trafficMirrorSessionDescription")
    def traffic_mirror_session_description(self) -> str:
        """
        The description of the traffic mirror session.
        """
        return pulumi.get(self, "traffic_mirror_session_description")

    @property
    @pulumi.getter(name="trafficMirrorSessionId")
    def traffic_mirror_session_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "traffic_mirror_session_id")

    @property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> str:
        """
        The name of the traffic mirror session.
        """
        return pulumi.get(self, "traffic_mirror_session_name")

    @property
    @pulumi.getter(name="trafficMirrorSourceIds")
    def traffic_mirror_source_ids(self) -> Sequence[str]:
        """
        The ID of the mirror source.
        """
        return pulumi.get(self, "traffic_mirror_source_ids")

    @property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> str:
        """
        The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        """
        return pulumi.get(self, "traffic_mirror_target_id")

    @property
    @pulumi.getter(name="trafficMirrorTargetType")
    def traffic_mirror_target_type(self) -> str:
        """
        The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance
        """
        return pulumi.get(self, "traffic_mirror_target_type")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> int:
        """
        You can specify VNIs to distinguish different mirrored traffic.
        """
        return pulumi.get(self, "virtual_network_id")


@pulumi.output_type
class GetVpcFlowLogsLogResult(dict):
    def __init__(__self__, *,
                 description: str,
                 flow_log_id: str,
                 flow_log_name: str,
                 id: str,
                 log_store_name: str,
                 project_name: str,
                 resource_id: str,
                 resource_type: str,
                 status: str,
                 traffic_type: str):
        """
        :param str description: The Description of flow log.
        :param str flow_log_id: The flow log ID.
        :param str flow_log_name: The flow log name.
        :param str id: The ID of the Flow Log.
        :param str log_store_name: The log store name.
        :param str project_name: The project name.
        :param str resource_id: The resource id.
        :param str resource_type: The resource type.
        :param str status: The status of flow log.
        :param str traffic_type: The traffic type.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "flow_log_id", flow_log_id)
        pulumi.set(__self__, "flow_log_name", flow_log_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_store_name", log_store_name)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "traffic_type", traffic_type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Description of flow log.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowLogId")
    def flow_log_id(self) -> str:
        """
        The flow log ID.
        """
        return pulumi.get(self, "flow_log_id")

    @property
    @pulumi.getter(name="flowLogName")
    def flow_log_name(self) -> str:
        """
        The flow log name.
        """
        return pulumi.get(self, "flow_log_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Flow Log.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logStoreName")
    def log_store_name(self) -> str:
        """
        The log store name.
        """
        return pulumi.get(self, "log_store_name")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The project name.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource id.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The resource type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of flow log.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficType")
    def traffic_type(self) -> str:
        """
        The traffic type.
        """
        return pulumi.get(self, "traffic_type")


