# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PublicIpAddressPoolArgs', 'PublicIpAddressPool']

@pulumi.input_type
class PublicIpAddressPoolArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a PublicIpAddressPool resource.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of PrefixList.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if public_ip_address_pool_name is not None:
            pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @public_ip_address_pool_name.setter
    def public_ip_address_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_pool_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PublicIpAddressPoolState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_address_remaining: Optional[pulumi.Input[bool]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 total_ip_num: Optional[pulumi.Input[int]] = None,
                 used_ip_num: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering PublicIpAddressPool resources.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[bool] ip_address_remaining: Whether there is a free IP address.
        :param pulumi.Input[str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[str] status: The status of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of PrefixList.
        :param pulumi.Input[int] total_ip_num: The total number of public IP address pools.
        :param pulumi.Input[int] used_ip_num: The number of used IP addresses in the public IP address pool.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_address_remaining is not None:
            pulumi.set(__self__, "ip_address_remaining", ip_address_remaining)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if public_ip_address_pool_name is not None:
            pulumi.set(__self__, "public_ip_address_pool_name", public_ip_address_pool_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if total_ip_num is not None:
            pulumi.set(__self__, "total_ip_num", total_ip_num)
        if used_ip_num is not None:
            pulumi.set(__self__, "used_ip_num", used_ip_num)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether there is a free IP address.
        """
        return pulumi.get(self, "ip_address_remaining")

    @ip_address_remaining.setter
    def ip_address_remaining(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ip_address_remaining", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @public_ip_address_pool_name.setter
    def public_ip_address_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_pool_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the VPC Public IP address pool.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of public IP address pools.
        """
        return pulumi.get(self, "total_ip_num")

    @total_ip_num.setter
    def total_ip_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_ip_num", value)

    @property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> Optional[pulumi.Input[int]]:
        """
        The number of used IP addresses in the public IP address pool.
        """
        return pulumi.get(self, "used_ip_num")

    @used_ip_num.setter
    def used_ip_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_ip_num", value)


class PublicIpAddressPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        Provides a Vpc Public Ip Address Pool resource.

        For information about Vpc Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("defaultPublicIpAddressPool",
            description=name,
            public_ip_address_pool_name=name,
            isp="BGP",
            resource_group_id=default_resource_groups.ids[0])
        ```

        ## Import

        Vpc Public Ip Address Pool can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of PrefixList.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PublicIpAddressPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Public Ip Address Pool resource.

        For information about Vpc Public Ip Address Pool and how to use it, see [What is Public Ip Address Pool](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/createpublicipaddresspool).

        > **NOTE:** Available since v1.186.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups(status="OK")
        default_public_ip_address_pool = alicloud.vpc.PublicIpAddressPool("defaultPublicIpAddressPool",
            description=name,
            public_ip_address_pool_name=name,
            isp="BGP",
            resource_group_id=default_resource_groups.ids[0])
        ```

        ## Import

        Vpc Public Ip Address Pool can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/publicIpAddressPool:PublicIpAddressPool example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PublicIpAddressPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicIpAddressPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicIpAddressPoolArgs.__new__(PublicIpAddressPoolArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["isp"] = isp
            __props__.__dict__["public_ip_address_pool_name"] = public_ip_address_pool_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ip_address_remaining"] = None
            __props__.__dict__["public_ip_address_pool_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["total_ip_num"] = None
            __props__.__dict__["used_ip_num"] = None
        super(PublicIpAddressPool, __self__).__init__(
            'alicloud:vpc/publicIpAddressPool:PublicIpAddressPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ip_address_remaining: Optional[pulumi.Input[bool]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
            public_ip_address_pool_name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            total_ip_num: Optional[pulumi.Input[int]] = None,
            used_ip_num: Optional[pulumi.Input[int]] = None) -> 'PublicIpAddressPool':
        """
        Get an existing PublicIpAddressPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] description: Description.
        :param pulumi.Input[bool] ip_address_remaining: Whether there is a free IP address.
        :param pulumi.Input[str] isp: The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        :param pulumi.Input[str] public_ip_address_pool_name: The name of the VPC Public IP address pool.
        :param pulumi.Input[str] resource_group_id: The resource group ID of the VPC Public IP address pool.
        :param pulumi.Input[str] status: The status of the VPC Public IP address pool.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of PrefixList.
        :param pulumi.Input[int] total_ip_num: The total number of public IP address pools.
        :param pulumi.Input[int] used_ip_num: The number of used IP addresses in the public IP address pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicIpAddressPoolState.__new__(_PublicIpAddressPoolState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_address_remaining"] = ip_address_remaining
        __props__.__dict__["isp"] = isp
        __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
        __props__.__dict__["public_ip_address_pool_name"] = public_ip_address_pool_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["total_ip_num"] = total_ip_num
        __props__.__dict__["used_ip_num"] = used_ip_num
        return PublicIpAddressPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipAddressRemaining")
    def ip_address_remaining(self) -> pulumi.Output[bool]:
        """
        Whether there is a free IP address.
        """
        return pulumi.get(self, "ip_address_remaining")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[str]:
        """
        The Internet service provider. Valid values: `BGP`, `BGP_PRO`, `ChinaTelecom`, `ChinaUnicom`, `ChinaMobile`, `ChinaTelecom_L2`, `ChinaUnicom_L2`, `ChinaMobile_L2`, `BGP_FinanceCloud`. Default Value: `BGP`.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_ip_address_pool_id")

    @property
    @pulumi.getter(name="publicIpAddressPoolName")
    def public_ip_address_pool_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the VPC Public IP address pool.
        """
        return pulumi.get(self, "public_ip_address_pool_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The resource group ID of the VPC Public IP address pool.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the VPC Public IP address pool.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tags of PrefixList.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalIpNum")
    def total_ip_num(self) -> pulumi.Output[int]:
        """
        The total number of public IP address pools.
        """
        return pulumi.get(self, "total_ip_num")

    @property
    @pulumi.getter(name="usedIpNum")
    def used_ip_num(self) -> pulumi.Output[int]:
        """
        The number of used IP addresses in the public IP address pool.
        """
        return pulumi.get(self, "used_ip_num")

