# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TrafficMirrorSessionArgs', 'TrafficMirrorSession']

@pulumi.input_type
class TrafficMirrorSessionArgs:
    def __init__(__self__, *,
                 priority: pulumi.Input[int],
                 traffic_mirror_filter_id: pulumi.Input[str],
                 traffic_mirror_source_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 traffic_mirror_target_id: pulumi.Input[str],
                 traffic_mirror_target_type: pulumi.Input[str],
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 packet_length: Optional[pulumi.Input[int]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 traffic_mirror_session_description: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_name: Optional[pulumi.Input[str]] = None,
                 virtual_network_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a TrafficMirrorSession resource.
        :param pulumi.Input[int] priority: The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        :param pulumi.Input[str] traffic_mirror_filter_id: The ID of the filter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_mirror_source_ids: The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        :param pulumi.Input[str] traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param pulumi.Input[str] traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        :param pulumi.Input[bool] dry_run: Whether to PreCheck only this request, value:
               - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
               - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        :param pulumi.Input[bool] enabled: Specifies whether to enable traffic mirror sessions. default to `false`.
        :param pulumi.Input[int] packet_length: Maximum Transmission Unit (MTU).
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of this resource.
        :param pulumi.Input[str] traffic_mirror_session_description: The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] traffic_mirror_session_name: The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[int] virtual_network_id: The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        pulumi.set(__self__, "traffic_mirror_source_ids", traffic_mirror_source_ids)
        pulumi.set(__self__, "traffic_mirror_target_id", traffic_mirror_target_id)
        pulumi.set(__self__, "traffic_mirror_target_type", traffic_mirror_target_type)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if packet_length is not None:
            pulumi.set(__self__, "packet_length", packet_length)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_mirror_session_description is not None:
            pulumi.set(__self__, "traffic_mirror_session_description", traffic_mirror_session_description)
        if traffic_mirror_session_name is not None:
            pulumi.set(__self__, "traffic_mirror_session_name", traffic_mirror_session_name)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[int]:
        """
        The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> pulumi.Input[str]:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @traffic_mirror_filter_id.setter
    def traffic_mirror_filter_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "traffic_mirror_filter_id", value)

    @property
    @pulumi.getter(name="trafficMirrorSourceIds")
    def traffic_mirror_source_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        """
        return pulumi.get(self, "traffic_mirror_source_ids")

    @traffic_mirror_source_ids.setter
    def traffic_mirror_source_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "traffic_mirror_source_ids", value)

    @property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> pulumi.Input[str]:
        """
        The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        """
        return pulumi.get(self, "traffic_mirror_target_id")

    @traffic_mirror_target_id.setter
    def traffic_mirror_target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "traffic_mirror_target_id", value)

    @property
    @pulumi.getter(name="trafficMirrorTargetType")
    def traffic_mirror_target_type(self) -> pulumi.Input[str]:
        """
        The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        """
        return pulumi.get(self, "traffic_mirror_target_type")

    @traffic_mirror_target_type.setter
    def traffic_mirror_target_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "traffic_mirror_target_type", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to PreCheck only this request, value:
        - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
        - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable traffic mirror sessions. default to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Transmission Unit (MTU).
        """
        return pulumi.get(self, "packet_length")

    @packet_length.setter
    def packet_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "packet_length", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tags of this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficMirrorSessionDescription")
    def traffic_mirror_session_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "traffic_mirror_session_description")

    @traffic_mirror_session_description.setter
    def traffic_mirror_session_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_session_description", value)

    @property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "traffic_mirror_session_name")

    @traffic_mirror_session_name.setter
    def traffic_mirror_session_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_session_name", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _TrafficMirrorSessionState:
    def __init__(__self__, *,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 packet_length: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_description: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_name: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_mirror_target_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_target_type: Optional[pulumi.Input[str]] = None,
                 virtual_network_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering TrafficMirrorSession resources.
        :param pulumi.Input[bool] dry_run: Whether to PreCheck only this request, value:
               - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
               - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        :param pulumi.Input[bool] enabled: Specifies whether to enable traffic mirror sessions. default to `false`.
        :param pulumi.Input[int] packet_length: Maximum Transmission Unit (MTU).
        :param pulumi.Input[int] priority: The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of this resource.
        :param pulumi.Input[str] traffic_mirror_filter_id: The ID of the filter.
        :param pulumi.Input[str] traffic_mirror_session_description: The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] traffic_mirror_session_name: The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_mirror_source_ids: The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        :param pulumi.Input[str] traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param pulumi.Input[str] traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        :param pulumi.Input[int] virtual_network_id: The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if packet_length is not None:
            pulumi.set(__self__, "packet_length", packet_length)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_mirror_filter_id is not None:
            pulumi.set(__self__, "traffic_mirror_filter_id", traffic_mirror_filter_id)
        if traffic_mirror_session_description is not None:
            pulumi.set(__self__, "traffic_mirror_session_description", traffic_mirror_session_description)
        if traffic_mirror_session_name is not None:
            pulumi.set(__self__, "traffic_mirror_session_name", traffic_mirror_session_name)
        if traffic_mirror_source_ids is not None:
            pulumi.set(__self__, "traffic_mirror_source_ids", traffic_mirror_source_ids)
        if traffic_mirror_target_id is not None:
            pulumi.set(__self__, "traffic_mirror_target_id", traffic_mirror_target_id)
        if traffic_mirror_target_type is not None:
            pulumi.set(__self__, "traffic_mirror_target_type", traffic_mirror_target_type)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to PreCheck only this request, value:
        - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
        - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable traffic mirror sessions. default to `false`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Transmission Unit (MTU).
        """
        return pulumi.get(self, "packet_length")

    @packet_length.setter
    def packet_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "packet_length", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tags of this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @traffic_mirror_filter_id.setter
    def traffic_mirror_filter_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_filter_id", value)

    @property
    @pulumi.getter(name="trafficMirrorSessionDescription")
    def traffic_mirror_session_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "traffic_mirror_session_description")

    @traffic_mirror_session_description.setter
    def traffic_mirror_session_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_session_description", value)

    @property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "traffic_mirror_session_name")

    @traffic_mirror_session_name.setter
    def traffic_mirror_session_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_session_name", value)

    @property
    @pulumi.getter(name="trafficMirrorSourceIds")
    def traffic_mirror_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        """
        return pulumi.get(self, "traffic_mirror_source_ids")

    @traffic_mirror_source_ids.setter
    def traffic_mirror_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "traffic_mirror_source_ids", value)

    @property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        """
        return pulumi.get(self, "traffic_mirror_target_id")

    @traffic_mirror_target_id.setter
    def traffic_mirror_target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_target_id", value)

    @property
    @pulumi.getter(name="trafficMirrorTargetType")
    def traffic_mirror_target_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        """
        return pulumi.get(self, "traffic_mirror_target_type")

    @traffic_mirror_target_type.setter
    def traffic_mirror_target_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "traffic_mirror_target_type", value)

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "virtual_network_id", value)


class TrafficMirrorSession(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 packet_length: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_description: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_name: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_mirror_target_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_target_type: Optional[pulumi.Input[str]] = None,
                 virtual_network_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a VPC Traffic Mirror Session resource. Traffic mirroring session.

        For information about VPC Traffic Mirror Session and how to use it, see [What is Traffic Mirror Session](https://www.alibabacloud.com/help/en/doc-detail/261364.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.g7")
        default_zones = alicloud.get_zones(available_resource_creation="Instance",
            available_instance_type=default_instance_types.instance_types[0].id)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup",
            description=name,
            vpc_id=default_network.id)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_instance = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_instance.append(alicloud.ecs.Instance(f"defaultInstance-{range['value']}",
                availability_zone=default_zones.zones[0].id,
                instance_name=name,
                host_name=name,
                image_id=default_images.images[0].id,
                instance_type=default_instance_types.instance_types[0].id,
                security_groups=[default_security_group.id],
                vswitch_id=default_switch.id,
                system_disk_category="cloud_essd"))
        default_ecs_network_interface = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_ecs_network_interface.append(alicloud.ecs.EcsNetworkInterface(f"defaultEcsNetworkInterface-{range['value']}",
                network_interface_name=name,
                vswitch_id=default_switch.id,
                security_group_ids=[default_security_group.id]))
        default_ecs_network_interface_attachment = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_ecs_network_interface_attachment.append(alicloud.ecs.EcsNetworkInterfaceAttachment(f"defaultEcsNetworkInterfaceAttachment-{range['value']}",
                instance_id=default_instance[range["value"]].id,
                network_interface_id=default_ecs_network_interface[range["value"]].id))
        default_traffic_mirror_filter = alicloud.vpc.TrafficMirrorFilter("defaultTrafficMirrorFilter",
            traffic_mirror_filter_name=name,
            traffic_mirror_filter_description=name)
        default_traffic_mirror_session = alicloud.vpc.TrafficMirrorSession("defaultTrafficMirrorSession",
            priority=1,
            virtual_network_id=10,
            traffic_mirror_session_description=name,
            traffic_mirror_session_name=name,
            traffic_mirror_target_id=default_ecs_network_interface_attachment[0].network_interface_id,
            traffic_mirror_source_ids=[default_ecs_network_interface_attachment[1].network_interface_id],
            traffic_mirror_filter_id=default_traffic_mirror_filter.id,
            traffic_mirror_target_type="NetworkInterface")
        ```

        ## Import

        VPC Traffic Mirror Session can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/trafficMirrorSession:TrafficMirrorSession example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Whether to PreCheck only this request, value:
               - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
               - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        :param pulumi.Input[bool] enabled: Specifies whether to enable traffic mirror sessions. default to `false`.
        :param pulumi.Input[int] packet_length: Maximum Transmission Unit (MTU).
        :param pulumi.Input[int] priority: The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of this resource.
        :param pulumi.Input[str] traffic_mirror_filter_id: The ID of the filter.
        :param pulumi.Input[str] traffic_mirror_session_description: The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] traffic_mirror_session_name: The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_mirror_source_ids: The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        :param pulumi.Input[str] traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param pulumi.Input[str] traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        :param pulumi.Input[int] virtual_network_id: The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficMirrorSessionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Traffic Mirror Session resource. Traffic mirroring session.

        For information about VPC Traffic Mirror Session and how to use it, see [What is Traffic Mirror Session](https://www.alibabacloud.com/help/en/doc-detail/261364.htm).

        > **NOTE:** Available since v1.142.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_instance_types = alicloud.ecs.get_instance_types(instance_type_family="ecs.g7")
        default_zones = alicloud.get_zones(available_resource_creation="Instance",
            available_instance_type=default_instance_types.instance_types[0].id)
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.4.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.4.0.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup",
            description=name,
            vpc_id=default_network.id)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_instance = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_instance.append(alicloud.ecs.Instance(f"defaultInstance-{range['value']}",
                availability_zone=default_zones.zones[0].id,
                instance_name=name,
                host_name=name,
                image_id=default_images.images[0].id,
                instance_type=default_instance_types.instance_types[0].id,
                security_groups=[default_security_group.id],
                vswitch_id=default_switch.id,
                system_disk_category="cloud_essd"))
        default_ecs_network_interface = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_ecs_network_interface.append(alicloud.ecs.EcsNetworkInterface(f"defaultEcsNetworkInterface-{range['value']}",
                network_interface_name=name,
                vswitch_id=default_switch.id,
                security_group_ids=[default_security_group.id]))
        default_ecs_network_interface_attachment = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_ecs_network_interface_attachment.append(alicloud.ecs.EcsNetworkInterfaceAttachment(f"defaultEcsNetworkInterfaceAttachment-{range['value']}",
                instance_id=default_instance[range["value"]].id,
                network_interface_id=default_ecs_network_interface[range["value"]].id))
        default_traffic_mirror_filter = alicloud.vpc.TrafficMirrorFilter("defaultTrafficMirrorFilter",
            traffic_mirror_filter_name=name,
            traffic_mirror_filter_description=name)
        default_traffic_mirror_session = alicloud.vpc.TrafficMirrorSession("defaultTrafficMirrorSession",
            priority=1,
            virtual_network_id=10,
            traffic_mirror_session_description=name,
            traffic_mirror_session_name=name,
            traffic_mirror_target_id=default_ecs_network_interface_attachment[0].network_interface_id,
            traffic_mirror_source_ids=[default_ecs_network_interface_attachment[1].network_interface_id],
            traffic_mirror_filter_id=default_traffic_mirror_filter.id,
            traffic_mirror_target_type="NetworkInterface")
        ```

        ## Import

        VPC Traffic Mirror Session can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/trafficMirrorSession:TrafficMirrorSession example <id>
        ```

        :param str resource_name: The name of the resource.
        :param TrafficMirrorSessionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficMirrorSessionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 packet_length: Optional[pulumi.Input[int]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 traffic_mirror_filter_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_description: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_session_name: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 traffic_mirror_target_id: Optional[pulumi.Input[str]] = None,
                 traffic_mirror_target_type: Optional[pulumi.Input[str]] = None,
                 virtual_network_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficMirrorSessionArgs.__new__(TrafficMirrorSessionArgs)

            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["packet_length"] = packet_length
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if traffic_mirror_filter_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_mirror_filter_id'")
            __props__.__dict__["traffic_mirror_filter_id"] = traffic_mirror_filter_id
            __props__.__dict__["traffic_mirror_session_description"] = traffic_mirror_session_description
            __props__.__dict__["traffic_mirror_session_name"] = traffic_mirror_session_name
            if traffic_mirror_source_ids is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_mirror_source_ids'")
            __props__.__dict__["traffic_mirror_source_ids"] = traffic_mirror_source_ids
            if traffic_mirror_target_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_mirror_target_id'")
            __props__.__dict__["traffic_mirror_target_id"] = traffic_mirror_target_id
            if traffic_mirror_target_type is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_mirror_target_type'")
            __props__.__dict__["traffic_mirror_target_type"] = traffic_mirror_target_type
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["status"] = None
        super(TrafficMirrorSession, __self__).__init__(
            'alicloud:vpc/trafficMirrorSession:TrafficMirrorSession',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            packet_length: Optional[pulumi.Input[int]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            traffic_mirror_filter_id: Optional[pulumi.Input[str]] = None,
            traffic_mirror_session_description: Optional[pulumi.Input[str]] = None,
            traffic_mirror_session_name: Optional[pulumi.Input[str]] = None,
            traffic_mirror_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            traffic_mirror_target_id: Optional[pulumi.Input[str]] = None,
            traffic_mirror_target_type: Optional[pulumi.Input[str]] = None,
            virtual_network_id: Optional[pulumi.Input[int]] = None) -> 'TrafficMirrorSession':
        """
        Get an existing TrafficMirrorSession resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] dry_run: Whether to PreCheck only this request, value:
               - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
               - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        :param pulumi.Input[bool] enabled: Specifies whether to enable traffic mirror sessions. default to `false`.
        :param pulumi.Input[int] packet_length: Maximum Transmission Unit (MTU).
        :param pulumi.Input[int] priority: The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[Mapping[str, Any]] tags: The tags of this resource.
        :param pulumi.Input[str] traffic_mirror_filter_id: The ID of the filter.
        :param pulumi.Input[str] traffic_mirror_session_description: The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] traffic_mirror_session_name: The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] traffic_mirror_source_ids: The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        :param pulumi.Input[str] traffic_mirror_target_id: The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        :param pulumi.Input[str] traffic_mirror_target_type: The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        :param pulumi.Input[int] virtual_network_id: The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficMirrorSessionState.__new__(_TrafficMirrorSessionState)

        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["packet_length"] = packet_length
        __props__.__dict__["priority"] = priority
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_mirror_filter_id"] = traffic_mirror_filter_id
        __props__.__dict__["traffic_mirror_session_description"] = traffic_mirror_session_description
        __props__.__dict__["traffic_mirror_session_name"] = traffic_mirror_session_name
        __props__.__dict__["traffic_mirror_source_ids"] = traffic_mirror_source_ids
        __props__.__dict__["traffic_mirror_target_id"] = traffic_mirror_target_id
        __props__.__dict__["traffic_mirror_target_type"] = traffic_mirror_target_type
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return TrafficMirrorSession(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to PreCheck only this request, value:
        - **true**: sends a check request and does not create a mirror session. Check items include whether required parameters are filled in, request format, and restrictions. If the check fails, the corresponding error is returned. If the check passes, the error code 'DryRunOperation' is returned '.
        - **false** (default): Sends a normal request and directly creates a mirror session after checking.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable traffic mirror sessions. default to `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="packetLength")
    def packet_length(self) -> pulumi.Output[int]:
        """
        Maximum Transmission Unit (MTU).
        """
        return pulumi.get(self, "packet_length")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[int]:
        """
        The priority of the traffic mirror session. Valid values: `1` to `32766`. A smaller value indicates a higher priority. You cannot specify the same priority for traffic mirror sessions that are created in the same region with the same Alibaba Cloud account.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tags of this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficMirrorFilterId")
    def traffic_mirror_filter_id(self) -> pulumi.Output[str]:
        """
        The ID of the filter.
        """
        return pulumi.get(self, "traffic_mirror_filter_id")

    @property
    @pulumi.getter(name="trafficMirrorSessionDescription")
    def traffic_mirror_session_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the traffic mirror session. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "traffic_mirror_session_description")

    @property
    @pulumi.getter(name="trafficMirrorSessionName")
    def traffic_mirror_session_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the traffic mirror session. The name must be `2` to `128` characters in length and can contain digits, underscores (_), and hyphens (-). It must start with a letter.
        """
        return pulumi.get(self, "traffic_mirror_session_name")

    @property
    @pulumi.getter(name="trafficMirrorSourceIds")
    def traffic_mirror_source_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The ID of the image source instance. Currently, the Eni is supported as the image source. The default value of N is 1, that is, only one mirror source can be added to a mirror session.
        """
        return pulumi.get(self, "traffic_mirror_source_ids")

    @property
    @pulumi.getter(name="trafficMirrorTargetId")
    def traffic_mirror_target_id(self) -> pulumi.Output[str]:
        """
        The ID of the mirror destination. You can specify only an ENI or a Server Load Balancer (SLB) instance as a mirror destination.
        """
        return pulumi.get(self, "traffic_mirror_target_id")

    @property
    @pulumi.getter(name="trafficMirrorTargetType")
    def traffic_mirror_target_type(self) -> pulumi.Output[str]:
        """
        The type of the mirror destination. Valid values: `NetworkInterface` or `SLB`. `NetworkInterface`: an ENI. `SLB`: an internal-facing SLB instance.
        """
        return pulumi.get(self, "traffic_mirror_target_type")

    @property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[int]:
        """
        The VXLAN network identifier (VNI) that is used to distinguish different mirrored traffic. Valid values: `0` to `16777215`. You can specify VNIs for the traffic mirror destination to identify mirrored traffic from different sessions. If you do not specify a VNI, the system randomly allocates a VNI. If you want the system to randomly allocate a VNI, ignore this parameter.
        """
        return pulumi.get(self, "virtual_network_id")

