# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VswitchCidrReservationArgs', 'VswitchCidrReservation']

@pulumi.input_type
class VswitchCidrReservationArgs:
    def __init__(__self__, *,
                 vswitch_id: pulumi.Input[str],
                 cidr_reservation_cidr: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_description: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_mask: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_type: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 vswitch_cidr_reservation_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VswitchCidrReservation resource.
        :param pulumi.Input[str] vswitch_id: The Id of the switch instance.
        :param pulumi.Input[str] cidr_reservation_cidr: Reserved network segment CIdrBlock.
        :param pulumi.Input[str] cidr_reservation_description: The description of the reserved CIDR block.
        :param pulumi.Input[str] cidr_reservation_mask: Reserved segment mask.
        :param pulumi.Input[str] cidr_reservation_type: Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        :param pulumi.Input[str] ip_version: Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        :param pulumi.Input[str] vswitch_cidr_reservation_name: The name of the resource.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if cidr_reservation_cidr is not None:
            pulumi.set(__self__, "cidr_reservation_cidr", cidr_reservation_cidr)
        if cidr_reservation_description is not None:
            pulumi.set(__self__, "cidr_reservation_description", cidr_reservation_description)
        if cidr_reservation_mask is not None:
            pulumi.set(__self__, "cidr_reservation_mask", cidr_reservation_mask)
        if cidr_reservation_type is not None:
            pulumi.set(__self__, "cidr_reservation_type", cidr_reservation_type)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if vswitch_cidr_reservation_name is not None:
            pulumi.set(__self__, "vswitch_cidr_reservation_name", vswitch_cidr_reservation_name)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The Id of the switch instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="cidrReservationCidr")
    def cidr_reservation_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved network segment CIdrBlock.
        """
        return pulumi.get(self, "cidr_reservation_cidr")

    @cidr_reservation_cidr.setter
    def cidr_reservation_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_cidr", value)

    @property
    @pulumi.getter(name="cidrReservationDescription")
    def cidr_reservation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the reserved CIDR block.
        """
        return pulumi.get(self, "cidr_reservation_description")

    @cidr_reservation_description.setter
    def cidr_reservation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_description", value)

    @property
    @pulumi.getter(name="cidrReservationMask")
    def cidr_reservation_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved segment mask.
        """
        return pulumi.get(self, "cidr_reservation_mask")

    @cidr_reservation_mask.setter
    def cidr_reservation_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_mask", value)

    @property
    @pulumi.getter(name="cidrReservationType")
    def cidr_reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        """
        return pulumi.get(self, "cidr_reservation_type")

    @cidr_reservation_type.setter
    def cidr_reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_type", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="vswitchCidrReservationName")
    def vswitch_cidr_reservation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "vswitch_cidr_reservation_name")

    @vswitch_cidr_reservation_name.setter
    def vswitch_cidr_reservation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_cidr_reservation_name", value)


@pulumi.input_type
class _VswitchCidrReservationState:
    def __init__(__self__, *,
                 cidr_reservation_cidr: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_description: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_mask: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_type: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_cidr_reservation_id: Optional[pulumi.Input[str]] = None,
                 vswitch_cidr_reservation_name: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VswitchCidrReservation resources.
        :param pulumi.Input[str] cidr_reservation_cidr: Reserved network segment CIdrBlock.
        :param pulumi.Input[str] cidr_reservation_description: The description of the reserved CIDR block.
        :param pulumi.Input[str] cidr_reservation_mask: Reserved segment mask.
        :param pulumi.Input[str] cidr_reservation_type: Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] ip_version: Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] vpc_id: The id of the vpc instance to which the reserved CIDR block belongs.
        :param pulumi.Input[str] vswitch_cidr_reservation_id: The resource attribute field of the resource ID.
        :param pulumi.Input[str] vswitch_cidr_reservation_name: The name of the resource.
        :param pulumi.Input[str] vswitch_id: The Id of the switch instance.
        """
        if cidr_reservation_cidr is not None:
            pulumi.set(__self__, "cidr_reservation_cidr", cidr_reservation_cidr)
        if cidr_reservation_description is not None:
            pulumi.set(__self__, "cidr_reservation_description", cidr_reservation_description)
        if cidr_reservation_mask is not None:
            pulumi.set(__self__, "cidr_reservation_mask", cidr_reservation_mask)
        if cidr_reservation_type is not None:
            pulumi.set(__self__, "cidr_reservation_type", cidr_reservation_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_cidr_reservation_id is not None:
            pulumi.set(__self__, "vswitch_cidr_reservation_id", vswitch_cidr_reservation_id)
        if vswitch_cidr_reservation_name is not None:
            pulumi.set(__self__, "vswitch_cidr_reservation_name", vswitch_cidr_reservation_name)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="cidrReservationCidr")
    def cidr_reservation_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved network segment CIdrBlock.
        """
        return pulumi.get(self, "cidr_reservation_cidr")

    @cidr_reservation_cidr.setter
    def cidr_reservation_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_cidr", value)

    @property
    @pulumi.getter(name="cidrReservationDescription")
    def cidr_reservation_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the reserved CIDR block.
        """
        return pulumi.get(self, "cidr_reservation_description")

    @cidr_reservation_description.setter
    def cidr_reservation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_description", value)

    @property
    @pulumi.getter(name="cidrReservationMask")
    def cidr_reservation_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved segment mask.
        """
        return pulumi.get(self, "cidr_reservation_mask")

    @cidr_reservation_mask.setter
    def cidr_reservation_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_mask", value)

    @property
    @pulumi.getter(name="cidrReservationType")
    def cidr_reservation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        """
        return pulumi.get(self, "cidr_reservation_type")

    @cidr_reservation_type.setter
    def cidr_reservation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_reservation_type", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the vpc instance to which the reserved CIDR block belongs.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchCidrReservationId")
    def vswitch_cidr_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource attribute field of the resource ID.
        """
        return pulumi.get(self, "vswitch_cidr_reservation_id")

    @vswitch_cidr_reservation_id.setter
    def vswitch_cidr_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_cidr_reservation_id", value)

    @property
    @pulumi.getter(name="vswitchCidrReservationName")
    def vswitch_cidr_reservation_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "vswitch_cidr_reservation_name")

    @vswitch_cidr_reservation_name.setter
    def vswitch_cidr_reservation_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_cidr_reservation_name", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the switch instance.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class VswitchCidrReservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_reservation_cidr: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_description: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_mask: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_type: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 vswitch_cidr_reservation_name: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Vpc Vswitch Cidr Reservation resource. The reserved network segment of the vswitch. This resource type can be used only in ap-southeast region.

        For information about Vpc Vswitch Cidr Reservation and how to use it, see [What is Vswitch Cidr Reservation](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/610154).

        > **NOTE:** Available since v1.205.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_vpc = alicloud.vpc.Network("defaultVpc",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_v_switch = alicloud.vpc.Switch("defaultVSwitch",
            vpc_id=default_vpc.id,
            cidr_block="10.0.0.0/20",
            vswitch_name=f"{name}1",
            zone_id=default_zones.zones[0].id)
        default_vswitch_cidr_reservation = alicloud.vpc.VswitchCidrReservation("defaultVswitchCidrReservation",
            ip_version="IPv4",
            vswitch_id=default_v_switch.id,
            cidr_reservation_description=name,
            cidr_reservation_cidr="10.0.10.0/24",
            vswitch_cidr_reservation_name=name,
            cidr_reservation_type="Prefix")
        ```

        ## Import

        Vpc Vswitch Cidr Reservation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/vswitchCidrReservation:VswitchCidrReservation example <vswitch_id>:<vswitch_cidr_reservation_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_reservation_cidr: Reserved network segment CIdrBlock.
        :param pulumi.Input[str] cidr_reservation_description: The description of the reserved CIDR block.
        :param pulumi.Input[str] cidr_reservation_mask: Reserved segment mask.
        :param pulumi.Input[str] cidr_reservation_type: Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        :param pulumi.Input[str] ip_version: Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        :param pulumi.Input[str] vswitch_cidr_reservation_name: The name of the resource.
        :param pulumi.Input[str] vswitch_id: The Id of the switch instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VswitchCidrReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Vswitch Cidr Reservation resource. The reserved network segment of the vswitch. This resource type can be used only in ap-southeast region.

        For information about Vpc Vswitch Cidr Reservation and how to use it, see [What is Vswitch Cidr Reservation](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/610154).

        > **NOTE:** Available since v1.205.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_vpc = alicloud.vpc.Network("defaultVpc",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_v_switch = alicloud.vpc.Switch("defaultVSwitch",
            vpc_id=default_vpc.id,
            cidr_block="10.0.0.0/20",
            vswitch_name=f"{name}1",
            zone_id=default_zones.zones[0].id)
        default_vswitch_cidr_reservation = alicloud.vpc.VswitchCidrReservation("defaultVswitchCidrReservation",
            ip_version="IPv4",
            vswitch_id=default_v_switch.id,
            cidr_reservation_description=name,
            cidr_reservation_cidr="10.0.10.0/24",
            vswitch_cidr_reservation_name=name,
            cidr_reservation_type="Prefix")
        ```

        ## Import

        Vpc Vswitch Cidr Reservation can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:vpc/vswitchCidrReservation:VswitchCidrReservation example <vswitch_id>:<vswitch_cidr_reservation_id>
        ```

        :param str resource_name: The name of the resource.
        :param VswitchCidrReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VswitchCidrReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cidr_reservation_cidr: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_description: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_mask: Optional[pulumi.Input[str]] = None,
                 cidr_reservation_type: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 vswitch_cidr_reservation_name: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VswitchCidrReservationArgs.__new__(VswitchCidrReservationArgs)

            __props__.__dict__["cidr_reservation_cidr"] = cidr_reservation_cidr
            __props__.__dict__["cidr_reservation_description"] = cidr_reservation_description
            __props__.__dict__["cidr_reservation_mask"] = cidr_reservation_mask
            __props__.__dict__["cidr_reservation_type"] = cidr_reservation_type
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["vswitch_cidr_reservation_name"] = vswitch_cidr_reservation_name
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["vswitch_cidr_reservation_id"] = None
        super(VswitchCidrReservation, __self__).__init__(
            'alicloud:vpc/vswitchCidrReservation:VswitchCidrReservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cidr_reservation_cidr: Optional[pulumi.Input[str]] = None,
            cidr_reservation_description: Optional[pulumi.Input[str]] = None,
            cidr_reservation_mask: Optional[pulumi.Input[str]] = None,
            cidr_reservation_type: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            ip_version: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_cidr_reservation_id: Optional[pulumi.Input[str]] = None,
            vswitch_cidr_reservation_name: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'VswitchCidrReservation':
        """
        Get an existing VswitchCidrReservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cidr_reservation_cidr: Reserved network segment CIdrBlock.
        :param pulumi.Input[str] cidr_reservation_description: The description of the reserved CIDR block.
        :param pulumi.Input[str] cidr_reservation_mask: Reserved segment mask.
        :param pulumi.Input[str] cidr_reservation_type: Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        :param pulumi.Input[str] create_time: The creation time of the resource.
        :param pulumi.Input[str] ip_version: Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        :param pulumi.Input[str] status: The status of the resource.
        :param pulumi.Input[str] vpc_id: The id of the vpc instance to which the reserved CIDR block belongs.
        :param pulumi.Input[str] vswitch_cidr_reservation_id: The resource attribute field of the resource ID.
        :param pulumi.Input[str] vswitch_cidr_reservation_name: The name of the resource.
        :param pulumi.Input[str] vswitch_id: The Id of the switch instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VswitchCidrReservationState.__new__(_VswitchCidrReservationState)

        __props__.__dict__["cidr_reservation_cidr"] = cidr_reservation_cidr
        __props__.__dict__["cidr_reservation_description"] = cidr_reservation_description
        __props__.__dict__["cidr_reservation_mask"] = cidr_reservation_mask
        __props__.__dict__["cidr_reservation_type"] = cidr_reservation_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["status"] = status
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_cidr_reservation_id"] = vswitch_cidr_reservation_id
        __props__.__dict__["vswitch_cidr_reservation_name"] = vswitch_cidr_reservation_name
        __props__.__dict__["vswitch_id"] = vswitch_id
        return VswitchCidrReservation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cidrReservationCidr")
    def cidr_reservation_cidr(self) -> pulumi.Output[str]:
        """
        Reserved network segment CIdrBlock.
        """
        return pulumi.get(self, "cidr_reservation_cidr")

    @property
    @pulumi.getter(name="cidrReservationDescription")
    def cidr_reservation_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the reserved CIDR block.
        """
        return pulumi.get(self, "cidr_reservation_description")

    @property
    @pulumi.getter(name="cidrReservationMask")
    def cidr_reservation_mask(self) -> pulumi.Output[Optional[str]]:
        """
        Reserved segment mask.
        """
        return pulumi.get(self, "cidr_reservation_mask")

    @property
    @pulumi.getter(name="cidrReservationType")
    def cidr_reservation_type(self) -> pulumi.Output[str]:
        """
        Reserved CIDR Block Type.Valid values: `Prefix`. Default value: Prefix.
        """
        return pulumi.get(self, "cidr_reservation_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[str]:
        """
        Reserved ip version of network segment, valid values: `IPv4`, `IPv6`, default IPv4.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The id of the vpc instance to which the reserved CIDR block belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchCidrReservationId")
    def vswitch_cidr_reservation_id(self) -> pulumi.Output[str]:
        """
        The resource attribute field of the resource ID.
        """
        return pulumi.get(self, "vswitch_cidr_reservation_id")

    @property
    @pulumi.getter(name="vswitchCidrReservationName")
    def vswitch_cidr_reservation_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the resource.
        """
        return pulumi.get(self, "vswitch_cidr_reservation_name")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The Id of the switch instance.
        """
        return pulumi.get(self, "vswitch_id")

