# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetGatewayVcoRoutesResult',
    'AwaitableGetGatewayVcoRoutesResult',
    'get_gateway_vco_routes',
    'get_gateway_vco_routes_output',
]

@pulumi.output_type
class GetGatewayVcoRoutesResult:
    """
    A collection of values returned by getGatewayVcoRoutes.
    """
    def __init__(__self__, id=None, ids=None, output_file=None, page_number=None, page_size=None, route_entry_type=None, routes=None, status=None, vpn_connection_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if route_entry_type and not isinstance(route_entry_type, str):
            raise TypeError("Expected argument 'route_entry_type' to be a str")
        pulumi.set(__self__, "route_entry_type", route_entry_type)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpn_connection_id and not isinstance(vpn_connection_id, str):
            raise TypeError("Expected argument 'vpn_connection_id' to be a str")
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="routeEntryType")
    def route_entry_type(self) -> Optional[str]:
        return pulumi.get(self, "route_entry_type")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetGatewayVcoRoutesRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> str:
        return pulumi.get(self, "vpn_connection_id")


class AwaitableGetGatewayVcoRoutesResult(GetGatewayVcoRoutesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayVcoRoutesResult(
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            route_entry_type=self.route_entry_type,
            routes=self.routes,
            status=self.status,
            vpn_connection_id=self.vpn_connection_id)


def get_gateway_vco_routes(ids: Optional[Sequence[str]] = None,
                           output_file: Optional[str] = None,
                           page_number: Optional[int] = None,
                           page_size: Optional[int] = None,
                           route_entry_type: Optional[str] = None,
                           status: Optional[str] = None,
                           vpn_connection_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayVcoRoutesResult:
    """
    This data source provides the Vpn Gateway Vco Routes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.183.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instance = alicloud.cen.Instance("defaultInstance", cen_instance_name=var["name"])
    default_transit_router = alicloud.cen.TransitRouter("defaultTransitRouter",
        cen_id=default_instance.id,
        transit_router_description="desd",
        transit_router_name=var["name"])
    default_transit_router_available_resources = alicloud.cen.get_transit_router_available_resources()
    default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
        ip_address="42.104.22.210",
        asn="45014",
        description="testAccVpnConnectionDesc")
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("defaultGatewayVpnAttachment",
        customer_gateway_id=default_customer_gateway.id,
        network_type="public",
        local_subnet="0.0.0.0/0",
        remote_subnet="0.0.0.0/0",
        effect_immediately=False,
        ike_config=alicloud.vpn.GatewayVpnAttachmentIkeConfigArgs(
            ike_auth_alg="md5",
            ike_enc_alg="des",
            ike_version="ikev2",
            ike_mode="main",
            ike_lifetime=86400,
            psk="tf-testvpn2",
            ike_pfs="group1",
            remote_id="testbob2",
            local_id="testalice2",
        ),
        ipsec_config=alicloud.vpn.GatewayVpnAttachmentIpsecConfigArgs(
            ipsec_pfs="group5",
            ipsec_enc_alg="des",
            ipsec_auth_alg="md5",
            ipsec_lifetime=86400,
        ),
        bgp_config=alicloud.vpn.GatewayVpnAttachmentBgpConfigArgs(
            enable=True,
            local_asn=45014,
            tunnel_cidr="169.254.11.0/30",
            local_bgp_ip="169.254.11.1",
        ),
        health_check_config=alicloud.vpn.GatewayVpnAttachmentHealthCheckConfigArgs(
            enable=True,
            sip="192.168.1.1",
            dip="10.0.0.1",
            interval=10,
            retry=10,
            policy="revoke_route",
        ),
        enable_dpd=True,
        enable_nat_traversal=True,
        vpn_attachment_name=var["name"])
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("defaultTransitRouterVpnAttachment",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=var["name"],
        transit_router_attachment_name=var["name"],
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        zones=[alicloud.cen.TransitRouterVpnAttachmentZoneArgs(
            zone_id=default_transit_router_available_resources.resources[0].master_zones[0],
        )])
    default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("defaultGatewayVcoRoute",
        route_dest="192.168.12.0/24",
        next_hop=default_transit_router_vpn_attachment.vpn_id,
        vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
        weight=100)
    default_gateway_vco_routes = alicloud.vpn.get_gateway_vco_routes_output(vpn_connection_id=default_transit_router_vpn_attachment.vpn_id)
    pulumi.export("vpnGatewayVcoRouteId1", data["alicloud_vpn_gateway_vco_routes"]["ids"]["routes"][0]["id"])
    ```


    :param Sequence[str] ids: A list of Vco Route IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str route_entry_type: The Routing input type. Valid values: `custom`, `bgp`.
    :param str status: The status of the vpn route entry.
    :param str vpn_connection_id: The id of the vpn connection.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['routeEntryType'] = route_entry_type
    __args__['status'] = status
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:vpn/getGatewayVcoRoutes:getGatewayVcoRoutes', __args__, opts=opts, typ=GetGatewayVcoRoutesResult).value

    return AwaitableGetGatewayVcoRoutesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        route_entry_type=pulumi.get(__ret__, 'route_entry_type'),
        routes=pulumi.get(__ret__, 'routes'),
        status=pulumi.get(__ret__, 'status'),
        vpn_connection_id=pulumi.get(__ret__, 'vpn_connection_id'))


@_utilities.lift_output_func(get_gateway_vco_routes)
def get_gateway_vco_routes_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                  page_number: Optional[pulumi.Input[Optional[int]]] = None,
                                  page_size: Optional[pulumi.Input[Optional[int]]] = None,
                                  route_entry_type: Optional[pulumi.Input[Optional[str]]] = None,
                                  status: Optional[pulumi.Input[Optional[str]]] = None,
                                  vpn_connection_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayVcoRoutesResult]:
    """
    This data source provides the Vpn Gateway Vco Routes of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.183.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instance = alicloud.cen.Instance("defaultInstance", cen_instance_name=var["name"])
    default_transit_router = alicloud.cen.TransitRouter("defaultTransitRouter",
        cen_id=default_instance.id,
        transit_router_description="desd",
        transit_router_name=var["name"])
    default_transit_router_available_resources = alicloud.cen.get_transit_router_available_resources()
    default_customer_gateway = alicloud.vpn.CustomerGateway("defaultCustomerGateway",
        ip_address="42.104.22.210",
        asn="45014",
        description="testAccVpnConnectionDesc")
    default_gateway_vpn_attachment = alicloud.vpn.GatewayVpnAttachment("defaultGatewayVpnAttachment",
        customer_gateway_id=default_customer_gateway.id,
        network_type="public",
        local_subnet="0.0.0.0/0",
        remote_subnet="0.0.0.0/0",
        effect_immediately=False,
        ike_config=alicloud.vpn.GatewayVpnAttachmentIkeConfigArgs(
            ike_auth_alg="md5",
            ike_enc_alg="des",
            ike_version="ikev2",
            ike_mode="main",
            ike_lifetime=86400,
            psk="tf-testvpn2",
            ike_pfs="group1",
            remote_id="testbob2",
            local_id="testalice2",
        ),
        ipsec_config=alicloud.vpn.GatewayVpnAttachmentIpsecConfigArgs(
            ipsec_pfs="group5",
            ipsec_enc_alg="des",
            ipsec_auth_alg="md5",
            ipsec_lifetime=86400,
        ),
        bgp_config=alicloud.vpn.GatewayVpnAttachmentBgpConfigArgs(
            enable=True,
            local_asn=45014,
            tunnel_cidr="169.254.11.0/30",
            local_bgp_ip="169.254.11.1",
        ),
        health_check_config=alicloud.vpn.GatewayVpnAttachmentHealthCheckConfigArgs(
            enable=True,
            sip="192.168.1.1",
            dip="10.0.0.1",
            interval=10,
            retry=10,
            policy="revoke_route",
        ),
        enable_dpd=True,
        enable_nat_traversal=True,
        vpn_attachment_name=var["name"])
    default_transit_router_vpn_attachment = alicloud.cen.TransitRouterVpnAttachment("defaultTransitRouterVpnAttachment",
        auto_publish_route_enabled=False,
        transit_router_attachment_description=var["name"],
        transit_router_attachment_name=var["name"],
        cen_id=default_transit_router.cen_id,
        transit_router_id=default_transit_router.transit_router_id,
        vpn_id=default_gateway_vpn_attachment.id,
        zones=[alicloud.cen.TransitRouterVpnAttachmentZoneArgs(
            zone_id=default_transit_router_available_resources.resources[0].master_zones[0],
        )])
    default_gateway_vco_route = alicloud.vpn.GatewayVcoRoute("defaultGatewayVcoRoute",
        route_dest="192.168.12.0/24",
        next_hop=default_transit_router_vpn_attachment.vpn_id,
        vpn_connection_id=default_transit_router_vpn_attachment.vpn_id,
        weight=100)
    default_gateway_vco_routes = alicloud.vpn.get_gateway_vco_routes_output(vpn_connection_id=default_transit_router_vpn_attachment.vpn_id)
    pulumi.export("vpnGatewayVcoRouteId1", data["alicloud_vpn_gateway_vco_routes"]["ids"]["routes"][0]["id"])
    ```


    :param Sequence[str] ids: A list of Vco Route IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str route_entry_type: The Routing input type. Valid values: `custom`, `bgp`.
    :param str status: The status of the vpn route entry.
    :param str vpn_connection_id: The id of the vpn connection.
    """
    ...
