# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionBgpConfig',
    'ConnectionHealthCheckConfig',
    'ConnectionIkeConfig',
    'ConnectionIpsecConfig',
    'GatewayVpnAttachmentBgpConfig',
    'GatewayVpnAttachmentHealthCheckConfig',
    'GatewayVpnAttachmentIkeConfig',
    'GatewayVpnAttachmentIpsecConfig',
    'IpsecServerIkeConfig',
    'IpsecServerIpsecConfig',
    'GetConnectionsConnectionResult',
    'GetConnectionsConnectionIkeConfigResult',
    'GetConnectionsConnectionIpsecConfigResult',
    'GetConnectionsConnectionVcoHealthCheckResult',
    'GetConnectionsConnectionVpnBgpConfigResult',
    'GetCustomerGatewaysGatewayResult',
    'GetGatewayVcoRoutesRouteResult',
    'GetGatewayVpnAttachmentsAttachmentResult',
    'GetGatewayVpnAttachmentsAttachmentBgpConfigResult',
    'GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult',
    'GetGatewayVpnAttachmentsAttachmentIkeConfigResult',
    'GetGatewayVpnAttachmentsAttachmentIpsecConfigResult',
    'GetGatewaysGatewayResult',
]

@pulumi.output_type
class ConnectionBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 local_asn: Optional[str] = None,
                 local_bgp_ip: Optional[str] = None,
                 tunnel_cidr: Optional[str] = None):
        """
        :param bool enable: Whether to enable BGP.
        :param str local_asn: The ASN on the Alibaba Cloud side.
        :param str local_bgp_ip: The BGP IP address on the Alibaba Cloud side.
        :param str tunnel_cidr: The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Whether to enable BGP.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[str]:
        """
        The ASN on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[str]:
        """
        The BGP IP address on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_bgp_ip")

    @property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[str]:
        """
        The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class ConnectionHealthCheckConfig(dict):
    def __init__(__self__, *,
                 dip: Optional[str] = None,
                 enable: Optional[bool] = None,
                 interval: Optional[int] = None,
                 retry: Optional[int] = None,
                 sip: Optional[str] = None):
        """
        :param str dip: The destination IP address.
        :param bool enable: Whether to enable Health Check.
        :param int interval: The interval between two consecutive health checks. Unit: seconds.
        :param int retry: The maximum number of health check retries.
        :param str sip: The source IP address.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)

    @property
    @pulumi.getter
    def dip(self) -> Optional[str]:
        """
        The destination IP address.
        """
        return pulumi.get(self, "dip")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Whether to enable Health Check.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retry(self) -> Optional[int]:
        """
        The maximum number of health check retries.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def sip(self) -> Optional[str]:
        """
        The source IP address.
        """
        return pulumi.get(self, "sip")


@pulumi.output_type
class ConnectionIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeLocalId":
            suggest = "ike_local_id"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeRemoteId":
            suggest = "ike_remote_id"
        elif key == "ikeVersion":
            suggest = "ike_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[str] = None,
                 ike_enc_alg: Optional[str] = None,
                 ike_lifetime: Optional[int] = None,
                 ike_local_id: Optional[str] = None,
                 ike_mode: Optional[str] = None,
                 ike_pfs: Optional[str] = None,
                 ike_remote_id: Optional[str] = None,
                 ike_version: Optional[str] = None,
                 psk: Optional[str] = None):
        """
        :param str ike_auth_alg: The authentication algorithm of phase-one negotiation. Valid value: md5 | sha1 . Default value: md5
        :param str ike_enc_alg: The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes
        :param int ike_lifetime: The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
        :param str ike_local_id: The identification of the VPN gateway.
        :param str ike_mode: The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: main
        :param str ike_pfs: The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
        :param str ike_remote_id: The identification of the customer gateway.
        :param str ike_version: The version of the IKE protocol. Valid value: ikev1 | ikev2. Default value: ikev1
        :param str psk: Used for authentication between the IPsec VPN gateway and the customer gateway.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_local_id is not None:
            pulumi.set(__self__, "ike_local_id", ike_local_id)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_remote_id is not None:
            pulumi.set(__self__, "ike_remote_id", ike_remote_id)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm of phase-one negotiation. Valid value: md5 | sha1 . Default value: md5
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeLocalId")
    def ike_local_id(self) -> Optional[str]:
        """
        The identification of the VPN gateway.
        """
        return pulumi.get(self, "ike_local_id")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[str]:
        """
        The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: main
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeRemoteId")
    def ike_remote_id(self) -> Optional[str]:
        """
        The identification of the customer gateway.
        """
        return pulumi.get(self, "ike_remote_id")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[str]:
        """
        The version of the IKE protocol. Valid value: ikev1 | ikev2. Default value: ikev1
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter
    def psk(self) -> Optional[str]:
        """
        Used for authentication between the IPsec VPN gateway and the customer gateway.
        """
        return pulumi.get(self, "psk")


@pulumi.output_type
class ConnectionIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[str] = None,
                 ipsec_enc_alg: Optional[str] = None,
                 ipsec_lifetime: Optional[int] = None,
                 ipsec_pfs: Optional[str] = None):
        """
        :param str ipsec_auth_alg: The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
        :param str ipsec_enc_alg: The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
        :param int ipsec_lifetime: The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
        :param str ipsec_pfs: The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GatewayVpnAttachmentBgpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localAsn":
            suggest = "local_asn"
        elif key == "localBgpIp":
            suggest = "local_bgp_ip"
        elif key == "tunnelCidr":
            suggest = "tunnel_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentBgpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentBgpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentBgpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable: Optional[bool] = None,
                 local_asn: Optional[int] = None,
                 local_bgp_ip: Optional[str] = None,
                 tunnel_cidr: Optional[str] = None):
        """
        :param bool enable: Whether to enable BGP.
        :param int local_asn: The ASN on the Alibaba Cloud side.
        :param str local_bgp_ip: The BGP IP address on the Alibaba Cloud side.
        :param str tunnel_cidr: The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Whether to enable BGP.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[int]:
        """
        The ASN on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[str]:
        """
        The BGP IP address on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_bgp_ip")

    @property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[str]:
        """
        The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GatewayVpnAttachmentHealthCheckConfig(dict):
    def __init__(__self__, *,
                 dip: Optional[str] = None,
                 enable: Optional[bool] = None,
                 interval: Optional[int] = None,
                 policy: Optional[str] = None,
                 retry: Optional[int] = None,
                 sip: Optional[str] = None):
        """
        :param str dip: The destination IP address that is used for health checks.
        :param bool enable: Specifies whether to enable health checks.
        :param int interval: The interval between two consecutive health checks. Unit: seconds.
        :param str policy: Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
        :param int retry: The maximum number of health check retries.
        :param str sip: The source IP address that is used for health checks.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)

    @property
    @pulumi.getter
    def dip(self) -> Optional[str]:
        """
        The destination IP address that is used for health checks.
        """
        return pulumi.get(self, "dip")

    @property
    @pulumi.getter
    def enable(self) -> Optional[bool]:
        """
        Specifies whether to enable health checks.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        Whether to revoke the published route when the health check fails. Valid values: `revoke_route` or `reserve_route`.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def retry(self) -> Optional[int]:
        """
        The maximum number of health check retries.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def sip(self) -> Optional[str]:
        """
        The source IP address that is used for health checks.
        """
        return pulumi.get(self, "sip")


@pulumi.output_type
class GatewayVpnAttachmentIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[str] = None,
                 ike_enc_alg: Optional[str] = None,
                 ike_lifetime: Optional[int] = None,
                 ike_mode: Optional[str] = None,
                 ike_pfs: Optional[str] = None,
                 ike_version: Optional[str] = None,
                 local_id: Optional[str] = None,
                 psk: Optional[str] = None,
                 remote_id: Optional[str] = None):
        """
        :param str ike_auth_alg: IKE authentication algorithm supports sha1 and MD5.
        :param str ike_enc_alg: The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
        :param int ike_lifetime: The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
        :param str ike_mode: The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
        :param str ike_pfs: The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
        :param str ike_version: The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
        :param str local_id: The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
        :param str psk: Used for authentication between the IPsec VPN gateway and the customer gateway.
        :param str remote_id: The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[str]:
        """
        IKE authentication algorithm supports sha1 and MD5.
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-one negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default Valid value: aes.
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-one negotiation. The valid value of n is [0, 86400], the unit is second and the default value is 86400.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[str]:
        """
        The negotiation mode of IKE V1. Valid value: main (main mode) | aggressive (aggressive mode). Default value: `main`.
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-one negotiation. Valid value: group1 | group2 | group5 | group14 | group24. Default value: group2
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[str]:
        """
        The version of the IKE protocol. Valid value: `ikev1`, `ikev2`. Default value: `ikev1`.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[str]:
        """
        The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default.
        """
        return pulumi.get(self, "local_id")

    @property
    @pulumi.getter
    def psk(self) -> Optional[str]:
        """
        Used for authentication between the IPsec VPN gateway and the customer gateway.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[str]:
        """
        The peer ID, which supports FQDN and IP formats. By default, the IP address of the currently selected user gateway.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GatewayVpnAttachmentIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayVpnAttachmentIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayVpnAttachmentIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayVpnAttachmentIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[str] = None,
                 ipsec_enc_alg: Optional[str] = None,
                 ipsec_lifetime: Optional[int] = None,
                 ipsec_pfs: Optional[str] = None):
        """
        :param str ipsec_auth_alg: The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
        :param str ipsec_enc_alg: The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
        :param int ipsec_lifetime: The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
        :param str ipsec_pfs: The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm of phase-two negotiation. Valid value: md5 | sha1 | sha256 | sha384 | sha512 |. Default value: sha1
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-two negotiation. Valid value: aes | aes192 | aes256 | des | 3des. Default value: aes
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-two negotiation. The valid value is [0, 86400], the unit is second and the default value is 86400.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-two negotiation. Valid value: group1 | group2 | group5 | group14 | group24| disabled. Default value: group2
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class IpsecServerIkeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ikeAuthAlg":
            suggest = "ike_auth_alg"
        elif key == "ikeEncAlg":
            suggest = "ike_enc_alg"
        elif key == "ikeLifetime":
            suggest = "ike_lifetime"
        elif key == "ikeMode":
            suggest = "ike_mode"
        elif key == "ikePfs":
            suggest = "ike_pfs"
        elif key == "ikeVersion":
            suggest = "ike_version"
        elif key == "localId":
            suggest = "local_id"
        elif key == "remoteId":
            suggest = "remote_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecServerIkeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecServerIkeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecServerIkeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ike_auth_alg: Optional[str] = None,
                 ike_enc_alg: Optional[str] = None,
                 ike_lifetime: Optional[int] = None,
                 ike_mode: Optional[str] = None,
                 ike_pfs: Optional[str] = None,
                 ike_version: Optional[str] = None,
                 local_id: Optional[str] = None,
                 remote_id: Optional[str] = None):
        """
        :param str ike_auth_alg: The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        :param str ike_enc_alg: The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        :param int ike_lifetime: IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param str ike_mode: The IKE negotiation mode. Default value: `main`.
        :param str ike_pfs: The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        :param str ike_version: The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        :param str local_id: The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        :param str remote_id: The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if local_id is not None:
            pulumi.set(__self__, "local_id", local_id)
        if remote_id is not None:
            pulumi.set(__self__, "remote_id", remote_id)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm that is used in Phase 1 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm that is used in Phase 1 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[int]:
        """
        IkeLifetime: the SA lifetime determined by Phase 1 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[str]:
        """
        The IKE negotiation mode. Default value: `main`.
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm that is used in Phase 1 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[str]:
        """
        The IKE version. Valid values: `ikev1` and `ikev2`. Default value: `ikev2`.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> Optional[str]:
        """
        The identifier of the IPsec server. The value can be a fully qualified domain name (FQDN) or an IP address. The default value is the public IP address of the VPN gateway.
        """
        return pulumi.get(self, "local_id")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> Optional[str]:
        """
        The identifier of the customer gateway. The value can be an FQDN or an IP address. By default, this parameter is not specified.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class IpsecServerIpsecConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipsecAuthAlg":
            suggest = "ipsec_auth_alg"
        elif key == "ipsecEncAlg":
            suggest = "ipsec_enc_alg"
        elif key == "ipsecLifetime":
            suggest = "ipsec_lifetime"
        elif key == "ipsecPfs":
            suggest = "ipsec_pfs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpsecServerIpsecConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpsecServerIpsecConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpsecServerIpsecConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[str] = None,
                 ipsec_enc_alg: Optional[str] = None,
                 ipsec_lifetime: Optional[int] = None,
                 ipsec_pfs: Optional[str] = None):
        """
        :param str ipsec_auth_alg: The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        :param str ipsec_enc_alg: The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        :param int ipsec_lifetime: The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        :param str ipsec_pfs: Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm that is used in Phase 2 negotiations. Default value: `sha1`.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm that is used in Phase 2 negotiations. Default value: `aes`.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[int]:
        """
        The SA lifetime determined by Phase 2 negotiations. Valid values: `0` to `86400`. Default value: `86400`. Unit: `seconds`.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[str]:
        """
        Forwards packets of all protocols. The Diffie-Hellman key exchange algorithm used in Phase 2 negotiations. Default value: `group2`.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 customer_gateway_id: str,
                 effect_immediately: bool,
                 enable_dpd: bool,
                 enable_nat_traversal: bool,
                 id: str,
                 local_subnet: str,
                 name: str,
                 remote_subnet: str,
                 status: str,
                 vpn_gateway_id: str,
                 ike_configs: Optional[Sequence['outputs.GetConnectionsConnectionIkeConfigResult']] = None,
                 ipsec_configs: Optional[Sequence['outputs.GetConnectionsConnectionIpsecConfigResult']] = None,
                 vco_health_checks: Optional[Sequence['outputs.GetConnectionsConnectionVcoHealthCheckResult']] = None,
                 vpn_bgp_configs: Optional[Sequence['outputs.GetConnectionsConnectionVpnBgpConfigResult']] = None):
        """
        :param str customer_gateway_id: Use the VPN customer gateway ID as the search key.
        :param bool enable_dpd: Specifies whether to enable the dead peer detection (DPD) feature.
        :param bool enable_nat_traversal: Specifies whether to enable NAT traversal.
        :param str id: ID of the VPN connection.
        :param str local_subnet: The local subnet of the VPN connection.
        :param str name: The name of the VPN connection.
        :param str remote_subnet: The remote subnet of the VPN connection.
        :param str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        :param str vpn_gateway_id: Use the VPN gateway ID as the search key.
        :param Sequence['GetConnectionsConnectionIkeConfigArgs'] ike_configs: The configurations of phase-one negotiation.
        :param Sequence['GetConnectionsConnectionIpsecConfigArgs'] ipsec_configs: The configurations of phase-two negotiation.
        :param Sequence['GetConnectionsConnectionVpnBgpConfigArgs'] vpn_bgp_configs: The configuration information for BGP.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "enable_dpd", enable_dpd)
        pulumi.set(__self__, "enable_nat_traversal", enable_nat_traversal)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "remote_subnet", remote_subnet)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if ike_configs is not None:
            pulumi.set(__self__, "ike_configs", ike_configs)
        if ipsec_configs is not None:
            pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        if vco_health_checks is not None:
            pulumi.set(__self__, "vco_health_checks", vco_health_checks)
        if vpn_bgp_configs is not None:
            pulumi.set(__self__, "vpn_bgp_configs", vpn_bgp_configs)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> str:
        """
        Use the VPN customer gateway ID as the search key.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> bool:
        return pulumi.get(self, "effect_immediately")

    @property
    @pulumi.getter(name="enableDpd")
    def enable_dpd(self) -> bool:
        """
        Specifies whether to enable the dead peer detection (DPD) feature.
        """
        return pulumi.get(self, "enable_dpd")

    @property
    @pulumi.getter(name="enableNatTraversal")
    def enable_nat_traversal(self) -> bool:
        """
        Specifies whether to enable NAT traversal.
        """
        return pulumi.get(self, "enable_nat_traversal")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the VPN connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> str:
        """
        The local subnet of the VPN connection.
        """
        return pulumi.get(self, "local_subnet")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the VPN connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> str:
        """
        The remote subnet of the VPN connection.
        """
        return pulumi.get(self, "remote_subnet")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> str:
        """
        Use the VPN gateway ID as the search key.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionIkeConfigResult']]:
        """
        The configurations of phase-one negotiation.
        """
        return pulumi.get(self, "ike_configs")

    @property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionIpsecConfigResult']]:
        """
        The configurations of phase-two negotiation.
        """
        return pulumi.get(self, "ipsec_configs")

    @property
    @pulumi.getter(name="vcoHealthChecks")
    def vco_health_checks(self) -> Optional[Sequence['outputs.GetConnectionsConnectionVcoHealthCheckResult']]:
        return pulumi.get(self, "vco_health_checks")

    @property
    @pulumi.getter(name="vpnBgpConfigs")
    def vpn_bgp_configs(self) -> Optional[Sequence['outputs.GetConnectionsConnectionVpnBgpConfigResult']]:
        """
        The configuration information for BGP.
        """
        return pulumi.get(self, "vpn_bgp_configs")


@pulumi.output_type
class GetConnectionsConnectionIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: Optional[str] = None,
                 ike_enc_alg: Optional[str] = None,
                 ike_lifetime: Optional[int] = None,
                 ike_local_id: Optional[str] = None,
                 ike_mode: Optional[str] = None,
                 ike_pfs: Optional[str] = None,
                 ike_remote_id: Optional[str] = None,
                 ike_version: Optional[str] = None,
                 psk: Optional[str] = None):
        """
        :param str ike_auth_alg: The authentication algorithm of phase-one negotiation.
        :param str ike_enc_alg: The encryption algorithm of phase-one negotiation.
        :param int ike_lifetime: The SA lifecycle as the result of phase-one negotiation.
        :param str ike_local_id: The identification of the VPN gateway.
        :param str ike_mode: The negotiation mode of IKE phase-one.
        :param str ike_pfs: The Diffie-Hellman key exchange algorithm used by phase-one negotiation.
        :param str ike_remote_id: The identification of the customer gateway.
        :param str ike_version: The version of the IKE protocol.
        :param str psk: Used for authentication between the IPsec VPN gateway and the customer gateway.
        """
        if ike_auth_alg is not None:
            pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        if ike_enc_alg is not None:
            pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        if ike_lifetime is not None:
            pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        if ike_local_id is not None:
            pulumi.set(__self__, "ike_local_id", ike_local_id)
        if ike_mode is not None:
            pulumi.set(__self__, "ike_mode", ike_mode)
        if ike_pfs is not None:
            pulumi.set(__self__, "ike_pfs", ike_pfs)
        if ike_remote_id is not None:
            pulumi.set(__self__, "ike_remote_id", ike_remote_id)
        if ike_version is not None:
            pulumi.set(__self__, "ike_version", ike_version)
        if psk is not None:
            pulumi.set(__self__, "psk", psk)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm of phase-one negotiation.
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-one negotiation.
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-one negotiation.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeLocalId")
    def ike_local_id(self) -> Optional[str]:
        """
        The identification of the VPN gateway.
        """
        return pulumi.get(self, "ike_local_id")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> Optional[str]:
        """
        The negotiation mode of IKE phase-one.
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-one negotiation.
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeRemoteId")
    def ike_remote_id(self) -> Optional[str]:
        """
        The identification of the customer gateway.
        """
        return pulumi.get(self, "ike_remote_id")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> Optional[str]:
        """
        The version of the IKE protocol.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter
    def psk(self) -> Optional[str]:
        """
        Used for authentication between the IPsec VPN gateway and the customer gateway.
        """
        return pulumi.get(self, "psk")


@pulumi.output_type
class GetConnectionsConnectionIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: Optional[str] = None,
                 ipsec_enc_alg: Optional[str] = None,
                 ipsec_lifetime: Optional[int] = None,
                 ipsec_pfs: Optional[str] = None):
        """
        :param str ipsec_auth_alg: The authentication algorithm of phase-two negotiation.
        :param str ipsec_enc_alg: The encryption algorithm of phase-two negotiation.
        :param int ipsec_lifetime: The SA lifecycle as the result of phase-two negotiation.
        :param str ipsec_pfs: The Diffie-Hellman key exchange algorithm used by phase-two negotiation.
        """
        if ipsec_auth_alg is not None:
            pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        if ipsec_enc_alg is not None:
            pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        if ipsec_lifetime is not None:
            pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        if ipsec_pfs is not None:
            pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> Optional[str]:
        """
        The authentication algorithm of phase-two negotiation.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> Optional[str]:
        """
        The encryption algorithm of phase-two negotiation.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> Optional[int]:
        """
        The SA lifecycle as the result of phase-two negotiation.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> Optional[str]:
        """
        The Diffie-Hellman key exchange algorithm used by phase-two negotiation.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetConnectionsConnectionVcoHealthCheckResult(dict):
    def __init__(__self__, *,
                 dip: Optional[str] = None,
                 enable: Optional[str] = None,
                 interval: Optional[int] = None,
                 retry: Optional[int] = None,
                 sip: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str dip: The destination ip address.
        :param str enable: The health check on status. Valid values: `true`, `false`.
        :param int interval: The time interval between health checks.
        :param int retry: The number of retries for health checks issued.
        :param str sip: The source ip address.
        :param str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        if dip is not None:
            pulumi.set(__self__, "dip", dip)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sip is not None:
            pulumi.set(__self__, "sip", sip)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def dip(self) -> Optional[str]:
        """
        The destination ip address.
        """
        return pulumi.get(self, "dip")

    @property
    @pulumi.getter
    def enable(self) -> Optional[str]:
        """
        The health check on status. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def interval(self) -> Optional[int]:
        """
        The time interval between health checks.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def retry(self) -> Optional[int]:
        """
        The number of retries for health checks issued.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def sip(self) -> Optional[str]:
        """
        The source ip address.
        """
        return pulumi.get(self, "sip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetConnectionsConnectionVpnBgpConfigResult(dict):
    def __init__(__self__, *,
                 auth_key: Optional[str] = None,
                 local_asn: Optional[int] = None,
                 local_bgp_ip: Optional[str] = None,
                 peer_asn: Optional[int] = None,
                 peer_bgp_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 tunnel_cidr: Optional[str] = None):
        """
        :param str auth_key: The authentication keys for BGP routing protocols.
        :param int local_asn: The ali cloud side autonomous system.
        :param str local_bgp_ip: The ali cloud side BGP address.
        :param int peer_asn: The counterpart autonomous system number.
        :param str peer_bgp_ip: The BGP address on the other side.
        :param str status: The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        :param str tunnel_cidr: The ipsec tunnel segments.
        """
        if auth_key is not None:
            pulumi.set(__self__, "auth_key", auth_key)
        if local_asn is not None:
            pulumi.set(__self__, "local_asn", local_asn)
        if local_bgp_ip is not None:
            pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_bgp_ip is not None:
            pulumi.set(__self__, "peer_bgp_ip", peer_bgp_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tunnel_cidr is not None:
            pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> Optional[str]:
        """
        The authentication keys for BGP routing protocols.
        """
        return pulumi.get(self, "auth_key")

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> Optional[int]:
        """
        The ali cloud side autonomous system.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> Optional[str]:
        """
        The ali cloud side BGP address.
        """
        return pulumi.get(self, "local_bgp_ip")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[int]:
        """
        The counterpart autonomous system number.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerBgpIp")
    def peer_bgp_ip(self) -> Optional[str]:
        """
        The BGP address on the other side.
        """
        return pulumi.get(self, "peer_bgp_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The negotiation status of the BGP routing protocol. Valid values: `success`, `false`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> Optional[str]:
        """
        The ipsec tunnel segments.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetCustomerGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 asn: int,
                 create_time: str,
                 description: str,
                 id: str,
                 ip_address: str,
                 name: str):
        """
        :param int asn: The autonomous system number of the local data center gateway device of the VPN customer gateway.
        :param str create_time: The creation time of the VPN customer gateway.
        :param str description: The description of the VPN customer gateway.
        :param str id: ID of the VPN customer gateway .
        :param str ip_address: The ip address of the VPN customer gateway.
        :param str name: The name of the VPN customer gateway.
        """
        pulumi.set(__self__, "asn", asn)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def asn(self) -> int:
        """
        The autonomous system number of the local data center gateway device of the VPN customer gateway.
        """
        return pulumi.get(self, "asn")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the VPN customer gateway.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the VPN customer gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the VPN customer gateway .
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The ip address of the VPN customer gateway.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the VPN customer gateway.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetGatewayVcoRoutesRouteResult(dict):
    def __init__(__self__, *,
                 as_path: str,
                 create_time: str,
                 id: str,
                 next_hop: str,
                 route_dest: str,
                 source: str,
                 status: str,
                 vpn_connection_id: str,
                 weight: int):
        """
        :param str as_path: List of autonomous system numbers through which BGP routing entries pass.
        :param str create_time: The creation time of the VPN destination route.
        :param str id: The ID of the Vpn Gateway Vco Routes.
        :param str next_hop: The next hop of the destination route.
        :param str route_dest: The destination network segment of the destination route.
        :param str source: The source CIDR block of the destination route.
        :param str status: The status of the vpn route entry.
        :param str vpn_connection_id: The id of the vpn connection.
        :param int weight: The weight value of the destination route.
        """
        pulumi.set(__self__, "as_path", as_path)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "route_dest", route_dest)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="asPath")
    def as_path(self) -> str:
        """
        List of autonomous system numbers through which BGP routing entries pass.
        """
        return pulumi.get(self, "as_path")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the VPN destination route.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vpn Gateway Vco Routes.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> str:
        """
        The next hop of the destination route.
        """
        return pulumi.get(self, "next_hop")

    @property
    @pulumi.getter(name="routeDest")
    def route_dest(self) -> str:
        """
        The destination network segment of the destination route.
        """
        return pulumi.get(self, "route_dest")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source CIDR block of the destination route.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the vpn route entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> str:
        """
        The id of the vpn connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight value of the destination route.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 bgp_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentBgpConfigResult'],
                 connection_status: str,
                 create_time: str,
                 customer_gateway_id: str,
                 effect_immediately: bool,
                 health_check_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult'],
                 id: str,
                 ike_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIkeConfigResult'],
                 internet_ip: str,
                 ipsec_configs: Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfigResult'],
                 local_subnet: str,
                 network_type: str,
                 remote_subnet: str,
                 status: str,
                 vpn_attachment_name: str,
                 vpn_connection_id: str):
        """
        :param Sequence['GetGatewayVpnAttachmentsAttachmentBgpConfigArgs'] bgp_configs: The configurations of the BGP routing protocol.
        :param str connection_status: The status of the IPsec-VPN connection.
        :param str create_time: The creation time of the resource.
        :param str customer_gateway_id: The ID of the customer gateway.
        :param bool effect_immediately: Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentHealthCheckConfigArgs'] health_check_configs: The health check configurations.
        :param str id: The ID of the Vpn Attachment.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentIkeConfigArgs'] ike_configs: Configuration negotiated in the second stage.
        :param str internet_ip: The internet ip of the resource. The cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
        :param Sequence['GetGatewayVpnAttachmentsAttachmentIpsecConfigArgs'] ipsec_configs: The configuration of Phase 2 negotiations.
        :param str local_subnet: The CIDR block of the virtual private cloud (VPC).
        :param str network_type: The network type.
        :param str remote_subnet: The CIDR block of the on-premises data center.
        :param str status: The status of the resource.
        :param str vpn_attachment_name: The name of the IPsec-VPN connection.
        :param str vpn_connection_id: The first ID of the resource.
        """
        pulumi.set(__self__, "bgp_configs", bgp_configs)
        pulumi.set(__self__, "connection_status", connection_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "effect_immediately", effect_immediately)
        pulumi.set(__self__, "health_check_configs", health_check_configs)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ike_configs", ike_configs)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "ipsec_configs", ipsec_configs)
        pulumi.set(__self__, "local_subnet", local_subnet)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "remote_subnet", remote_subnet)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpn_attachment_name", vpn_attachment_name)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @property
    @pulumi.getter(name="bgpConfigs")
    def bgp_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentBgpConfigResult']:
        """
        The configurations of the BGP routing protocol.
        """
        return pulumi.get(self, "bgp_configs")

    @property
    @pulumi.getter(name="connectionStatus")
    def connection_status(self) -> str:
        """
        The status of the IPsec-VPN connection.
        """
        return pulumi.get(self, "connection_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> str:
        """
        The ID of the customer gateway.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="effectImmediately")
    def effect_immediately(self) -> bool:
        """
        Indicates whether IPsec-VPN negotiations are initiated immediately. Valid values.
        """
        return pulumi.get(self, "effect_immediately")

    @property
    @pulumi.getter(name="healthCheckConfigs")
    def health_check_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult']:
        """
        The health check configurations.
        """
        return pulumi.get(self, "health_check_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vpn Attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ikeConfigs")
    def ike_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIkeConfigResult']:
        """
        Configuration negotiated in the second stage.
        """
        return pulumi.get(self, "ike_configs")

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> str:
        """
        The internet ip of the resource. The cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
        """
        return pulumi.get(self, "internet_ip")

    @property
    @pulumi.getter(name="ipsecConfigs")
    def ipsec_configs(self) -> Sequence['outputs.GetGatewayVpnAttachmentsAttachmentIpsecConfigResult']:
        """
        The configuration of Phase 2 negotiations.
        """
        return pulumi.get(self, "ipsec_configs")

    @property
    @pulumi.getter(name="localSubnet")
    def local_subnet(self) -> str:
        """
        The CIDR block of the virtual private cloud (VPC).
        """
        return pulumi.get(self, "local_subnet")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="remoteSubnet")
    def remote_subnet(self) -> str:
        """
        The CIDR block of the on-premises data center.
        """
        return pulumi.get(self, "remote_subnet")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpnAttachmentName")
    def vpn_attachment_name(self) -> str:
        """
        The name of the IPsec-VPN connection.
        """
        return pulumi.get(self, "vpn_attachment_name")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "vpn_connection_id")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentBgpConfigResult(dict):
    def __init__(__self__, *,
                 local_asn: str,
                 local_bgp_ip: str,
                 status: str,
                 tunnel_cidr: str):
        """
        :param str local_asn: The ASN on the Alibaba Cloud side.
        :param str local_bgp_ip: The BGP IP address on the Alibaba Cloud side.
        :param str status: The status of the resource.
        :param str tunnel_cidr: The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        pulumi.set(__self__, "local_asn", local_asn)
        pulumi.set(__self__, "local_bgp_ip", local_bgp_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tunnel_cidr", tunnel_cidr)

    @property
    @pulumi.getter(name="localAsn")
    def local_asn(self) -> str:
        """
        The ASN on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_asn")

    @property
    @pulumi.getter(name="localBgpIp")
    def local_bgp_ip(self) -> str:
        """
        The BGP IP address on the Alibaba Cloud side.
        """
        return pulumi.get(self, "local_bgp_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tunnelCidr")
    def tunnel_cidr(self) -> str:
        """
        The CIDR block of the IPsec tunnel. The CIDR block belongs to 169.254.0.0/16. The mask of the CIDR block is 30 bits in length.
        """
        return pulumi.get(self, "tunnel_cidr")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentHealthCheckConfigResult(dict):
    def __init__(__self__, *,
                 dip: str,
                 enable: bool,
                 interval: int,
                 policy: str,
                 retry: int,
                 sip: str,
                 status: str):
        """
        :param str dip: The destination IP address.
        :param bool enable: Specifies whether to enable health checks.
        :param int interval: The interval between two consecutive health checks. Unit: seconds.
        :param str policy: Whether to revoke the published route when the health check fails.
        :param int retry: The maximum number of health check retries.
        :param str sip: The source IP address.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "dip", dip)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "retry", retry)
        pulumi.set(__self__, "sip", sip)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def dip(self) -> str:
        """
        The destination IP address.
        """
        return pulumi.get(self, "dip")

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Specifies whether to enable health checks.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def interval(self) -> int:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Whether to revoke the published route when the health check fails.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter
    def retry(self) -> int:
        """
        The maximum number of health check retries.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter
    def sip(self) -> str:
        """
        The source IP address.
        """
        return pulumi.get(self, "sip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentIkeConfigResult(dict):
    def __init__(__self__, *,
                 ike_auth_alg: str,
                 ike_enc_alg: str,
                 ike_lifetime: str,
                 ike_mode: str,
                 ike_pfs: str,
                 ike_version: str,
                 local_id: str,
                 psk: str,
                 remote_id: str):
        """
        :param str ike_auth_alg: The IKE authentication algorithm.
        :param str ike_enc_alg: The IKE encryption algorithm.
        :param str ike_lifetime: The IKE lifetime. Unit: seconds.
        :param str ike_mode: The IKE negotiation mode.
        :param str ike_pfs: The DH group.
        :param str ike_version: The version of the IKE protocol.
        :param str local_id: The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default. The cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
        :param str psk: The pre-shared key.
        :param str remote_id: The identifier of the peer. The default value is the IP address of the VPN gateway. The value can be a fully qualified domain name (FQDN) or an IP address.
        """
        pulumi.set(__self__, "ike_auth_alg", ike_auth_alg)
        pulumi.set(__self__, "ike_enc_alg", ike_enc_alg)
        pulumi.set(__self__, "ike_lifetime", ike_lifetime)
        pulumi.set(__self__, "ike_mode", ike_mode)
        pulumi.set(__self__, "ike_pfs", ike_pfs)
        pulumi.set(__self__, "ike_version", ike_version)
        pulumi.set(__self__, "local_id", local_id)
        pulumi.set(__self__, "psk", psk)
        pulumi.set(__self__, "remote_id", remote_id)

    @property
    @pulumi.getter(name="ikeAuthAlg")
    def ike_auth_alg(self) -> str:
        """
        The IKE authentication algorithm.
        """
        return pulumi.get(self, "ike_auth_alg")

    @property
    @pulumi.getter(name="ikeEncAlg")
    def ike_enc_alg(self) -> str:
        """
        The IKE encryption algorithm.
        """
        return pulumi.get(self, "ike_enc_alg")

    @property
    @pulumi.getter(name="ikeLifetime")
    def ike_lifetime(self) -> str:
        """
        The IKE lifetime. Unit: seconds.
        """
        return pulumi.get(self, "ike_lifetime")

    @property
    @pulumi.getter(name="ikeMode")
    def ike_mode(self) -> str:
        """
        The IKE negotiation mode.
        """
        return pulumi.get(self, "ike_mode")

    @property
    @pulumi.getter(name="ikePfs")
    def ike_pfs(self) -> str:
        """
        The DH group.
        """
        return pulumi.get(self, "ike_pfs")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> str:
        """
        The version of the IKE protocol.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter(name="localId")
    def local_id(self) -> str:
        """
        The local ID, which supports the FQDN and IP formats. The current VPN gateway IP address is selected by default. The cen.TransitRouterVpnAttachment resource will not have a value until after it is created.
        """
        return pulumi.get(self, "local_id")

    @property
    @pulumi.getter
    def psk(self) -> str:
        """
        The pre-shared key.
        """
        return pulumi.get(self, "psk")

    @property
    @pulumi.getter(name="remoteId")
    def remote_id(self) -> str:
        """
        The identifier of the peer. The default value is the IP address of the VPN gateway. The value can be a fully qualified domain name (FQDN) or an IP address.
        """
        return pulumi.get(self, "remote_id")


@pulumi.output_type
class GetGatewayVpnAttachmentsAttachmentIpsecConfigResult(dict):
    def __init__(__self__, *,
                 ipsec_auth_alg: str,
                 ipsec_enc_alg: str,
                 ipsec_lifetime: str,
                 ipsec_pfs: str):
        """
        :param str ipsec_auth_alg: The IPsec authentication algorithm.
        :param str ipsec_enc_alg: The IPsec encryption algorithm.
        :param str ipsec_lifetime: The IPsec lifetime. Unit: seconds.
        :param str ipsec_pfs: The DH group.
        """
        pulumi.set(__self__, "ipsec_auth_alg", ipsec_auth_alg)
        pulumi.set(__self__, "ipsec_enc_alg", ipsec_enc_alg)
        pulumi.set(__self__, "ipsec_lifetime", ipsec_lifetime)
        pulumi.set(__self__, "ipsec_pfs", ipsec_pfs)

    @property
    @pulumi.getter(name="ipsecAuthAlg")
    def ipsec_auth_alg(self) -> str:
        """
        The IPsec authentication algorithm.
        """
        return pulumi.get(self, "ipsec_auth_alg")

    @property
    @pulumi.getter(name="ipsecEncAlg")
    def ipsec_enc_alg(self) -> str:
        """
        The IPsec encryption algorithm.
        """
        return pulumi.get(self, "ipsec_enc_alg")

    @property
    @pulumi.getter(name="ipsecLifetime")
    def ipsec_lifetime(self) -> str:
        """
        The IPsec lifetime. Unit: seconds.
        """
        return pulumi.get(self, "ipsec_lifetime")

    @property
    @pulumi.getter(name="ipsecPfs")
    def ipsec_pfs(self) -> str:
        """
        The DH group.
        """
        return pulumi.get(self, "ipsec_pfs")


@pulumi.output_type
class GetGatewaysGatewayResult(dict):
    def __init__(__self__, *,
                 auto_propagate: str,
                 business_status: str,
                 create_time: str,
                 description: str,
                 enable_ipsec: str,
                 enable_ssl: str,
                 end_time: str,
                 id: str,
                 instance_charge_type: str,
                 internet_ip: str,
                 name: str,
                 network_type: str,
                 specification: str,
                 ssl_connections: int,
                 status: str,
                 vpc_id: str):
        """
        :param str auto_propagate: Whether to automatically propagate BGP routes to the VPC. Valid values: `true`, `false`.
        :param str business_status: Limit search to specific business status - valid value is "Normal", "FinancialLocked".
        :param str create_time: The creation time of the VPN gateway.
        :param str description: The description of the VPN
        :param str enable_ipsec: Indicates whether the IPsec-VPN feature is enabled.
        :param str enable_ssl: Whether the ssl function is enabled.
        :param str end_time: The expiration time of the VPN gateway.
        :param str id: ID of the VPN.
        :param str instance_charge_type: The charge type of the VPN gateway.
        :param str internet_ip: The internet ip of the VPN.
        :param str name: The name of the VPN.
        :param str network_type: The network type of the VPN gateway.
        :param str specification: The Specification of the VPN
        :param int ssl_connections: Total count of ssl vpn connections.
        :param str status: Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
        :param str vpc_id: Use the VPC ID as the search key.
        """
        pulumi.set(__self__, "auto_propagate", auto_propagate)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_ipsec", enable_ipsec)
        pulumi.set(__self__, "enable_ssl", enable_ssl)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "internet_ip", internet_ip)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "ssl_connections", ssl_connections)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoPropagate")
    def auto_propagate(self) -> str:
        """
        Whether to automatically propagate BGP routes to the VPC. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "auto_propagate")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        Limit search to specific business status - valid value is "Normal", "FinancialLocked".
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the VPN gateway.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the VPN
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableIpsec")
    def enable_ipsec(self) -> str:
        """
        Indicates whether the IPsec-VPN feature is enabled.
        """
        return pulumi.get(self, "enable_ipsec")

    @property
    @pulumi.getter(name="enableSsl")
    def enable_ssl(self) -> str:
        """
        Whether the ssl function is enabled.
        """
        return pulumi.get(self, "enable_ssl")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The expiration time of the VPN gateway.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the VPN.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> str:
        """
        The charge type of the VPN gateway.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="internetIp")
    def internet_ip(self) -> str:
        """
        The internet ip of the VPN.
        """
        return pulumi.get(self, "internet_ip")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the VPN.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type of the VPN gateway.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def specification(self) -> str:
        """
        The Specification of the VPN
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter(name="sslConnections")
    def ssl_connections(self) -> int:
        """
        Total count of ssl vpn connections.
        """
        return pulumi.get(self, "ssl_connections")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Limit search to specific status - valid value is "Init", "Provisioning", "Active", "Updating", "Deleting".
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Use the VPC ID as the search key.
        """
        return pulumi.get(self, "vpc_id")


