# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DomainLogHeader',
    'GetCertificatesCertificateResult',
    'GetDomainsDomainResult',
    'GetDomainsDomainLogHeaderResult',
    'GetInstancesInstanceResult',
]

@pulumi.output_type
class DomainLogHeader(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetCertificatesCertificateResult(dict):
    def __init__(__self__, *,
                 certificate_id: str,
                 certificate_name: str,
                 common_name: str,
                 domain: str,
                 id: str,
                 instance_id: str,
                 is_using: bool,
                 sans: Sequence[str]):
        """
        :param str certificate_id: Certificate recording ID.
        :param str certificate_name: Your certificate name.
        :param str common_name: Certificate bound to the domain name.
        :param str domain: The domain that you want to add to WAF.
        :param str id: The ID of the Certificate.
        :param str instance_id: WAF instance ID.
        """
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_using", is_using)
        pulumi.set(__self__, "sans", sans)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        """
        Certificate recording ID.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        """
        Your certificate name.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        Certificate bound to the domain name.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain that you want to add to WAF.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Certificate.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        WAF instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isUsing")
    def is_using(self) -> bool:
        return pulumi.get(self, "is_using")

    @property
    @pulumi.getter
    def sans(self) -> Sequence[str]:
        return pulumi.get(self, "sans")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 cluster_type: str,
                 cname: str,
                 connection_time: int,
                 domain: str,
                 domain_name: str,
                 http2_ports: Sequence[str],
                 http_ports: Sequence[str],
                 http_to_user_ip: str,
                 https_ports: Sequence[str],
                 https_redirect: str,
                 id: str,
                 is_access_product: str,
                 load_balancing: str,
                 log_headers: Sequence['outputs.GetDomainsDomainLogHeaderResult'],
                 read_time: int,
                 resource_group_id: str,
                 source_ips: Sequence[str],
                 version: int,
                 write_time: int):
        """
        :param str cluster_type: The type of the WAF cluster.
        :param str cname: The CNAME record assigned by the WAF instance to the specified domain.
        :param int connection_time: The connection timeout for WAF exclusive clusters. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        :param str domain: Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        :param str domain_name: Name of the domain.
        :param Sequence[str] http2_ports: List of the HTTP 2.0 ports.
        :param Sequence[str] http_ports: List of the HTTP ports.
        :param str http_to_user_ip: Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
        :param Sequence[str] https_ports: List of the HTTPS ports.
        :param str https_redirect: Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: `On` and `Off`. Default to `Off`.
        :param str id: The ID of domain self ID, value as `domain_name`.
        :param str is_access_product: Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and "Off". Default to `Off`.
        :param str load_balancing: The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        :param Sequence['GetDomainsDomainLogHeaderArgs'] log_headers: The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
        :param int read_time: The read timeout of a WAF exclusive cluster. Unit: seconds.
        :param str resource_group_id: The ID of the resource group to which the queried domain belongs in Resource Management.
        :param Sequence[str] source_ips: List of the IP address or domain of the origin server to which the specified domain points.
        :param int version: The system data identifier that is used to control optimistic locking.
        :param int write_time: The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "cname", cname)
        pulumi.set(__self__, "connection_time", connection_time)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "http2_ports", http2_ports)
        pulumi.set(__self__, "http_ports", http_ports)
        pulumi.set(__self__, "http_to_user_ip", http_to_user_ip)
        pulumi.set(__self__, "https_ports", https_ports)
        pulumi.set(__self__, "https_redirect", https_redirect)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_access_product", is_access_product)
        pulumi.set(__self__, "load_balancing", load_balancing)
        pulumi.set(__self__, "log_headers", log_headers)
        pulumi.set(__self__, "read_time", read_time)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "source_ips", source_ips)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "write_time", write_time)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        """
        The type of the WAF cluster.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter
    def cname(self) -> str:
        """
        The CNAME record assigned by the WAF instance to the specified domain.
        """
        return pulumi.get(self, "cname")

    @property
    @pulumi.getter(name="connectionTime")
    def connection_time(self) -> int:
        """
        The connection timeout for WAF exclusive clusters. Valid values: `PhysicalCluster` and `VirtualCluster`. Default to `PhysicalCluster`.
        """
        return pulumi.get(self, "connection_time")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Field `domain` has been deprecated from version 1.94.0. Use `domain_name` instead.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="http2Ports")
    def http2_ports(self) -> Sequence[str]:
        """
        List of the HTTP 2.0 ports.
        """
        return pulumi.get(self, "http2_ports")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Sequence[str]:
        """
        List of the HTTP ports.
        """
        return pulumi.get(self, "http_ports")

    @property
    @pulumi.getter(name="httpToUserIp")
    def http_to_user_ip(self) -> str:
        """
        Specifies whether to enable the HTTP back-to-origin feature. After this feature is enabled, the WAF instance can use HTTP to forward HTTPS requests to the origin server.
        """
        return pulumi.get(self, "http_to_user_ip")

    @property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Sequence[str]:
        """
        List of the HTTPS ports.
        """
        return pulumi.get(self, "https_ports")

    @property
    @pulumi.getter(name="httpsRedirect")
    def https_redirect(self) -> str:
        """
        Specifies whether to redirect HTTP requests as HTTPS requests. Valid values: `On` and `Off`. Default to `Off`.
        """
        return pulumi.get(self, "https_redirect")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of domain self ID, value as `domain_name`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAccessProduct")
    def is_access_product(self) -> str:
        """
        Specifies whether to configure a Layer-7 proxy, such as Anti-DDoS Pro or CDN, to filter the inbound traffic before it is forwarded to WAF. Valid values: `On` and "Off". Default to `Off`.
        """
        return pulumi.get(self, "is_access_product")

    @property
    @pulumi.getter(name="loadBalancing")
    def load_balancing(self) -> str:
        """
        The load balancing algorithm that is used to forward requests to the origin. Valid values: `IpHash` and `RoundRobin`. Default to `IpHash`.
        """
        return pulumi.get(self, "load_balancing")

    @property
    @pulumi.getter(name="logHeaders")
    def log_headers(self) -> Sequence['outputs.GetDomainsDomainLogHeaderResult']:
        """
        The key-value pair that is used to mark the traffic that flows through WAF to the domain. Each item contains two field:
        """
        return pulumi.get(self, "log_headers")

    @property
    @pulumi.getter(name="readTime")
    def read_time(self) -> int:
        """
        The read timeout of a WAF exclusive cluster. Unit: seconds.
        """
        return pulumi.get(self, "read_time")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the queried domain belongs in Resource Management.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="sourceIps")
    def source_ips(self) -> Sequence[str]:
        """
        List of the IP address or domain of the origin server to which the specified domain points.
        """
        return pulumi.get(self, "source_ips")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        The system data identifier that is used to control optimistic locking.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="writeTime")
    def write_time(self) -> int:
        """
        The timeout period for a WAF exclusive cluster write connection. Unit: seconds.
        """
        return pulumi.get(self, "write_time")


@pulumi.output_type
class GetDomainsDomainLogHeaderResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of label.
        :param str value: The value of label.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of label.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of label.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 end_date: int,
                 id: str,
                 in_debt: int,
                 instance_id: str,
                 remain_day: int,
                 status: int,
                 subscription_type: str,
                 trial: int):
        """
        :param int end_date: The timestamp (in seconds) indicating when the WAF instance expires.
        :param str id: The ID of the WAF instance.
        :param int in_debt: Indicates whether the WAF instance has overdue payments.
        :param str instance_id: The ID of WAF the instance.
        :param int remain_day: The number of days before the trial period of the WAF instance expires.
        :param int status: The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
        :param int trial: Indicates whether this is a trial instance.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "in_debt", in_debt)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "remain_day", remain_day)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscription_type", subscription_type)
        pulumi.set(__self__, "trial", trial)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> int:
        """
        The timestamp (in seconds) indicating when the WAF instance expires.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the WAF instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inDebt")
    def in_debt(self) -> int:
        """
        Indicates whether the WAF instance has overdue payments.
        """
        return pulumi.get(self, "in_debt")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of WAF the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="remainDay")
    def remain_day(self) -> int:
        """
        The number of days before the trial period of the WAF instance expires.
        """
        return pulumi.get(self, "remain_day")

    @property
    @pulumi.getter
    def status(self) -> int:
        """
        The status of WAF instance to filter results. Optional value: `0`: The instance has expired, `1` : The instance has not expired and is working properly.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> str:
        return pulumi.get(self, "subscription_type")

    @property
    @pulumi.getter
    def trial(self) -> int:
        """
        Indicates whether this is a trial instance.
        """
        return pulumi.get(self, "trial")


