# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsResult',
    'AwaitableGetDomainsResult',
    'get_domains',
    'get_domains_output',
]

@pulumi.output_type
class GetDomainsResult:
    """
    A collection of values returned by getDomains.
    """
    def __init__(__self__, backend=None, domain=None, domains=None, enable_details=None, id=None, ids=None, instance_id=None, output_file=None, page_number=None, page_size=None):
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)

    @property
    @pulumi.getter
    def backend(self) -> Optional[str]:
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetDomainsDomainResult']:
        """
        A list of Domain Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")


class AwaitableGetDomainsResult(GetDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsResult(
            backend=self.backend,
            domain=self.domain,
            domains=self.domains,
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size)


def get_domains(backend: Optional[str] = None,
                domain: Optional[str] = None,
                enable_details: Optional[bool] = None,
                ids: Optional[Sequence[str]] = None,
                instance_id: Optional[str] = None,
                output_file: Optional[str] = None,
                page_number: Optional[int] = None,
                page_size: Optional[int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsResult:
    """
    This data source provides the Wafv3 Domains of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.200.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instances = alicloud.wafv3.get_instances()
    ids = alicloud.wafv3.get_domains(instance_id=default_instances.ids[0],
        ids=["example_id"])
    pulumi.export("wafv3DomainsId1", ids.domains[0].id)
    default_domains = alicloud.wafv3.get_domains(instance_id=default_instances.ids[0],
        domain="zctest12.wafqax.top")
    pulumi.export("wafv3DomainsId2", default_domains.domains[0].id)
    ```


    :param str backend: The address type of the origin server. The address can be an IP address or a domain name. You can specify only one type of address.
    :param str domain: The name of the domain name to query.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of domain IDs.
    :param str instance_id: The WAF instance ID.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['domain'] = domain
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:wafv3/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult).value

    return AwaitableGetDomainsResult(
        backend=pulumi.get(__ret__, 'backend'),
        domain=pulumi.get(__ret__, 'domain'),
        domains=pulumi.get(__ret__, 'domains'),
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'))


@_utilities.lift_output_func(get_domains)
def get_domains_output(backend: Optional[pulumi.Input[Optional[str]]] = None,
                       domain: Optional[pulumi.Input[Optional[str]]] = None,
                       enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       instance_id: Optional[pulumi.Input[str]] = None,
                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       page_number: Optional[pulumi.Input[Optional[int]]] = None,
                       page_size: Optional[pulumi.Input[Optional[int]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainsResult]:
    """
    This data source provides the Wafv3 Domains of the current Alibaba Cloud user.

    > **NOTE:** Available since v1.200.0.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_instances = alicloud.wafv3.get_instances()
    ids = alicloud.wafv3.get_domains(instance_id=default_instances.ids[0],
        ids=["example_id"])
    pulumi.export("wafv3DomainsId1", ids.domains[0].id)
    default_domains = alicloud.wafv3.get_domains(instance_id=default_instances.ids[0],
        domain="zctest12.wafqax.top")
    pulumi.export("wafv3DomainsId2", default_domains.domains[0].id)
    ```


    :param str backend: The address type of the origin server. The address can be an IP address or a domain name. You can specify only one type of address.
    :param str domain: The name of the domain name to query.
    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of domain IDs.
    :param str instance_id: The WAF instance ID.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
