# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DomainListen',
    'DomainRedirect',
    'DomainRedirectRequestHeader',
    'GetDomainsDomainResult',
    'GetDomainsDomainListenResult',
    'GetDomainsDomainRedirectResult',
    'GetDomainsDomainRedirectRequestHeaderResult',
    'GetInstancesInstanceResult',
]

@pulumi.output_type
class DomainListen(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certId":
            suggest = "cert_id"
        elif key == "cipherSuite":
            suggest = "cipher_suite"
        elif key == "customCiphers":
            suggest = "custom_ciphers"
        elif key == "enableTlsv3":
            suggest = "enable_tlsv3"
        elif key == "exclusiveIp":
            suggest = "exclusive_ip"
        elif key == "focusHttps":
            suggest = "focus_https"
        elif key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "httpPorts":
            suggest = "http_ports"
        elif key == "httpsPorts":
            suggest = "https_ports"
        elif key == "ipv6Enabled":
            suggest = "ipv6_enabled"
        elif key == "protectionResource":
            suggest = "protection_resource"
        elif key == "tlsVersion":
            suggest = "tls_version"
        elif key == "xffHeaderMode":
            suggest = "xff_header_mode"
        elif key == "xffHeaders":
            suggest = "xff_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainListen. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainListen.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainListen.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_id: Optional[str] = None,
                 cipher_suite: Optional[int] = None,
                 custom_ciphers: Optional[Sequence[str]] = None,
                 enable_tlsv3: Optional[bool] = None,
                 exclusive_ip: Optional[bool] = None,
                 focus_https: Optional[bool] = None,
                 http2_enabled: Optional[bool] = None,
                 http_ports: Optional[Sequence[int]] = None,
                 https_ports: Optional[Sequence[int]] = None,
                 ipv6_enabled: Optional[bool] = None,
                 protection_resource: Optional[str] = None,
                 tls_version: Optional[str] = None,
                 xff_header_mode: Optional[int] = None,
                 xff_headers: Optional[Sequence[str]] = None):
        """
        :param str cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param int cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **1**: indicates that all encryption suites are added.
               - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
               - **99**: indicates that a custom encryption suite is added.
        :param Sequence[str] custom_ciphers: The specific custom encryption suite to add.
        :param bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that TSL1.3 is supported.
               - **false**: indicates that TSL1.3 is not supported.
        :param bool exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
               - **true**: indicates that the exclusive IP address is enabled.
               - **false** (default): indicates that exclusive IP address is not enabled.
        :param bool focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
               - **true**: indicates that HTTPS forced redirection is enabled.
               - **false**: indicates that HTTPS forced redirection is not enabled.
        :param bool http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true:** indicates that HTTP2 is enabled.
               - **false** (default): indicates that HTTP2 is not enabled.
        :param Sequence[int] http_ports: The listening port of the HTTP protocol.
        :param Sequence[int] https_ports: The listening port of the HTTPS protocol.
        :param bool ipv6_enabled: Whether IPv6 is turned on. Value:
               - **true**: indicates that IPv6 is enabled.
               - **false** (default): indicates that IPv6 is not enabled.
        :param str protection_resource: The type of protection resource to use. Value:
               - **share** (default): indicates that a shared cluster is used.
               - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        :param str tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        :param int xff_header_mode: WAF obtains the real IP address of the client. Value:
               - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
               - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
               - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        :param Sequence[str] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        if cert_id is not None:
            pulumi.set(__self__, "cert_id", cert_id)
        if cipher_suite is not None:
            pulumi.set(__self__, "cipher_suite", cipher_suite)
        if custom_ciphers is not None:
            pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        if enable_tlsv3 is not None:
            pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        if exclusive_ip is not None:
            pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        if focus_https is not None:
            pulumi.set(__self__, "focus_https", focus_https)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if http_ports is not None:
            pulumi.set(__self__, "http_ports", http_ports)
        if https_ports is not None:
            pulumi.set(__self__, "https_ports", https_ports)
        if ipv6_enabled is not None:
            pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        if protection_resource is not None:
            pulumi.set(__self__, "protection_resource", protection_resource)
        if tls_version is not None:
            pulumi.set(__self__, "tls_version", tls_version)
        if xff_header_mode is not None:
            pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        if xff_headers is not None:
            pulumi.set(__self__, "xff_headers", xff_headers)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> Optional[str]:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> Optional[int]:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **1**: indicates that all encryption suites are added.
        - **2**: indicates that a strong encryption package is added. You can select this value only if the value of **tls_version** is `tlsv1.2`.
        - **99**: indicates that a custom encryption suite is added.
        """
        return pulumi.get(self, "cipher_suite")

    @property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Optional[Sequence[str]]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> Optional[bool]:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that TSL1.3 is supported.
        - **false**: indicates that TSL1.3 is not supported.
        """
        return pulumi.get(self, "enable_tlsv3")

    @property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> Optional[bool]:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used). Value:
        - **true**: indicates that the exclusive IP address is enabled.
        - **false** (default): indicates that exclusive IP address is not enabled.
        """
        return pulumi.get(self, "exclusive_ip")

    @property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> Optional[bool]:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol). Value:
        - **true**: indicates that HTTPS forced redirection is enabled.
        - **false**: indicates that HTTPS forced redirection is not enabled.
        """
        return pulumi.get(self, "focus_https")

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[bool]:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true:** indicates that HTTP2 is enabled.
        - **false** (default): indicates that HTTP2 is not enabled.
        """
        return pulumi.get(self, "http2_enabled")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Optional[Sequence[int]]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Optional[Sequence[int]]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> Optional[bool]:
        """
        Whether IPv6 is turned on. Value:
        - **true**: indicates that IPv6 is enabled.
        - **false** (default): indicates that IPv6 is not enabled.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> Optional[str]:
        """
        The type of protection resource to use. Value:
        - **share** (default): indicates that a shared cluster is used.
        - **gslb**: indicates that the shared cluster intelligent load balancing is used.
        """
        return pulumi.get(self, "protection_resource")

    @property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> Optional[str]:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value: **tlsv1**, **tlsv1.1**, **tlsv1.2**.
        """
        return pulumi.get(self, "tls_version")

    @property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> Optional[int]:
        """
        WAF obtains the real IP address of the client. Value:
        - **0** (default): indicates that the client has not forwarded the traffic to WAF through other layer -7 agents.
        - **1**: indicates that the first value of the X-Forwarded-For(XFF) field in the WAF read request header is used as the client IP address.
        - **2**: indicates that the custom field value set by you in the WAF read request header is used as the client IP address.
        """
        return pulumi.get(self, "xff_header_mode")

    @property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Optional[Sequence[str]]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class DomainRedirect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectTimeout":
            suggest = "connect_timeout"
        elif key == "focusHttpBackend":
            suggest = "focus_http_backend"
        elif key == "keepaliveRequests":
            suggest = "keepalive_requests"
        elif key == "keepaliveTimeout":
            suggest = "keepalive_timeout"
        elif key == "readTimeout":
            suggest = "read_timeout"
        elif key == "requestHeaders":
            suggest = "request_headers"
        elif key == "sniEnabled":
            suggest = "sni_enabled"
        elif key == "sniHost":
            suggest = "sni_host"
        elif key == "writeTimeout":
            suggest = "write_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainRedirect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainRedirect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainRedirect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalance: str,
                 backends: Optional[Sequence[str]] = None,
                 connect_timeout: Optional[int] = None,
                 focus_http_backend: Optional[bool] = None,
                 keepalive: Optional[bool] = None,
                 keepalive_requests: Optional[int] = None,
                 keepalive_timeout: Optional[int] = None,
                 read_timeout: Optional[int] = None,
                 request_headers: Optional[Sequence['outputs.DomainRedirectRequestHeader']] = None,
                 retry: Optional[bool] = None,
                 sni_enabled: Optional[bool] = None,
                 sni_host: Optional[str] = None,
                 write_timeout: Optional[int] = None):
        """
        :param str loadbalance: The load balancing algorithm used when returning to the source. Value:
               - **iphash**: indicates the IPHash algorithm.
               - **roundRobin**: indicates the polling algorithm.
               - **leastTime**: indicates the Least Time algorithm.
               - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        :param Sequence[str] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param int connect_timeout: Connection timeout. Unit: seconds, value range: 5~120.
        :param bool focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that forced HTTP back-to-origin is enabled.
               - **false**: indicates that forced HTTP back-to-origin is not enabled.
        :param bool keepalive: Open long connection, default true.
        :param int keepalive_requests: Number of long connections,  default: `60`. range :60-1000.
        :param int keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param int read_timeout: Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        :param Sequence['DomainRedirectRequestHeaderArgs'] request_headers: The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
               It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
               and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
               when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
               to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
               custom header field already exists in the request, the system will overwrite the value of the custom field in the
               request with the set traffic tag value. See `request_headers` below.
        :param bool retry: Back to Source Retry. default: true, retry 3 times by default.
        :param bool sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
               - **true**: indicates that the back-to-source SNI is enabled.
               - **false** (default) indicates that the back-to-source SNI is not enabled.
        :param str sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param int write_timeout: Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        pulumi.set(__self__, "loadbalance", loadbalance)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if focus_http_backend is not None:
            pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_requests is not None:
            pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        if keepalive_timeout is not None:
            pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        if read_timeout is not None:
            pulumi.set(__self__, "read_timeout", read_timeout)
        if request_headers is not None:
            pulumi.set(__self__, "request_headers", request_headers)
        if retry is not None:
            pulumi.set(__self__, "retry", retry)
        if sni_enabled is not None:
            pulumi.set(__self__, "sni_enabled", sni_enabled)
        if sni_host is not None:
            pulumi.set(__self__, "sni_host", sni_host)
        if write_timeout is not None:
            pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter
    def loadbalance(self) -> str:
        """
        The load balancing algorithm used when returning to the source. Value:
        - **iphash**: indicates the IPHash algorithm.
        - **roundRobin**: indicates the polling algorithm.
        - **leastTime**: indicates the Least Time algorithm.
        - This value can be selected only if the value of **protection_resource** is **gslb** (indicating that the protected resource type uses shared cluster intelligent load balancing).
        """
        return pulumi.get(self, "loadbalance")

    @property
    @pulumi.getter
    def backends(self) -> Optional[Sequence[str]]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[int]:
        """
        Connection timeout. Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> Optional[bool]:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that forced HTTP back-to-origin is enabled.
        - **false**: indicates that forced HTTP back-to-origin is not enabled.
        """
        return pulumi.get(self, "focus_http_backend")

    @property
    @pulumi.getter
    def keepalive(self) -> Optional[bool]:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> Optional[int]:
        """
        Number of long connections,  default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> Optional[int]:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> Optional[int]:
        """
        Read timeout duration. **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Optional[Sequence['outputs.DomainRedirectRequestHeader']]:
        """
        The traffic tag field and value of the domain name which used to mark the traffic processed by WAF. 
        It formats as `[{" k ":"_key_"," v ":"_value_"}]`. Where the `k` represents the specified custom request header field,
        and the `v` represents the value set for this field. By specifying the custom request header field and the corresponding value,
        when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value
        to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the
        custom header field already exists in the request, the system will overwrite the value of the custom field in the
        request with the set traffic tag value. See `request_headers` below.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter
    def retry(self) -> Optional[bool]:
        """
        Back to Source Retry. default: true, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> Optional[bool]:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol). Value:
        - **true**: indicates that the back-to-source SNI is enabled.
        - **false** (default) indicates that the back-to-source SNI is not enabled.
        """
        return pulumi.get(self, "sni_enabled")

    @property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> Optional[str]:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> Optional[int]:
        """
        Write timeout duration> **Unit**: seconds, **Value range**: 5~1800.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class DomainRedirectRequestHeader(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param str value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 id: str,
                 listens: Sequence['outputs.GetDomainsDomainListenResult'],
                 redirects: Sequence['outputs.GetDomainsDomainRedirectResult'],
                 resource_manager_resource_group_id: str,
                 status: str):
        """
        :param str domain: The name of the domain name to query.
        :param str id: The ID of the domain. It formats as `<instance_id>:<domain>`.
        :param Sequence['GetDomainsDomainListenArgs'] listens: Configure listening information
        :param Sequence['GetDomainsDomainRedirectArgs'] redirects: Configure forwarding information.
        :param str resource_manager_resource_group_id: The ID of the resource group.
        :param str status: The status of the domain.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "listens", listens)
        pulumi.set(__self__, "redirects", redirects)
        pulumi.set(__self__, "resource_manager_resource_group_id", resource_manager_resource_group_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The name of the domain name to query.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the domain. It formats as `<instance_id>:<domain>`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def listens(self) -> Sequence['outputs.GetDomainsDomainListenResult']:
        """
        Configure listening information
        """
        return pulumi.get(self, "listens")

    @property
    @pulumi.getter
    def redirects(self) -> Sequence['outputs.GetDomainsDomainRedirectResult']:
        """
        Configure forwarding information.
        """
        return pulumi.get(self, "redirects")

    @property
    @pulumi.getter(name="resourceManagerResourceGroupId")
    def resource_manager_resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_manager_resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the domain.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetDomainsDomainListenResult(dict):
    def __init__(__self__, *,
                 cert_id: str,
                 cipher_suite: int,
                 custom_ciphers: Sequence[str],
                 enable_tlsv3: bool,
                 exclusive_ip: bool,
                 focus_https: bool,
                 http2_enabled: bool,
                 http_ports: Sequence[int],
                 https_ports: Sequence[int],
                 ipv6_enabled: bool,
                 protection_resource: str,
                 tls_version: str,
                 xff_header_mode: int,
                 xff_headers: Sequence[str]):
        """
        :param str cert_id: The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param int cipher_suite: The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[str] custom_ciphers: The specific custom encryption suite to add.
        :param bool enable_tlsv3: Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param bool exclusive_ip: Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        :param bool focus_https: Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        :param bool http2_enabled: Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param Sequence[int] http_ports: The listening port of the HTTP protocol.
        :param Sequence[int] https_ports: The listening port of the HTTPS protocol.
        :param bool ipv6_enabled: Whether IPv6 is turned on.
        :param str protection_resource: The type of protection resource to use.
        :param str tls_version: The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param int xff_header_mode: WAF obtains the real IP address of the client.
        :param Sequence[str] xff_headers: Set the list of custom fields used to obtain the client IP address.
        """
        pulumi.set(__self__, "cert_id", cert_id)
        pulumi.set(__self__, "cipher_suite", cipher_suite)
        pulumi.set(__self__, "custom_ciphers", custom_ciphers)
        pulumi.set(__self__, "enable_tlsv3", enable_tlsv3)
        pulumi.set(__self__, "exclusive_ip", exclusive_ip)
        pulumi.set(__self__, "focus_https", focus_https)
        pulumi.set(__self__, "http2_enabled", http2_enabled)
        pulumi.set(__self__, "http_ports", http_ports)
        pulumi.set(__self__, "https_ports", https_ports)
        pulumi.set(__self__, "ipv6_enabled", ipv6_enabled)
        pulumi.set(__self__, "protection_resource", protection_resource)
        pulumi.set(__self__, "tls_version", tls_version)
        pulumi.set(__self__, "xff_header_mode", xff_header_mode)
        pulumi.set(__self__, "xff_headers", xff_headers)

    @property
    @pulumi.getter(name="certId")
    def cert_id(self) -> str:
        """
        The ID of the certificate to be added. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cert_id")

    @property
    @pulumi.getter(name="cipherSuite")
    def cipher_suite(self) -> int:
        """
        The type of encryption suite to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "cipher_suite")

    @property
    @pulumi.getter(name="customCiphers")
    def custom_ciphers(self) -> Sequence[str]:
        """
        The specific custom encryption suite to add.
        """
        return pulumi.get(self, "custom_ciphers")

    @property
    @pulumi.getter(name="enableTlsv3")
    def enable_tlsv3(self) -> bool:
        """
        Whether TSL1.3 version is supported. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "enable_tlsv3")

    @property
    @pulumi.getter(name="exclusiveIp")
    def exclusive_ip(self) -> bool:
        """
        Whether to enable exclusive IP address. This parameter is used only when the value of **ipv6_enabled** is **false** (indicating that IPv6 is not enabled) and the value of **protection_resource** is **share** (indicating that a shared cluster is used).
        """
        return pulumi.get(self, "exclusive_ip")

    @property
    @pulumi.getter(name="focusHttps")
    def focus_https(self) -> bool:
        """
        Whether to enable the forced jump of HTTPS. This parameter is used only when the value of `https_ports` is not empty (indicating that the domain name uses HTTPS protocol) and the value of httports is empty (indicating that the domain name does not use HTTP protocol).
        """
        return pulumi.get(self, "focus_https")

    @property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> bool:
        """
        Whether to turn on http2. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "http2_enabled")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Sequence[int]:
        """
        The listening port of the HTTP protocol.
        """
        return pulumi.get(self, "http_ports")

    @property
    @pulumi.getter(name="httpsPorts")
    def https_ports(self) -> Sequence[int]:
        """
        The listening port of the HTTPS protocol.
        """
        return pulumi.get(self, "https_ports")

    @property
    @pulumi.getter(name="ipv6Enabled")
    def ipv6_enabled(self) -> bool:
        """
        Whether IPv6 is turned on.
        """
        return pulumi.get(self, "ipv6_enabled")

    @property
    @pulumi.getter(name="protectionResource")
    def protection_resource(self) -> str:
        """
        The type of protection resource to use.
        """
        return pulumi.get(self, "protection_resource")

    @property
    @pulumi.getter(name="tlsVersion")
    def tls_version(self) -> str:
        """
        The version of TLS to add. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "tls_version")

    @property
    @pulumi.getter(name="xffHeaderMode")
    def xff_header_mode(self) -> int:
        """
        WAF obtains the real IP address of the client.
        """
        return pulumi.get(self, "xff_header_mode")

    @property
    @pulumi.getter(name="xffHeaders")
    def xff_headers(self) -> Sequence[str]:
        """
        Set the list of custom fields used to obtain the client IP address.
        """
        return pulumi.get(self, "xff_headers")


@pulumi.output_type
class GetDomainsDomainRedirectResult(dict):
    def __init__(__self__, *,
                 backends: Sequence[str],
                 connect_timeout: int,
                 focus_http_backend: bool,
                 keepalive: bool,
                 keepalive_requests: int,
                 keepalive_timeout: int,
                 loadbalance: str,
                 read_timeout: int,
                 request_headers: Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult'],
                 retry: bool,
                 sni_enabled: bool,
                 sni_host: str,
                 write_timeout: int):
        """
        :param Sequence[str] backends: The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        :param int connect_timeout: Connection timeout, Unit: seconds, value range: 5~120.
        :param bool focus_http_backend: Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param bool keepalive: Open long connection, default true.
        :param int keepalive_requests: Number of long connections, default: `60`. range :60-1000.
        :param int keepalive_timeout: Long connection over time, default: `15`. Range: 1-60.
        :param str loadbalance: The load balancing algorithm used when returning to the source.
        :param int read_timeout: Read timeout duration. Unit: seconds, Value range: 5~1800.
        :param Sequence['GetDomainsDomainRedirectRequestHeaderArgs'] request_headers: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param bool retry: Back to Source Retry. default `true`, retry 3 times by default.
        :param bool sni_enabled: Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        :param str sni_host: Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        :param int write_timeout: Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "connect_timeout", connect_timeout)
        pulumi.set(__self__, "focus_http_backend", focus_http_backend)
        pulumi.set(__self__, "keepalive", keepalive)
        pulumi.set(__self__, "keepalive_requests", keepalive_requests)
        pulumi.set(__self__, "keepalive_timeout", keepalive_timeout)
        pulumi.set(__self__, "loadbalance", loadbalance)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "request_headers", request_headers)
        pulumi.set(__self__, "retry", retry)
        pulumi.set(__self__, "sni_enabled", sni_enabled)
        pulumi.set(__self__, "sni_host", sni_host)
        pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter
    def backends(self) -> Sequence[str]:
        """
        The IP address of the origin server corresponding to the domain name or the back-to-origin domain name of the server.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> int:
        """
        Connection timeout, Unit: seconds, value range: 5~120.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="focusHttpBackend")
    def focus_http_backend(self) -> bool:
        """
        Whether to enable forced HTTP back-to-origin. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "focus_http_backend")

    @property
    @pulumi.getter
    def keepalive(self) -> bool:
        """
        Open long connection, default true.
        """
        return pulumi.get(self, "keepalive")

    @property
    @pulumi.getter(name="keepaliveRequests")
    def keepalive_requests(self) -> int:
        """
        Number of long connections, default: `60`. range :60-1000.
        """
        return pulumi.get(self, "keepalive_requests")

    @property
    @pulumi.getter(name="keepaliveTimeout")
    def keepalive_timeout(self) -> int:
        """
        Long connection over time, default: `15`. Range: 1-60.
        """
        return pulumi.get(self, "keepalive_timeout")

    @property
    @pulumi.getter
    def loadbalance(self) -> str:
        """
        The load balancing algorithm used when returning to the source.
        """
        return pulumi.get(self, "loadbalance")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> int:
        """
        Read timeout duration. Unit: seconds, Value range: 5~1800.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter(name="requestHeaders")
    def request_headers(self) -> Sequence['outputs.GetDomainsDomainRedirectRequestHeaderResult']:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "request_headers")

    @property
    @pulumi.getter
    def retry(self) -> bool:
        """
        Back to Source Retry. default `true`, retry 3 times by default.
        """
        return pulumi.get(self, "retry")

    @property
    @pulumi.getter(name="sniEnabled")
    def sni_enabled(self) -> bool:
        """
        Whether to enable back-to-source SNI. This parameter is used only if the value of **https_ports** is not empty (indicating that the domain name uses the HTTPS protocol).
        """
        return pulumi.get(self, "sni_enabled")

    @property
    @pulumi.getter(name="sniHost")
    def sni_host(self) -> str:
        """
        Sets the value of the custom SNI extension field. If this parameter is not set, the value of the **Host** field in the request header is used as the value of the SNI extension field by default.In general, you do not need to customize SNI unless your business has special configuration requirements. You want WAF to use SNI that is inconsistent with the actual request Host in the back-to-origin request (that is, the custom SNI set here).> This parameter is required only when **sni_enalbed** is set to **true** (indicating that back-to-source SNI is enabled).
        """
        return pulumi.get(self, "sni_host")

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> int:
        """
        Write timeout duration. **Unit**: seconds, **Value range**:5~1800.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class GetDomainsDomainRedirectRequestHeaderResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        :param str value: The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The traffic tag field and value of the domain name, which is used to mark the traffic processed by WAF. the format of this parameter value is **[{" k ":"_key_"," v ":"_value_"}]**. where_key_represents the specified custom request header field, and_value_represents the value set for this field.By specifying the custom request header field and the corresponding value, when the access traffic of the domain name passes through WAF, WAF automatically adds the specified custom field value to the request header as the traffic mark, which is convenient for backend service statistics.Explain that if the custom header field already exists in the request, the system will overwrite the value of the custom field in the request with the set traffic tag value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 instance_id: str,
                 status: str):
        """
        :param str create_time: The creation time of the resource.
        :param str id: The ID of the resource.
        :param str instance_id: The first ID of the resource.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


