# Alternatives to Janito

There are many tools for AI-powered code assistance and project automation. Here are some notable alternatives, grouped by category:

| Category              | Name                | Description                                                                 | Link                                   |
|-----------------------|---------------------|-----------------------------------------------------------------------------|----------------------------------------|
| 🟢 Open Source CLI    | aider               | Fast, open-source GPT coding in your terminal.                              | [aider.chat](https://aider.chat)       |
| 🟢 Open Source CLI    | RA.Aid              | Autonomous software development agent with multi-step planning, research, and implementation. CLI-based, supports shell command execution, web research, and integration with aider. | [github.com/ai-christianson/RA.Aid](https://github.com/ai-christianson/RA.Aid) |
| 🟢 Open Source CLI    | OpenAI Codex CLI    | Lightweight, open-source coding agent that runs in your terminal.            | [github.com/openai/codex](https://github.com/openai/codex) |
| 🟢 Open Source CLI    | Continue            | Open-source autopilot for software development. Integrates with VS Code and JetBrains, supports multiple models, and enables conversational coding and project-wide edits. | [continue.dev](https://continue.dev)   |
| 🟩 VS Code Extension  | roo code            | Open-source, model-agnostic AI coding assistant for VS Code. Supports multi-file edits, guarded command execution, and deep project context. | [roocode.com](https://roocode.com)    |
| 🟩 VS Code Extension  | cline               | Open-source, collaborative AI coding agent for VS Code. Autonomous, extensible, and supports multiple models. | [cline.bot](https://cline.bot)         |
| 🟦 IDE-Integrated     | Cursor              | AI-powered code editor based on VS Code, with deep context and refactoring.  | [cursor.com](https://cursor.com)       |
| 🟦 IDE-Integrated     | Windsurf            | AI coding assistant and IDE (formerly Codeium) for VS Code, JetBrains, and its own editor. | [windsurf.com](https://windsurf.com)   |
| 🟦 IDE-Integrated     | GitHub Copilot      | AI pair programmer for VS Code, JetBrains, and more.                        | [github.com/features/copilot](https://github.com/features/copilot) |
| 🟪 Commercial Assistant| Claude Code         | Anthropic’s Claude models with code-focused features.                        | [github.com/anthropics/claude-code](https://github.com/anthropics/claude-code) |
| 🟪 Commercial Assistant| Amazon CodeWhisperer| AI code suggestions in IDEs.                                                | [aws.amazon.com/codewhisperer](https://aws.amazon.com/codewhisperer) |
| 🟪 Commercial Assistant| Tabnine             | AI code completion for multiple editors.                                     | [tabnine.com](https://tabnine.com)     |
| 🌐 Web-Based Chat     | ChatGPT             | OpenAI’s web-based conversational AI.                                        | [chat.openai.com](https://chat.openai.com) |
| 🌐 Web-Based Chat     | Gemini              | Google’s AI chat for code and general tasks.                                 | [gemini.google.com](https://gemini.google.com) |
| 🌐 Web-Based Chat     | Copilot Web         | GitHub Copilot’s browser-based chat.                                         | [github.com/features/copilot](https://github.com/features/copilot) |
| 🌐 Web-Based Chat     | Claude              | Anthropic’s Claude conversational AI.                                        | [claude.ai](https://claude.ai)         |

Each tool has its own strengths, focus, and integration style. Janito is unique in its open, prompt-driven, and tool-based approach—see the rest of the docs for what sets it apart!
