# Our Approach to Code Intelligence and Editing

## Overview

Janito’s approach to code intelligence is designed to maximize transparency, traceability, and user alignment. We leverage methods and primitives that are familiar to developers and closely aligned with human inference and established tooling.

## Context Building with Human-like Primitives

- **Search Text & Search File:**
  - We use explicit text and file search operations to build context, similar to how developers use `grep`, `find`, or IDE search.
  - This makes every step visible and auditable, allowing users to understand and guide the assistant’s inference.

## String Replacement over Diff

- **Natural Language Alignment:**
  - Instead of relying solely on code diffs, we use string replacement primitives.
  - This approach is more aligned with how humans describe changes ("replace X with Y"), and is easier to validate and review.
  - It reduces ambiguity and makes the change process more transparent.

## Range Selection and Contextual References

- **Filename:Line Number:Context:**
  - We adopt conventions like `filename:line_nr:context` for referencing code locations.
  - This is inspired by tools like `grep` and error reporting systems in Python, JavaScript, and other languages.
  - It enables precise, context-rich navigation and error reporting.

## Benefits of Our Approach

- **Transparency:** Every step is explicit and visible to the user.
- **Traceability:** Changes and inference can be audited and reviewed.
- **User Alignment:** Methods are familiar to developers, reducing friction and cognitive load.
- **Reliability:** By mirroring established developer workflows, we minimize surprises and errors.

---
_generated by janito.dev_
