"""Exception classes for AdsOverAI SDK"""


class AdsOverAIError(Exception):
    """Base exception for AdsOverAI SDK"""
    pass


class APIError(AdsOverAIError):
    """Exception raised for API errors"""
    pass


class AuthenticationError(AdsOverAIError):
    """Exception raised for authentication errors"""
    pass


class ValidationError(AdsOverAIError):
    """Exception raised for validation errors"""
    pass


class RateLimitError(APIError):
    """Exception raised when rate limit is exceeded"""
    pass


class NetworkError(APIError):
    """Exception raised for network-related errors"""
    pass