"""Utility functions for AdsOverAI SDK"""

import hashlib
from typing import Any


def generate_cache_key(*args: Any) -> str:
    """Generate a cache key from arguments"""
    content = ":".join(str(arg) for arg in args)
    return hashlib.md5(content.encode()).hexdigest()


def validate_url(url: str) -> bool:
    """Validate if a string is a valid URL"""
    import re
    url_pattern = re.compile(
        r'^https?://'  # http:// or https://
        r'(?:(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+[A-Z]{2,6}\.?|'  # domain...
        r'localhost|'  # localhost...
        r'\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})'  # ...or ip
        r'(?::\d+)?'  # optional port
        r'(?:/?|[/?]\S+)$', re.IGNORECASE)
    return url_pattern.match(url) is not None


def truncate_text(text: str, max_length: int = 50) -> str:
    """Truncate text to max_length with ellipsis"""
    if len(text) <= max_length:
        return text
    return text[:max_length - 3] + "..."