from adsoverai import AdsOverAI

def main():
    # Initialize client
    client = AdsOverAI(
        api_key="your-api-key-here",
        max_ads=3,
        theme="auto"
    )
    
    # Example conversation
    query = "What are the best running shoes for marathons?"
    response = """
    For marathons, I recommend the following running shoes:
    1. Nike ZoomX Vaporfly - Excellent energy return
    2. Adidas Adizero Adios Pro - Great cushioning
    3. Brooks Hyperion Elite - Lightweight and durable
    """
    
    # Fetch ads
    print("Fetching contextual ads...")
    ads = client.get_ads(query=query, response=response)
    
    # Display results
    print(f"\nFound {len(ads)} ads:\n")
    for i, ad in enumerate(ads, 1):
        print(f"Ad #{i}")
        print(f"  Title: {ad.title}")
        print(f"  Description: {ad.description}")
        print(f"  URL: {ad.url}")
        if ad.advertiser:
            print(f"  Advertiser: {ad.advertiser}")
        print()
    
    # Close client
    client.close()

if __name__ == "__main__":
    main()