from django.conf import settings
from adsoverai import AdsOverAI

# Initialize client (do this once, perhaps in your app's __init__.py)
ads_client = AdsOverAI(
    api_key=settings.ADSOVERAI_API_KEY,
    max_ads=3,
    theme="auto"
)

# In your Django view
def chat_view(request):
    if request.method == 'POST':
        user_query = request.POST.get('query')
        ai_response = generate_ai_response(user_query)  # Your AI logic
        
        # Fetch ads
        try:
            ads = ads_client.get_ads(
                query=user_query,
                response=ai_response
            )
            
            return render(request, 'chat.html', {
                'query': user_query,
                'response': ai_response,
                'ads': [ad.to_dict() for ad in ads]
            })
        except Exception as e:
            # Handle error
            print(f"Error fetching ads: {e}")
            return render(request, 'chat.html', {
                'query': user_query,
                'response': ai_response,
                'ads': []
            })