import pytest
from adsoverai import AdsOverAI
from adsoverai.models import AdResult


@pytest.fixture
def api_key():
    """Test API key"""
    return "test-api-key-12345"


@pytest.fixture
def client(api_key):
    """Create a test client"""
    return AdsOverAI(
        api_key=api_key,
        max_ads=3,
        theme="auto",
        debug_mode=True
    )


@pytest.fixture
def sample_ad_data():
    """Sample ad data for testing"""
    return {
        'title': 'Test Product',
        'description': 'A great test product',
        'url': 'https://example.com/product',
        'image_url': 'https://example.com/image.jpg',
        'advertiser': 'Test Company',
        'cta_text': 'Buy Now',
        'metadata': {'category': 'electronics'}
    }


@pytest.fixture
def sample_ad_result(sample_ad_data):
    """Sample AdResult instance"""
    return AdResult.from_dict(sample_ad_data)


@pytest.fixture
def mock_api_response():
    """Mock API response"""
    return {
        'ads': [
            {
                'title': 'Product 1',
                'description': 'Description 1',
                'url': 'https://example.com/1',
            },
            {
                'title': 'Product 2',
                'description': 'Description 2',
                'url': 'https://example.com/2',
            }
        ]
    }