"""Tests for data models"""

import pytest
from adsoverai.models import AdResult


def test_ad_result_creation(sample_ad_data):
    """Test AdResult creation"""
    ad = AdResult.from_dict(sample_ad_data)
    
    assert ad.title == "Test Product"
    assert ad.description == "A great test product"
    assert ad.url == "https://example.com/product"
    assert ad.advertiser == "Test Company"


def test_ad_result_to_dict(sample_ad_result):
    """Test AdResult to_dict conversion"""
    data = sample_ad_result.to_dict()
    
    assert data['title'] == "Test Product"
    assert data['url'] == "https://example.com/product"
    assert isinstance(data, dict)


def test_ad_result_defaults():
    """Test AdResult default values"""
    ad = AdResult(
        title="Test",
        description="Test Desc",
        url="https://test.com"
    )
    
    assert ad.cta_text == "Learn More"
    assert ad.image_url is None
    assert ad.advertiser is None
    assert ad.metadata == {}


def test_ad_result_repr(sample_ad_result):
    """Test AdResult string representation"""
    repr_str = repr(sample_ad_result)
    assert "Test Product" in repr_str
    assert "https://example.com/product" in repr_str