from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="adsoverai",
    version="1.0.0",
    author="AdsOverAI Team",
    author_email="hello@adsoverai.com",
    description="Python SDK for AdsOverAI - Native advertising for AI chat interfaces",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/adsoverai/python-sdk",
    packages=find_packages(exclude=["tests", "examples", "docs"]),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
    python_requires=">=3.8",
    install_requires=[
        "requests>=2.28.0",
    ],
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=22.0.0",
            "flake8>=5.0.0",
            "mypy>=0.990",
            "types-requests",
        ],
    },
    keywords="ads advertising ai chat conversational-ai monetization adtech",
    project_urls={
        "Bug Reports": "https://github.com/adsoverai/python-sdk/issues",
        "Documentation": "https://docs.adsoverai.com",
        "Source": "https://github.com/adsoverai/python-sdk",
    },
)