"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SettlementTypedDict(TypedDict):
    r"""A settlement record for a transaction."""

    id: str
    r"""The unique identifier for the settlement."""
    merchant_account_id: str
    r"""The merchant account this settlement belongs to."""
    created_at: datetime
    r"""The date and time the settlement was created, in ISO 8601 format."""
    updated_at: datetime
    r"""The date and time the settlement was last updated, in ISO 8601 format."""
    posted_at: datetime
    r"""The date and time the settlement was posted, in ISO 8601 format."""
    ingested_at: datetime
    r"""The date and time the settlement was ingested, in ISO 8601 format."""
    currency: str
    r"""ISO 4217 currency code for the settlement."""
    amount: int
    r"""The total settled amount in the smallest currency unit (e.g. cents)."""
    commission: int
    r"""The commission amount deducted in the smallest currency unit."""
    payment_service_report_id: str
    r"""The report ID from the payment service."""
    payment_service_report_file_ids: List[str]
    r"""List of file IDs for the payment service report."""
    transaction_id: str
    r"""The transaction this settlement is associated with."""
    type: Literal["settlement"]
    r"""Always 'settlement'."""
    exchange_rate: NotRequired[Nullable[float]]
    r"""The exchange rate used for settlement, if applicable."""
    interchange: NotRequired[Nullable[int]]
    r"""The interchange fee, if applicable, in the smallest currency unit."""
    markup: NotRequired[Nullable[int]]
    r"""The markup fee, if applicable, in the smallest currency unit."""
    scheme_fee: NotRequired[Nullable[int]]
    r"""The scheme fee, if applicable, in the smallest currency unit."""


class Settlement(BaseModel):
    r"""A settlement record for a transaction."""

    id: str
    r"""The unique identifier for the settlement."""

    merchant_account_id: str
    r"""The merchant account this settlement belongs to."""

    created_at: datetime
    r"""The date and time the settlement was created, in ISO 8601 format."""

    updated_at: datetime
    r"""The date and time the settlement was last updated, in ISO 8601 format."""

    posted_at: datetime
    r"""The date and time the settlement was posted, in ISO 8601 format."""

    ingested_at: datetime
    r"""The date and time the settlement was ingested, in ISO 8601 format."""

    currency: str
    r"""ISO 4217 currency code for the settlement."""

    amount: int
    r"""The total settled amount in the smallest currency unit (e.g. cents)."""

    commission: int
    r"""The commission amount deducted in the smallest currency unit."""

    payment_service_report_id: str
    r"""The report ID from the payment service."""

    payment_service_report_file_ids: List[str]
    r"""List of file IDs for the payment service report."""

    transaction_id: str
    r"""The transaction this settlement is associated with."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["settlement"]],
            AfterValidator(validate_const("settlement")),
        ],
        pydantic.Field(alias="type"),
    ] = "settlement"
    r"""Always 'settlement'."""

    exchange_rate: OptionalNullable[float] = UNSET
    r"""The exchange rate used for settlement, if applicable."""

    interchange: OptionalNullable[int] = UNSET
    r"""The interchange fee, if applicable, in the smallest currency unit."""

    markup: OptionalNullable[int] = UNSET
    r"""The markup fee, if applicable, in the smallest currency unit."""

    scheme_fee: OptionalNullable[int] = UNSET
    r"""The scheme fee, if applicable, in the smallest currency unit."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "exchange_rate",
            "interchange",
            "markup",
            "scheme_fee",
        ]
        nullable_fields = ["exchange_rate", "interchange", "markup", "scheme_fee"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
