#!/usr/bin/env python
#
# XPCS Toolkit documentation build configuration file, created by
# sphinx-quickstart on Fri Jun  9 13:47:02 2017.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

# If extensions (or modules to document with autodoc) are in another
# directory, add these directories to sys.path here. If the directory is
# relative to the documentation root, use os.path.abspath to make it
# absolute, like shown here.
#
import logging
import os
import sys
from unittest import mock

sys.path.insert(0, os.path.abspath(".."))


# Create a more sophisticated mock for Qt/GUI modules
class MockQtModule(mock.MagicMock):
    """Enhanced mock for Qt modules that provides common Qt patterns"""

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # Mock common Qt signal pattern
        self.pyqtSignal = mock.MagicMock()
        self.Signal = mock.MagicMock()

        # Mock common Qt classes that might have metaclass conflicts
        self.QWidget = mock.MagicMock()
        self.QMainWindow = mock.MagicMock()
        self.QApplication = mock.MagicMock()
        self.QObject = mock.MagicMock()


# Mock heavy dependencies that may not be available in docs build environment
MOCK_MODULES = [
    "PySide6",
    "PySide6.QtCore",
    "PySide6.QtWidgets",
    "PySide6.QtGui",
    "PySide6.QtOpenGL",
    "pyqtgraph",
    "pyqtgraph.Qt",
    "pyqtgraph.opengl",
    "pyqtgraph.console",
    "pyqtgraph.parametertree",
    "joblib",
    "memory_profiler",
    "line_profiler",
    "py_spy",
    "psutil",
]

for mod_name in MOCK_MODULES:
    if "Qt" in mod_name or "pyqtgraph" in mod_name:
        sys.modules[mod_name] = MockQtModule()
    else:
        sys.modules[mod_name] = mock.MagicMock()

# Set environment variable to indicate we're building docs
os.environ["BUILDING_DOCS"] = "1"

try:
    import xpcs_toolkit

    version = xpcs_toolkit.__version__
except ImportError:
    # Fallback version if package can't be imported
    version = "1.0.5"

# Simple logger for docs build
logging.info(f"Building documentation for XPCS Toolkit version {version}")

# Monkey patch to suppress autodoc import warnings
logging.getLogger("sphinx.ext.autodoc").setLevel(logging.ERROR)


# Setup function for Sphinx extension
def setup(app):
    """Setup function for Sphinx extension."""


# -- General configuration ---------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.autosummary",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.githubpages",
    "myst_parser",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
source_suffix = [".rst", ".md"]

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "XPCS Toolkit"
project_copyright = "2025, Miaoqi Chu"
author = "Miaoqi Chu"

# The version info for the project you're documenting, acts as replacement
# for |version| and |release|, also used in various other places throughout
# the built documents.
#
# The short X.Y version.
# version is already set above from package metadata
# The full version, including alpha/beta/rc tags.
release = version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# Suppress specific warnings to reduce noise in documentation builds
suppress_warnings = [
    "autodoc.import_error",
    "autodoc",
    "ref.any",
]

# Don't check broken external links during build
nitpicky = False

# Configure autodoc to be more lenient
autodoc_inherit_docstrings = True

# -- Extension configuration ------------------------------------------------

# Napoleon settings for Google/NumPy style docstrings
napoleon_google_docstring = True
napoleon_numpy_docstring = True
napoleon_include_init_with_doc = False
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = True
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = False
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = True
napoleon_use_rtype = True
napoleon_type_aliases = None

# Autodoc settings
autodoc_default_options = {
    "members": True,
    "undoc-members": True,
    "show-inheritance": True,
    "special-members": "__init__",
}
autodoc_member_order = "bysource"
autodoc_typehints = "description"

# Mock imports for autodoc - prevents import warnings during documentation build
autodoc_mock_imports = [
    "PySide6",
    "PySide6.QtCore",
    "PySide6.QtWidgets",
    "PySide6.QtGui",
    "PySide6.QtOpenGL",
    "pyqtgraph",
    "pyqtgraph.Qt",
    "pyqtgraph.opengl",
    "pyqtgraph.console",
    "pyqtgraph.parametertree",
    "joblib",
    "memory_profiler",
    "line_profiler",
    "py_spy",
    "psutil",
    # Scientific computing dependencies that might cause import issues
    "matplotlib.backends.qt_compat",
    "numpy.distutils",
]

# Autosummary settings
autosummary_generate = True
autosummary_imported_members = False

# Intersphinx mapping for linking to other project documentation
intersphinx_mapping = {
    "python": ("https://docs.python.org/3/", None),
    "numpy": ("https://numpy.org/doc/stable/", None),
    "scipy": ("https://docs.scipy.org/doc/scipy/", None),
    "matplotlib": ("https://matplotlib.org/stable/", None),
    "h5py": ("https://docs.h5py.org/en/stable/", None),
    "pyside6": ("https://doc.qt.io/qtforpython-6/", None),
}

# MyST Parser settings
myst_enable_extensions = [
    "colon_fence",
    "deflist",
    "dollarmath",
    "fieldlist",
    "html_admonition",
    "html_image",
    "replacements",
    "smartquotes",
    "strikethrough",
    "substitution",
    "tasklist",
]


# -- Options for HTML output -------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a
# theme further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    "logo_only": False,
    "prev_next_buttons_location": "bottom",
    "style_external_links": False,
    "collapse_navigation": False,
    "sticky_navigation": True,
    "navigation_depth": 4,
    "includehidden": True,
    "titles_only": False,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ["_static"]


# -- Options for HTMLHelp output ---------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "xpcs_toolkitdoc"


# -- Options for LaTeX output ------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    # The font size ('10pt', '11pt' or '12pt').
    # Additional stuff for the LaTeX preamble.
    # Latex figure (float) alignment
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title, author, documentclass
# [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "xpcs_toolkit.tex",
        "XPCS Toolkit Documentation",
        "Miaoqi Chu",
        "manual",
    ),
]


# -- Options for manual page output ------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "xpcs_toolkit", "XPCS Toolkit Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "xpcs_toolkit",
        "XPCS Toolkit Documentation",
        author,
        "xpcs_toolkit",
        "One line description of project.",
        "Miscellaneous",
    ),
]
