# Validation Archive

This directory contains archived validation files from the XPCS Toolkit optimization and production deployment process.

## Current Active Files

- `comprehensive_validation_runner.py` - Main validation script
- `scientific_accuracy_validator.py` - Scientific accuracy validation

## Archived Files

### `archived_reports/`
- `OPTIMIZATION_VALIDATION_REPORT.md` - Original validation report (superseded by final report)
- `PRODUCTION_READINESS_REPORT.md` - Intermediate production assessment (superseded by final report)

### `archived_scripts/`
- `optimization_validation_test.py` - Complete optimization validation script
- `optimization_validation_report_20250912_084100.json` - Latest validation results
- `test_cleanup_optimization.py` - Cleanup optimization tests
- `test_memory_optimization.py` - Memory optimization tests  
- `validate_gc_optimizations.py` - Garbage collection validation
- `validate_io_optimizations.py` - I/O optimization validation
- `validate_threading_optimizations.py` - Threading optimization validation
- `verify_memory_optimization.py` - Memory optimization verification
- `run_phase6_validation.py` - Phase 6 specific validation

These individual scripts were consolidated into the comprehensive validation framework.

## Usage

For current validation needs, use:
- `comprehensive_validation_runner.py` for complete system validation
- `scientific_accuracy_validator.py` for scientific accuracy checks

Archived files are kept for reference and historical purposes.
